/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscretePoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.data.FilterPickInterface;
import com.sas.graphics.data.IOBSInterface;
import com.sas.graphics.data.sort.SortContext;
import com.sas.graphics.data.subset.WhereClauseSubset;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.DataFilterStatisticsInterface;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.DefaultStatistics;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.RangeInfoModel;
import com.sas.graphics.util.Sort;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.util.BitSet;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public abstract class AbstractDataFilter
implements DataFilterReadInterface {
    protected int[] subsetList;
    protected Vector whereClauses = new Vector();
    protected DvrDataFilterEvent evt = new DvrDataFilterEvent();
    protected EventListenerList listeners = new EventListenerList();
    protected boolean subsetted;
    protected boolean supportsEvents = true;
    protected Locale locale;
    private BitSet subsetMask = new BitSet();
    protected boolean localSelections = false;
    protected BitSet localSelectionModel = new BitSet();
    protected boolean localGraphed = false;
    protected BitSet localGraphedModel = new BitSet();
    protected SASFormat defFmt = null;
    protected PickObject picker = null;
    protected DataFilterStatisticsInterface statistics = null;
    protected RangeInfoModel rangeInfoModel = null;
    public static final String TOO_MANY_VALUES = "OVERFLOW";
    protected Hashtable subsetUniqueValues = new Hashtable();
    protected Hashtable subsetNonMissingUniqueValues = new Hashtable();
    protected Hashtable subsetFormattedValues = new Hashtable();
    protected boolean suppressEvents = false;
    public static final int SET = 1;
    public static final int CLEAR = 2;
    public static final int TOGGLE = 3;
    public static final int LEAVE_CURRENT_GRAPHED_STATE = 0;
    public static final int CLEAR_ALL_GRAPHED = 1;
    public static final int SET_ALL_GRAPHED = 2;

    public AbstractDataFilter() {
        this.defFmt = this.getDefaultNumericFormat();
    }

    private SASFormat getDefaultNumericFormat() {
        SASFormat defaultNumericFormat;
        String s = null;
        s = ResourceLoader.getPropertyString("Graph.config", "Global.DefaultNumericFormat", "BEST8");
        if (s == null) {
            s = "BEST8";
        }
        if ((defaultNumericFormat = SASFormat.getInstance((String)s)) == null) {
            defaultNumericFormat = SASFormat.getInstance((String)"BEST8");
        }
        return defaultNumericFormat;
    }

    @Override
    public boolean removeSource() {
        this.subsetList = null;
        if (this.whereClauses != null) {
            this.whereClauses.clear();
        }
        this.whereClauses = null;
        this.evt = null;
        if (this.listeners != null) {
            EventListener[] arr = this.listeners.getListeners(DataFilterListenerInterface.class);
            for (int i = 0; i < arr.length; ++i) {
                this.listeners.remove(DataFilterListenerInterface.class, (DataFilterListenerInterface)arr[i]);
            }
            this.listeners = null;
        }
        this.locale = null;
        this.subsetMask = null;
        this.localSelectionModel = null;
        this.localGraphedModel = null;
        this.picker = null;
        if (this.statistics != null) {
            this.statistics.dispose();
        }
        this.statistics = null;
        if (this.rangeInfoModel != null) {
            this.rangeInfoModel.dispose();
        }
        this.rangeInfoModel = null;
        if (this.subsetUniqueValues != null) {
            this.subsetUniqueValues.clear();
        }
        this.subsetUniqueValues = null;
        if (this.subsetFormattedValues != null) {
            this.subsetFormattedValues.clear();
        }
        this.subsetFormattedValues = null;
        if (this.subsetNonMissingUniqueValues != null) {
            this.subsetNonMissingUniqueValues.clear();
        }
        this.subsetNonMissingUniqueValues = null;
        return true;
    }

    public static void detachFromModel(Object dataModel) {
    }

    @Override
    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        int[] prevList = this.subsetList;
        int[] newList = null;
        if (clause == null) {
            this.whereClauses.removeAllElements();
            this.setSubsetList(null);
            return true;
        }
        WhereClauseSubset subset = new WhereClauseSubset(clause);
        this.setSubsetList(null, false);
        newList = subset.getPassedObs(this);
        if (newList == null) {
            this.setSubsetList(prevList);
            return false;
        }
        if (clearPrevious) {
            this.whereClauses.removeAllElements();
        }
        this.whereClauses.addElement(clause);
        this.setSubsetList(newList);
        return true;
    }

    @Override
    public String getWhereClause() {
        String rc = "";
        if (this.whereClauses == null) {
            return rc;
        }
        for (int i = 0; i < this.whereClauses.size(); ++i) {
            rc = rc + "(" + this.whereClauses.elementAt(i).toString() + ")";
            if (i >= this.whereClauses.size() - 1) continue;
            rc = rc + " & ";
        }
        return rc;
    }

    @Override
    public void sendEvent(Object event) {
        if (event == null || !(event instanceof DvrDataFilterEvent)) {
            return;
        }
        this.throwEvent((DvrDataFilterEvent)event);
    }

    protected void throwEvent(int type, int firstVarIdx, int lastVarIdx, int firstObs, int lastObs, Object oldValue, Object newValue, boolean isAdjustingIn) {
        if (this.evt == null) {
            return;
        }
        this.evt.source = this;
        this.evt.type = type;
        this.evt.varStartIndex = firstVarIdx;
        this.evt.varEndIndex = lastVarIdx;
        this.evt.obsStartIndex = firstObs;
        this.evt.obsEndIndex = lastObs;
        this.evt.oldValue = oldValue;
        this.evt.newValue = newValue;
        this.evt.isAdjusting = isAdjustingIn;
        this.evt.info = 0;
        this.throwEvent(this.evt);
    }

    protected void throwEvent(DvrDataFilterEvent evt) {
        if (!this.supportsEvents || this.suppressEvents) {
            return;
        }
        DataFilterListenerInterface[] list = (DataFilterListenerInterface[])this.listeners.getListeners(DataFilterListenerInterface.class);
        for (int i = 0; i < list.length; ++i) {
            list[i].dataFilterChanged(evt);
        }
    }

    @Override
    public boolean addDataFilterListener(Object listener) {
        if (!this.supportsEvents || !(listener instanceof DataFilterListenerInterface)) {
            return false;
        }
        if (!this.containsListener(this.listeners, listener)) {
            this.listeners.add(DataFilterListenerInterface.class, (DataFilterListenerInterface)listener);
        }
        return true;
    }

    @Override
    public boolean removeDataFilterListener(Object listener) {
        if (!this.supportsEvents || !(listener instanceof DataFilterListenerInterface)) {
            return false;
        }
        this.listeners.remove(DataFilterListenerInterface.class, (DataFilterListenerInterface)listener);
        return true;
    }

    @Override
    public boolean setSubsetList(Object list) {
        return this.setSubsetList(list, true);
    }

    private boolean setSubsetList(Object list, boolean throwEvent) {
        int i;
        int n;
        if (this.subsetUniqueValues != null) {
            this.subsetUniqueValues.clear();
        }
        if (this.subsetFormattedValues != null) {
            this.subsetFormattedValues.clear();
        }
        if (this.subsetNonMissingUniqueValues != null) {
            this.subsetNonMissingUniqueValues.clear();
        }
        if (list == null) {
            if (this.rangeInfoModel != null) {
                this.rangeInfoModel.invalidate();
            }
            this.subsetted = false;
            this.subsetList = null;
            if (throwEvent) {
                this.throwEvent(3, 0, this.getNumberVariables() - 1, 0, this.getNumberObservations(-1) - 1, null, null, false);
            }
            return true;
        }
        int type = Extract.getSourceType(list);
        if (type <= 0) {
            return false;
        }
        this.subsetted = true;
        if (this.rangeInfoModel != null) {
            this.rangeInfoModel.invalidate();
        }
        this.subsetList = (n = Extract.getNumberItems(list, type)) <= 0 ? new int[0] : new int[n];
        for (i = 0; i < n; ++i) {
            this.subsetList[i] = Extract.getInteger(list, i, type);
        }
        Sort.heapsort(this.subsetList, -1);
        this.subsetMask.clear();
        for (i = 0; i < n; ++i) {
            this.subsetMask.set(this.subsetList[i]);
        }
        if (throwEvent) {
            this.throwEvent(3, 0, this.getNumberVariables() - 1, 0, this.getNumberObservations(-1) - 1, null, null, false);
        }
        return true;
    }

    @Override
    public Object getSubsetList() {
        return this.subsetList;
    }

    @Override
    public boolean isIndexInCurrentSubset(int index) {
        return this.subsetMask.get(index);
    }

    @Override
    public int getObservationNumber(int index) {
        if (!this.subsetted) {
            return index;
        }
        if (this.subsetList == null) {
            return -1;
        }
        if (index < 0 || index >= this.subsetList.length) {
            return -1;
        }
        return this.subsetList[index];
    }

    protected boolean isNumericClass(Class classIn) {
        Class superCls = null;
        if (classIn == null) {
            return false;
        }
        if (classIn == Number.class) {
            return true;
        }
        superCls = classIn.getSuperclass();
        return superCls != null && superCls == Number.class;
    }

    @Override
    public boolean setSource(Object source, Locale localeIn) {
        this.locale = localeIn;
        return this.setSource(source);
    }

    @Override
    public Object getExactVariableId(Object id) {
        int idx = this.getVariableIndex(id);
        if (idx < 0) {
            return null;
        }
        return this.getVariableId(idx);
    }

    @Override
    public Object getVariableDescription(Object id) {
        return this.getVariableDescription(this.getVariableIndex(id));
    }

    @Override
    public Class getVariableClass(Object id) {
        return this.getVariableClass(this.getVariableIndex(id));
    }

    @Override
    public int getNumberObservations(Object id) {
        return this.getNumberObservations(this.getVariableIndex(id));
    }

    @Override
    public boolean isMissing(Object id, Object value) {
        return this.isMissing(this.getVariableIndex(id), value);
    }

    @Override
    public boolean isNumericVariable(Object id) {
        return this.isNumericVariable(this.getVariableIndex(id));
    }

    @Override
    public Object getValue(Object variableId, long iobs) {
        return this.getValue(this.getVariableIndex(variableId), iobs);
    }

    @Override
    public Object getValue(Object variableId, long iobs, SortContext sort) {
        return this.getValue(variableId, this.getSortedIndex(iobs, sort));
    }

    @Override
    public Object getValue(int idx, long iobs, SortContext sort) {
        return this.getValue(idx, this.getSortedIndex(iobs, sort));
    }

    protected abstract Object getModelValue(int var1, long var2);

    protected abstract int getNumberOfObservationsOnModel();

    @Override
    public double getNumericValue(Object variableId, long iobs) {
        return this.getNumericValue(this.getVariableIndex(variableId), iobs);
    }

    @Override
    public double getNumericValue(Object variableId, long iobs, SortContext sort) {
        return this.getNumericValue(variableId, this.getSortedIndex(iobs, sort));
    }

    @Override
    public double getNumericValue(int idx, long iobs, SortContext sort) {
        return this.getNumericValue(idx, this.getSortedIndex(iobs, sort));
    }

    @Override
    public Object[] getRowValues(long iobs) {
        Object[] arr = new Object[this.getNumberVariables()];
        this.getRowValues(iobs, arr);
        return arr;
    }

    @Override
    public Object[] getRowValues(long iobs, SortContext sort) {
        return this.getRowValues(this.getSortedIndex(iobs, sort));
    }

    @Override
    public int getRowValues(long iobs, Object[] outValues, SortContext sort) {
        return this.getRowValues(this.getSortedIndex(iobs, sort), outValues);
    }

    @Override
    public String getFormattedValue(Object variableId, long iobs, SortContext sort, Object format) {
        return this.getFormattedValue(variableId, this.getSortedIndex(iobs, sort), format);
    }

    @Override
    public String getFormattedValue(Object variableId, long iobs, Object format) {
        return this.getFormattedValue(variableId, this.getValue(variableId, iobs), format);
    }

    @Override
    public boolean isSelected(long iobs, SortContext sort) {
        return this.isSelected(this.getSortedIndex(iobs, sort));
    }

    @Override
    public void setSelected(long iobs, SortContext sort, boolean selected) {
        this.setSelected(this.getSortedIndex(iobs, sort), selected);
    }

    @Override
    public void setSelected(Object list, boolean selected) {
        this.setSelected(list, selected, null);
    }

    public abstract void setSelected(Object var1, int var2, IOBSInterface var3);

    public abstract void setGraphed(Object var1, int var2, IOBSInterface var3);

    public void toggleSelected(String[] variables, DataRange[] values, boolean useFormat) {
        this.setMetadataBit("Selected", variables, values, 3, useFormat);
    }

    @Override
    public void setSelected(Object list, SortContext sort, boolean selected) {
        this.setSelected(this.mapToSortedList(list, sort), selected);
    }

    @Override
    public void setSelected(Object list, SortContext sort, boolean selected, IOBSInterface operator) {
        this.setSelected((Object)this.mapToSortedList(list, sort), selected, operator);
    }

    @Override
    public void setSelected(String[] variables, DataRange[] values, boolean selected) {
        this.setSelected(variables, values, selected, false);
    }

    @Override
    public void setSelected(String[] variables, DataRange[] values, boolean selected, boolean useFormat) {
        int state = selected ? 1 : 2;
        this.setMetadataBit("Selected", variables, values, state, useFormat);
    }

    private void setMetadataBit(String type, String[] variables, DataRange[] values, int state, boolean useFormat) {
        if (variables == null || values == null || variables.length != values.length) {
            return;
        }
        boolean[] discrete = new boolean[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            if (!this.verifyVariable(variables[i])) {
                return;
            }
            if (this.isNumericVariable(variables[i])) {
                discrete[i] = !(values[i] instanceof ContinuousRange);
            }
            if (this.isNumericVariable(variables[i])) continue;
            if (!(values[i] instanceof DiscreteRange)) {
                return;
            }
            discrete[i] = true;
        }
        int numObs = this.getNumberObservations(-1);
        int[] indexes = new int[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            indexes[i] = this.getVariableIndex(variables[i]);
        }
        BitSet bits = new BitSet(numObs);
        DiscretePoint dp = new DiscretePoint();
        ContinuousPoint cp = new ContinuousPoint();
        for (int i = 0; i < numObs; ++i) {
            boolean inBB = true;
            for (int j = 0; j < indexes.length; ++j) {
                String value;
                if (discrete[j]) {
                    value = null;
                    value = this.getFormattedValue((Object)variables[j], i, (Object)null);
                    dp.setValue(value);
                    if (values[j].contains(dp)) continue;
                    inBB = false;
                    continue;
                }
                if (useFormat) {
                    value = this.getFormattedValue((Object)variables[j], i, (Object)null);
                    dp.setValue(value);
                    if (values[j].contains(dp)) continue;
                    inBB = false;
                    continue;
                }
                cp.setValue(this.getNumericValue(indexes[j], (long)i));
                if (values[j].contains(cp)) continue;
                inBB = false;
            }
            if (!inBB) continue;
            bits.set(i);
        }
        int[] obs = new int[bits.cardinality()];
        int count = 0;
        int i = bits.nextSetBit(0);
        while (i >= 0) {
            obs[count++] = i;
            i = bits.nextSetBit(i + 1);
        }
        if (type == null || type.equalsIgnoreCase("selected")) {
            this.setSelected((Object)obs, state, null);
        } else if (type.equalsIgnoreCase("graphed")) {
            this.setGraphed((Object)obs, state, null);
        }
    }

    private void setMetadataBit(String type, String[] variables, DataRange[] values, boolean[] setOrClear, boolean[] useFormat) {
        if (variables == null || values == null || variables.length != values.length) {
            return;
        }
        boolean[] discrete = new boolean[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            if (!this.verifyVariable(variables[i])) {
                return;
            }
            if (this.isNumericVariable(variables[i])) {
                discrete[i] = !(values[i] instanceof ContinuousRange);
            }
            if (this.isNumericVariable(variables[i])) continue;
            if (!(values[i] instanceof DiscreteRange)) {
                return;
            }
            discrete[i] = true;
        }
        int numObs = this.getNumberObservations(-1);
        int[] indexes = new int[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            indexes[i] = this.getVariableIndex(variables[i]);
        }
        BitSet bits = new BitSet(numObs);
        DiscretePoint dp = new DiscretePoint();
        ContinuousPoint cp = new ContinuousPoint();
        for (int i = 0; i < numObs; ++i) {
            boolean inBB = true;
            for (int j = 0; j < indexes.length; ++j) {
                String value;
                if (discrete[j]) {
                    value = null;
                    value = this.getFormattedValue((Object)variables[j], i, (Object)null);
                    dp.setValue(value);
                    if (setOrClear[j]) {
                        inBB &= values[j].contains(dp);
                        continue;
                    }
                    inBB &= !values[j].contains(dp);
                    continue;
                }
                if (useFormat[j]) {
                    value = this.getFormattedValue((Object)variables[j], i, (Object)null);
                    dp.setValue(value);
                    if (setOrClear[j]) {
                        inBB &= values[j].contains(dp);
                        continue;
                    }
                    inBB &= !values[j].contains(dp);
                    continue;
                }
                cp.setValue(this.getNumericValue(indexes[j], (long)i));
                if (setOrClear[j]) {
                    inBB &= values[j].contains(cp);
                    continue;
                }
                inBB &= !values[j].contains(cp);
            }
            if (!inBB) continue;
            bits.set(i);
        }
        int[] obs = new int[bits.cardinality()];
        int count = 0;
        int i = bits.nextSetBit(0);
        while (i >= 0) {
            obs[count++] = i;
            i = bits.nextSetBit(i + 1);
        }
        if (type == null || type.equalsIgnoreCase("selected")) {
            this.setSelected(obs, true);
        } else if (type.equalsIgnoreCase("graphed")) {
            this.setGraphed(obs, true);
        }
    }

    @Override
    public boolean isGraphed(long iobs, SortContext sort) {
        return this.isGraphed(this.getSortedIndex(iobs, sort));
    }

    @Override
    public void setGraphed(long iobs, SortContext sort, boolean graphed) {
        this.setGraphed(this.getSortedIndex(iobs, sort), graphed);
    }

    @Override
    public void setGraphed(Object list, boolean graphed) {
        this.setGraphed(list, graphed, null);
    }

    @Override
    public void setGraphed(Object list, SortContext sort, boolean graphed) {
        this.setGraphed(this.mapToSortedList(list, sort), graphed);
    }

    @Override
    public void setGraphed(Object list, SortContext sort, boolean graphed, IOBSInterface operator) {
        this.setGraphed((Object)this.mapToSortedList(list, sort), graphed, operator);
    }

    @Override
    public void setGraphed(String[] variables, DataRange[] ranges, boolean[] graphed, boolean[] useFormats, boolean extendCurrentGraphedState, boolean setOrClearAll) {
        if (variables == null || ranges == null || graphed == null || variables.length != ranges.length || variables.length != graphed.length) {
            return;
        }
        this.setSuppressEvents(true);
        if (!extendCurrentGraphedState) {
            this.setAllGraphed(setOrClearAll);
        }
        this.setSuppressEvents(false);
        this.setMetadataBit("graphed", variables, ranges, graphed, useFormats);
    }

    @Override
    public void setGraphed(String[] variables, DataRange[] boundingBox, boolean graphed, boolean useFormat) {
        int state = graphed ? 1 : 2;
        this.setMetadataBit("graphed", variables, boundingBox, state, useFormat);
    }

    @Override
    public Color getObservationColor(long iobs, SortContext sort) {
        return this.getObservationColor(this.getSortedIndex(iobs, sort));
    }

    @Override
    public boolean setObservationColor(long iobs, SortContext sort, Color c) {
        return this.setObservationColor(this.getSortedIndex(iobs, sort), c);
    }

    @Override
    public void setObservationColor(Object list, Color c) {
        this.setObservationColor(list, c, null);
    }

    @Override
    public void setObservationColor(Object list, SortContext sort, Color c) {
        this.setObservationColor(this.mapToSortedList(list, sort), c);
    }

    @Override
    public void setObservationColor(Object list, SortContext sort, Color c, IOBSInterface operator) {
        this.setObservationColor((Object)this.mapToSortedList(list, sort), c, operator);
    }

    protected int[] mapToSortedList(Object list, SortContext sort) {
        int type = Extract.getSourceType(list);
        int[] rc = new int[Extract.getNumberItems(list, type)];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = (int)this.getSortedIndex(Extract.getInteger(list, i, type), sort);
        }
        return rc;
    }

    protected long getSortedIndex(long iobs, SortContext sort) {
        if (sort == null) {
            return iobs;
        }
        if (sort.getSource() != this.getSource()) {
            return iobs;
        }
        return sort.getSortedIndex((int)iobs, this);
    }

    protected LinkedHashMap buildFormattedVariableValueList(Object var, LinkedHashMap uniqueFormattedValues) {
        if (var == null || uniqueFormattedValues == null) {
            return null;
        }
        int index = this.getVariableIndex(var);
        int nobs = this.getNumberOfObservationsOnModel();
        LinkedHashMap<Object, String> rawValuesToFormattedValuesMap = new LinkedHashMap<Object, String>();
        int idx = this.getVariableIndex(var);
        for (int i = 0; i < nobs; ++i) {
            String formattedValue;
            Object value = this.getModelValue(index, i);
            if (rawValuesToFormattedValuesMap.containsKey(value) || (formattedValue = this.computeFormattedValueByIndex(idx, value, null)) == null) continue;
            rawValuesToFormattedValuesMap.put(value, formattedValue);
        }
        return rawValuesToFormattedValuesMap;
    }

    protected Object buildVariableValueList(Object var, int maxSize) {
        if (var == null) {
            return null;
        }
        int index = this.getVariableIndex(var);
        int nobs = this.getNumberOfObservationsOnModel();
        LinkedHashMap<String, String> items = new LinkedHashMap<String, String>();
        LinkedHashMap<Object, String> rawValuesToFormattedValuesMap = new LinkedHashMap<Object, String>();
        int count = 0;
        int idx = this.getVariableIndex(var);
        for (int i = 0; i < nobs; ++i) {
            String formattedValue;
            Object value = this.getModelValue(index, i);
            if (rawValuesToFormattedValuesMap.containsKey(value) || (formattedValue = this.computeFormattedValueByIndex(idx, value, null)) == null || items.containsKey(formattedValue)) continue;
            if (++count > maxSize) {
                return TOO_MANY_VALUES;
            }
            items.put(formattedValue, formattedValue);
            rawValuesToFormattedValuesMap.put(value, formattedValue);
        }
        return items;
    }

    protected Object updateVariableValueList(Object var, int maxSize, LinkedHashMap items, int obs, LinkedHashMap rawValuesToFormattedValuesMap) {
        String formattedValue;
        if (var == null || items == null || obs < 0 || obs >= this.getNumberObservations(-1)) {
            return null;
        }
        int index = this.getVariableIndex(var);
        if (rawValuesToFormattedValuesMap == null) {
            return null;
        }
        Object value = this.getModelValue(index, obs);
        int count = items.size();
        if (!rawValuesToFormattedValuesMap.containsKey(value) && (formattedValue = this.computeFormattedValueByIndex(index, value, null)) != null) {
            if (!items.containsKey(formattedValue)) {
                if (++count > maxSize) {
                    return TOO_MANY_VALUES;
                }
                items.put(formattedValue, formattedValue);
            }
            rawValuesToFormattedValuesMap.put(value, formattedValue);
        }
        return items;
    }

    protected Object buildVariableValueList(Object var, int[] subsetList, int maxSize, boolean includeMissing) {
        if (var == null || subsetList == null) {
            return null;
        }
        if (includeMissing && this.subsetUniqueValues.containsKey(var)) {
            return this.subsetUniqueValues.get(var);
        }
        if (!includeMissing && this.subsetNonMissingUniqueValues.containsKey(var)) {
            return this.subsetNonMissingUniqueValues.get(var);
        }
        int index = this.getVariableIndex(var);
        LinkedHashMap<String, String> items = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> nonMissingItems = new LinkedHashMap<String, String>();
        LinkedHashMap<Object, String> rawValues = new LinkedHashMap<Object, String>();
        int count = 0;
        int idx = this.getVariableIndex(var);
        for (int i = 0; i < subsetList.length; ++i) {
            String formattedValue;
            Object value = this.getModelValue(index, subsetList[i]);
            if (value == null || rawValues.containsKey(value) || (formattedValue = this.computeFormattedValueByIndex(idx, value, null)) == null || items.containsKey(formattedValue)) continue;
            if (++count > maxSize) {
                return TOO_MANY_VALUES;
            }
            if (!this.isMissing(idx, value)) {
                nonMissingItems.put(formattedValue, formattedValue);
            }
            items.put(formattedValue, formattedValue);
            rawValues.put(value, formattedValue);
        }
        this.subsetNonMissingUniqueValues.put(var, nonMissingItems);
        this.subsetFormattedValues.put(var, rawValues);
        this.subsetUniqueValues.put(var, items);
        if (includeMissing) {
            return items;
        }
        return nonMissingItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String computeFormattedValueByIndex(int idx, Object value, Object format) {
        Object o = null;
        SASFormat fmt = null;
        if (value == null) {
            return null;
        }
        if (format != null && format instanceof SASFormat) {
            fmt = (SASFormat)format;
        } else {
            o = this.getFormat(this.getVariableId(idx), SASFormat.class);
            if (o instanceof SASFormat) {
                fmt = (SASFormat)o;
            }
        }
        if (fmt == null && value instanceof Number && this.defFmt != null) {
            fmt = this.defFmt;
        }
        if (fmt == null) {
            return value.toString();
        }
        SASFormat sASFormat = fmt;
        synchronized (sASFormat) {
            return fmt.format(value);
        }
    }

    @Override
    public Object getAdapter(Class type) {
        if (type == FilterPickInterface.class) {
            if (this.picker == null) {
                this.picker = new PickObject();
            }
            return this.picker;
        }
        if (type == DataFilterStatisticsInterface.class) {
            if (this.statistics == null) {
                this.statistics = new DefaultStatistics(this);
            }
            return this.statistics;
        }
        if (type == RangeInfoModel.class) {
            if (this.rangeInfoModel == null) {
                this.rangeInfoModel = new RangeInfoModel(this);
            }
            return this.rangeInfoModel;
        }
        return null;
    }

    @Override
    public boolean areSelectionsLocal() {
        return this.localSelections;
    }

    @Override
    public void setSelectionsLocal(boolean local) {
        this.localSelections = local;
    }

    @Override
    public boolean isGraphedLocal() {
        return this.localGraphed;
    }

    @Override
    public void setGraphedLocal(boolean local) {
        this.localGraphed = local;
    }

    public void setSuppressEvents(boolean suppressEvents) {
        this.suppressEvents = suppressEvents;
    }

    private boolean containsListener(EventListenerList listeners, Object listener) {
        if (listeners != null && listener != null) {
            Object[] listenerList = listeners.getListenerList();
            for (int i = 0; i < listenerList.length; ++i) {
                if (listener != listenerList[i]) continue;
                return true;
            }
        }
        return false;
    }

    class PickObject
    implements FilterPickInterface {
        PickObject() {
        }

        @Override
        public int pickFirst(String[] variables, DataRange[] values) {
            if (variables == null || values == null || variables.length != values.length) {
                return -1;
            }
            boolean[] discrete = new boolean[variables.length];
            for (int i = 0; i < variables.length; ++i) {
                if (!AbstractDataFilter.this.verifyVariable(variables[i])) {
                    return -1;
                }
                if (AbstractDataFilter.this.isNumericVariable(variables[i])) {
                    if (!(values[i] instanceof ContinuousRange)) {
                        return -1;
                    }
                    discrete[i] = false;
                }
                if (AbstractDataFilter.this.isNumericVariable(variables[i])) continue;
                if (!(values[i] instanceof DiscreteRange)) {
                    return -1;
                }
                discrete[i] = true;
            }
            int numObs = AbstractDataFilter.this.getNumberObservations(-1);
            int[] indexes = new int[variables.length];
            for (int i = 0; i < variables.length; ++i) {
                indexes[i] = AbstractDataFilter.this.getVariableIndex(variables[i]);
            }
            DiscretePoint dp = new DiscretePoint();
            ContinuousPoint cp = new ContinuousPoint();
            for (int i = numObs - 1; i >= 0; --i) {
                boolean inBB = true;
                for (int j = 0; j < indexes.length; ++j) {
                    if (discrete[j]) {
                        dp.setValue(AbstractDataFilter.this.getFormattedValue((Object)variables[j], i, (Object)null));
                        if (values[j].contains(dp)) continue;
                        inBB = false;
                        continue;
                    }
                    cp.setValue(AbstractDataFilter.this.getNumericValue(indexes[j], (long)i));
                    if (values[j].contains(cp)) continue;
                    inBB = false;
                }
                if (!inBB) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int[] pickAll(String[] variables, DataRange[] values) {
            if (variables == null || values == null || variables.length != values.length) {
                return null;
            }
            boolean[] discrete = new boolean[variables.length];
            for (int i = 0; i < variables.length; ++i) {
                if (!AbstractDataFilter.this.verifyVariable(variables[i])) {
                    return null;
                }
                if (AbstractDataFilter.this.isNumericVariable(variables[i])) {
                    if (!(values[i] instanceof ContinuousRange)) {
                        return null;
                    }
                    discrete[i] = false;
                }
                if (AbstractDataFilter.this.isNumericVariable(variables[i])) continue;
                if (!(values[i] instanceof DiscreteRange)) {
                    return null;
                }
                discrete[i] = true;
            }
            int numObs = AbstractDataFilter.this.getNumberObservations(-1);
            int[] indexes = new int[variables.length];
            for (int i = 0; i < variables.length; ++i) {
                indexes[i] = AbstractDataFilter.this.getVariableIndex(variables[i]);
            }
            BitSet bits = new BitSet(numObs);
            DiscretePoint dp = new DiscretePoint();
            ContinuousPoint cp = new ContinuousPoint();
            for (int i = 0; i < numObs; ++i) {
                boolean inBB = true;
                for (int j = 0; j < indexes.length; ++j) {
                    if (discrete[j]) {
                        dp.setValue(AbstractDataFilter.this.getValue(indexes[j], (long)i));
                        if (values[j].contains(dp)) continue;
                        inBB = false;
                        continue;
                    }
                    cp.setValue(AbstractDataFilter.this.getNumericValue(indexes[j], (long)i));
                    if (values[j].contains(cp)) continue;
                    inBB = false;
                }
                if (!inBB) continue;
                bits.set(i);
            }
            int[] obs = new int[bits.cardinality()];
            int count = 0;
            int i = bits.nextSetBit(0);
            while (i >= 0) {
                obs[count++] = i;
                i = bits.nextSetBit(i + 1);
            }
            return obs;
        }
    }
}

