/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.common.waterfall;

import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Accumulator;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ColorMap;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.Bar;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.gtk.gl.SelectResult;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import java.util.Vector;

public class WaterfallParmObject {
    protected Channel channel;
    protected NetworkRoot root;
    protected Bar transactionBar;
    protected Bar initialBar;
    protected Bar finalBar;
    protected RasterLabel barLabel;
    protected Variable categoryVariable;
    protected Variable responseVariable;
    protected Variable colorVariable;
    protected Variable dataLabelVariable;
    protected StringToNumericMapper categoryMapper;
    protected ContinuousRangeToNumericMapper startValueMapper;
    protected ContinuousRangeToNumericMapper endValueMapper;
    protected ColorMapper colorMapper;
    private Accumulator cumulativeResponse;
    private Calculator computedEndValue;
    private Calculator computedStartValue;
    private BooleanVector isCategorySelected;
    protected boolean reconnectRequired = false;
    protected DataRange categoryRange;
    protected DataRange responseRange;
    protected DataRange colorRange;
    protected int totalNumberOfCategories = 0;
    protected double barThicknessAsPercentage = 0.85;
    protected double barThicknessRelative;
    protected Image barSkin;
    protected int skinType;
    protected boolean displayBarLabels = this.showBarLabels;
    protected boolean showBarLabels = false;
    protected boolean showTrendLine = true;
    protected boolean showBarEdge = true;
    protected boolean showBarFill = true;
    protected boolean showInitialBar = false;
    protected boolean showFillColor = true;
    protected boolean showFinalBar = true;
    protected double baselineIntercept = 0.0;
    protected int trendlineType;
    public static final int TREND_TO_END = 1;
    public static final int TREND_TO_START = 0;
    protected FillAttrs transactionBarFillAttrs = null;
    protected FillAttrs initialBarFillAttrs = null;
    protected FillAttrs finalBarFillAttrs = null;
    protected LineAttrs barOutlineAttrs = null;
    protected LineAttrs trendlineAttrs = null;
    protected TextStyle barLabelStyle = new TextStyle();
    protected TextStyle dataLabelStyle;
    protected double initialBarValue;
    protected double finalBarValue;
    protected String initialBarTickmarkLabel;
    protected String finalBarTickmarkLabel;
    private static final int BAR_COLOR_POLICY_DEFAULT = 0;
    public static final int BAR_COLOR_POLICY_CHART = 1;
    public static final int BAR_COLOR_POLICY_DISCRETE = 2;
    public static final int BAR_COLOR_POLICY_CONTINUOUS = 3;
    public static final int BAR_COLOR_POLICY_DISCRETE_GRADIENT = 4;
    public static final int BAR_COLOR_POLICY_CONTINUOUS_GRADIENT = 5;
    private int barColorPolicy = 0;
    private String colorModel = null;
    private double lowerLimit = 0.0;
    private double upperLimit = 0.0;

    public WaterfallParmObject() {
        this.barLabelStyle.setColor(Color.BLUE);
        this.dataLabelStyle = new TextStyle();
        this.dataLabelStyle.setColor(Color.MAGENTA);
        this.initialBarValue = this.showInitialBar ? 0.0 : 0.0;
        this.finalBarValue = 0.0;
        this.initialBarTickmarkLabel = "Initial";
        this.initialBarFillAttrs = new FillAttrs();
        this.initialBarFillAttrs.setColor(Color.GRAY);
        this.initialBarFillAttrs.setTransparency(0.0);
        this.transactionBarFillAttrs = new FillAttrs();
        this.transactionBarFillAttrs.setColor(Color.BLUE);
        this.transactionBarFillAttrs.setTransparency(0.0);
        this.finalBarTickmarkLabel = "Final";
        this.finalBarFillAttrs = new FillAttrs();
        this.finalBarFillAttrs.setColor(Color.GRAY);
        this.finalBarFillAttrs.setTransparency(0.0);
        this.barOutlineAttrs = new LineAttrs();
        this.barOutlineAttrs.setColor(Color.black);
        this.barOutlineAttrs.setWidth(1);
        this.trendlineAttrs = new LineAttrs();
        this.trendlineAttrs.setColor(Color.GREEN);
        this.trendlineAttrs.setPatternName("Solid");
        this.trendlineAttrs.setWidth(1);
        this.trendlineType = 0;
    }

    public void setDisplayMode(String mode) {
        if (mode.length() == 0) {
            return;
        }
        if (mode.equalsIgnoreCase("standard")) {
            this.showFinalBar = true;
            this.showTrendLine = false;
            this.showBarEdge = true;
            this.showBarFill = true;
        } else if (mode.equalsIgnoreCase("all")) {
            this.showFinalBar = true;
            this.showTrendLine = true;
            this.showBarEdge = true;
            this.showBarFill = true;
        } else {
            this.showFinalBar = false;
            this.showTrendLine = false;
            this.showBarEdge = false;
            this.showBarFill = false;
            StringTokenizer st = new StringTokenizer(mode);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("Fill".equalsIgnoreCase(token)) {
                    this.showBarFill = true;
                    continue;
                }
                if ("Outline".equalsIgnoreCase(token)) {
                    this.showBarEdge = true;
                    continue;
                }
                if ("TrendLines".equalsIgnoreCase(token)) {
                    this.showTrendLine = true;
                    continue;
                }
                if (!"FinalBar".equalsIgnoreCase(token)) continue;
                this.showFinalBar = true;
            }
        }
    }

    public Font getBarLabelFont() {
        return this.barLabelStyle.getFont();
    }

    public void setBarLabelFont(Font font) {
        this.barLabelStyle.setFont(font);
    }

    public Color getBarLabelColor() {
        return this.barLabelStyle.getColor();
    }

    public void setBarLabelColor(Color color) {
        this.barLabelStyle.setColor(color);
    }

    public Image getBarSkin() {
        return this.barSkin;
    }

    public void setBarSkin(Image barSkin) {
        this.barSkin = barSkin;
    }

    public void setSkinType(int t) {
        this.skinType = t;
    }

    public Color getBarEdgeColor() {
        return this.barOutlineAttrs.getColor();
    }

    public void setBarEdgeColor(Color barEdgeColor) {
        this.barOutlineAttrs.setColor(barEdgeColor);
    }

    public int getBarEdgeWidth() {
        return this.barOutlineAttrs.getWidth();
    }

    public void setBarEdgeWidth(int barEdgeWidth) {
        this.barOutlineAttrs.setWidth(barEdgeWidth);
    }

    public double getBarThicknessAsPercentage() {
        return this.barThicknessAsPercentage;
    }

    public void setBarThicknessAsPercentage(double barThicknessAsPercentage) {
        this.barThicknessAsPercentage = barThicknessAsPercentage;
    }

    public double getTransactionBarTransparency() {
        return this.transactionBarFillAttrs.getTransparency();
    }

    public void setTransactionBarTransparency(double transparency) {
        this.transactionBarFillAttrs.setTransparency(transparency);
    }

    public boolean isShowBarLabels() {
        return this.showBarLabels;
    }

    public void setShowBarLabels(boolean showBarLabels) {
        this.showBarLabels = showBarLabels;
        this.checkDisplayLabels();
    }

    public boolean isShowTrendLine() {
        return this.showTrendLine;
    }

    public void setShowTrendLine(boolean showTrendLine) {
        this.showTrendLine = showTrendLine;
    }

    public boolean isShowInitialBar() {
        return this.showInitialBar;
    }

    public void setShowInitialBar(boolean showInitialBar) {
        this.showInitialBar = showInitialBar;
    }

    public boolean isShowFinalBar() {
        return this.showFinalBar;
    }

    public void setShowFinalBar(boolean showFinalBar) {
        this.showFinalBar = showFinalBar;
    }

    public double getBaselineIntercept() {
        return this.baselineIntercept;
    }

    public void setBaselineIntercept(double baselineIntercept) {
        this.baselineIntercept = baselineIntercept;
    }

    public int getTrendlineType() {
        return this.trendlineType;
    }

    public void setTrendlineType(int trendlineType) {
        this.trendlineType = trendlineType;
    }

    public double getInitialBarValue() {
        return this.initialBarValue;
    }

    public double getFinalBarValue() {
        return this.finalBarValue;
    }

    public void setInitialBarValue(double initialBarValue) {
        this.initialBarValue = initialBarValue;
        if (!Double.isNaN(initialBarValue)) {
            this.showInitialBar = true;
        }
    }

    public Color getInitialBarColor() {
        return this.initialBarFillAttrs.getColor();
    }

    public void setInitialBarColor(Color initialBarColor) {
        this.initialBarFillAttrs.setColor(initialBarColor);
    }

    public double getInitialBarTransparency() {
        return this.initialBarFillAttrs.getTransparency();
    }

    public void setInitialBarTransparency(double initialBarTransparency) {
        this.initialBarFillAttrs.setTransparency(initialBarTransparency);
    }

    public String getInitialBarTickmarkLabel() {
        return this.initialBarTickmarkLabel;
    }

    public void setInitialBarTickmarkLabel(String initialBarTickmarkLabel) {
        this.initialBarTickmarkLabel = initialBarTickmarkLabel;
    }

    public Color getFinalBarColor() {
        return this.finalBarFillAttrs.getColor();
    }

    public void setFinalBarColor(Color finalBarColor) {
        this.finalBarFillAttrs.setColor(finalBarColor);
    }

    public double getFinalBarTransparency() {
        return this.finalBarFillAttrs.getTransparency();
    }

    public void setFinalBarTransparency(double finalBarTransparency) {
        this.finalBarFillAttrs.setTransparency(finalBarTransparency);
    }

    public String getFinalBarTickmarkLabel() {
        return this.finalBarTickmarkLabel;
    }

    public void setFinalBarTickmarkLabel(String finalBarTickmarkLabel) {
        this.finalBarTickmarkLabel = finalBarTickmarkLabel;
    }

    public TextStyle getBarLabelStyle() {
        return this.barLabelStyle;
    }

    public void setBarLabelStyle(TextStyle barLabelStyle) {
        this.barLabelStyle = barLabelStyle;
    }

    public FillAttrs getTransactionBarFillAttrs() {
        return this.transactionBarFillAttrs;
    }

    public void setTransactionBarFillAttrs(FillAttrs transactionBarFillAttrs) {
        this.transactionBarFillAttrs = transactionBarFillAttrs;
    }

    public FillAttrs getInitialBarFillAttrs() {
        return this.initialBarFillAttrs;
    }

    public void setInitialBarFillAttrs(FillAttrs initialBarFillAttrs) {
        this.initialBarFillAttrs = initialBarFillAttrs;
    }

    public FillAttrs getFinalBarFillAttrs() {
        return this.finalBarFillAttrs;
    }

    public void setFinalBarFillAttrs(FillAttrs finalBarFillAttrs) {
        this.finalBarFillAttrs = finalBarFillAttrs;
    }

    public LineAttrs getBarOutlineAttrs() {
        return this.barOutlineAttrs;
    }

    public void setBarOutlineAttrs(LineAttrs barOutlineAttrs) {
        this.barOutlineAttrs = barOutlineAttrs;
    }

    public LineAttrs getTrendlineAttrs() {
        return this.trendlineAttrs;
    }

    public void setTrendlineAttrs(LineAttrs trendlineAttrs) {
        this.trendlineAttrs = trendlineAttrs;
    }

    protected void initInitialBar() {
        this.initialBar = new Bar();
        this.initialBar.setTwoD(true);
        this.initialBar.selectEnabled.setValue(true);
        this.initialBar.selectDetailEnabled.setValue(true);
        this.initialBar.verticalOn.setValue(true);
        this.initialBar.fillOn.setValue(this.showFillColor);
        this.initialBar.color1.setValue(this.adjustTransparency(this.initialBarFillAttrs.getColor(), this.initialBarFillAttrs.getTransparency()));
        this.initialBar.edgeOn.setValue(this.showBarEdge);
        this.initialBar.fillOn.setValue(this.showBarFill);
        this.initialBar.edgeWidth.setValue((double)this.barOutlineAttrs.getWidth());
        this.initialBar.edgeColor.setValue(this.barOutlineAttrs.getColor());
        this.initialBar.trendLineColor.setValue(this.trendlineAttrs.getColor());
        if (this.barSkin != null) {
            this.initialBar.setSkin(this.barSkin);
        }
        this.initialBar.setSkinType(this.skinType);
    }

    protected void initTransactionBar() {
        this.transactionBar = new Bar();
        this.transactionBar.setTwoD(true);
        this.transactionBar.selectEnabled.setValue(true);
        this.transactionBar.selectDetailEnabled.setValue(true);
        this.transactionBar.verticalOn.setValue(true);
        this.transactionBar.fillOn.setValue(this.showFillColor);
        this.transactionBar.trendLineOn.setValue(this.showTrendLine);
        this.transactionBar.trendLineType.setValue(this.trendlineType);
        this.transactionBar.trendLineInitialOn.setValue(this.showTrendLine && this.showInitialBar);
        this.transactionBar.trendLineColor.setValue(this.trendlineAttrs.getColor());
        this.transactionBar.edgeOn.setValue(this.showBarEdge);
        this.transactionBar.fillOn.setValue(this.showBarFill);
        this.transactionBar.edgeWidth.setValue((double)this.barOutlineAttrs.getWidth());
        this.transactionBar.edgeColor.setValue(this.barOutlineAttrs.getColor());
        if (this.barSkin != null) {
            this.transactionBar.setSkin(this.barSkin);
        }
        this.transactionBar.setSkinType(this.skinType);
    }

    protected void initFinalBar() {
        this.finalBar = new Bar();
        this.finalBar.setTwoD(true);
        this.finalBar.selectEnabled.setValue(true);
        this.finalBar.selectDetailEnabled.setValue(true);
        this.finalBar.verticalOn.setValue(true);
        this.finalBar.fillOn.setValue(this.showFillColor);
        this.finalBar.color1.setValue(this.adjustTransparency(this.finalBarFillAttrs.getColor(), this.finalBarFillAttrs.getTransparency()));
        this.finalBar.trendLineOn.setValue(this.showTrendLine);
        this.finalBar.trendLineInitialOn.setValue(this.showTrendLine);
        this.finalBar.trendLineColor.setValue(this.trendlineAttrs.getColor());
        this.finalBar.trendLineType.setValue(1);
        this.finalBar.edgeOn.setValue(this.showBarEdge);
        this.finalBar.fillOn.setValue(this.showBarFill);
        this.finalBar.edgeWidth.setValue((double)this.barOutlineAttrs.getWidth());
        this.finalBar.edgeColor.setValue(this.barOutlineAttrs.getColor());
        if (this.barSkin != null) {
            this.finalBar.setSkin(this.barSkin);
        }
        this.finalBar.setSkinType(this.skinType);
    }

    public void draw() {
        if (!this.allRequiredVariablesAreValid()) {
            return;
        }
        this.channel.glPushAttrib(0);
        this.channel.glDisable(4);
        this.channel.glDisable(3);
        this.root.draw(this.root.getChannel(), false);
        this.channel.glPopAttrib();
    }

    public void select() {
        if (this.root == null || !this.allRequiredVariablesAreValid()) {
            return;
        }
        this.root.draw(this.root.getChannel(), true);
    }

    public Vector getSelected(Rectangle r) {
        if (!this.allRequiredVariablesAreValid()) {
            return null;
        }
        this.channel.glPushAttrib(0);
        this.channel.glDisable(4);
        this.channel.glDisable(3);
        Vector selectedObservations = this.root.select(r.x, r.y, r.width, r.height, true, true);
        if (selectedObservations.size() == 0) {
            if (this.showInitialBar) {
                this.initialBar.highlightOn.setValue(false);
            }
            if (this.showFinalBar) {
                this.finalBar.highlightOn.setValue(false);
            }
        }
        for (int i = selectedObservations.size() - 1; i >= 0; --i) {
            Element selectedElement = ((SelectResult)selectedObservations.get(i)).getElement();
            if (selectedElement.equals(this.transactionBar)) continue;
            if (selectedElement.equals(this.initialBar)) {
                this.initialBar.highlightOn.setValue(true);
            } else if (selectedElement.equals(this.finalBar)) {
                this.finalBar.highlightOn.setValue(true);
            }
            selectedObservations.remove(i);
        }
        this.channel.glPopAttrib();
        return selectedObservations;
    }

    public void setSelected(int[] selectedObservationsArray) {
        for (int i = this.isCategorySelected.capacity() - 1; i >= 0; --i) {
            this.isCategorySelected.setValueAt(false, i);
        }
        if (selectedObservationsArray != null && selectedObservationsArray.length > 0) {
            int numberOfSelectableCategories = this.isCategorySelected.capacity();
            for (int i = selectedObservationsArray.length - 1; i >= 0; --i) {
                if (selectedObservationsArray[i] >= numberOfSelectableCategories) continue;
                this.isCategorySelected.setValueAt(true, selectedObservationsArray[i]);
            }
        }
    }

    public String getTipText(int screenX, int screenY) {
        Rectangle selectArea = new Rectangle(screenX, screenY, 1, 1);
        Vector selectResults = this.getSelected(selectArea);
        if (selectResults == null || selectResults.size() == 0) {
            return null;
        }
        SelectResult result = (SelectResult)selectResults.elementAt(0);
        Element selectedBar = result.getElement();
        int observationIndex = result.getValueIndex();
        if (observationIndex < 0 || observationIndex > this.categoryVariable.getValueCount()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (selectedBar == this.initialBar) {
            sb.append("\n");
            sb.append(this.categoryVariable.getColumnName());
            sb.append(" \t=\t ");
            sb.append(this.initialBarTickmarkLabel);
            sb.append("\n");
            sb.append(this.responseVariable.getColumnName());
            sb.append(" \t=\t ");
            sb.append(this.initialBarValue - this.baselineIntercept);
        } else if (selectedBar == this.finalBar) {
            sb.append("\n");
            sb.append(this.categoryVariable.getColumnName());
            sb.append(" \t=\t ");
            sb.append(this.finalBarTickmarkLabel);
            sb.append("\n");
            sb.append(this.responseVariable.getColumnName());
            sb.append(" \t=\t ");
            sb.append(this.baselineIntercept - this.finalBar.startValue.getValue());
        } else {
            sb.append("\n");
            sb.append(this.categoryVariable.getColumnName());
            sb.append(" \t=\t ");
            sb.append(Variable.getValue((Variable)this.categoryVariable, (int)observationIndex, (boolean)true));
            sb.append("\n");
            sb.append(this.responseVariable.getColumnName());
            sb.append(" \t=\t ");
            sb.append(Variable.getValue((Variable)this.responseVariable, (int)observationIndex, (boolean)true));
        }
        return sb.toString();
    }

    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.categoryRange;
            }
            case 2: {
                return this.responseRange;
            }
            case 4: {
                return this.colorRange;
            }
        }
        return null;
    }

    protected void computeTotalNumberOfCategories() {
        int n = this.totalNumberOfCategories = this.categoryVariable == null ? 0 : this.categoryVariable.getUniqueValueCount();
        if (this.showInitialBar) {
            ++this.totalNumberOfCategories;
        }
        if (this.showFinalBar) {
            ++this.totalNumberOfCategories;
        }
    }

    protected void computeCategoryRange() {
        DataRange newRange = null;
        DataRange oldRange = this.categoryRange;
        this.computeTotalNumberOfCategories();
        if (this.categoryVariable != null) {
            if (this.categoryVariable.getUniqueValueCount() == 0) {
                return;
            }
            int numberOfUniqueValues = this.categoryVariable.getUniqueValueCount();
            Object[] values = new Object[this.totalNumberOfCategories];
            if (this.showInitialBar) {
                values[0] = this.initialBarTickmarkLabel;
            }
            for (int i = numberOfUniqueValues - 1; i >= 0; --i) {
                try {
                    values[i + (this.showInitialBar ? 1 : 0)] = this.categoryVariable.formattedUniqueValue.getValue(i);
                    continue;
                }
                catch (MissingValueException e) {
                    e.printStackTrace();
                }
            }
            if (this.showFinalBar) {
                values[this.totalNumberOfCategories - 1] = this.finalBarTickmarkLabel;
            }
            newRange = new DiscreteRange(values);
            newRange.setLabel(this.categoryVariable.getLabel());
        }
        if (newRange != null && newRange.equals(oldRange)) {
            newRange = oldRange;
        }
        this.categoryRange = newRange;
    }

    protected void computeResponseRange() {
        DataRange newRange = null;
        DataRange oldRange = this.responseRange;
        if (this.responseVariable != null) {
            if (this.responseVariable.getValueCount() == 0) {
                return;
            }
            if (this.responseVariable instanceof NumericVariable) {
                NumericVariable nv = (NumericVariable)this.responseVariable;
                double relativeMin = Math.min(this.initialBarValue, this.baselineIntercept);
                double relativeMax = Math.max(this.initialBarValue, this.baselineIntercept);
                double responseTotal = this.initialBarValue;
                int numberOfValues = nv.getValueCount();
                for (int i = 0; i < numberOfValues; ++i) {
                    try {
                        responseTotal += nv.value.getValue(i);
                        if (responseTotal < relativeMin) {
                            relativeMin = responseTotal;
                            continue;
                        }
                        if (!(responseTotal > relativeMax)) continue;
                        relativeMax = responseTotal;
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                this.finalBarValue = responseTotal;
                newRange = new ContinuousRange(relativeMin, relativeMax);
            }
        }
        if (newRange != null && newRange.equals(oldRange)) {
            newRange = oldRange;
        }
        newRange.setLabel(this.responseVariable.getLabel());
        this.responseRange = newRange;
    }

    protected void computeColorRange() {
        DataRange newRange = null;
        if (this.responseVariable instanceof NumericVariable) {
            if (this.responseVariable.getValueCount() == 0) {
                return;
            }
            NumericVariable rv = (NumericVariable)this.responseVariable;
            if (this.getBarColorPolicy() == 1 || this.getBarColorPolicy() == 2 || this.getBarColorPolicy() == 4) {
                StringVector cv = new StringVector();
                int n = this.responseVariable.getValueCount();
                for (int i = 0; i < n; ++i) {
                    try {
                        if (rv.value.getValue(i) >= 0.0) {
                            cv.addValue("Positive");
                            continue;
                        }
                        cv.addValue("Negative");
                        continue;
                    }
                    catch (MissingValueException e) {
                        cv.addValue("Missing");
                    }
                }
                StringVectorVariable svv = new StringVectorVariable();
                svv.connectFrom((StringPipe)cv);
                this.colorVariable = svv;
                newRange = new DiscreteRange(new Object[]{"Positive", "Negative", "Missing"});
            } else if (this.getBarColorPolicy() == 3 || this.getBarColorPolicy() == 5) {
                NumericVariable nv = new NumericVariable();
                nv.connectFrom(rv);
                this.colorVariable = nv;
                newRange = new ContinuousRange(rv.getMin(), rv.getMax());
            }
        }
        this.colorRange = newRange;
    }

    public Insets getPreferredInnerMargin() {
        int l;
        int t;
        if (this.categoryVariable == null || this.responseVariable == null) {
            return null;
        }
        int b = t = 5;
        int componentBasedWidth = (int)Math.rint(this.channel.getComponent().getWidth() / this.totalNumberOfCategories);
        int mapperBasedWidth = this.categoryMapper == null ? 0 : (int)Math.rint((this.categoryMapper.getOutputMax() - this.categoryMapper.getOutputMin()) / (double)this.totalNumberOfCategories);
        int r = l = Math.max(componentBasedWidth, mapperBasedWidth) / 2;
        if (this.displayBarLabels) {
            double requiredBarLabelHeight = Math.max(this.dataLabelStyle.getFont().getSize(), this.barLabelStyle.getFont().getSize());
            ContinuousRange continuousResponseRange = (ContinuousRange)this.responseRange;
            if (continuousResponseRange.getMin() <= this.baselineIntercept) {
                b = (int)((double)b + requiredBarLabelHeight);
            }
            if (continuousResponseRange.getMax() >= this.baselineIntercept) {
                t = (int)((double)t + requiredBarLabelHeight);
            }
        }
        return new Insets(t, l, b, r);
    }

    public void setDataRegionBounds(Rectangle bounds) {
        this.channel.getComponent().setBounds(bounds);
    }

    public void setChannel(Channel aChannel) {
        if (aChannel == null) {
            return;
        }
        this.channel = aChannel;
        this.createNetwork();
    }

    public Channel getChannel() {
        return this.channel;
    }

    protected void createNetwork() {
        this.root = new NetworkRoot(this.channel);
    }

    public Variable getCatetoryVariable() {
        return this.categoryVariable;
    }

    public void setCategoryVariable(Variable variable) {
        if (variable == null) {
            return;
        }
        this.categoryVariable = variable;
        this.isCategorySelected = new BooleanVector(this.categoryVariable.getValueCount());
        for (int i = this.isCategorySelected.capacity() - 1; i >= 0; --i) {
            this.isCategorySelected.addValue(false);
        }
        this.reconnectRequired = true;
        this.computeCategoryRange();
    }

    public Variable getResponseVariable() {
        return this.responseVariable;
    }

    public void setResponseVariable(Variable variable) {
        if (variable == null) {
            return;
        }
        this.responseVariable = variable;
        this.reconnectRequired = true;
        this.computeResponseRange();
        this.computeColorRange();
    }

    public boolean isReconnectRequired() {
        return this.reconnectRequired;
    }

    public boolean allRequiredVariablesAreValid() {
        return this.root != null && this.channel != null && this.categoryVariable != null && this.responseVariable != null && this.colorVariable != null && this.categoryVariable.isConnected() && this.responseVariable.isConnected() && this.colorVariable.isConnected();
    }

    public boolean connectNetwork(StringToNumericMap categorymap, ContinuousRangeToNumericMap responsemap, ColorMap colormap, Probe probe, Probe initBarProbe, Probe finalBarProbe) {
        if (!this.allRequiredVariablesAreValid()) {
            return false;
        }
        this.root.removeElement((Element)this.initialBar);
        this.root.removeElement((Element)this.transactionBar);
        this.root.removeElement((Element)this.finalBar);
        this.root.removeElement((Element)this.barLabel);
        boolean rc = this.connectCategoryMappers(categorymap);
        rc &= this.connectResponseMappers(responsemap);
        rc &= this.connectColorMappers(colormap);
        LineSegment baseLine = new LineSegment();
        this.root.addElement((Element)baseLine);
        baseLine.beginX.setValue(this.lowerLimit);
        baseLine.beginY.setValue(this.startValueMapper.getValue(this.baselineIntercept));
        baseLine.endX.setValue(this.upperLimit);
        baseLine.endY.setValue(this.startValueMapper.getValue(this.baselineIntercept));
        baseLine.color.setValue(Color.black);
        baseLine.lineWidth.setValue(1.0);
        if (this.showInitialBar) {
            this.initialBar.setUserData((Object)initBarProbe);
        }
        this.transactionBar.setUserData((Object)probe);
        if (this.showFinalBar) {
            this.finalBar.setUserData((Object)finalBarProbe);
        }
        this.root.addElement((Element)this.initialBar);
        this.root.addElement((Element)this.transactionBar);
        this.root.addElement((Element)this.finalBar);
        this.checkDisplayLabels();
        if (this.displayBarLabels) {
            rc &= this.connectBarLabelMappers();
            this.root.addElement((Element)this.barLabel);
        }
        this.reconnectRequired = !rc;
        return rc;
    }

    protected boolean connectCategoryMappers(StringToNumericMap categorymap) {
        if (categorymap == null) {
            return false;
        }
        if (this.categoryMapper == null) {
            this.categoryMapper = new StringToNumericMapper();
        }
        this.categoryMapper.input.disconnect();
        this.categoryMapper.input.connectFrom(this.categoryVariable.formattedValue);
        this.categoryMapper.setMap(categorymap);
        this.computeBarThickness((NumericMap)categorymap);
        this.initTransactionBar();
        this.transactionBar.position.connectFrom((NumericPipe)this.categoryMapper);
        this.transactionBar.thickness.setValue(this.barThicknessRelative);
        this.transactionBar.highlightOn.connectFrom((BooleanPipe)this.isCategorySelected);
        if (this.showInitialBar) {
            this.initInitialBar();
            this.initialBar.position.setValue(categorymap.getOutputMin());
            this.initialBar.thickness.setValue(this.barThicknessRelative);
            this.transactionBar.trendLineInitialX.setValue(this.initialBar.position.getValue() + this.barThicknessRelative / 2.0);
        }
        if (this.showFinalBar) {
            this.initFinalBar();
            this.finalBar.position.setValue(categorymap.getOutputMax());
            this.finalBar.thickness.setValue(this.barThicknessRelative);
            try {
                this.finalBar.trendLineInitialX.setValue(this.categoryMapper.getValue(Variable.getValue((Variable)this.categoryVariable, (int)(this.categoryVariable.getValueCount() - 1), (boolean)true)) + this.barThicknessRelative / 2.0);
            }
            catch (MissingValueException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    protected boolean connectResponseMappers(ContinuousRangeToNumericMap responsemap) {
        if (responsemap == null) {
            return false;
        }
        if (this.cumulativeResponse == null) {
            this.cumulativeResponse = new Accumulator();
            this.cumulativeResponse.setPostAccumulate(true);
            this.cumulativeResponse.setStartValue(this.initialBarValue);
        }
        this.cumulativeResponse.input.disconnect();
        this.cumulativeResponse.input.connectFrom(((NumericVariable)this.responseVariable).value);
        if (this.computedEndValue == null) {
            this.computedStartValue = new Calculator("inA");
            this.computedEndValue = new Calculator("inA + inB");
        }
        this.computedStartValue.inA.connectFrom((NumericPipe)this.cumulativeResponse);
        this.computedEndValue.inA.connectFrom((NumericPipe)this.cumulativeResponse);
        this.computedEndValue.inB.connectFrom(((NumericVariable)this.responseVariable).value);
        if (this.startValueMapper == null) {
            this.startValueMapper = new ContinuousRangeToNumericMapper();
        }
        this.startValueMapper.input.disconnect();
        this.startValueMapper.input.connectFrom((NumericPipe)this.computedStartValue);
        this.startValueMapper.setMap(responsemap);
        if (this.endValueMapper == null) {
            this.endValueMapper = new ContinuousRangeToNumericMapper();
        }
        this.endValueMapper.input.disconnect();
        this.endValueMapper.input.connectFrom((NumericPipe)this.computedEndValue);
        this.endValueMapper.setMap(responsemap);
        this.transactionBar.startValue.connectFrom((NumericPipe)this.startValueMapper);
        this.transactionBar.endValue.connectFrom((NumericPipe)this.endValueMapper);
        if (this.showInitialBar) {
            this.initialBar.startValue.setValue(this.startValueMapper.getValue(this.baselineIntercept));
            this.initialBar.endValue.setValue(this.startValueMapper.getValue(this.initialBarValue));
            this.transactionBar.trendLineInitialY.setValue(this.startValueMapper.getValue(this.initialBarValue));
        }
        if (this.showFinalBar) {
            this.finalBar.trendLineInitialY.setValue(this.startValueMapper.getValue(((NumericVariable)this.responseVariable).getSum() + this.initialBarValue));
            this.finalBar.startValue.setValue(this.startValueMapper.getValue(this.baselineIntercept));
            this.finalBar.endValue.setValue(this.finalBar.trendLineInitialY.getValue());
        }
        return true;
    }

    protected boolean connectBarLabelMappers() {
        if (this.responseVariable == null || this.categoryVariable == null || this.categoryMapper == null) {
            return false;
        }
        GTKFormat responseLabelFormat = this.responseVariable.getFormat();
        int responseCount = this.responseVariable.getValueCount();
        NumericVector responseValues = new NumericVector();
        StringVector labelValues = new StringVector();
        double extraPadding = 0.0;
        NumericVector offset = new NumericVector();
        NumericVector allEndValues = new NumericVector();
        NumericVector computedCategoryPositions = new NumericVector();
        TextStyle labelStyle = null;
        if (this.showInitialBar && this.showBarLabels) {
            allEndValues.addValue(this.initialBar.endValue.getValue());
            computedCategoryPositions.addValue(this.initialBar.position.getValue());
        }
        for (int i = 0; i < responseCount; ++i) {
            try {
                allEndValues.addValue(this.endValueMapper.getValue(i));
                computedCategoryPositions.addValue(this.categoryMapper.getValue(i));
                continue;
            }
            catch (MissingValueException e) {
                e.printStackTrace();
            }
        }
        if (this.showFinalBar && this.showBarLabels) {
            allEndValues.addValue(this.finalBar.endValue.getValue());
            computedCategoryPositions.addValue(this.finalBar.position.getValue());
        }
        Calculator responsePlusOffset = new Calculator("inA + inB");
        responsePlusOffset.inA.connectFrom((NumericPipe)allEndValues);
        responsePlusOffset.inB.connectFrom((NumericPipe)offset);
        IntegerVector justificationStyle = new IntegerVector();
        if (this.dataLabelVariable != null && this.dataLabelVariable.isConnected()) {
            labelStyle = this.dataLabelStyle;
            if (this.showBarLabels && this.showInitialBar) {
                double v = this.initialBarValue - this.baselineIntercept;
                this.updateBarLabelMetaDataVectors(this.initialBarValue, v < 0.0, extraPadding, responseLabelFormat, responseValues, labelValues, offset, justificationStyle);
            }
            for (int i = 0; i < responseCount; ++i) {
                try {
                    double v;
                    Object fdl = Variable.getValue((Variable)this.dataLabelVariable, (int)i, (boolean)true);
                    String label = "";
                    if (fdl != null) {
                        label = fdl.toString();
                    }
                    this.updateBarLabelMetaDataVectors(label, (v = ((NumericVariable)this.responseVariable).value.getValue(i)) < 0.0, extraPadding, labelValues, offset, justificationStyle);
                    continue;
                }
                catch (MissingValueException e) {
                    e.printStackTrace();
                }
            }
            if (this.showBarLabels && this.showFinalBar) {
                double v;
                this.updateBarLabelMetaDataVectors(v, (v = this.initialBarValue + ((NumericVariable)this.responseVariable).getSum()) - this.baselineIntercept < 0.0, extraPadding, responseLabelFormat, responseValues, labelValues, offset, justificationStyle);
            }
        } else {
            labelStyle = this.barLabelStyle;
            double lastValue = 0.0;
            if (this.showInitialBar) {
                double v = this.initialBarValue - this.baselineIntercept;
                this.updateBarLabelMetaDataVectors(this.initialBarValue, v < 0.0, extraPadding, responseLabelFormat, responseValues, labelValues, offset, justificationStyle);
                lastValue = this.initialBarValue;
            }
            for (int i = 0; i < responseCount; ++i) {
                try {
                    double v = ((NumericVariable)this.responseVariable).value.getValue(i);
                    double value = lastValue + v;
                    this.updateBarLabelMetaDataVectors(value, v < 0.0, extraPadding, responseLabelFormat, responseValues, labelValues, offset, justificationStyle);
                    lastValue = value;
                    continue;
                }
                catch (MissingValueException e) {
                    e.printStackTrace();
                }
            }
            if (this.showFinalBar) {
                double v;
                this.updateBarLabelMetaDataVectors(v, (v = this.initialBarValue + ((NumericVariable)this.responseVariable).getSum()) - this.baselineIntercept < 0.0, extraPadding, responseLabelFormat, responseValues, labelValues, offset, justificationStyle);
            }
        }
        StringProperty labelProperty = new StringProperty();
        labelProperty.connectFrom((StringPipe)labelValues);
        if (this.barLabel == null) {
            this.barLabel = new RasterLabel();
            this.barLabel.trimOn.setValue(true);
            this.barLabel.color.setValue(labelStyle.getColor());
            this.barLabel.fontName.setValue(labelStyle.getFont().getName());
            this.barLabel.fontSize.setValue(labelStyle.getFont().getSize());
            this.barLabel.fontStyle.setValue(labelStyle.getFont().getStyle());
            this.barLabel.horizontalJustification.setValue(1);
        } else {
            this.barLabel.string.disconnect();
            this.barLabel.transform.translateX.disconnect();
            this.barLabel.transform.translateY.disconnect();
            this.barLabel.verticalJustification.disconnect();
        }
        this.barLabel.string.connectFrom((StringPipe)labelProperty);
        this.barLabel.transform.translateX.connectFrom((NumericPipe)computedCategoryPositions);
        this.barLabel.transform.translateY.connectFrom((NumericPipe)responsePlusOffset);
        this.barLabel.verticalJustification.connectFrom((IntegerPipe)justificationStyle);
        return true;
    }

    protected void updateBarLabelMetaDataVectors(double newValue, boolean negativeValue, double extraPadding, GTKFormat responseLabelFormat, NumericVector responseValues, StringVector labelValues, NumericVector offset, IntegerVector justificationStyle) {
        responseValues.addValue(newValue);
        labelValues.addValue(responseLabelFormat.format((Object)new Double(newValue)));
        if (!negativeValue) {
            offset.addValue(extraPadding);
            justificationStyle.addValue(3);
        } else if (negativeValue) {
            offset.addValue(-extraPadding);
            justificationStyle.addValue(0);
        }
    }

    protected void updateBarLabelMetaDataVectors(String newValue, boolean negativeValue, double extraPadding, StringVector labelValues, NumericVector offset, IntegerVector justificationStyle) {
        labelValues.addValue(newValue);
        if (!negativeValue) {
            offset.addValue(extraPadding);
            justificationStyle.addValue(3);
        } else if (negativeValue) {
            offset.addValue(-extraPadding);
            justificationStyle.addValue(0);
        }
    }

    protected double computeBarThickness(NumericMap map) {
        this.barThicknessRelative = this.barThicknessAsPercentage * (map.getOutputMax() - map.getOutputMin()) / (double)this.totalNumberOfCategories;
        return this.barThicknessRelative;
    }

    protected boolean connectColorMappers(ColorMap colormap) {
        boolean rc = false;
        switch (this.getBarColorPolicy()) {
            case 1: {
                break;
            }
            case 2: {
                if (!(colormap instanceof StringToColorMap)) break;
                StringToColorMap stcmap = (StringToColorMap)colormap;
                if (this.colorMapper == null || !(this.colorMapper instanceof StringToColorMapper)) {
                    this.colorMapper = new StringToColorMapper();
                }
                StringToColorMapper stcmapper = (StringToColorMapper)this.colorMapper;
                stcmapper.input.disconnect();
                stcmapper.input.connectFrom(((StringVariable)this.colorVariable).value);
                stcmapper.setMap(stcmap);
                this.transactionBar.color1.connectFrom(stcmapper.value);
                rc = true;
                break;
            }
            case 3: {
                if (!(colormap instanceof ContinuousRangeToColorMap)) break;
                ContinuousRangeToColorMap crtcmap = (ContinuousRangeToColorMap)colormap;
                Color[] mappedColors = crtcmap.getColorSpectrumColors();
                for (int i = mappedColors.length - 1; i >= 0; --i) {
                    mappedColors[i] = this.adjustTransparency(mappedColors[i], this.transactionBarFillAttrs.getTransparency());
                }
                crtcmap.setColorSpectrumColors(mappedColors);
                if (this.colorMapper == null || !(this.colorMapper instanceof ContinuousRangeToColorMapper)) {
                    this.colorMapper = new ContinuousRangeToColorMapper();
                }
                ContinuousRangeToColorMapper crtcmapper = (ContinuousRangeToColorMapper)this.colorMapper;
                crtcmapper.input.disconnect();
                crtcmapper.input.connectFrom(((NumericVariable)this.colorVariable).value);
                crtcmapper.setMap(crtcmap);
                this.transactionBar.color1.connectFrom(crtcmapper.value);
                rc = true;
            }
        }
        if (!rc) {
            Color c = this.transactionBarFillAttrs.getColor();
            double fillTransparency = this.transactionBarFillAttrs.getTransparency();
            this.transactionBar.color1.setValue(this.adjustTransparency(c, fillTransparency));
            rc = true;
        }
        return rc;
    }

    protected Color adjustTransparency(Color color, double transparency) {
        if (transparency > 0.0) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * (1.0 - transparency)));
        }
        return color;
    }

    public String[] getUniqueValues(byte dim) {
        Object[] vals;
        if (dim == 4 && this.colorRange instanceof DiscreteRange && (vals = ((DiscreteRange)this.colorRange).getValues().toArray()) != null) {
            String[] str = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                str[i] = vals[i].toString();
            }
            return str;
        }
        return null;
    }

    public void setXLimits(double lowerLimit, double upperLimit) {
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public Variable getDataLabelVariable() {
        return this.dataLabelVariable;
    }

    public void setDataLabelVariable(Variable dataLabelVariable) {
        this.dataLabelVariable = dataLabelVariable;
        this.checkDisplayLabels();
    }

    private void checkDisplayLabels() {
        this.displayBarLabels = this.showBarLabels || this.dataLabelVariable != null && this.dataLabelVariable.isConnected();
    }

    public int getBarColorPolicy() {
        if (0 == this.barColorPolicy) {
            if (this.colorModel == null) {
                return 1;
            }
            if ("ThreeColorRamp".equalsIgnoreCase(this.colorModel) || "ThreeColorAltRamp".equalsIgnoreCase(this.colorModel)) {
                return 3;
            }
            return 2;
        }
        return this.barColorPolicy;
    }

    public void setBarColorPolicy(int barColorPolicy) {
        switch (barColorPolicy) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.barColorPolicy = barColorPolicy;
            }
        }
    }

    public TextStyle getDataLabelStyle() {
        return this.dataLabelStyle;
    }

    public void setDataLabelStyle(TextStyle dataLabelStyle) {
        this.dataLabelStyle = dataLabelStyle;
    }
}

