/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.common.dendrogram;

import com.sas.graphics.common.dendrogram.DendrogramTreeNode;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DendrogramTreeModel
implements TreeModel {
    private DendrogramTreeNode rootNode = null;
    private Hashtable nodes = new Hashtable();
    private LinkedHashMap nodePositionMap = new LinkedHashMap();
    private LinkedHashMap nodeChildrenPositionMap = new LinkedHashMap();
    private DendrogramTreeNode[] leafOrder = null;
    private int sortOrder = 0;

    public DendrogramTreeModel() {
    }

    public DendrogramTreeModel(DendrogramTreeNode root) {
        this();
        this.setRoot(root);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof DendrogramTreeNode) {
            return ((DendrogramTreeNode)parent).getChildAt(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof DendrogramTreeNode) {
            return ((DendrogramTreeNode)parent).getChildCount();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof DendrogramTreeNode && child instanceof DendrogramTreeNode) {
            return ((DendrogramTreeNode)parent).getIndex((DendrogramTreeNode)child);
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.rootNode;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof DendrogramTreeNode) {
            return ((DendrogramTreeNode)node).isLeaf();
        }
        return false;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void setRoot(DendrogramTreeNode root) {
        this.rootNode = root;
        this.nodes.put(this.rootNode.getId(), this.rootNode);
    }

    public void addNode(DendrogramTreeNode parent, DendrogramTreeNode node) {
        parent.addChild(node);
        this.nodes.put(node.getId(), node);
    }

    public DendrogramTreeNode getNode(Object id) {
        if (this.nodes.containsKey(id)) {
            return (DendrogramTreeNode)this.nodes.get(id);
        }
        return null;
    }

    public void removeNode(DendrogramTreeNode node) {
        if (this.nodes.containsKey(node)) {
            DendrogramTreeNode parent = (DendrogramTreeNode)node.getParent();
            parent.remove(node);
            this.nodes.remove(node);
        }
    }

    public void sort(int order) {
        if (this.rootNode == null) {
            return;
        }
        this.sortOrder = order;
        this.rootNode.sort(order);
    }

    public void computeLeafOrder() {
        if (this.rootNode == null) {
            return;
        }
        this.nodePositionMap.clear();
        this.nodeChildrenPositionMap.clear();
        this.leafOrder = this.rootNode.getLeafOrder();
        for (int i = 0; i < this.leafOrder.length; ++i) {
            this.nodePositionMap.put(this.leafOrder[i].getId(), new Double(i));
        }
        this.rootNode.computePosition(this.nodePositionMap, this.nodeChildrenPositionMap);
    }

    public double getPosition(Object id) {
        Object pos = this.nodePositionMap.get(id);
        if (pos != null) {
            return ((Number)pos).doubleValue();
        }
        return Double.NaN;
    }

    public double[] getMinMaxChildPositions(Object id) {
        return (double[])this.nodeChildrenPositionMap.get(id);
    }

    public DendrogramTreeNode[] getLeafOrder() {
        return this.leafOrder;
    }

    public void setLeafOrder(DendrogramTreeNode[] leafOrder) {
        this.leafOrder = leafOrder;
    }

    public DendrogramTreeNode getLeafAt(int position) {
        if (this.leafOrder == null || position < 0 || position >= this.leafOrder.length) {
            return null;
        }
        return this.leafOrder[position];
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public boolean isIncreasingHeight() {
        if (this.rootNode == null || this.rootNode.getChildCount() == 0) {
            return false;
        }
        return this.rootNode.getHeight() > ((DendrogramTreeNode)this.rootNode.getChildAt(0)).getHeight();
    }

    public DendrogramTreeNode[] getCutClustersByHeight(double cutHeight) {
        Vector clusters = new Vector();
        if ((clusters = this.rootNode.getCutClustersByHeight(cutHeight, clusters, this.isIncreasingHeight())).size() == 0) {
            return null;
        }
        DendrogramTreeNode[] cutClusters = new DendrogramTreeNode[clusters.size()];
        for (int i = 0; i < clusters.size(); ++i) {
            cutClusters[i] = (DendrogramTreeNode)clusters.elementAt(i);
        }
        return cutClusters;
    }

    public double[] getMinMaxLeafPositions(Object id) {
        DendrogramTreeNode node = this.getNode(id);
        double[] pos = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        if (node.isLeaf()) {
            pos[0] = pos[1] = this.getPosition(id);
        } else {
            this.findMinMaxLeafPositions(node, pos);
        }
        return pos;
    }

    private void findMinMaxLeafPositions(DendrogramTreeNode node, double[] pos) {
        if (node.isLeaf()) {
            pos[0] = Math.min(pos[0], this.getPosition(node.getId()));
            pos[1] = Math.max(pos[1], this.getPosition(node.getId()));
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.findMinMaxLeafPositions((DendrogramTreeNode)node.getChildAt(i), pos);
            }
        }
    }
}

