/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.common.dendrogram;

import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.common.dendrogram.DendrogramTreeModel;
import com.sas.graphics.common.dendrogram.DendrogramTreeNode;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToNumberMap;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.Dendrogram;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.Rectangle;
import com.sas.graphics.util.legend.LegendItem;
import java.awt.Color;
import java.awt.Insets;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.Vector;

public class DendrogramObject {
    protected DataRange nodeRange = null;
    protected DataRange responseRange = null;
    private Variable nodeVar;
    private Variable parentVar;
    private NumericVariable heightVar;
    private NumericVariable weightVar;
    private NumericVariable numClustersVar;
    private Variable leafLabelVar;
    private LinkedHashMap<Object, Integer> nodeIndexMap = null;
    private NumericVectorVariable nodePositionVar = null;
    private NumericVectorVariable nodeHeightVar = null;
    private NumericVectorVariable parentPositionVar = null;
    private NumericVectorVariable parentHeightVar = null;
    private NumericVectorVariable selectedNodePositionVar = null;
    private NumericVectorVariable selectedNodeHeightVar = null;
    private NumericVectorVariable selectedParentPositionVar = null;
    private NumericVectorVariable selectedParentHeightVar = null;
    private Object rootNodeId = null;
    private int rootNodeIndex = -1;
    private DendrogramTreeNode rootNode = null;
    private ContinuousRange heightRange = null;
    private DiscreteRange leafOrderRange = null;
    private Dendrogram dendrogram = new Dendrogram();
    private Dendrogram selectionDendrogram = new Dendrogram();
    private DendrogramTreeModel model = null;
    private int sortOrder = -2;
    private double cutHeight = Double.NaN;
    private double cutNumClusters = Double.NaN;
    private DendrogramTreeNode[] cutClusters = null;
    protected VariableProcessor selectionProcessor;
    private Rectangle clusterBox = new Rectangle();
    protected LineAttrs lineAttrs = null;
    protected LineAttrs cutLineAttrs = null;
    protected Vector<DendrogramTreeNode> orderedNodes = null;
    protected ResourceBundle resourceBundle = null;
    private boolean xReversed = false;
    private boolean yReversed = false;
    private boolean rootHeightIsMax = true;
    private double minHeight = Double.POSITIVE_INFINITY;
    private double maxHeight = Double.NEGATIVE_INFINITY;
    private int leafAxisOffsetMin = 0;
    private int leafAxisOffsetMax = 0;

    public DendrogramObject() {
        this.resourceBundle = ResourceLoader.loadBundle("com.sas.graphics.common.dendrogram.dendrogram");
        this.dendrogram.color.setValue(Color.black);
        this.dendrogram.lineWidth.setValue(1);
        this.selectionDendrogram.color.setValue(Color.yellow);
        this.selectionDendrogram.lineWidth.setValue(2);
        this.orderedNodes = new Vector();
        this.leafLabelVar = null;
        this.lineAttrs = new LineAttrs();
        this.lineAttrs.setColor(Color.BLACK);
        this.lineAttrs.setPatternName("Solid");
        this.lineAttrs.setWidth(1);
        this.cutLineAttrs = new LineAttrs();
        this.cutLineAttrs.setColor(Color.RED);
        this.cutLineAttrs.setPatternName("Solid");
        this.cutLineAttrs.setWidth(1);
        this.clusterBox.set2D(true);
    }

    private void build() {
        int i;
        if (this.nodeVar == null || this.parentVar == null || this.heightVar == null || this.nodeVar.getValueCount() != this.parentVar.getValueCount() || this.nodeVar.getValueCount() != this.heightVar.getValueCount()) {
            return;
        }
        int numNodes = this.nodeVar.getValueCount();
        this.rootNodeId = null;
        this.leafOrderRange = null;
        this.heightRange = null;
        this.nodeIndexMap = new LinkedHashMap();
        for (i = 0; i < numNodes; ++i) {
            if (!this.parentVar.isMissing(i)) continue;
            this.rootNodeId = Variable.getValue((Variable)this.nodeVar, (int)i, (boolean)true);
            this.rootNodeIndex = i;
            break;
        }
        if (this.rootNodeId == null) {
            return;
        }
        for (i = 0; i < numNodes; ++i) {
            Object n = Variable.getValue((Variable)this.nodeVar, (int)i, (boolean)true);
            if (n == null) continue;
            this.nodeIndexMap.put(n, i);
        }
        this.buildTree();
        this.computePositions();
        if (!Double.isNaN(this.cutHeight)) {
            this.cutClusters = this.model.getCutClustersByHeight(this.cutHeight);
        } else if (!Double.isNaN(this.cutNumClusters)) {
            if (this.orderedNodes.size() > 0 && this.numClustersVar != null && this.cutNumClusters > 0.0 && this.cutNumClusters <= this.numClustersVar.getMax()) {
                DendrogramTreeNode dtn1 = this.getOrderedNode((int)this.cutNumClusters);
                DendrogramTreeNode dtn2 = this.getOrderedNode((int)this.cutNumClusters - 1);
                if (dtn1 == null) {
                    return;
                }
                this.cutHeight = dtn1.getHeight();
                if (dtn2 != null) {
                    this.cutHeight = (dtn1.getHeight() + dtn2.getHeight()) / 2.0;
                }
                this.cutClusters = this.model.getCutClustersByHeight(this.cutHeight);
            }
        } else {
            this.cutClusters = null;
        }
    }

    private void buildTree() {
        Object l;
        if (this.rootNodeId == null) {
            return;
        }
        this.orderedNodes.clear();
        this.rootNode = new DendrogramTreeNode();
        this.rootNode.setId(this.rootNodeId);
        String label = this.rootNode.getId().toString();
        if (this.leafLabelVar != null && (l = Variable.getValue((Variable)this.leafLabelVar, (int)this.rootNodeIndex, (boolean)true)) != null) {
            label = l.toString();
        }
        this.rootNode.setLabel(label);
        double height = this.getNumericValue(Variable.getValue((Variable)this.heightVar, (int)this.rootNodeIndex, (boolean)false));
        this.rootNode.setHeight(height);
        if (this.weightVar != null) {
            this.rootNode.setWeight(this.getNumericValue(Variable.getValue((Variable)this.weightVar, (int)this.rootNodeIndex, (boolean)false)));
        } else {
            this.rootNode.setWeight(Double.NaN);
        }
        this.model = new DendrogramTreeModel(this.rootNode);
        int numNodes = this.nodeVar.getValueCount();
        boolean first = true;
        this.rootHeightIsMax = true;
        double rootHeight = this.getNumericValue(Variable.getValue((Variable)this.heightVar, (int)this.rootNodeIndex, (boolean)false));
        this.minHeight = Double.POSITIVE_INFINITY;
        this.maxHeight = Double.NEGATIVE_INFINITY;
        this.minHeight = Math.min(this.minHeight, rootHeight);
        this.maxHeight = Math.max(this.maxHeight, rootHeight);
        for (int i = 0; i < numNodes; ++i) {
            if (this.rootNodeIndex == i || Double.isNaN(height = this.getNumericValue(Variable.getValue((Variable)this.heightVar, (int)i, (boolean)false)))) continue;
            if (first) {
                this.rootHeightIsMax = rootHeight >= height;
                first = false;
            }
            this.minHeight = Math.min(this.minHeight, height);
            this.maxHeight = Math.max(this.maxHeight, height);
        }
        LinkedHashMap<Object, Vector<DendrogramTreeNode>> childList = new LinkedHashMap<Object, Vector<DendrogramTreeNode>>();
        for (int i = 0; i < numNodes; ++i) {
            Object l2;
            if (this.rootNodeIndex == i) continue;
            DendrogramTreeNode node = new DendrogramTreeNode();
            node.setId(Variable.getValue((Variable)this.nodeVar, (int)i, (boolean)true));
            label = node.getId().toString();
            if (this.leafLabelVar != null && (l2 = Variable.getValue((Variable)this.leafLabelVar, (int)i, (boolean)true)) != null) {
                label = l2.toString();
            }
            node.setLabel(label);
            height = this.getNumericValue(Variable.getValue((Variable)this.heightVar, (int)i, (boolean)false));
            if (Double.isNaN(height)) {
                height = this.getMissingHeightValue();
            }
            node.setHeight(height);
            if (this.weightVar != null) {
                node.setWeight(this.getNumericValue(Variable.getValue((Variable)this.weightVar, (int)i, (boolean)false)));
            } else {
                node.setWeight(Double.NaN);
            }
            if (this.numClustersVar != null) {
                int nClus = (int)this.getNumericValue(Variable.getValue((Variable)this.numClustersVar, (int)i, (boolean)false));
                node.setNumberOfClusters(nClus);
                this.insertNode(this.orderedNodes, node);
            } else {
                node.setNumberOfClusters(0);
            }
            Object parentId = Variable.getValue((Variable)this.parentVar, (int)i, (boolean)true);
            Vector<DendrogramTreeNode> cList = (Vector<DendrogramTreeNode>)childList.get(parentId);
            if (cList == null) {
                cList = new Vector<DendrogramTreeNode>();
                childList.put(parentId, cList);
            }
            cList.add(node);
        }
        if (childList.size() > 0) {
            this.addChildren(this.rootNode, childList);
        }
    }

    private double getMissingHeightValue() {
        if (this.rootHeightIsMax) {
            return this.minHeight;
        }
        return this.maxHeight;
    }

    private void insertNode(Vector<DendrogramTreeNode> orderedNodes, DendrogramTreeNode node) {
        if (node == null) {
            return;
        }
        int index = 0;
        for (int i = 0; i < orderedNodes.size(); ++i) {
            DendrogramTreeNode n = orderedNodes.elementAt(i);
            if (node.getNumberOfClusters() >= n.getNumberOfClusters()) continue;
            index = i;
            break;
        }
        orderedNodes.insertElementAt(node, index);
    }

    private DendrogramTreeNode getOrderedNode(int nClus) {
        if (this.numClustersVar == null || this.orderedNodes.size() == 0 || nClus < 0 || (double)nClus > this.numClustersVar.getMax()) {
            return null;
        }
        for (int i = 0; i < this.orderedNodes.size(); ++i) {
            DendrogramTreeNode n = this.orderedNodes.elementAt(i);
            if (n.getNumberOfClusters() != nClus) continue;
            return n;
        }
        return null;
    }

    private void addChildren(DendrogramTreeNode node, LinkedHashMap childList) {
        Object o = childList.get(node.getId());
        if (o instanceof Vector) {
            Vector children = (Vector)o;
            for (int i = 0; i < children.size(); ++i) {
                this.model.addNode(node, (DendrogramTreeNode)children.elementAt(i));
            }
            childList.remove(node.getId());
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DendrogramTreeNode child = (DendrogramTreeNode)node.getChildAt(i);
            this.addChildren(child, childList);
        }
    }

    private void updateTree() {
        if (this.model == null || this.rootNode == null) {
            return;
        }
        int numNodes = this.nodeVar.getValueCount();
        for (int i = 0; i < numNodes; ++i) {
            Object id = Variable.getValue((Variable)this.nodeVar, (int)i, (boolean)true);
            DendrogramTreeNode node = this.model.getNode(id);
            if (this.weightVar != null) {
                node.setWeight(this.getNumericValue(Variable.getValue((Variable)this.weightVar, (int)i, (boolean)false)));
                continue;
            }
            node.setWeight(Double.NaN);
        }
    }

    private void computePositions() {
        if (this.model == null) {
            return;
        }
        int sort = this.model.getSortOrder();
        if (this.sortOrder != -2) {
            sort = this.sortOrder;
        }
        this.model.sort(sort);
        this.model.computeLeafOrder();
        DendrogramTreeNode[] leafOrder = this.model.getLeafOrder();
        Object[] leaves = new Object[leafOrder.length];
        for (int i = 0; i < leafOrder.length; ++i) {
            leaves[i] = leafOrder[i].getId();
        }
        this.leafOrderRange = new DiscreteRange(leaves);
        this.heightRange = new ContinuousRange(this.heightVar.getMin(), this.heightVar.getMax());
        this.heightRange.setLabel(this.heightVar.getLabel());
    }

    private double getNumericValue(Object v) {
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        return Double.NaN;
    }

    public Variable getNodeVar() {
        return this.nodeVar;
    }

    public void setNodeVar(Variable nodeVar) {
        this.nodeVar = nodeVar;
        this.build();
    }

    public Variable getParentVar() {
        return this.parentVar;
    }

    public void setParentVar(Variable parentVar) {
        this.parentVar = parentVar;
        this.build();
    }

    public Variable getHeightVar() {
        return this.heightVar;
    }

    public void setHeightVar(NumericVariable heightVar) {
        this.heightVar = heightVar;
        this.build();
    }

    public DataRange getLeafOrder() {
        return this.leafOrderRange;
    }

    public ContinuousRange getHeightRange() {
        return this.heightRange;
    }

    public DataRange getDataRange(byte dimension) {
        if (this.dendrogram.getOrientation() == 1) {
            if (1 == dimension) {
                return this.heightRange;
            }
            if (2 == dimension) {
                return this.leafOrderRange;
            }
        } else if (this.dendrogram.getOrientation() == 2) {
            if (1 == dimension) {
                return this.leafOrderRange;
            }
            if (2 == dimension) {
                return this.heightRange;
            }
        }
        return null;
    }

    public void select(NetworkRoot networkRoot) {
        if (networkRoot == null) {
            return;
        }
        networkRoot.draw(networkRoot.getChannel(), true);
    }

    public String validateData() {
        if (this.rootNode == null || this.rootNode.getChildCount() == 0) {
            return ResourceLoader.getResourceString(this.resourceBundle, "DendrogramObject.InvalidParentData.txt", "Nodes without valid parent nodes have been dropped");
        }
        return null;
    }

    public boolean connectNetwork(NetworkRoot networkRoot, ValueMap xValueMap, ValueMap yValueMap, Probe probe, boolean xReversed, boolean yReversed) {
        networkRoot.removeAllElements();
        ContinuousRangeToNumericMap heightMap = null;
        StringToNumberMap leafAxisMap = null;
        boolean heightReversed = false;
        switch (this.dendrogram.getOrientation()) {
            case 1: {
                if (!(xValueMap instanceof ContinuousRangeToNumericMap) || !(yValueMap instanceof StringToNumberMap) && !(yValueMap instanceof StringToNumericMap)) {
                    return false;
                }
                heightMap = (ContinuousRangeToNumericMap)xValueMap;
                heightReversed = xReversed;
                if (yValueMap instanceof StringToNumberMap) {
                    leafAxisMap = (StringToNumberMap)yValueMap;
                    break;
                }
                leafAxisMap = this.convertToNumberMap((StringToNumericMap)yValueMap);
                break;
            }
            case 2: {
                if (!(xValueMap instanceof StringToNumberMap) && !(xValueMap instanceof StringToNumericMap) || !(yValueMap instanceof ContinuousRangeToNumericMap)) {
                    return false;
                }
                heightMap = (ContinuousRangeToNumericMap)yValueMap;
                heightReversed = yReversed;
                leafAxisMap = xValueMap instanceof StringToNumberMap ? (StringToNumberMap)xValueMap : this.convertToNumberMap((StringToNumericMap)xValueMap);
            }
        }
        int numNodes = this.nodeVar.getValueCount();
        double[] nPos = new double[numNodes];
        double[] pPos = new double[numNodes];
        double[] nHeight = new double[numNodes];
        double[] pHeight = new double[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            Object node = Variable.getValue((Variable)this.nodeVar, (int)i, (boolean)true);
            DendrogramTreeNode n = this.model.getNode(node);
            if (n == null) continue;
            nPos[i] = this.getMappedPosition(leafAxisMap, this.model.getPosition(node));
            double height = this.getNumericValue(Variable.getValue((Variable)this.heightVar, (int)i, (boolean)false));
            if (Double.isNaN(height)) {
                height = this.getMissingHeightValue();
            }
            nHeight[i] = heightMap.getValue(height);
            int nIndex = this.nodeIndexMap.get(node);
            Object parent = Variable.getValue((Variable)this.parentVar, (int)nIndex, (boolean)true);
            pPos[i] = this.getMappedPosition(leafAxisMap, this.model.getPosition(parent));
            int pIndex = (int)this.getNumericValue(this.nodeIndexMap.get(parent));
            pHeight[i] = heightMap.getValue(this.getNumericValue(Variable.getValue((Variable)this.heightVar, (int)pIndex, (boolean)false)));
        }
        this.nodePositionVar = new NumericVectorVariable();
        this.nodePositionVar.connectFrom(nPos);
        this.nodeHeightVar = new NumericVectorVariable();
        this.nodeHeightVar.connectFrom(nHeight);
        this.parentPositionVar = new NumericVectorVariable();
        this.parentPositionVar.connectFrom(pPos);
        this.parentHeightVar = new NumericVectorVariable();
        this.parentHeightVar.connectFrom(pHeight);
        switch (this.dendrogram.getOrientation()) {
            case 1: {
                this.dendrogram.coordX.connectFrom(this.nodeHeightVar.value);
                this.dendrogram.coordY.connectFrom(this.nodePositionVar.value);
                this.dendrogram.parentX.connectFrom(this.parentHeightVar.value);
                this.dendrogram.parentY.connectFrom(this.parentPositionVar.value);
                break;
            }
            case 2: {
                this.dendrogram.coordX.connectFrom(this.nodePositionVar.value);
                this.dendrogram.coordY.connectFrom(this.nodeHeightVar.value);
                this.dendrogram.parentX.connectFrom(this.parentPositionVar.value);
                this.dendrogram.parentY.connectFrom(this.parentHeightVar.value);
            }
        }
        this.dendrogram.color.setValue(this.lineAttrs.getColor());
        this.dendrogram.lineWidth.setValue(this.lineAttrs.getWidth());
        this.dendrogram.linePattern.setValue(this.lineAttrs.getLinePattern());
        this.dendrogram.setUserData((Object)probe);
        networkRoot.addElement((Element)this.dendrogram);
        if (this.cutClusters != null) {
            double min = this.getMappedPosition(leafAxisMap, 0.0);
            double d2 = this.getMappedPosition(leafAxisMap, 1.0);
            double max = this.getMappedPosition(leafAxisMap, this.leafOrderRange.getValuesSize() - 1);
            double tickDist = Math.abs(d2 - min);
            double heightMin = 0.0;
            if (this.model.isIncreasingHeight() && !heightReversed || !this.model.isIncreasingHeight() && heightReversed) {
                heightMap.getValue(heightMap.getInputMin());
            } else {
                heightMin = heightMap.getValue(heightMap.getInputMax());
            }
            double cutHt = heightMap.getValue(this.cutHeight);
            double[] pos = new double[this.cutClusters.length];
            double[] sizePos = new double[this.cutClusters.length];
            int wallMin = (int)(leafAxisMap.getOutputMin() - (double)this.leafAxisOffsetMin);
            int wallMax = (int)(leafAxisMap.getOutputMax() + (double)this.leafAxisOffsetMax);
            for (int i = 0; i < this.cutClusters.length; ++i) {
                DendrogramTreeNode node = this.cutClusters[i];
                double p = Double.NaN;
                double size = Double.NaN;
                double[] cPos = this.model.getMinMaxLeafPositions(node.getId());
                if (cPos != null) {
                    double left = this.getMappedPosition(leafAxisMap, cPos[0]);
                    double right = this.getMappedPosition(leafAxisMap, cPos[1]);
                    p = (left + right) / 2.0;
                    size = (cPos[1] - cPos[0]) * tickDist + (tickDist - 4.0);
                } else {
                    double position = this.model.getPosition(node.getId());
                    p = this.getMappedPosition(leafAxisMap, position);
                    size = tickDist;
                }
                pos[i] = Math.max(min, Math.min(p, max));
                sizePos[i] = size;
                if (pos[i] - size / 2.0 < (double)wallMin) {
                    int end = (int)(pos[i] + size / 2.0);
                    size = end - wallMin;
                    pos[i] = (double)end - size / 2.0;
                    sizePos[i] = size;
                }
                if (!(pos[i] + size / 2.0 > (double)wallMax)) continue;
                int start = (int)(pos[i] - size / 2.0);
                size = wallMax - start;
                pos[i] = (double)start + size / 2.0;
                sizePos[i] = size;
            }
            NumericVectorVariable clusterPos = new NumericVectorVariable();
            clusterPos.connectFrom(pos);
            NumericVectorVariable clusterSize = new NumericVectorVariable();
            clusterSize.connectFrom(sizePos);
            this.clusterBox.fillOn.setValue(false);
            this.clusterBox.edgeOn.setValue(true);
            this.clusterBox.color.setValue(this.cutLineAttrs.getColor());
            this.clusterBox.edgeColor.setValue(this.cutLineAttrs.getColor());
            this.clusterBox.edgeWidth.setValue(this.cutLineAttrs.getWidth());
            this.clusterBox.edgePattern.setValue(this.cutLineAttrs.getLinePattern());
            switch (this.dendrogram.getOrientation()) {
                case 1: {
                    this.clusterBox.coordY.connectFrom(clusterPos.value);
                    this.clusterBox.sizeY.connectFrom(clusterSize.value);
                    if (this.model.isIncreasingHeight() && !xReversed || !this.model.isIncreasingHeight() && xReversed) {
                        this.clusterBox.coordX.setValue(heightMin + cutHt / 2.0);
                        this.clusterBox.sizeX.setValue(cutHt);
                        break;
                    }
                    this.clusterBox.coordX.setValue((heightMin + cutHt) / 2.0);
                    this.clusterBox.sizeX.setValue(cutHt - heightMin);
                    break;
                }
                case 2: {
                    this.clusterBox.coordX.connectFrom(clusterPos.value);
                    this.clusterBox.sizeX.connectFrom(clusterSize.value);
                    if (this.model.isIncreasingHeight() && !yReversed || !this.model.isIncreasingHeight() && yReversed) {
                        this.clusterBox.coordY.setValue(heightMin + cutHt / 2.0);
                        this.clusterBox.sizeY.setValue(cutHt);
                        break;
                    }
                    this.clusterBox.coordY.setValue((heightMin + cutHt) / 2.0);
                    this.clusterBox.sizeY.setValue(cutHt - heightMin);
                }
            }
            networkRoot.addElement((Element)this.clusterBox);
        }
        return true;
    }

    public boolean connectSelectionNetwork(NetworkRoot selectionNetworkRoot) {
        selectionNetworkRoot.removeAllElements();
        if (this.nodePositionVar == null || this.nodeHeightVar == null || this.parentPositionVar == null || this.parentHeightVar == null) {
            return false;
        }
        this.selectionProcessor = new VariableProcessor();
        this.selectedNodePositionVar = new NumericVectorVariable();
        this.selectedNodePositionVar.connectFrom(this.nodePositionVar.value);
        this.selectionProcessor.addVariable((Variable)this.selectedNodePositionVar);
        this.selectedNodeHeightVar = new NumericVectorVariable();
        this.selectedNodeHeightVar.connectFrom(this.nodeHeightVar.value);
        this.selectionProcessor.addVariable((Variable)this.selectedNodeHeightVar);
        this.selectedParentPositionVar = new NumericVectorVariable();
        this.selectedParentPositionVar.connectFrom(this.parentPositionVar.value);
        this.selectionProcessor.addVariable((Variable)this.selectedParentPositionVar);
        this.selectedParentHeightVar = new NumericVectorVariable();
        this.selectedParentHeightVar.connectFrom(this.parentHeightVar.value);
        this.selectionProcessor.addVariable((Variable)this.selectedParentHeightVar);
        switch (this.selectionDendrogram.getOrientation()) {
            case 1: {
                this.selectionDendrogram.coordX.connectFrom(this.selectedNodeHeightVar.value);
                this.selectionDendrogram.coordY.connectFrom(this.selectedNodePositionVar.value);
                this.selectionDendrogram.parentX.connectFrom(this.selectedParentHeightVar.value);
                this.selectionDendrogram.parentY.connectFrom(this.selectedParentPositionVar.value);
                break;
            }
            case 2: {
                this.selectionDendrogram.coordX.connectFrom(this.selectedNodePositionVar.value);
                this.selectionDendrogram.coordY.connectFrom(this.selectedNodeHeightVar.value);
                this.selectionDendrogram.parentX.connectFrom(this.selectedParentPositionVar.value);
                this.selectionDendrogram.parentY.connectFrom(this.selectedParentHeightVar.value);
            }
        }
        this.selectionDendrogram.lineWidth.setValue(this.lineAttrs.getWidth());
        selectionNetworkRoot.addElement((Element)this.selectionDendrogram);
        return true;
    }

    private StringToNumberMap convertToNumberMap(StringToNumericMap valueMap) {
        StringToNumberMap map = new StringToNumberMap();
        map.setTrimTrailing(true);
        StringPipe sPipe = valueMap.getStringPipe(0);
        map.addStringPipe(sPipe);
        int n = valueMap.getUniqueValueCount();
        for (int i = 0; i < n; ++i) {
            try {
                String o = sPipe.getValue(i);
                if (o == null) continue;
                double d = valueMap.getValue((Object)o);
                map.add(o.toString(), (Number)new Double(d));
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        map.init(new AInitAction());
        return map;
    }

    public void setSelectedLineColor(Color c) {
        this.selectionDendrogram.color.setValue(c);
    }

    public Color getSelectedLineColor() {
        return this.selectionDendrogram.color.getValue();
    }

    public void setSelected(int[] selectedObs) {
        if (selectedObs == null) {
            this.selectionProcessor.clearSubsetByObservation();
        } else {
            this.selectionProcessor.setSubsetByObservation(selectedObs, selectedObs.length);
        }
    }

    private double getMappedPosition(StringToNumberMap leafAxisMap, double pos) {
        double d1 = 0.0;
        double stride = 0.0;
        try {
            d1 = leafAxisMap.getValue(this.model.getLeafAt((int)pos).getId());
            stride = leafAxisMap.getValue(this.model.getLeafAt(1).getId()) - leafAxisMap.getValue(this.model.getLeafAt(0).getId());
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        double d2 = (pos - (double)((int)pos)) * stride;
        return d1 + d2;
    }

    public Insets getPreferredInnerMargin() {
        int offset;
        int lineWidth = Math.round(this.lineAttrs.getWidth() * 2 - 1);
        int top = offset = Math.max(lineWidth, 5);
        int bottom = offset;
        int left = offset;
        int right = offset;
        if (this.dendrogram.getOrientation() == 1) {
            if (this.heightVar != null && this.heightVar.getMax() <= 0.0) {
                if (this.xReversed) {
                    left = 0;
                } else {
                    right = 0;
                }
            } else if (this.xReversed) {
                right = 0;
            } else {
                left = 0;
            }
        } else if (this.dendrogram.getOrientation() == 2) {
            if (this.heightVar != null && this.heightVar.getMax() <= 0.0) {
                if (this.yReversed) {
                    bottom = 0;
                } else {
                    top = 0;
                }
            } else if (this.yReversed) {
                top = 0;
            } else {
                bottom = 0;
            }
        }
        return new Insets(top, left, bottom, right);
    }

    public void setConnectType(int type) {
        if (this.dendrogram != null) {
            this.dendrogram.setConnectType(type);
            this.selectionDendrogram.setConnectType(type);
        }
    }

    public int getConnectType() {
        if (this.dendrogram != null) {
            return this.dendrogram.getConnectType();
        }
        return 2;
    }

    public int getOrientation() {
        return this.dendrogram.getOrientation();
    }

    public void setOrientation(int orientation) {
        this.dendrogram.setOrientation(orientation);
        this.selectionDendrogram.setOrientation(orientation);
    }

    public void setSortOrder(int order) {
        if (this.model != null) {
            this.model.setSortOrder(order);
            this.computePositions();
        } else {
            this.sortOrder = order;
        }
    }

    public void setCutHeight(double height) {
        this.cutHeight = height;
        this.cutNumClusters = Double.NaN;
    }

    public void setCutClusters(int nClus) {
        this.cutNumClusters = nClus;
        this.cutHeight = Double.NaN;
    }

    public LineAttrs getLineAttrs() {
        return this.lineAttrs;
    }

    public void setLineAttrs(LineAttrs lineAttrs) {
        this.lineAttrs = lineAttrs;
    }

    public Variable getLeafLabelVar() {
        return this.leafLabelVar;
    }

    public void setLeafLabelVar(Variable leafLabelVar) {
        this.leafLabelVar = leafLabelVar;
    }

    public NumericVariable getNumClustersVar() {
        return this.numClustersVar;
    }

    public void setNumClustersVar(NumericVariable numClustersVar) {
        this.numClustersVar = numClustersVar;
    }

    public boolean isXReversed() {
        return this.xReversed;
    }

    public void setXReversed(boolean reversed) {
        this.xReversed = reversed;
    }

    public boolean isYReversed() {
        return this.yReversed;
    }

    public void setYReversed(boolean reversed) {
        this.yReversed = reversed;
    }

    public LegendItem getOverlayLegendItem(String legendLabel) {
        LegendItem item = new LegendItem(2, legendLabel);
        item.setSymbolAttrs((ColorAttr)this.getLineAttrs());
        return item;
    }

    public LineAttrs getCutLineAttrs() {
        return this.cutLineAttrs;
    }

    public void setCutLineAttrs(LineAttrs cutLineAttrs) {
        this.cutLineAttrs = cutLineAttrs;
    }

    public void setLeafAxisOffsetMin(int leafAxisOffsetMin) {
        this.leafAxisOffsetMin = leafAxisOffsetMin;
    }

    public void setLeafAxisOffsetMax(int leafAxisOffsetMax) {
        this.leafAxisOffsetMax = leafAxisOffsetMax;
    }
}

