/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.common.attrmap;

import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.attrmap.RangeAttributeMap;
import com.sas.graphics.util.attrmap.RangeColorMapper;
import com.sas.graphics.util.attrmap.RangeColorMapperFactory;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.text.SASFormat;
import java.awt.Color;

public class RangeAttrMapper
extends AttrMapper {
    public NumericPipe variable;
    public final ColorPipe color = new RangeColorPipe();
    private RangeAttributeMap attrMap;
    private RangeColorMapper rangeColorMapper;
    private double transparency = 0.0;
    private Style style;

    public RangeAttrMapper(RangeAttributeMap attrMap, Style style) {
        this.attrMap = attrMap;
        this.style = style;
    }

    public String createColorMapper(double min, double max, boolean contrastColors, SASFormat format) {
        String error = RangeColorMapperFactory.validateMap((RangeAttributeMap)this.attrMap, (double)min, (double)max);
        if (error != null) {
            return error;
        }
        this.rangeColorMapper = RangeColorMapperFactory.getInstance((RangeAttributeMap)this.attrMap, (double)min, (double)max, (Style)this.style, (boolean)contrastColors, (SASFormat)format);
        return null;
    }

    public String createColorMapper(double min, double max, boolean contrastColors) {
        return this.createColorMapper(min, max, contrastColors, null);
    }

    public String createColorMapper(double min, double max) {
        return this.createColorMapper(min, max, false);
    }

    public RangeAttributeMap getAttrMap() {
        return this.attrMap;
    }

    public void setAttrMap(RangeAttributeMap map) {
        this.attrMap = map;
    }

    public RangeColorMapper getRangeColorMapper() {
        return this.rangeColorMapper;
    }

    public double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(double transparency) {
        this.transparency = transparency;
    }

    private class RangeColorPipe
    implements ColorPipe {
        private RangeColorPipe() {
        }

        public Formatter getFormatter() {
            return RangeAttrMapper.this.variable.getFormatter();
        }

        public void init(AInitAction initAction) {
            RangeAttrMapper.this.variable.init(initAction);
        }

        public void reset(AResetAction resetAction) {
        }

        public Color getValue(int index) throws MissingValueException {
            Color result = null;
            try {
                double value = RangeAttrMapper.this.variable.getValue(index);
                result = RangeAttrMapper.this.rangeColorMapper.getMappedColor(value);
            }
            catch (MissingValueException e) {
                result = RangeAttrMapper.this.rangeColorMapper.getMappedColor(Double.NaN);
            }
            if (result != null) {
                return AttrMapper.applyTransparency(result, RangeAttrMapper.this.transparency);
            }
            return null;
        }
    }
}

