/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.range;

import com.sas.graphics.applets.statgraph.sgchart.range.BinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.SimpleBinnedRange;

public class CustomBinnedRange
extends BinnedRange {
    private boolean endLabels = true;
    private boolean updateDual = false;
    private double[] boundaries;
    private double[] midpoints;
    private double min;
    private double max;

    public CustomBinnedRange() {
        this.valid = false;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CustomBinnedRange)) {
            return false;
        }
        CustomBinnedRange cbr = (CustomBinnedRange)o;
        if (!this.equalDR(cbr)) {
            return false;
        }
        if (this.endLabels != cbr.endLabels) {
            return false;
        }
        if (this.min != cbr.min || this.max != cbr.max) {
            return false;
        }
        if (cbr.boundaries == null || cbr.boundaries.length != this.boundaries.length) {
            return false;
        }
        for (int i = 0; i < this.boundaries.length; ++i) {
            if (this.boundaries[i] == cbr.boundaries[i]) continue;
            return false;
        }
        return true;
    }

    public CustomBinnedRange(double[] boundaries) {
        int i;
        this.boundaries = new double[boundaries.length];
        for (i = 0; i < boundaries.length; ++i) {
            this.boundaries[i] = boundaries[i];
        }
        this.midpoints = new double[boundaries.length - 1];
        for (i = 0; i < this.midpoints.length; ++i) {
            this.midpoints[i] = (boundaries[i] + boundaries[i + 1]) / 2.0;
        }
        this.min = boundaries[0];
        this.max = boundaries[boundaries.length - 1];
    }

    public CustomBinnedRange(DataRange src) {
        this.copyDR(src);
        if (src instanceof ContinuousRange) {
            ContinuousRange cr = (ContinuousRange)src;
            this.boundaries = new double[]{cr.getMin(), cr.getMax()};
            this.midpoints = new double[]{(cr.getMin() + cr.getMax()) / 2.0};
            this.min = cr.getMin();
            this.max = cr.getMax();
        } else if (src instanceof DiscreteRange) {
            this.valid = false;
        } else if (src instanceof SimpleBinnedRange) {
            SimpleBinnedRange sbr = (SimpleBinnedRange)src;
            double firstMidpoint = sbr.getFirstMidpoint();
            double lastMidpoint = sbr.getLastMidpoint();
            double binSize = sbr.getBinSize();
            int nMidpoints = (int)Math.round((lastMidpoint - firstMidpoint) / binSize) + 1;
            this.midpoints = new double[nMidpoints];
            this.boundaries = new double[nMidpoints + 1];
            for (int i = 0; i < nMidpoints; ++i) {
                this.midpoints[i] = firstMidpoint + (double)i * binSize;
                this.boundaries[i] = this.midpoints[i] - binSize / 2.0;
            }
            this.boundaries[nMidpoints] = this.midpoints[nMidpoints - 1] + binSize / 2.0;
            this.endLabels = sbr.isEndLabels();
            this.updateDual = sbr.isUpdateDual();
            this.min = sbr.getMin();
            this.max = sbr.getMax();
        } else if (src instanceof CustomBinnedRange) {
            int i;
            CustomBinnedRange cbr = (CustomBinnedRange)src;
            this.boundaries = new double[cbr.boundaries.length];
            for (i = 0; i < this.boundaries.length; ++i) {
                this.boundaries[i] = cbr.boundaries[i];
            }
            this.midpoints = new double[cbr.midpoints.length];
            for (i = 0; i < this.midpoints.length; ++i) {
                this.midpoints[i] = cbr.midpoints[i];
            }
            this.endLabels = cbr.endLabels;
            this.updateDual = cbr.updateDual;
            this.min = cbr.getMin();
            this.max = cbr.getMax();
        }
    }

    @Override
    public boolean isEndLabels() {
        return this.endLabels;
    }

    @Override
    public void setEndLabels(boolean b) {
        this.endLabels = b;
    }

    @Override
    public Object cloneRange() {
        return new CustomBinnedRange(this);
    }

    @Override
    public boolean union(DataRange range) {
        double ma;
        double mi;
        if (range instanceof ContinuousRange) {
            ContinuousRange cr = (ContinuousRange)range;
            mi = cr.getMin();
            ma = cr.getMax();
        } else if (range instanceof BinnedRange) {
            BinnedRange br = (BinnedRange)range;
            mi = br.getMin();
            ma = br.getMax();
        } else {
            return false;
        }
        this.min = Math.min(this.min, mi);
        this.max = Math.max(this.max, ma);
        this.dual = new ContinuousRange(this);
        if (this.updateDual) {
            ((ContinuousRange)this.dual).setMin(this.min);
            ((ContinuousRange)this.dual).setMax(this.max);
        }
        return true;
    }

    public boolean isMergeableBinnedRange(CustomBinnedRange r) {
        return true;
    }

    @Override
    public boolean contains(DataPoint point) {
        return false;
    }

    @Override
    public String toString() {
        String out = "{";
        int num = this.midpoints.length;
        boolean abbrev = num > 3;
        boolean dots = false;
        for (int i = 0; i < num; ++i) {
            if (abbrev && i > 0 && i < num - 1) {
                if (dots) continue;
                dots = true;
                out = out + ", ...";
                continue;
            }
            if (i != 0) {
                out = out + ", ";
            }
            out = out + this.boundaries[i] + "-" + this.boundaries[i + 1];
        }
        out = out + "}";
        if (this.dual != null) {
            out = out + " = " + this.dual;
        }
        return out;
    }

    public double[] getBoundaries() {
        return this.boundaries;
    }

    public double[] getMidpoints() {
        return this.midpoints;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public void updateDual(boolean update) {
        this.updateDual = update;
    }

    @Override
    public boolean isUpdateDual() {
        return this.updateDual;
    }
}

