/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.grid;

import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemSynchronizationInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.ComplexEntryInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.CompoundHeader;
import com.sas.graphics.applets.statgraph.sgchart.grid.GridAxisInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.GridAxisInterface2;
import com.sas.graphics.applets.statgraph.sgchart.grid.GridLabelInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginInterface2;
import com.sas.graphics.applets.statgraph.sgchart.grid.OLAPHeader;
import com.sas.graphics.applets.statgraph.sgchart.grid.OneDPlotInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisConstants;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisGridCell;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisGridColumnMeta;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisGridRowMeta;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.tree.DefaultMutableTreeNode;

public class TrellisLayout
implements TrellisConstants,
LayoutManager2 {
    protected int gridHGap;
    protected int gridVGap;
    protected ArrayList titles = new ArrayList();
    protected ArrayList footnotes = new ArrayList();
    protected JComponent globalLegend = null;
    protected String globalLegendPosition = "bottom";
    protected ArrayList cells;
    protected ArrayList rowMetaData;
    protected ArrayList columnMetaData;
    protected int rowAxisLabelPosition = 0;
    protected int row2AxisLabelPosition = 0;
    protected int columnAxisLabelPosition = 0;
    protected int column2AxisLabelPosition = 0;
    protected Component[] rowAxisLabel = null;
    protected Component[] row2AxisLabel = null;
    protected Component columnAxisLabel = null;
    protected Component column2AxisLabel = null;
    protected int rowHeaderLabelPosition = 1;
    protected int colHeaderLabelPosition = 2;
    protected Component rowHeaderLabel = null;
    protected Component row2HeaderLabel = null;
    protected Component columnHeaderLabel = null;
    protected Component column2HeaderLabel = null;
    protected CompoundHeader rowCompoundHeader;
    protected CompoundHeader columnCompoundHeader;
    protected OLAPHeader rowOLAPHeader;
    protected OLAPHeader columnOLAPHeader;
    protected int gridAxisCount;
    protected ArrayList tAnnotation;
    protected boolean tSpaceFilled = true;
    protected ArrayList bAnnotation;
    protected boolean bSpaceFilled = true;
    protected ArrayList lAnnotation;
    protected boolean lSpaceFilled = true;
    protected ArrayList rAnnotation;
    protected boolean rSpaceFilled = true;
    protected JScrollBar vsbar;
    protected JScrollBar hsbar;
    protected Dimension trellisSize;
    protected Insets trellisInsets;
    protected Insets initialTrellisInsets;
    protected int titleHeight;
    protected int footnoteHeight;
    protected Insets sbMargin;
    protected Insets rcaMargin;
    protected Insets oaMargin;
    protected Insets rcSbarMargin;
    protected Insets axisMargin;
    protected int maxCellHeaderHeight;
    protected int[] cellHeaderHeights;
    protected Dimension cellSize;
    protected int startRow;
    protected int startColumn;
    protected int visibleRows;
    protected int visibleColumns;
    protected double[] userRowWeight;
    protected String[] rowWeights = null;
    protected double[] userColumnWeight;
    protected String[] columnWeights = null;
    protected double[] rowWeight;
    protected double[] columnWeight;
    protected boolean uniformGrid = true;
    protected boolean cellHeadersAligned = false;
    protected int externalAxesAlignment = 0;
    protected boolean skipEmptyCells = false;
    protected Component cornerButton;
    protected int buttonPosition;
    private boolean initAxisBounds = true;
    protected Dimension minCellSize = null;
    public static int titleFootnoteSpacing = 5;
    public static int interTitleFootnoteGap = 5;
    private int globalLegendSpacing = 5;
    double cellAspectRatio = -1.0;
    private ArrayList hiddenComponents = new ArrayList();
    private int maxRowLabelHeight = 0;
    private int maxColLabelWidth = 0;
    private boolean rowHeadersAligned = true;
    private boolean colHeadersAligned = true;
    private LineAttrs gridAttrs = new LineAttrs();
    private FillAttrs headerAttrs = new FillAttrs();
    private Insets axisLabelPadding = new Insets(0, 0, 0, 0);
    private boolean autoRowAxisLabelAlignment = false;
    private double columnAxisHeightPercentage = Double.NaN;
    private double rowAxisWidthPercentage = Double.NaN;
    private double row2AxisWidthPercentage = Double.NaN;
    private Insets gridLabelMargin;
    private TrellisPlot trellis;

    public TrellisLayout() {
        this(1, 1, 0, 0);
    }

    public TrellisLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
    }

    public TrellisLayout(int rows, int cols, int hgap, int vgap) {
        if (rows < 0) {
            throw new IllegalArgumentException("invalid rows " + rows);
        }
        if (cols < 0) {
            throw new IllegalArgumentException("invalid columns " + cols);
        }
        if (hgap < 0) {
            throw new IllegalArgumentException("invalid hgap " + hgap);
        }
        if (vgap < 0) {
            throw new IllegalArgumentException("invalid vgap " + vgap);
        }
        this.gridHGap = hgap;
        this.gridVGap = vgap;
        this.rowMetaData = new ArrayList();
        this.columnMetaData = new ArrayList();
        this.cells = new ArrayList();
        this.setSize(rows, cols);
        this.gridAxisCount = 0;
    }

    public int getGridRows() {
        return this.rowMetaData.size();
    }

    public void setGridRows(int rows) {
        if (rows < 0) {
            throw new IllegalArgumentException("invalid rows " + rows);
        }
        this.setSize(rows, this.getGridColumns());
    }

    public int getGridColumns() {
        return this.columnMetaData.size();
    }

    public void setGridColumns(int cols) {
        if (cols < 0) {
            throw new IllegalArgumentException("invalid columns " + cols);
        }
        this.setSize(this.getGridRows(), cols);
    }

    public void setSize(int rows, int cols) {
        int r;
        int c;
        int oldRows = this.getGridRows();
        int oldCols = this.getGridColumns();
        if (rows == oldRows && cols == oldCols) {
            return;
        }
        for (c = oldCols - 1; c > cols; --c) {
            this.removeColumn(c);
        }
        for (c = oldCols; c < cols; ++c) {
            this.addColumn(c);
        }
        for (r = oldRows - 1; r > rows; --r) {
            this.removeRow(r);
        }
        for (r = oldRows; r < rows; ++r) {
            this.addRow(r);
        }
        this.startRow = 0;
        this.startColumn = 0;
        this.visibleRows = rows;
        this.visibleColumns = cols;
    }

    public int getGridVGap() {
        return this.gridVGap;
    }

    public void setGridVGap(int vgap) {
        this.gridVGap = vgap;
    }

    public int getGridHGap() {
        return this.gridHGap;
    }

    public void setGridHGap(int hgap) {
        this.gridHGap = hgap;
    }

    public double[] getRowWeights() {
        return this.userRowWeight;
    }

    public void setRowWeights(double[] weight) {
        this.userRowWeight = weight;
    }

    public double[] getColumnWeights() {
        return this.userColumnWeight;
    }

    public void setColumnWeights(double[] weight) {
        this.userColumnWeight = weight;
    }

    public boolean isRowHeadersAligned() {
        return this.rowHeadersAligned;
    }

    public void setRowHeadersAligned(boolean b) {
        this.rowHeadersAligned = b;
    }

    public boolean isColumnHeadersAligned() {
        return this.colHeadersAligned;
    }

    public void setColumnHeadersAligned(boolean b) {
        this.colHeadersAligned = b;
    }

    public boolean isCellHeadersAligned() {
        return this.cellHeadersAligned;
    }

    public void setCellHeadersAligned(boolean b) {
        this.cellHeadersAligned = b;
    }

    public int getExternalAxesAlignment() {
        return this.externalAxesAlignment;
    }

    public void setExternalAxesAlignment(int alignment) {
        this.externalAxesAlignment = alignment;
    }

    public boolean isEmptyCellsSkipped() {
        return this.skipEmptyCells;
    }

    public void setEmptyCellsSkipped(boolean b) {
        this.skipEmptyCells = b;
    }

    public double getCellAspectRatio() {
        return this.cellAspectRatio;
    }

    public void setCellAspectRatio(double aspect) {
        this.cellAspectRatio = aspect;
    }

    public boolean isAnnotationPreferredSizeUsed() {
        return !this.tSpaceFilled && !this.bSpaceFilled && !this.lSpaceFilled && !this.rSpaceFilled;
    }

    public void setAnnotationPreferredSizeUsed(boolean b) {
        this.tSpaceFilled = !b;
        this.bSpaceFilled = !b;
        this.lSpaceFilled = !b;
        this.rSpaceFilled = !b;
    }

    @Override
    public void addLayoutComponent(Component comp, Object obj) {
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container parent) {
        int i;
        for (i = 0; i < this.getGridRows(); ++i) {
            this.getRowMeta(i).resetMargins();
        }
        for (i = 0; i < this.getGridColumns(); ++i) {
            this.getColumnMeta(i).resetMargins();
        }
        this.initAxisBounds = true;
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        TrellisPlot trellis = (TrellisPlot)parent;
        if (trellis.isLayoutDisabled()) {
            return;
        }
        this.invalidateLayout(parent);
        trellis.inLayout = true;
        trellis.finalLayout = false;
        trellis.marginChanged = false;
        this.layoutTrellisContainer(parent);
        if (trellis.marginChanged) {
            trellis.marginChanged = false;
            this.invalidateLayout(parent);
            this.layoutTrellisContainer(parent);
            if (trellis.marginChanged) {
                trellis.finalLayout = true;
                this.invalidateLayout(parent);
                this.layoutTrellisContainer(parent);
            }
        }
        trellis.inLayout = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutTrellisContainer(Container parent) {
        this.trellis = (TrellisPlot)parent;
        if (this.trellis.isLayoutDisabled()) {
            return;
        }
        this.allocateGridAxisSize(parent);
        this.showHiddenComponents();
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.trellisInsets = this.trellis.getInsets();
            this.initialTrellisInsets = new Insets(this.trellisInsets.top, this.trellisInsets.left, this.trellisInsets.bottom, this.trellisInsets.right);
            this.trellisSize = this.trellis.getSize();
            this.verifyWeights();
            if (!this.uniformGrid) {
                this.startRow = 0;
                this.startColumn = 0;
                this.visibleRows = this.getGridRows();
                this.visibleColumns = this.getGridColumns();
            }
            this.titleHeight = this.getTotalTitleHeight();
            this.footnoteHeight = this.getTotalFootnoteHeight();
            this.calcGlobalLegendMargins();
            this.rcaMargin = this.calcRowColHeaderMargin(false);
            this.oaMargin = this.calcGridBorderAnnotationMargin(false);
            this.rcSbarMargin = this.calcRowColScrollBarMargin(false);
            this.maxCellHeaderHeight = this.calcCellHeaderHeight(false);
            if (this.initAxisBounds) {
                this.initAxisBounds(this.trellis);
            }
            this.axisMargin = this.calcAxisMargin(this.trellis);
            this.gridLabelMargin = this.calcGridLabelMargin();
            this.axisMargin.left = Math.max(this.axisMargin.left, this.gridLabelMargin.left);
            this.axisMargin.right = Math.max(this.axisMargin.right, this.gridLabelMargin.right);
            this.axisMargin.top = Math.max(this.axisMargin.top, this.gridLabelMargin.top);
            this.axisMargin.bottom = Math.max(this.axisMargin.bottom, this.gridLabelMargin.bottom);
            this.adjustTrellisInsets();
            this.calcVisibleGrid(this.trellis);
            this.initScrollBars(this.trellis);
            this.sbMargin = this.calcScrollBarMargin(false);
            this.cellSize = this.calcCellSize();
            if (this.uniformGrid && this.minCellSize != null) {
                if (this.cellSize.width < this.minCellSize.width) {
                    System.out.println("Cell width " + this.cellSize.width + " is smaller than the minimum cell width " + this.minCellSize.width + ". All contents are removed from the layout.");
                    this.hideComponents(parent);
                    return;
                }
                if (this.cellSize.height < this.minCellSize.height) {
                    System.out.println("Cell height " + this.cellSize.height + " is smaller than the minimum cell height " + this.minCellSize.height + ". All contents are removed from the layout.");
                    this.hideComponents(parent);
                    return;
                }
            }
            this.hideInvisibleComponents(this.trellis);
            this.computeRowWeights();
            this.computeColumnWeights();
            this.layoutCell(this.trellis);
            this.calcItemIOMargin();
            this.calcAxisIMargin();
            this.layoutItemIOMargin();
            this.updateItemIOMargin();
            this.layoutRowColHeader();
            if (this.cellHeadersAligned) {
                this.layoutCellHeader();
            }
            this.adjustCellLayout();
            this.layoutGridAxis(this.trellis);
            this.layoutRowColScrollBar();
            this.layoutGridBorderAnnotation();
            this.adjustItemIOMargin();
            this.layoutTitle();
            this.layoutFootnote();
            this.layoutGlobalLegend();
            this.layoutScrollBar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            TrellisPlot trellis = (TrellisPlot)parent;
            Insets pi = trellis.getInsets();
            pi.top += this.titleHeight;
            pi.bottom += this.footnoteHeight;
            Insets i1 = this.calcRowColHeaderMargin(true);
            Insets i2 = this.calcGridBorderAnnotationMargin(true);
            Insets i3 = this.calcAxisMargin(trellis);
            Insets i4 = this.calcRowColScrollBarMargin(true);
            int sh = this.calcCellHeaderHeight(true);
            int w = 0;
            int h = 0;
            for (int i = 0; i < this.getGridRows(); ++i) {
                for (int j = 0; j < this.getGridColumns(); ++j) {
                    Component comp = this.getCell(i, j).getItem();
                    if (comp == null) continue;
                    Dimension d = comp.getMinimumSize();
                    if (w < d.width) {
                        w = d.width;
                    }
                    if (h >= d.height) continue;
                    h = d.height;
                }
            }
            return new Dimension(pi.left + pi.right + i1.left + i1.right + i2.left + i2.right + i3.left + i3.right + i4.left + i4.right + this.getGridColumns() * w + (this.getGridColumns() - 1) * this.gridHGap, pi.top + pi.bottom + i1.top + i1.bottom + i2.top + i2.bottom + i3.top + i3.bottom + i4.top + i4.bottom + this.getGridRows() * (h + sh) + (this.getGridRows() - 1) * this.gridVGap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            TrellisPlot trellis = (TrellisPlot)parent;
            Insets pi = trellis.getInsets();
            pi.top += this.titleHeight;
            pi.bottom += this.footnoteHeight;
            Insets i1 = this.calcRowColHeaderMargin(false);
            Insets i2 = this.calcGridBorderAnnotationMargin(false);
            Insets i3 = this.calcAxisMargin(trellis);
            Insets i4 = this.calcRowColScrollBarMargin(false);
            int sh = this.calcCellHeaderHeight(false);
            int w = 0;
            int h = 0;
            for (int i = 0; i < this.getGridRows(); ++i) {
                for (int j = 0; j < this.getGridColumns(); ++j) {
                    Component comp = this.getCell(i, j).getItem();
                    if (comp == null) continue;
                    Dimension d = comp.getPreferredSize();
                    if (w < d.width) {
                        w = d.width;
                    }
                    if (h >= d.height) continue;
                    h = d.height;
                }
            }
            return new Dimension(pi.left + pi.right + i1.left + i1.right + i2.left + i2.right + i3.left + i3.right + i4.left + i4.right + this.getGridColumns() * w + (this.getGridColumns() - 1) * this.gridHGap, pi.top + pi.bottom + i1.top + i1.bottom + i2.top + i2.bottom + i3.top + i3.bottom + i4.top + i4.bottom + this.getGridRows() * (h + sh) + (this.getGridRows() - 1) * this.gridVGap);
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    public void resetVisibleRows() {
        this.startRow = 0;
        this.visibleRows = this.getGridRows();
    }

    public void resetVisibleColumns() {
        this.startColumn = 0;
        this.visibleColumns = this.getGridColumns();
    }

    protected void addRow(int row) {
        this.rowMetaData.add(row, new TrellisGridRowMeta());
        ArrayList<TrellisGridCell> rowVector = new ArrayList<TrellisGridCell>();
        this.cells.add(row, rowVector);
        for (int c = 0; c < this.getGridColumns(); ++c) {
            rowVector.add(new TrellisGridCell());
        }
    }

    public void removeRow(int row) {
        this.rowMetaData.remove(row);
        this.cells.remove(row);
    }

    protected void addColumn(int col) {
        this.columnMetaData.add(col, new TrellisGridColumnMeta());
        for (int r = 0; r < this.getGridRows(); ++r) {
            ArrayList rowVector = (ArrayList)this.cells.get(r);
            rowVector.add(col, new TrellisGridCell());
        }
    }

    public void removeColumn(int col) {
        this.columnMetaData.remove(col);
        for (int r = 0; r < this.getGridRows(); ++r) {
            ArrayList rowVector = (ArrayList)this.cells.get(r);
            rowVector.remove(col);
        }
    }

    protected TrellisGridRowMeta getRowMeta(int row) {
        return (TrellisGridRowMeta)this.rowMetaData.get(row);
    }

    protected TrellisGridColumnMeta getColumnMeta(int col) {
        return (TrellisGridColumnMeta)this.columnMetaData.get(col);
    }

    protected Insets getRowOM(int row) {
        return this.getRowMeta(row).getOuterMargin();
    }

    protected Insets getRowIM(int row) {
        return this.getRowMeta(row).getInnerMargin();
    }

    protected Insets getRowIM2(int row) {
        return this.getRowMeta(row).getInnerMargin2();
    }

    protected Insets getColOM(int col) {
        return this.getColumnMeta(col).getOuterMargin();
    }

    protected Insets getColIM(int col) {
        return this.getColumnMeta(col).getInnerMargin();
    }

    protected Insets getColIM2(int col) {
        return this.getColumnMeta(col).getInnerMargin2();
    }

    public TrellisGridCell getCell(int row, int col) {
        ArrayList rowVector = (ArrayList)this.cells.get(row);
        return (TrellisGridCell)rowVector.get(col);
    }

    protected Component getRowHeader(int row) {
        return this.getRowMeta(row).getHeader();
    }

    protected void addRowHeader(int row, Component comp) {
        this.getRowMeta(row).addHeader(comp);
    }

    protected void removeRowHeader(int row) {
        this.getRowMeta(row).removeHeader();
    }

    protected Component getRowHeader2(int row) {
        return this.getRowMeta(row).getHeader2();
    }

    protected void addRowHeader2(int row, Component comp) {
        this.getRowMeta(row).addHeader2(comp);
    }

    protected void removeRowHeader2(int row) {
        this.getRowMeta(row).removeHeader2();
    }

    protected Component getColumnHeader(int col) {
        return this.getColumnMeta(col).getHeader();
    }

    protected void addColumnHeader(int col, Component comp) {
        this.getColumnMeta(col).addHeader(comp);
    }

    protected void removeColumnHeader(int col) {
        this.getColumnMeta(col).removeHeader();
    }

    protected Component getColumnHeader2(int col) {
        return this.getColumnMeta(col).getHeader2();
    }

    protected void addColumnHeader2(int col, Component comp) {
        this.getColumnMeta(col).addHeader2(comp);
    }

    protected void removeColumnHeader2(int col) {
        this.getColumnMeta(col).removeHeader2();
    }

    protected Component getRowAxis(int row, boolean primary) {
        if (primary) {
            return this.getRowMeta(row).getAxis(2);
        }
        return this.getRowMeta(row).getAxis(4);
    }

    protected void addRowAxis(int row, Component comp, boolean primary) {
        if (primary) {
            this.getRowMeta(row).addAxis(2, comp);
        } else {
            this.getRowMeta(row).addAxis(4, comp);
        }
        ++this.gridAxisCount;
    }

    protected void removeRowAxis(int row, boolean primary) {
        if (primary) {
            this.getRowMeta(row).removeAxis(2);
        } else {
            this.getRowMeta(row).removeAxis(4);
        }
        --this.gridAxisCount;
    }

    protected Component getColumnAxis(int col, boolean primary) {
        if (primary) {
            return this.getColumnMeta(col).getAxis(3);
        }
        return this.getColumnMeta(col).getAxis(1);
    }

    protected void addColumnAxis(int col, Component comp, boolean primary) {
        if (primary) {
            this.getColumnMeta(col).addAxis(3, comp);
        } else {
            this.getColumnMeta(col).addAxis(1, comp);
        }
        ++this.gridAxisCount;
    }

    protected void removeColumnAxis(int col, boolean primary) {
        if (primary) {
            this.getColumnMeta(col).removeAxis(3);
        } else {
            this.getColumnMeta(col).removeAxis(1);
        }
        --this.gridAxisCount;
    }

    protected ArrayList getGridBorderAnnotation(int position) {
        switch (position) {
            default: {
                return null;
            }
            case 1: {
                return this.tAnnotation;
            }
            case 3: {
                return this.bAnnotation;
            }
            case 2: {
                return this.lAnnotation;
            }
            case 4: 
        }
        return this.rAnnotation;
    }

    protected void addGridBorderAnnotation(Component comp, int position) {
        switch (position) {
            default: {
                break;
            }
            case 1: {
                if (this.tAnnotation == null) {
                    this.tAnnotation = new ArrayList();
                }
                this.tAnnotation.add(comp);
                break;
            }
            case 3: {
                if (this.bAnnotation == null) {
                    this.bAnnotation = new ArrayList();
                }
                this.bAnnotation.add(comp);
                break;
            }
            case 2: {
                if (this.lAnnotation == null) {
                    this.lAnnotation = new ArrayList();
                }
                this.lAnnotation.add(comp);
                break;
            }
            case 4: {
                if (this.rAnnotation == null) {
                    this.rAnnotation = new ArrayList();
                }
                this.rAnnotation.add(comp);
            }
        }
    }

    protected void removeGridBorderAnnotation(int position) {
        switch (position) {
            default: {
                break;
            }
            case 1: {
                this.tAnnotation = null;
                break;
            }
            case 3: {
                this.bAnnotation = null;
                break;
            }
            case 2: {
                this.lAnnotation = null;
                break;
            }
            case 4: {
                this.rAnnotation = null;
            }
        }
    }

    protected boolean isGridAnnotationFilled(int position) {
        boolean filled = true;
        switch (position) {
            default: {
                break;
            }
            case 1: {
                filled = this.tSpaceFilled;
                break;
            }
            case 3: {
                filled = this.bSpaceFilled;
                break;
            }
            case 2: {
                filled = this.lSpaceFilled;
                break;
            }
            case 4: {
                filled = this.rSpaceFilled;
            }
        }
        return filled;
    }

    protected void setGridAnnotationFilled(boolean filled, int position) {
        switch (position) {
            default: {
                break;
            }
            case 1: {
                this.tSpaceFilled = filled;
                break;
            }
            case 3: {
                this.bSpaceFilled = filled;
                break;
            }
            case 2: {
                this.lSpaceFilled = filled;
                break;
            }
            case 4: {
                this.rSpaceFilled = filled;
            }
        }
    }

    protected void addTitle(Component comp) {
        this.titles.add(comp);
    }

    protected void addTitle(Component comp, int position) {
        if (position == -1 || position >= this.titles.size()) {
            this.titles.add(comp);
        } else {
            this.titles.add(position, comp);
        }
    }

    protected void removeTitle(Component comp) {
        if (this.titles.contains(comp)) {
            this.titles.remove(comp);
        }
    }

    protected void addFootnote(Component comp) {
        this.footnotes.add(comp);
    }

    protected void addFootnote(Component comp, int position) {
        if (position == -1 || position >= this.footnotes.size()) {
            this.footnotes.add(comp);
        } else {
            this.footnotes.add(position, comp);
        }
    }

    protected void removeFootnote(Component comp) {
        if (this.footnotes.contains(comp)) {
            this.footnotes.remove(comp);
        }
    }

    protected void addGlobalLegend(JComponent comp, String position) {
        this.globalLegend = comp;
        this.globalLegendPosition = position;
    }

    protected void removeGlobalLegend(JComponent comp) {
        if (this.globalLegend == comp) {
            this.globalLegend = null;
        }
    }

    protected JScrollBar getRowScrollBar() {
        return this.vsbar;
    }

    protected void addRowScrollBar(JScrollBar sbar) {
        if (sbar == null || sbar.getOrientation() != 1) {
            return;
        }
        this.vsbar = sbar;
    }

    protected void removeRowScrollBar() {
        this.vsbar = null;
    }

    protected JScrollBar getColumnScrollBar() {
        return this.hsbar;
    }

    protected void addColumnScrollBar(JScrollBar sbar) {
        if (sbar == null || sbar.getOrientation() != 0) {
            return;
        }
        this.hsbar = sbar;
    }

    protected void removeColumnScrollBar() {
        this.hsbar = null;
    }

    protected boolean isScrollable() {
        return this.visibleRows < this.getGridRows() || this.visibleColumns < this.getGridColumns();
    }

    protected void setStartRow(int row) {
        this.startRow = row;
    }

    protected void setStartColumn(int col) {
        this.startColumn = col;
    }

    protected void scrollGrid(TrellisPlot trellis) {
        if (this.cellSize == null) {
            return;
        }
        this.hideInvisibleComponents(trellis);
        this.layoutCell(trellis);
        this.calcItemIOMargin();
        this.layoutItemIOMargin();
        this.layoutGridAxis(trellis);
    }

    public boolean isUseRowColAxes() {
        return this.gridAxisCount > 0;
    }

    protected int getTotalTitleHeight() {
        int ht = 0;
        for (int i = 0; i < this.titles.size(); ++i) {
            Component c = (Component)this.titles.get(i);
            if (!c.isVisible()) continue;
            ht += c.getPreferredSize().height;
        }
        if (this.titles.size() > 0) {
            ht += titleFootnoteSpacing;
        }
        if (this.titles.size() > 1) {
            ht += (this.titles.size() - 1) * interTitleFootnoteGap;
        }
        return ht;
    }

    protected int getTotalFootnoteHeight() {
        int ht = 0;
        for (int i = 0; i < this.footnotes.size(); ++i) {
            Component c = (Component)this.footnotes.get(i);
            if (!c.isVisible()) continue;
            ht += c.getPreferredSize().height;
        }
        if (this.footnotes.size() > 0) {
            ht += titleFootnoteSpacing;
        }
        if (this.footnotes.size() > 1) {
            ht += (this.footnotes.size() - 1) * interTitleFootnoteGap;
        }
        return ht;
    }

    protected void calcGlobalLegendMargins() {
        if (this.globalLegend == null || !this.globalLegend.isVisible()) {
            return;
        }
        if (this.globalLegendPosition.equals("top")) {
            this.titleHeight += this.globalLegend.getPreferredSize().height + this.globalLegendSpacing;
        } else if (this.globalLegendPosition.equals("bottom")) {
            this.footnoteHeight += this.globalLegend.getPreferredSize().height + this.globalLegendSpacing;
        } else if (this.globalLegendPosition.equals("left")) {
            this.trellisInsets.left += this.globalLegend.getPreferredSize().width + this.globalLegendSpacing;
        } else {
            this.trellisInsets.right += this.globalLegend.getPreferredSize().width + this.globalLegendSpacing;
        }
    }

    protected Insets calcScrollBarMargin(boolean isMinSize) {
        Insets i = new Insets(0, 0, 0, 0);
        if (!this.uniformGrid) {
            return i;
        }
        if (this.hsbar != null && this.hsbar.isVisible()) {
            i.bottom = isMinSize ? this.hsbar.getMinimumSize().height : this.hsbar.getPreferredSize().height;
        }
        if (this.vsbar != null && this.vsbar.isVisible()) {
            i.right = isMinSize ? this.vsbar.getMinimumSize().width : this.vsbar.getPreferredSize().width;
        }
        return i;
    }

    protected Insets calcRowColHeaderMargin(boolean isMinSize) {
        if (this.isOLAPHeaders()) {
            return this.calcRowColOLAPHeaderMargin(isMinSize);
        }
        if (this.isCompoundHeaders()) {
            return this.calcRowColCompoundHeaderMargin(isMinSize);
        }
        Insets i = new Insets(0, 0, 0, 0);
        if (this.rowHeaderLabel != null) {
            i.left = isMinSize ? Math.max(i.left, this.rowHeaderLabel.getMinimumSize().width) : Math.max(i.left, this.rowHeaderLabel.getPreferredSize().width);
            this.maxRowLabelHeight = Math.max(this.maxRowLabelHeight, this.rowHeaderLabel.getPreferredSize().height);
        }
        if (this.row2HeaderLabel != null) {
            i.right = isMinSize ? Math.max(i.right, this.row2HeaderLabel.getMinimumSize().width) : Math.max(i.right, this.row2HeaderLabel.getPreferredSize().width);
            this.maxRowLabelHeight = Math.max(this.maxRowLabelHeight, this.row2HeaderLabel.getPreferredSize().height);
        }
        int left = 0;
        int right = 0;
        for (int r = 0; r < this.getGridRows(); ++r) {
            if (this.getRowHeader(r) != null && this.getRowHeader(r).isVisible() && (left = isMinSize ? this.getRowHeader((int)r).getMinimumSize().width : this.getRowHeader((int)r).getPreferredSize().width) > i.left) {
                i.left = left;
            }
            if (this.getRowHeader2(r) == null || !this.getRowHeader2(r).isVisible() || (right = isMinSize ? this.getRowHeader2((int)r).getMinimumSize().width : this.getRowHeader2((int)r).getPreferredSize().width) <= i.right) continue;
            i.right = right;
        }
        if (this.columnHeaderLabel != null) {
            i.top = isMinSize ? Math.max(i.top, this.columnHeaderLabel.getMinimumSize().height) : Math.max(i.top, this.columnHeaderLabel.getPreferredSize().height);
            this.maxColLabelWidth = Math.max(this.maxColLabelWidth, this.columnHeaderLabel.getPreferredSize().width);
        }
        if (this.column2HeaderLabel != null) {
            i.bottom = isMinSize ? Math.max(i.bottom, this.column2HeaderLabel.getMinimumSize().height) : Math.max(i.bottom, this.column2HeaderLabel.getPreferredSize().height);
            this.maxColLabelWidth = Math.max(this.maxColLabelWidth, this.column2HeaderLabel.getPreferredSize().width);
        }
        int top = 0;
        int bottom = 0;
        for (int c = 0; c < this.getGridColumns(); ++c) {
            if (this.getColumnHeader(c) != null && this.getColumnHeader(c).isVisible() && (top = isMinSize ? this.getColumnHeader((int)c).getMinimumSize().height : this.getColumnHeader((int)c).getPreferredSize().height) > i.top) {
                i.top = top;
            }
            if (this.getColumnHeader2(c) == null || !this.getColumnHeader2(c).isVisible() || (bottom = isMinSize ? this.getColumnHeader2((int)c).getMinimumSize().height : this.getColumnHeader2((int)c).getPreferredSize().height) <= i.bottom) continue;
            i.bottom = bottom;
        }
        return i;
    }

    protected Insets calcRowColCompoundHeaderMargin(boolean isMinSize) {
        int j;
        Component comp;
        int j2;
        int num;
        int l;
        Insets i = new Insets(0, 0, 0, 0);
        for (l = 0; this.rowCompoundHeader != null && l < this.rowCompoundHeader.getLevels(); ++l) {
            num = this.rowCompoundHeader.getHeader(l).getNumHeaders();
            int left = 0;
            for (j2 = 0; j2 < num; ++j2) {
                comp = this.getRowCompoundHeader(l, j2);
                if (comp == null || !comp.isVisible()) continue;
                left = Math.max(left, comp.getPreferredSize().width);
            }
            i.left += left;
            int right = 0;
            if (this.rowCompoundHeader.getHeader(l).getLabel2() != null) {
                right = Math.max(left, this.rowCompoundHeader.getHeader((int)l).getLabel2().getPreferredSize().width);
                this.maxRowLabelHeight = Math.max(this.maxRowLabelHeight, this.rowCompoundHeader.getHeader((int)l).getLabel2().getPreferredSize().height);
            }
            num = this.rowCompoundHeader.getHeader(l).getNumHeaders2();
            for (j = 0; j < num; ++j) {
                comp = this.getRow2CompoundHeader(l, j);
                if (comp == null || !comp.isVisible()) continue;
                right = Math.max(right, comp.getPreferredSize().width);
            }
            i.right += right;
            if (this.rowCompoundHeader.getHeader(l).getLabel() == null) continue;
            i.top += this.rowCompoundHeader.getHeader((int)l).getLabel().getPreferredSize().height;
        }
        for (l = 0; this.columnCompoundHeader != null && l < this.columnCompoundHeader.getLevels(); ++l) {
            num = this.columnCompoundHeader.getHeader(l).getNumHeaders();
            int top = 0;
            if (this.columnCompoundHeader.getHeader(l).getLabel() != null) {
                top = Math.max(top, this.columnCompoundHeader.getHeader((int)l).getLabel().getPreferredSize().height);
                this.maxColLabelWidth = Math.max(this.maxColLabelWidth, this.columnCompoundHeader.getHeader((int)l).getLabel().getPreferredSize().width);
            }
            for (j2 = 0; j2 < num; ++j2) {
                comp = this.getColumnCompoundHeader(l, j2);
                if (comp == null || !comp.isVisible()) continue;
                top = Math.max(top, comp.getPreferredSize().height);
            }
            i.top += top;
            int bottom = 0;
            if (this.columnCompoundHeader.getHeader(l).getLabel2() != null) {
                bottom = this.columnCompoundHeader.getHeader((int)l).getLabel2().getPreferredSize().height;
                this.maxColLabelWidth = Math.max(this.maxColLabelWidth, this.columnCompoundHeader.getHeader((int)l).getLabel2().getPreferredSize().width);
            }
            num = this.columnCompoundHeader.getHeader(l).getNumHeaders2();
            for (j = 0; j < num; ++j) {
                comp = this.getColumn2CompoundHeader(l, j);
                if (comp == null || !comp.isVisible()) continue;
                bottom = Math.max(bottom, comp.getPreferredSize().height);
            }
            i.bottom += bottom;
        }
        return i;
    }

    protected Insets calcRowColOLAPHeaderMargin(boolean isMinSize) {
        int levels;
        DataTreeGroupNode tree;
        OLAPHeader.TreeHeader major;
        Insets i = new Insets(0, 0, 0, 0);
        if (this.columnOLAPHeader != null && this.columnOLAPHeader.getMajor().getTree() != null) {
            major = this.columnOLAPHeader.getMajor();
            tree = major.getTree();
            levels = major.getLevels();
            int[] levelHeights = new int[levels];
            for (int k = 0; k < levels; ++k) {
                int h;
                Component c = major.getLabel(k);
                levelHeights[k] = h = isMinSize ? c.getMinimumSize().height : c.getPreferredSize().height;
            }
            Enumeration eu = tree.breadthFirstEnumeration();
            while (eu.hasMoreElements()) {
                DataTreeGroupNode n = (DataTreeGroupNode)eu.nextElement();
                if (n.isRoot()) continue;
                int l = n.getDepth();
                Component c = (Component)n.getUserObject();
                int h = isMinSize ? c.getMinimumSize().height : c.getPreferredSize().height;
                levelHeights[l] = Math.max(levelHeights[l], h);
            }
            major.levelHeights = levelHeights;
            int height = 0;
            for (int k = 0; k < levels; ++k) {
                height += levelHeights[k];
            }
            if (major.titleComponent != null) {
                Component c = major.titleComponent;
                int h = isMinSize ? c.getMinimumSize().height : c.getPreferredSize().height;
                height += h;
            }
            i.bottom = Math.max(i.bottom, height);
        }
        if (this.rowOLAPHeader != null && this.rowOLAPHeader.getMajor().getTree() != null) {
            major = this.rowOLAPHeader.getMajor();
            tree = major.getTree();
            levels = major.getLevels();
            int[] levelWidths = new int[levels];
            int t = 0;
            for (int k = 0; k < levels; ++k) {
                Component c = major.getLabel(k);
                t += isMinSize ? c.getMinimumSize().height : c.getPreferredSize().height;
            }
            i.top = Math.max(i.top, t);
            Enumeration eu = tree.breadthFirstEnumeration();
            while (eu.hasMoreElements()) {
                DataTreeGroupNode n = (DataTreeGroupNode)eu.nextElement();
                if (n.isRoot()) continue;
                int l = n.getDepth();
                Component c = (Component)n.getUserObject();
                int w = isMinSize ? c.getMinimumSize().width : c.getPreferredSize().width;
                levelWidths[l] = Math.max(levelWidths[l], w);
            }
            major.levelWidths = levelWidths;
            int width = 0;
            for (int k = 0; k < levels; ++k) {
                width += levelWidths[k];
            }
            if (major.titleComponent != null) {
                Component c = major.titleComponent;
                int w = isMinSize ? c.getMinimumSize().width : c.getPreferredSize().width;
                width += w;
            }
            i.left = Math.max(i.left, width);
        }
        return i;
    }

    protected void adjustTrellisInsets() {
        if (this.isOLAPHeaders()) {
            this.adjustOLAPTrellisInsets();
            return;
        }
        if (this.rowHeaderLabelPosition == 1) {
            if (this.rcaMargin.top + this.oaMargin.top + this.axisMargin.top < this.maxRowLabelHeight) {
                this.trellisInsets.top += this.maxRowLabelHeight - this.rcaMargin.top - this.oaMargin.top - this.axisMargin.top;
            }
        } else if (this.rcaMargin.bottom + this.oaMargin.bottom + this.axisMargin.bottom < this.maxRowLabelHeight) {
            this.trellisInsets.bottom += this.maxRowLabelHeight - this.rcaMargin.bottom - this.oaMargin.bottom - this.axisMargin.bottom;
        }
        if (this.colHeaderLabelPosition == 2) {
            int leftColLabelWidth = this.maxColLabelWidth;
            if (this.columnAxisLabel != null && this.columnAxisLabelPosition == 2) {
                leftColLabelWidth = Math.max(leftColLabelWidth, this.columnAxisLabel.getPreferredSize().width);
            }
            if (this.rcaMargin.left + this.oaMargin.left + this.axisMargin.left < leftColLabelWidth) {
                this.trellisInsets.left += leftColLabelWidth - this.rcaMargin.left - this.oaMargin.left - this.axisMargin.left;
            }
            if (this.axisLabelPadding.left > this.rcaMargin.left) {
                this.trellisInsets.left -= this.rcaMargin.left;
            }
        } else if (this.rcaMargin.right + this.oaMargin.right + this.axisMargin.right < this.maxColLabelWidth) {
            this.trellisInsets.right += this.maxColLabelWidth - this.rcaMargin.right - this.oaMargin.right - this.axisMargin.right;
        }
    }

    protected void adjustOLAPTrellisInsets() {
        if (this.columnOLAPHeader != null) {
            OLAPHeader.TreeHeader major = this.columnOLAPHeader.getMajor();
            int w = 0;
            int levels = major.getLevels();
            for (int i = 0; i < levels; ++i) {
                Component comp = major.getLabel(i);
                w = Math.max(w, comp.getPreferredSize().width);
            }
            if (this.columnAxisLabel != null) {
                if (this.getColumnAxis(0, true) != null) {
                    GridAxisInterface ga = (GridAxisInterface)((Object)this.getColumnAxis(0, true));
                    Insets pam = ga.getPreferredOuterMargin();
                    w = Math.max(w, this.columnAxisLabel.getPreferredSize().width + pam.left);
                } else {
                    w = Math.max(w, this.columnAxisLabel.getPreferredSize().width);
                }
            }
            if (this.colHeaderLabelPosition == 2) {
                if (this.rcaMargin.left + this.oaMargin.left + this.axisMargin.left < w) {
                    this.trellisInsets.left += w - this.rcaMargin.left - this.oaMargin.left - this.axisMargin.left;
                }
            } else if (this.rcaMargin.right + this.oaMargin.right + this.axisMargin.right < w) {
                this.trellisInsets.right += w - this.rcaMargin.right - this.oaMargin.right - this.axisMargin.right;
            }
        }
        if (this.rowOLAPHeader != null) {
            // empty if block
        }
    }

    protected Insets calcGridBorderAnnotationMargin(boolean isMinSize) {
        Component comp;
        int n;
        Insets i = new Insets(0, 0, 0, 0);
        if (this.tAnnotation != null) {
            i.top = 0;
            for (n = 0; n < this.tAnnotation.size(); ++n) {
                comp = (Component)this.tAnnotation.get(n);
                if (!comp.isVisible()) continue;
                if (isMinSize) {
                    i.top += comp.getMinimumSize().height;
                    continue;
                }
                i.top += comp.getPreferredSize().height;
            }
        }
        if (this.bAnnotation != null) {
            i.bottom = 0;
            for (n = 0; n < this.bAnnotation.size(); ++n) {
                comp = (Component)this.bAnnotation.get(n);
                if (!comp.isVisible()) continue;
                if (isMinSize) {
                    i.bottom += comp.getMinimumSize().height;
                    continue;
                }
                i.bottom += comp.getPreferredSize().height;
            }
        }
        if (this.lAnnotation != null) {
            i.left = 0;
            for (n = 0; n < this.lAnnotation.size(); ++n) {
                comp = (Component)this.lAnnotation.get(n);
                if (!comp.isVisible()) continue;
                if (isMinSize) {
                    i.left += comp.getMinimumSize().width;
                    continue;
                }
                i.left += comp.getPreferredSize().width;
            }
        }
        if (this.rAnnotation != null) {
            i.right = 0;
            for (n = 0; n < this.rAnnotation.size(); ++n) {
                comp = (Component)this.rAnnotation.get(n);
                if (!comp.isVisible()) continue;
                if (isMinSize) {
                    i.right += comp.getMinimumSize().width;
                    continue;
                }
                i.right += comp.getPreferredSize().width;
            }
        }
        return i;
    }

    private void initAxisBounds(TrellisPlot trellis) {
        GridAxisInterface axis;
        int height = this.trellisSize.height - this.trellisInsets.top - this.trellisInsets.bottom - this.titleHeight - this.footnoteHeight - this.rcaMargin.top - this.rcaMargin.bottom - this.oaMargin.top - this.oaMargin.bottom - this.rcSbarMargin.top - this.rcSbarMargin.bottom - this.visibleRows * this.maxCellHeaderHeight - (this.visibleRows - 1) * this.gridVGap;
        int left = 0;
        int right = 0;
        for (int i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
            Insets pam;
            int h = (int)(this.rowWeight[i - this.startRow] * (double)height + 0.5);
            axis = (GridAxisInterface)((Object)this.getRowAxis(i, true));
            if (axis != null) {
                if (axis.getBounds().width == 0 || axis.getBounds().height == 0) {
                    axis.setBounds(0, 0, 200, h);
                }
                pam = axis.getPreferredOuterMargin();
                if (left < pam.left) {
                    left = pam.left;
                }
            }
            if ((axis = (GridAxisInterface)((Object)this.getRowAxis(i, false))) == null) continue;
            if (axis.getBounds().width == 0 || axis.getBounds().height == 0) {
                axis.setBounds(0, 0, 200, h);
            }
            pam = axis.getPreferredOuterMargin();
            if (right >= pam.right) continue;
            right = pam.right;
        }
        int width = this.trellisSize.width - this.trellisInsets.left - this.trellisInsets.right - this.rcaMargin.left - this.rcaMargin.right - this.oaMargin.left - this.oaMargin.right - this.rcSbarMargin.left - this.rcSbarMargin.right - left - right - (this.visibleColumns - 1) * this.gridHGap;
        for (int i = this.startColumn; i < this.startColumn + this.visibleColumns; ++i) {
            int w = (int)(this.columnWeight[i - this.startColumn] * (double)width + 0.5);
            axis = (GridAxisInterface)((Object)this.getColumnAxis(i, true));
            if (axis != null) {
                axis.setBounds(0, 0, w, 200);
            }
            if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(i, false))) == null) continue;
            axis.setBounds(0, 0, w, 200);
        }
        this.initAxisBounds = false;
    }

    protected Insets calcAxisMargin(TrellisPlot trellis) {
        Insets ins;
        block84: {
            block82: {
                int i;
                int RLHeight2;
                int i2;
                int RLHeight;
                int i3;
                Insets pam;
                GridAxisInterface axis;
                block83: {
                    int RLHeight3;
                    int CLWidth;
                    Insets pom;
                    int CLWidth2;
                    ins = new Insets(0, 0, 0, 0);
                    if (this.gridAxisCount <= 0) break block82;
                    for (int r = 0; r < this.getGridRows(); ++r) {
                        axis = (GridAxisInterface)((Object)this.getRowAxis(r, true));
                        if (axis != null) {
                            pam = axis.getPreferredOuterMargin();
                            if (ins.left < pam.left) {
                                ins.left = pam.left;
                            }
                        }
                        if ((axis = (GridAxisInterface)((Object)this.getRowAxis(r, false))) == null) continue;
                        pam = axis.getPreferredOuterMargin();
                        if (ins.right >= pam.right) continue;
                        ins.right = pam.right;
                    }
                    if (ins.left > 0) {
                        axis = (GridAxisInterface)((Object)this.getColumnAxis(0, true));
                        if (axis != null) {
                            pam = axis.getPreferredOuterMargin();
                            CLWidth2 = 0;
                            if (this.columnAxisLabel != null && this.columnAxisLabelPosition == 2) {
                                CLWidth2 = this.columnAxisLabel.getPreferredSize().width;
                            }
                            if (ins.left < pam.left + CLWidth2) {
                                this.axisLabelPadding.left = Math.max(this.axisLabelPadding.left, pam.left + CLWidth2 - ins.left);
                                ins.left = pam.left + CLWidth2;
                            }
                        }
                        if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(0, false))) != null) {
                            pam = axis.getPreferredOuterMargin();
                            CLWidth2 = 0;
                            if (this.column2AxisLabel != null && this.column2AxisLabelPosition == 2) {
                                CLWidth2 = this.column2AxisLabel.getPreferredSize().width;
                            }
                            if (ins.left < pam.left + CLWidth2) {
                                this.axisLabelPadding.left = Math.max(this.axisLabelPadding.left, pam.left + CLWidth2 - ins.left);
                                ins.left = pam.left + CLWidth2;
                            }
                        }
                    } else {
                        int omLeft = 0;
                        for (i3 = this.startRow; i3 < this.startRow + this.visibleRows; ++i3) {
                            CellItemInterface item;
                            if (!this.getCell(i3, 0).isCellItem() || !(item = (CellItemInterface)((Object)this.getCell(i3, 0).getItem())).getMarginsAligned()) continue;
                            pom = item.getPreferredOuterMargin();
                            omLeft = Math.max(omLeft, pom.left);
                        }
                        int left = 0;
                        axis = (GridAxisInterface)((Object)this.getColumnAxis(0, true));
                        if (axis != null) {
                            pam = axis.getPreferredOuterMargin();
                            CLWidth = 0;
                            if (this.columnAxisLabel != null && this.columnAxisLabelPosition == 2) {
                                CLWidth = this.columnAxisLabel.getPreferredSize().width;
                            }
                            if (pam.left + CLWidth > omLeft) {
                                left = Math.max(pam.left + CLWidth - omLeft, left);
                            }
                        }
                        if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(0, false))) != null) {
                            pam = axis.getPreferredOuterMargin();
                            CLWidth = 0;
                            if (this.column2AxisLabel != null && this.column2AxisLabelPosition == 2) {
                                CLWidth = this.column2AxisLabel.getPreferredSize().width;
                            }
                            if (pam.left + CLWidth > omLeft) {
                                left = Math.max(pam.left + CLWidth - omLeft, left);
                            }
                        }
                        if (!this.isOLAPHeaders() && !this.isCompoundHeaders() && left > 0) {
                            ins.left = left;
                        }
                    }
                    if (ins.right > 0) {
                        axis = (GridAxisInterface)((Object)this.getColumnAxis(this.getGridColumns() - 1, true));
                        if (axis != null) {
                            pam = axis.getPreferredOuterMargin();
                            CLWidth2 = 0;
                            if (this.columnAxisLabel != null && this.columnAxisLabelPosition == 4) {
                                CLWidth2 = this.columnAxisLabel.getPreferredSize().width;
                            }
                            if (ins.right < pam.right + CLWidth2) {
                                ins.right = pam.right + CLWidth2;
                            }
                        }
                        if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(this.getGridColumns() - 1, false))) != null) {
                            pam = axis.getPreferredOuterMargin();
                            CLWidth2 = 0;
                            if (this.column2AxisLabel != null && this.column2AxisLabelPosition == 4) {
                                CLWidth2 = this.column2AxisLabel.getPreferredSize().width;
                            }
                            if (ins.right < pam.right + CLWidth2) {
                                ins.right = pam.right + CLWidth2;
                            }
                        }
                    } else {
                        int omRight = 0;
                        for (i3 = this.startRow; i3 < this.startRow + this.visibleRows; ++i3) {
                            CellItemInterface item;
                            if (!this.getCell(i3, this.getGridColumns() - 1).isCellItem() || !(item = (CellItemInterface)((Object)this.getCell(i3, this.getGridColumns() - 1).getItem())).getMarginsAligned()) continue;
                            pom = item.getPreferredOuterMargin();
                            omRight = Math.max(omRight, pom.right);
                        }
                        int right = 0;
                        axis = (GridAxisInterface)((Object)this.getColumnAxis(this.getGridColumns() - 1, true));
                        if (axis != null) {
                            pam = axis.getPreferredOuterMargin();
                            CLWidth = 0;
                            if (this.columnAxisLabel != null && this.columnAxisLabelPosition == 4) {
                                CLWidth = this.columnAxisLabel.getPreferredSize().width;
                            }
                            if (pam.right + CLWidth > omRight) {
                                right = Math.max(pam.right + CLWidth - omRight, right);
                            }
                        }
                        if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(this.getGridColumns() - 1, false))) != null) {
                            pam = axis.getPreferredOuterMargin();
                            CLWidth = 0;
                            if (this.column2AxisLabel != null && this.column2AxisLabelPosition == 4) {
                                CLWidth = this.column2AxisLabel.getPreferredSize().width;
                            }
                            if (pam.right + CLWidth > omRight) {
                                right = Math.max(pam.right + CLWidth - omRight, right);
                            }
                        }
                        if (right > 0) {
                            ins.right = right;
                        }
                    }
                    for (int c = 0; c < this.getGridColumns(); ++c) {
                        axis = (GridAxisInterface)((Object)this.getColumnAxis(c, true));
                        if (axis != null) {
                            pam = axis.getPreferredOuterMargin();
                            if (ins.bottom < pam.bottom) {
                                ins.bottom = pam.bottom;
                            }
                        }
                        if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(c, false))) == null) continue;
                        pam = axis.getPreferredOuterMargin();
                        if (ins.top >= pam.top) continue;
                        ins.top = pam.top;
                    }
                    if (this.columnAxisLabel != null) {
                        ins.bottom = Math.max(ins.bottom, this.columnAxisLabel.getPreferredSize().height);
                    }
                    if (ins.top > 0) {
                        axis = (GridAxisInterface)((Object)this.getRowAxis(0, true));
                        if (axis != null) {
                            pam = axis.getPreferredOuterMargin();
                            pam.top -= this.maxCellHeaderHeight;
                            RLHeight3 = 0;
                            if (this.rowAxisLabel != null && this.rowAxisLabelPosition == 1) {
                                for (int i4 = 0; i4 < this.rowAxisLabel.length; ++i4) {
                                    RLHeight3 += this.rowAxisLabel[i4].getPreferredSize().height;
                                }
                            }
                            if (ins.top < pam.top + RLHeight3) {
                                ins.top = pam.top + RLHeight3;
                            }
                        }
                        if ((axis = (GridAxisInterface)((Object)this.getRowAxis(0, false))) != null) {
                            pam = axis.getPreferredOuterMargin();
                            pam.top -= this.maxCellHeaderHeight;
                            RLHeight3 = 0;
                            if (this.row2AxisLabel != null && this.row2AxisLabelPosition == 1) {
                                for (int i5 = 0; i5 < this.row2AxisLabel.length; ++i5) {
                                    RLHeight3 += this.row2AxisLabel[i5].getPreferredSize().height;
                                }
                            }
                            if (ins.top < pam.top + RLHeight3) {
                                ins.top = pam.top + RLHeight3;
                            }
                        }
                    } else {
                        int omTop = 0;
                        for (i3 = this.startColumn; i3 < this.startColumn + this.visibleColumns; ++i3) {
                            CellItemInterface item;
                            if (!this.getCell(0, i3).isCellItem() || !(item = (CellItemInterface)((Object)this.getCell(0, i3).getItem())).getMarginsAligned()) continue;
                            pom = item.getPreferredOuterMargin();
                            omTop = Math.max(omTop, pom.top);
                        }
                        omTop += this.maxCellHeaderHeight;
                        int top = 0;
                        RLHeight = 0;
                        axis = (GridAxisInterface)((Object)this.getRowAxis(0, true));
                        if (axis != null) {
                            pam = axis.getPreferredOuterMargin();
                            if (pam.top > omTop) {
                                top = Math.max(pam.top - omTop, top);
                            }
                            if (this.rowAxisLabel != null && this.rowAxisLabelPosition == 1) {
                                for (i2 = 0; i2 < this.rowAxisLabel.length; ++i2) {
                                    RLHeight += this.rowAxisLabel[i2].getPreferredSize().height;
                                }
                            }
                        }
                        if ((axis = (GridAxisInterface)((Object)this.getRowAxis(0, false))) != null) {
                            pam = axis.getPreferredOuterMargin();
                            if (pam.top > omTop) {
                                top = Math.max(pam.top - omTop, top);
                            }
                            if (this.row2AxisLabel != null && this.row2AxisLabelPosition == 1) {
                                RLHeight2 = 0;
                                for (i = 0; i < this.row2AxisLabel.length; ++i) {
                                    RLHeight2 += this.row2AxisLabel[i].getPreferredSize().height;
                                }
                                RLHeight = Math.max(RLHeight, RLHeight2);
                            }
                        }
                        if ((top += RLHeight) > 0) {
                            ins.top = top;
                        }
                    }
                    if (ins.bottom <= 0) break block83;
                    axis = (GridAxisInterface)((Object)this.getRowAxis(this.getGridRows() - 1, true));
                    if (axis != null) {
                        pam = axis.getPreferredOuterMargin();
                        RLHeight3 = 0;
                        if (this.rowAxisLabel != null && this.rowAxisLabelPosition == 3) {
                            for (int i6 = 0; i6 < this.rowAxisLabel.length; ++i6) {
                                RLHeight3 += this.rowAxisLabel[i6].getPreferredSize().height;
                            }
                        }
                        if (ins.bottom < pam.bottom + RLHeight3) {
                            ins.bottom = pam.bottom + RLHeight3;
                        }
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getRowAxis(this.getGridRows() - 1, false))) == null) break block84;
                    pam = axis.getPreferredOuterMargin();
                    RLHeight3 = 0;
                    if (this.row2AxisLabel != null && this.row2AxisLabelPosition == 3) {
                        for (int i7 = 0; i7 < this.row2AxisLabel.length; ++i7) {
                            RLHeight3 += this.row2AxisLabel[i7].getPreferredSize().height;
                        }
                    }
                    if (ins.bottom >= pam.bottom + RLHeight3) break block84;
                    ins.bottom = pam.bottom + RLHeight3;
                    break block84;
                }
                int omBottom = 0;
                for (i3 = this.startColumn; i3 < this.startColumn + this.visibleColumns; ++i3) {
                    CellItemInterface item;
                    if (!this.getCell(this.getGridRows() - 1, i3).isCellItem() || !(item = (CellItemInterface)((Object)this.getCell(this.getGridRows() - 1, i3).getItem())).getMarginsAligned()) continue;
                    Insets pom = item.getPreferredOuterMargin();
                    omBottom = Math.max(omBottom, pom.bottom);
                }
                int bottom = 0;
                RLHeight = 0;
                axis = (GridAxisInterface)((Object)this.getRowAxis(this.getGridRows() - 1, true));
                if (axis != null) {
                    pam = axis.getPreferredOuterMargin();
                    if (pam.bottom > omBottom) {
                        bottom = Math.max(pam.bottom - omBottom, bottom);
                    }
                    if (this.rowAxisLabel != null && this.rowAxisLabelPosition == 3) {
                        for (i2 = 0; i2 < this.rowAxisLabel.length; ++i2) {
                            RLHeight += this.rowAxisLabel[i2].getPreferredSize().height;
                        }
                    }
                }
                if ((axis = (GridAxisInterface)((Object)this.getRowAxis(this.getGridRows() - 1, false))) != null) {
                    pam = axis.getPreferredOuterMargin();
                    if (pam.bottom > omBottom) {
                        bottom = Math.max(pam.bottom - omBottom, bottom);
                    }
                    if (this.row2AxisLabel != null && this.row2AxisLabelPosition == 3) {
                        RLHeight2 = 0;
                        for (i = 0; i < this.row2AxisLabel.length; ++i) {
                            RLHeight2 += this.row2AxisLabel[i].getPreferredSize().height;
                        }
                        RLHeight = Math.max(RLHeight, RLHeight2);
                    }
                }
                if ((bottom += RLHeight) <= 0) break block84;
                ins.bottom = bottom;
                break block84;
            }
            for (int i = 0; i < this.getGridRows(); ++i) {
                for (int j = 0; j < this.getGridColumns(); ++j) {
                    Insets pam;
                    GridAxisInterface axis;
                    if (i == 0 && (axis = (GridAxisInterface)((Object)this.getCell(i, j).getAxis(1))) != null) {
                        pam = axis.getPreferredOuterMargin();
                        if (ins.top < pam.top) {
                            ins.top = pam.top;
                        }
                    }
                    if (j == 0 && (axis = (GridAxisInterface)((Object)this.getCell(i, j).getAxis(2))) != null) {
                        pam = axis.getPreferredOuterMargin();
                        if (ins.left < pam.left) {
                            ins.left = pam.left;
                        }
                    }
                    if (i == this.getGridRows() - 1 && (axis = (GridAxisInterface)((Object)this.getCell(i, j).getAxis(3))) != null) {
                        pam = axis.getPreferredOuterMargin();
                        if (ins.bottom < pam.bottom) {
                            ins.bottom = pam.bottom;
                        }
                    }
                    if (j != this.getGridColumns() - 1 || (axis = (GridAxisInterface)((Object)this.getCell(i, j).getAxis(4))) == null) continue;
                    pam = axis.getPreferredOuterMargin();
                    if (ins.right >= pam.right) continue;
                    ins.right = pam.right;
                }
            }
        }
        return ins;
    }

    protected int calcCellHeaderHeight(boolean isMinSize) {
        int j;
        int i;
        int maxNumCellHeaders = 0;
        for (i = 0; i < this.getGridRows(); ++i) {
            for (j = 0; j < this.getGridColumns(); ++j) {
                if (this.getCell(i, j).getNumHeaders() <= maxNumCellHeaders) continue;
                maxNumCellHeaders = this.getCell(i, j).getNumHeaders();
            }
        }
        this.cellHeaderHeights = new int[maxNumCellHeaders];
        for (i = 0; i < this.getGridRows(); ++i) {
            for (j = 0; j < this.getGridColumns(); ++j) {
                for (int k = 0; k < this.getCell(i, j).getNumHeaders(); ++k) {
                    int ch;
                    if (!this.getCell(i, j).getHeader(k).isVisible()) continue;
                    int n = ch = isMinSize ? this.getCell((int)i, (int)j).getHeader((int)k).getMinimumSize().height : this.getCell((int)i, (int)j).getHeader((int)k).getPreferredSize().height;
                    if (ch <= this.cellHeaderHeights[k]) continue;
                    this.cellHeaderHeights[k] = ch;
                }
            }
        }
        int sh = 0;
        for (int i2 = 0; i2 < maxNumCellHeaders; ++i2) {
            sh += this.cellHeaderHeights[i2];
        }
        return sh;
    }

    protected Dimension calcCellSize() {
        int totalRowSpace;
        int rowAccumulationError;
        Dimension d = new Dimension();
        int expectedTotalColSpace = this.trellisSize.width - this.trellisInsets.left - this.trellisInsets.right - this.sbMargin.right - this.rcaMargin.left - this.rcaMargin.right - this.oaMargin.left - this.oaMargin.right - this.rcSbarMargin.left - this.rcSbarMargin.right - this.axisMargin.left - this.axisMargin.right - (this.visibleColumns - 1) * this.gridHGap;
        d.width = expectedTotalColSpace / this.visibleColumns;
        int expectedTotalRowSpace = this.trellisSize.height - this.trellisInsets.top - this.trellisInsets.bottom - this.titleHeight - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.top - this.rcaMargin.bottom - this.oaMargin.top - this.oaMargin.bottom - this.rcSbarMargin.top - this.rcSbarMargin.bottom - this.axisMargin.top - this.axisMargin.bottom - this.visibleRows * this.maxCellHeaderHeight - (this.visibleRows - 1) * this.gridVGap;
        d.height = expectedTotalRowSpace / this.visibleRows + this.maxCellHeaderHeight;
        int totalColSpace = d.width * this.visibleColumns;
        int colAccumulationError = expectedTotalColSpace - totalColSpace;
        if (colAccumulationError > 0) {
            this.trellisInsets.right += colAccumulationError;
        }
        if ((rowAccumulationError = expectedTotalRowSpace - (totalRowSpace = d.height * this.visibleRows)) > 0) {
            this.trellisInsets.bottom += rowAccumulationError;
        }
        if (this.cellAspectRatio > 0.0) {
            int h = (int)Math.ceil((double)d.width * this.cellAspectRatio);
            if ((h += this.maxCellHeaderHeight) > d.height) {
                int w = (int)Math.ceil((double)(d.height - this.maxCellHeaderHeight) / this.cellAspectRatio);
                int dw = (int)Math.ceil((double)(d.width - w) * 0.5) * this.visibleColumns;
                d.width = w;
                this.trellisInsets.left += dw;
                this.trellisInsets.right += dw;
            } else {
                int dh = (int)Math.ceil((double)(d.height - h) * 0.5) * this.visibleRows;
                d.height = h;
                this.trellisInsets.top += dh;
                this.trellisInsets.bottom = dh;
            }
        }
        return d;
    }

    protected void layoutCell(TrellisPlot trellis) {
        int yo;
        int xo = this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + this.rcSbarMargin.left + this.axisMargin.left;
        int y = yo = this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top + this.rcSbarMargin.top + this.axisMargin.top;
        for (int i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
            int ch = (int)(this.rowWeight[i - this.startRow] * (double)this.visibleRows * (double)this.cellSize.height + 0.5);
            int x = xo;
            for (int j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
                int cw = (int)(this.columnWeight[j - this.startColumn] * (double)this.visibleColumns * (double)this.cellSize.width + 0.5);
                this.getCell(i, j).setBounds(x, y, cw, ch);
                if (!this.cellHeadersAligned) {
                    int chy = y;
                    for (int k = 0; k < this.getCell(i, j).getNumHeaders(); ++k) {
                        if (this.getCell(i, j).getHeader(k).isVisible()) {
                            this.getCell(i, j).getHeader(k).setBounds(x, chy, cw, this.cellHeaderHeights[k]);
                        }
                        chy += this.cellHeaderHeights[k];
                    }
                }
                if (this.getCell(i, j).isMarginsAlignedCellItem()) {
                    CellItemInterface item = (CellItemInterface)((Object)this.getCell(i, j).getItem());
                    item.removeMarginListener(trellis);
                    item.setBounds(x, y + this.maxCellHeaderHeight, cw, ch - this.maxCellHeaderHeight);
                    item.addMarginListener(trellis);
                } else if (this.getCell(i, j).getItem() != null) {
                    this.getCell(i, j).getItem().setBounds(x, y + this.maxCellHeaderHeight, cw, ch - this.maxCellHeaderHeight);
                }
                x += cw + this.gridHGap;
            }
            y += ch + this.gridVGap;
        }
    }

    protected void layoutGridBorderAnnotation() {
        int y;
        int height;
        int yo;
        int maxHeight;
        int w;
        int x;
        int width;
        Component comp;
        int n;
        int xo;
        int maxWidth;
        int h;
        int[] shifts = this.getShifts();
        int topShift = shifts[0];
        int leftShift = shifts[1];
        int bottomShift = shifts[2];
        int rightShift = shifts[3];
        if (this.tAnnotation != null) {
            h = 0;
            maxWidth = this.cellSize.width * this.visibleColumns + this.gridHGap * (this.visibleColumns - 1) - leftShift - rightShift;
            xo = this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + this.rcSbarMargin.left + this.axisMargin.left + leftShift;
            for (n = 0; n < this.tAnnotation.size(); ++n) {
                comp = (Component)this.tAnnotation.get(n);
                if (!comp.isVisible()) continue;
                if (!this.tSpaceFilled) {
                    width = Math.min(maxWidth, comp.getPreferredSize().width);
                    x = Math.max(xo, (int)((double)xo + (double)maxWidth * 0.5 - (double)width * 0.5 + 0.5));
                } else {
                    width = maxWidth;
                    x = xo;
                }
                comp.setBounds(x, this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top + topShift - h - comp.getPreferredSize().height, width, comp.getPreferredSize().height);
                h += comp.getPreferredSize().height;
            }
        }
        if (this.bAnnotation != null) {
            h = 0;
            maxWidth = this.cellSize.width * this.visibleColumns + this.gridHGap * (this.visibleColumns - 1) - leftShift - rightShift;
            xo = this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + this.rcSbarMargin.left + this.axisMargin.left + leftShift;
            for (n = 0; n < this.bAnnotation.size(); ++n) {
                comp = (Component)this.bAnnotation.get(n);
                if (!comp.isVisible()) continue;
                if (!this.bSpaceFilled) {
                    width = Math.min(maxWidth, comp.getPreferredSize().width);
                    x = Math.max(xo, (int)((double)xo + (double)maxWidth * 0.5 - (double)width * 0.5 + 0.5));
                } else {
                    width = maxWidth;
                    x = xo;
                }
                comp.setBounds(x, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom - this.oaMargin.bottom - bottomShift + h, width, comp.getPreferredSize().height);
                h += comp.getPreferredSize().height;
            }
        }
        if (this.lAnnotation != null) {
            w = 0;
            maxHeight = this.cellSize.height * this.visibleRows + this.gridVGap * (this.visibleRows - 1) - topShift - bottomShift;
            yo = this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top + this.rcSbarMargin.top + this.axisMargin.top + topShift;
            for (n = 0; n < this.lAnnotation.size(); ++n) {
                comp = (Component)this.lAnnotation.get(n);
                if (!comp.isVisible()) continue;
                if (!this.lSpaceFilled) {
                    height = Math.min(maxHeight, comp.getPreferredSize().height);
                    y = Math.max(yo, (int)((double)yo + (double)maxHeight * 0.5 - (double)height * 0.5 + 0.5));
                } else {
                    height = maxHeight;
                    y = yo;
                }
                comp.setBounds(this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + leftShift - w - comp.getPreferredSize().width, y, comp.getPreferredSize().width, height);
                w += comp.getPreferredSize().width;
            }
        }
        if (this.rAnnotation != null) {
            w = 0;
            maxHeight = this.cellSize.height * this.visibleRows + this.gridVGap * (this.visibleRows - 1) - topShift - bottomShift;
            yo = this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top + this.rcSbarMargin.top + this.axisMargin.top + topShift;
            for (n = 0; n < this.rAnnotation.size(); ++n) {
                comp = (Component)this.rAnnotation.get(n);
                if (!comp.isVisible()) continue;
                if (!this.rSpaceFilled) {
                    height = Math.min(maxHeight, comp.getPreferredSize().height);
                    y = Math.max(yo, (int)((double)yo + (double)maxHeight * 0.5 - (double)height * 0.5 + 0.5));
                } else {
                    height = maxHeight;
                    y = yo;
                }
                comp.setBounds(this.trellisSize.width - this.trellisInsets.right - this.sbMargin.right - this.rcaMargin.right - this.oaMargin.right - rightShift + w, y, comp.getPreferredSize().width, height);
                w += comp.getPreferredSize().width;
            }
        }
    }

    protected void layoutScrollBar() {
        if (!this.uniformGrid) {
            return;
        }
        if (this.vsbar != null && this.vsbar.isVisible()) {
            this.vsbar.setBounds(this.trellisSize.width - this.trellisInsets.right - this.sbMargin.right, this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top + this.rcSbarMargin.top + this.axisMargin.top, this.sbMargin.right, this.trellisSize.height - this.trellisInsets.top - this.trellisInsets.bottom - this.titleHeight - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.top - this.rcaMargin.bottom - this.oaMargin.top - this.oaMargin.bottom - this.rcSbarMargin.top - this.rcSbarMargin.bottom - this.axisMargin.top - this.axisMargin.bottom);
        }
        if (this.hsbar != null && this.hsbar.isVisible()) {
            this.hsbar.setBounds(this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + this.rcSbarMargin.left + this.axisMargin.left, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom, this.trellisSize.width - this.trellisInsets.left - this.trellisInsets.right - this.sbMargin.right - this.rcaMargin.left - this.rcaMargin.right - this.oaMargin.left - this.oaMargin.right - this.rcSbarMargin.left - this.rcSbarMargin.right - this.axisMargin.left - this.axisMargin.right, this.sbMargin.bottom);
        }
    }

    protected Insets calcGridLabelMargin() {
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        int endRow = this.startRow + this.visibleRows;
        int endColumn = this.startColumn + this.visibleColumns;
        for (int i = this.startRow; i < endRow; ++i) {
            for (int j = this.startColumn; j < endColumn; ++j) {
                CellItemInterface item;
                if (!this.getCell(i, j).isCellItem() || !((item = (CellItemInterface)((Object)this.getCell(i, j).getItem())) instanceof GridLabelInterface) || !item.getMarginsAligned() || !((GridLabelInterface)((Object)item)).hasGridLabel()) continue;
                Insets glm = ((GridLabelInterface)((Object)item)).getGridLabelMargin();
                left = Math.max(left, glm.left);
                right = Math.max(right, glm.right);
                top = Math.max(top, glm.top);
                bottom = Math.max(bottom, glm.bottom);
            }
        }
        return new Insets(top, left, bottom, right);
    }

    protected void calcItemIOMargin() {
        for (int i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
            for (int j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
                CellItemInterface item;
                if (!this.getCell(i, j).isCellItem() || !(item = (CellItemInterface)((Object)this.getCell(i, j).getItem())).getMarginsAligned()) continue;
                Insets pom = item.getPreferredOuterMargin();
                Insets pim = item.getPreferredInnerMargin();
                this.getRowOM((int)i).top = Math.max(this.getRowOM((int)i).top, pom.top);
                this.getRowOM((int)i).bottom = Math.max(this.getRowOM((int)i).bottom, pom.bottom);
                this.getColOM((int)j).left = Math.max(this.getColOM((int)j).left, pom.left);
                this.getColOM((int)j).right = Math.max(this.getColOM((int)j).right, pom.right);
                this.getRowIM((int)i).top = Math.max(this.getRowIM((int)i).top, pim.top);
                this.getRowIM((int)i).bottom = Math.max(this.getRowIM((int)i).bottom, pim.bottom);
                this.getColIM((int)j).left = Math.max(this.getColIM((int)j).left, pim.left);
                this.getColIM((int)j).right = Math.max(this.getColIM((int)j).right, pim.right);
                if (!(item instanceof MarginInterface2)) continue;
                MarginInterface2 im2 = (MarginInterface2)((Object)item);
                Insets pim2 = im2.getPreferredInnerMargin2();
                this.getRowIM2((int)i).top = Math.max(this.getRowIM2((int)i).top, pim2.top);
                this.getRowIM2((int)i).bottom = Math.max(this.getRowIM2((int)i).bottom, pim2.bottom);
                this.getColIM2((int)j).left = Math.max(this.getColIM2((int)j).left, pim2.left);
                this.getColIM2((int)j).right = Math.max(this.getColIM2((int)j).right, pim2.right);
            }
        }
    }

    protected void updateItemIOMargin() {
        for (int i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
            for (int j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
                if (!this.getCell(i, j).isCellItem()) continue;
                CellItemInterface item = (CellItemInterface)((Object)this.getCell(i, j).getItem());
                Insets pom = item.getOuterMargin();
                Insets pim = item.getInnerMargin();
                this.getRowOM((int)i).top = Math.max(this.getRowOM((int)i).top, pom.top);
                this.getRowOM((int)i).bottom = Math.max(this.getRowOM((int)i).bottom, pom.bottom);
                this.getColOM((int)j).left = Math.max(this.getColOM((int)j).left, pom.left);
                this.getColOM((int)j).right = Math.max(this.getColOM((int)j).right, pom.right);
                this.getRowIM((int)i).top = Math.max(this.getRowIM((int)i).top, pim.top);
                this.getRowIM((int)i).bottom = Math.max(this.getRowIM((int)i).bottom, pim.bottom);
                this.getColIM((int)j).left = Math.max(this.getColIM((int)j).left, pim.left);
                this.getColIM((int)j).right = Math.max(this.getColIM((int)j).right, pim.right);
                if (!(item instanceof MarginInterface2)) continue;
                MarginInterface2 im2 = (MarginInterface2)((Object)item);
                Insets pim2 = im2.getInnerMargin2();
                this.getRowIM2((int)i).top = Math.max(this.getRowIM2((int)i).top, pim2.top);
                this.getRowIM2((int)i).bottom = Math.max(this.getRowIM2((int)i).bottom, pim2.bottom);
                this.getColIM2((int)j).left = Math.max(this.getColIM2((int)j).left, pim2.left);
                this.getColIM2((int)j).right = Math.max(this.getColIM2((int)j).right, pim2.right);
            }
        }
    }

    protected void calcAxisIMargin() {
        Insets pim2;
        GridAxisInterface2 axis2;
        Insets pim;
        GridAxisInterface axis;
        if (this.gridAxisCount == 0) {
            return;
        }
        for (int r = 0; r < this.getGridRows(); ++r) {
            axis = (GridAxisInterface)((Object)this.getRowAxis(r, true));
            if (axis != null) {
                pim = axis.getPreferredInnerMargin();
                if (axis instanceof GridAxisInterface2 && (axis2 = (GridAxisInterface2)((Object)this.getRowAxis(r, false))) != null && axis2.isMirror()) {
                    pim2 = axis2.getPreferredInnerMargin();
                    pim.top = Math.max(pim.top, pim2.top);
                    pim.left = Math.max(pim.left, pim2.left);
                    pim.bottom = Math.max(pim.bottom, pim2.bottom);
                    pim.right = Math.max(pim.right, pim2.right);
                }
                if (this.getRowIM((int)r).top < pim.top) {
                    this.getRowIM((int)r).top = pim.top;
                }
                if (this.getRowIM((int)r).bottom < pim.bottom) {
                    this.getRowIM((int)r).bottom = pim.bottom;
                }
            }
            if ((axis = (GridAxisInterface)((Object)this.getRowAxis(r, false))) == null) continue;
            pim = axis.getPreferredInnerMargin();
            if (axis instanceof GridAxisInterface2) {
                axis2 = (GridAxisInterface2)((Object)this.getRowAxis(r, true));
                if (axis2 != null && axis2.isMirror()) {
                    pim2 = axis2.getPreferredInnerMargin();
                    pim.top = Math.max(pim.top, pim2.top);
                    pim.left = Math.max(pim.left, pim2.left);
                    pim.bottom = Math.max(pim.bottom, pim2.bottom);
                    pim.right = Math.max(pim.right, pim2.right);
                }
                if (this.getRowIM2((int)r).top < pim.top) {
                    this.getRowIM2((int)r).top = pim.top;
                }
                if (this.getRowIM2((int)r).bottom >= pim.bottom) continue;
                this.getRowIM2((int)r).bottom = pim.bottom;
                continue;
            }
            if (this.getRowIM((int)r).top < pim.top) {
                this.getRowIM((int)r).top = pim.top;
            }
            if (this.getRowIM((int)r).bottom >= pim.bottom) continue;
            this.getRowIM((int)r).bottom = pim.bottom;
        }
        for (int c = 0; c < this.getGridColumns(); ++c) {
            axis = (GridAxisInterface)((Object)this.getColumnAxis(c, true));
            if (axis != null) {
                pim = axis.getPreferredInnerMargin();
                if (axis instanceof GridAxisInterface2 && (axis2 = (GridAxisInterface2)((Object)this.getColumnAxis(c, false))) != null && axis2.isMirror()) {
                    pim2 = axis2.getPreferredInnerMargin();
                    pim.top = Math.max(pim.top, pim2.top);
                    pim.left = Math.max(pim.left, pim2.left);
                    pim.bottom = Math.max(pim.bottom, pim2.bottom);
                    pim.right = Math.max(pim.right, pim2.right);
                }
                if (this.getColIM((int)c).left < pim.left) {
                    this.getColIM((int)c).left = pim.left;
                }
                if (this.getColIM((int)c).right < pim.right) {
                    this.getColIM((int)c).right = pim.right;
                }
            }
            if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(c, false))) == null) continue;
            pim = axis.getPreferredInnerMargin();
            if (axis instanceof GridAxisInterface2) {
                axis2 = (GridAxisInterface2)((Object)this.getColumnAxis(c, true));
                if (axis2 != null && axis2.isMirror()) {
                    pim2 = axis2.getPreferredInnerMargin();
                    pim.top = Math.max(pim.top, pim2.top);
                    pim.left = Math.max(pim.left, pim2.left);
                    pim.bottom = Math.max(pim.bottom, pim2.bottom);
                    pim.right = Math.max(pim.right, pim2.right);
                }
                if (this.getColIM2((int)c).left < pim.left) {
                    this.getColIM2((int)c).left = pim.left;
                }
                if (this.getColIM2((int)c).right >= pim.right) continue;
                this.getColIM2((int)c).right = pim.right;
                continue;
            }
            if (this.getColIM((int)c).left < pim.left) {
                this.getColIM((int)c).left = pim.left;
            }
            if (this.getColIM((int)c).right >= pim.right) continue;
            this.getColIM((int)c).right = pim.right;
        }
    }

    protected void layoutItemIOMargin() {
        for (int i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
            for (int j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
                CellItemInterface item;
                if (!this.getCell(i, j).isCellItem() || !(item = (CellItemInterface)((Object)this.getCell(i, j).getItem())).getMarginsAligned()) continue;
                Insets om = new Insets(this.getRowOM((int)i).top, this.getColOM((int)j).left, this.getRowOM((int)i).bottom, this.getColOM((int)j).right);
                item.setOuterMargin(om);
                Insets im = new Insets(this.getRowIM((int)i).top, this.getColIM((int)j).left, this.getRowIM((int)i).bottom, this.getColIM((int)j).right);
                if (!(item instanceof MarginInterface2)) {
                    item.setInnerMargin(im);
                    continue;
                }
                MarginInterface2 im2 = (MarginInterface2)((Object)item);
                Insets im_2 = new Insets(this.getRowIM2((int)i).top, this.getColIM2((int)j).left, this.getRowIM2((int)i).bottom, this.getColIM2((int)j).right);
                im2.setInnerMargins(im, im_2);
            }
        }
    }

    protected void layoutRowColHeader() {
        int i;
        if (this.isOLAPHeaders()) {
            this.layoutRowColOLAPHeader();
            return;
        }
        if (this.isCompoundHeaders()) {
            this.layoutRowColCompoundHeader();
            return;
        }
        int[] shifts = this.getShifts();
        int topShift = shifts[0];
        int leftShift = shifts[1];
        int bottomShift = shifts[2];
        int rightShift = shifts[3];
        int xo = this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + this.rcSbarMargin.left + this.axisMargin.left;
        int yo = this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top + this.rcSbarMargin.top + this.axisMargin.top;
        int x = xo;
        int y = yo;
        int firstRow = this.getFirstNonEmptyRow();
        int lastRow = this.getLastNonEmptyRow();
        int maxRowHeaderWidth = 0;
        if (this.rowHeaderLabel != null) {
            maxRowHeaderWidth = this.rowHeaderLabel.getPreferredSize().width;
        }
        for (int i2 = this.startRow; i2 < this.startRow + this.visibleRows; ++i2) {
            Component comp = this.getRowHeader(i2);
            if (comp == null || !comp.isVisible()) continue;
            maxRowHeaderWidth = Math.max(maxRowHeaderWidth, comp.getPreferredSize().width);
        }
        int maxRow2HeaderWidth = 0;
        if (this.rowHeaderLabel != null) {
            maxRow2HeaderWidth = this.rowHeaderLabel.getPreferredSize().width;
        }
        for (i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
            Component comp = this.getRowHeader2(i);
            if (comp == null || !comp.isVisible()) continue;
            maxRow2HeaderWidth = Math.max(maxRow2HeaderWidth, comp.getPreferredSize().width);
        }
        if (this.rowHeaderLabelPosition == 1) {
            if (this.rowHeaderLabel != null) {
                this.rowHeaderLabel.setBounds(this.trellisInsets.left + leftShift, yo - this.rowHeaderLabel.getPreferredSize().height, maxRowHeaderWidth, this.rowHeaderLabel.getPreferredSize().height);
            }
            if (this.row2HeaderLabel != null) {
                this.row2HeaderLabel.setBounds(this.trellisSize.width - this.trellisInsets.right - this.sbMargin.right - this.rcaMargin.right - rightShift, yo - this.row2HeaderLabel.getPreferredSize().height, maxRow2HeaderWidth, this.row2HeaderLabel.getPreferredSize().height);
            }
        }
        for (i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
            boolean align = this.rowHeadersAligned;
            if (this.rowHeadersAligned && this.visibleColumns > 1) {
                for (int j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
                    if (!this.getCell(i, j).isCellItem() || ((CellItemInterface)((Object)this.getCell(i, j).getItem())).getMarginsAligned()) continue;
                    align = false;
                    break;
                }
            }
            int ch = (int)(this.rowWeight[i - this.startRow] * (double)this.visibleRows * (double)this.cellSize.height + 0.5);
            if (this.getRowHeader(i) != null && this.getRowHeader(i).isVisible()) {
                if (this.skipEmptyCells && (i < firstRow || i > lastRow)) {
                    this.getRowHeader(i).setVisible(false);
                } else if (align) {
                    this.getRowHeader(i).setBounds(this.trellisInsets.left + leftShift, y + this.maxCellHeaderHeight + this.getRowOM((int)i).top, maxRowHeaderWidth, ch - this.maxCellHeaderHeight - this.getRowOM((int)i).top - this.getRowOM((int)i).bottom);
                } else {
                    this.getRowHeader(i).setBounds(this.trellisInsets.left + leftShift, y + this.maxCellHeaderHeight, maxRowHeaderWidth, ch - this.maxCellHeaderHeight);
                }
            }
            if (this.getRowHeader2(i) != null && this.getRowHeader2(i).isVisible()) {
                if (this.skipEmptyCells && (i < firstRow || i > lastRow)) {
                    this.getRowHeader2(i).setVisible(false);
                } else if (align) {
                    this.getRowHeader2(i).setBounds(this.trellisSize.width - this.trellisInsets.right - this.sbMargin.right - this.rcaMargin.right - rightShift, y + this.maxCellHeaderHeight + this.getRowOM((int)i).top, maxRow2HeaderWidth, ch - this.maxCellHeaderHeight - this.getRowOM((int)i).top - this.getRowOM((int)i).bottom);
                } else {
                    this.getRowHeader2(i).setBounds(this.trellisSize.width - this.trellisInsets.right - this.sbMargin.right - this.rcaMargin.right - rightShift, y + this.maxCellHeaderHeight, maxRow2HeaderWidth, ch - this.maxCellHeaderHeight);
                }
            }
            y += ch + this.gridVGap;
        }
        if (this.rowHeaderLabelPosition == 3) {
            if (this.rowHeaderLabel != null) {
                this.rowHeaderLabel.setBounds(this.trellisInsets.left + leftShift, y - this.gridVGap, maxRowHeaderWidth, this.rowHeaderLabel.getPreferredSize().height);
            }
            if (this.row2HeaderLabel != null) {
                this.row2HeaderLabel.setBounds(this.trellisSize.width - this.trellisInsets.right - this.sbMargin.right - this.rcaMargin.right - rightShift, y - this.gridVGap, maxRow2HeaderWidth, this.row2HeaderLabel.getPreferredSize().height);
            }
        }
        int firstCol = this.getFirstNonEmptyColumn();
        int lastCol = this.getLastNonEmptyColumn();
        int maxColumnHeaderHeight = 0;
        if (this.columnHeaderLabel != null) {
            maxColumnHeaderHeight = this.columnHeaderLabel.getPreferredSize().height;
        }
        for (int i3 = this.startColumn; i3 < this.startColumn + this.visibleColumns; ++i3) {
            Component comp = this.getColumnHeader(i3);
            if (comp == null || !comp.isVisible()) continue;
            maxColumnHeaderHeight = Math.max(maxColumnHeaderHeight, comp.getPreferredSize().height);
        }
        int maxColumn2HeaderHeight = 0;
        if (this.column2HeaderLabel != null) {
            maxColumn2HeaderHeight = this.column2HeaderLabel.getPreferredSize().height;
        }
        for (int i4 = this.startColumn; i4 < this.startColumn + this.visibleColumns; ++i4) {
            Component comp = this.getColumnHeader2(i4);
            if (comp == null || !comp.isVisible()) continue;
            maxColumn2HeaderHeight = Math.max(maxColumn2HeaderHeight, comp.getPreferredSize().height);
        }
        if (this.colHeaderLabelPosition == 2) {
            if (this.columnHeaderLabel != null) {
                this.columnHeaderLabel.setBounds(xo - this.columnHeaderLabel.getPreferredSize().width, this.trellisInsets.top + this.titleHeight + topShift, this.columnHeaderLabel.getPreferredSize().width, maxColumnHeaderHeight);
            }
            if (this.column2HeaderLabel != null) {
                this.column2HeaderLabel.setBounds(xo - this.column2HeaderLabel.getPreferredSize().width, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom - bottomShift, this.column2HeaderLabel.getPreferredSize().width, maxColumn2HeaderHeight);
            }
        }
        for (int j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
            boolean align = this.colHeadersAligned;
            if (this.colHeadersAligned && this.visibleRows > 1) {
                for (int i5 = this.startRow; i5 < this.startRow + this.visibleRows; ++i5) {
                    if (!this.getCell(i5, j).isCellItem() || ((CellItemInterface)((Object)this.getCell(i5, j).getItem())).getMarginsAligned()) continue;
                    align = false;
                    break;
                }
            }
            int cw = (int)(this.columnWeight[j - this.startColumn] * (double)this.visibleColumns * (double)this.cellSize.width + 0.5);
            if (this.getColumnHeader(j) != null && this.getColumnHeader(j).isVisible()) {
                if (this.skipEmptyCells && (j < firstCol || j > lastCol)) {
                    this.getColumnHeader(j).setVisible(false);
                } else if (align) {
                    this.getColumnHeader(j).setBounds(x + this.getColOM((int)j).left, this.trellisInsets.top + this.titleHeight + topShift, cw - this.getColOM((int)j).left - this.getColOM((int)j).right, maxColumnHeaderHeight);
                } else {
                    this.getColumnHeader(j).setBounds(x, this.trellisInsets.top + this.titleHeight + topShift, cw, maxColumnHeaderHeight);
                }
            }
            if (this.getColumnHeader2(j) != null && this.getColumnHeader2(j).isVisible()) {
                if (this.skipEmptyCells && (j < firstCol || j > lastCol)) {
                    this.getColumnHeader2(j).setVisible(false);
                } else if (align) {
                    this.getColumnHeader2(j).setBounds(x + this.getColOM((int)j).left, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom - bottomShift, cw - this.getColOM((int)j).left - this.getColOM((int)j).right, maxColumn2HeaderHeight);
                } else {
                    this.getColumnHeader2(j).setBounds(x, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom - bottomShift, cw, maxColumn2HeaderHeight);
                }
            }
            x += cw + this.gridHGap;
        }
        if (this.colHeaderLabelPosition == 4) {
            if (this.columnHeaderLabel != null) {
                this.columnHeaderLabel.setBounds(x - this.gridHGap, this.trellisInsets.top + this.titleHeight + topShift, this.columnHeaderLabel.getPreferredSize().width, maxColumnHeaderHeight);
            }
            if (this.column2HeaderLabel != null) {
                this.column2HeaderLabel.setBounds(x - this.gridHGap, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom - bottomShift, this.column2HeaderLabel.getPreferredSize().width, maxColumn2HeaderHeight);
            }
        }
    }

    protected void layoutRowColCompoundHeader() {
        int l;
        int k;
        int[] shifts = this.getShifts();
        int topShift = shifts[0];
        int leftShift = shifts[1];
        int bottomShift = shifts[2];
        int rightShift = shifts[3];
        int xo = this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + this.rcSbarMargin.left + this.axisMargin.left;
        int yo = this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top + this.rcSbarMargin.top + this.axisMargin.top;
        int dh = 0;
        if (this.rowAxisLabel != null) {
            for (int l2 = 0; l2 < this.rowAxisLabel.length; ++l2) {
                dh += this.rowAxisLabel[l2].getHeight();
            }
        }
        int x = xo;
        int y = yo;
        for (k = 0; this.rowCompoundHeader != null && k < this.rowCompoundHeader.getLevels(); ++k) {
            y = yo;
            l = this.rowCompoundHeader.getLevels() - 1 - k;
            int num = this.rowCompoundHeader.getHeader(l).getNumHeaders();
            int span = this.rowCompoundHeader.getHeader(l).getSpan();
            int maxWidth = 0;
            for (int i = 0; i < num; ++i) {
                Component comp = this.getRowCompoundHeader(l, i);
                maxWidth = Math.max(maxWidth, comp.getPreferredSize().width);
            }
            if (this.rowCompoundHeader.getHeader(l).getLabel() != null && this.rowHeaderLabelPosition == 1) {
                Component comp = this.rowCompoundHeader.getHeader(l).getLabel();
                int topTitleShift = 0;
                for (int kk = 0; kk < l; ++kk) {
                    topTitleShift += this.rowCompoundHeader.getHeader((int)kk).getLabel().getPreferredSize().height;
                }
                comp.setBounds(this.trellisInsets.left + leftShift + this.axisLabelPadding.left, yo - dh - comp.getPreferredSize().height - topTitleShift, comp.getPreferredSize().width, comp.getPreferredSize().height);
                topTitleShift += comp.getPreferredSize().height;
            }
            for (int i = 0; i < num; ++i) {
                int ch = 0;
                for (int j = 0; j < span; ++j) {
                    int r = i * span + j;
                    ch += (int)(this.rowWeight[r] * (double)this.visibleRows * (double)this.cellSize.height + 0.5) + this.gridVGap;
                }
                Component comp = this.getRowCompoundHeader(l, i);
                comp.setBounds(this.trellisInsets.left + leftShift + this.axisLabelPadding.left, y + this.maxCellHeaderHeight, maxWidth, (ch -= this.gridVGap) - this.maxCellHeaderHeight);
                y += ch + this.gridVGap;
            }
            if (this.rowCompoundHeader.getHeader(l).getLabel() != null && this.rowHeaderLabelPosition == 3) {
                Component comp = this.rowCompoundHeader.getHeader(l).getLabel();
                comp.setBounds(this.trellisInsets.left + leftShift, y - this.gridVGap, maxWidth, comp.getPreferredSize().height);
            }
            leftShift += maxWidth;
            y = yo;
            l = k;
            num = this.rowCompoundHeader.getHeader(l).getNumHeaders2();
            span = this.rowCompoundHeader.getHeader(l).getSpan();
            int maxWidth2 = 0;
            if (this.rowCompoundHeader.getHeader(l).getLabel2() != null) {
                maxWidth2 = this.rowCompoundHeader.getHeader((int)l).getLabel2().getPreferredSize().width;
            }
            for (int i = 0; i < num; ++i) {
                Component comp = this.getRow2CompoundHeader(l, i);
                maxWidth2 = Math.max(maxWidth2, comp.getPreferredSize().width);
            }
            if (this.rowCompoundHeader.getHeader(l).getLabel2() != null && this.rowHeaderLabelPosition == 1) {
                Component comp = this.rowCompoundHeader.getHeader(l).getLabel2();
                comp.setBounds(this.trellisSize.width - this.trellisInsets.right - this.sbMargin.right - this.rcaMargin.right - rightShift, yo - comp.getPreferredSize().height, maxWidth2, comp.getPreferredSize().height);
            }
            for (int i = 0; i < num; ++i) {
                int ch = 0;
                for (int j = 0; j < span; ++j) {
                    int r = i * span + j;
                    ch += (int)(this.rowWeight[r] * (double)this.visibleRows * (double)this.cellSize.height + 0.5) + this.gridVGap;
                }
                Component comp = this.getRow2CompoundHeader(l, i);
                comp.setBounds(this.trellisSize.width - this.trellisInsets.right - this.sbMargin.right - this.rcaMargin.right - rightShift, y + this.maxCellHeaderHeight, maxWidth2, (ch -= this.gridVGap) - this.maxCellHeaderHeight);
                y += ch + this.gridVGap;
            }
            if (this.rowCompoundHeader.getHeader(l).getLabel2() != null && this.rowHeaderLabelPosition == 3) {
                Component comp = this.rowCompoundHeader.getHeader(l).getLabel2();
                comp.setBounds(this.trellisSize.width - this.trellisInsets.right - this.sbMargin.right - this.rcaMargin.right - rightShift, y - this.gridVGap, maxWidth2, comp.getPreferredSize().height);
            }
            rightShift -= maxWidth2;
        }
        for (k = 0; this.columnCompoundHeader != null && k < this.columnCompoundHeader.getLevels(); ++k) {
            x = xo;
            l = this.columnCompoundHeader.getLevels() - 1 - k;
            int maxHeight = 0;
            if (this.columnCompoundHeader.getHeader(l).getLabel() != null) {
                Component comp = this.columnCompoundHeader.getHeader(l).getLabel();
                maxHeight = comp.getPreferredSize().height;
            }
            int num = this.columnCompoundHeader.getHeader(l).getNumHeaders();
            for (int i = 0; i < num; ++i) {
                Component comp = this.getColumnCompoundHeader(l, i);
                maxHeight = Math.max(maxHeight, comp.getPreferredSize().height);
            }
            if (this.columnCompoundHeader.getHeader(l).getLabel() != null && this.colHeaderLabelPosition == 2) {
                Component comp = this.columnCompoundHeader.getHeader(l).getLabel();
                comp.setBounds(xo - comp.getPreferredSize().width, this.trellisInsets.top + this.titleHeight + topShift, comp.getPreferredSize().width, maxHeight);
            }
            int span = this.columnCompoundHeader.getHeader(l).getSpan();
            for (int i = 0; i < num; ++i) {
                int cw = 0;
                for (int j = 0; j < span; ++j) {
                    int c = i * span + j;
                    cw += (int)(this.columnWeight[c] * (double)this.visibleColumns * (double)this.cellSize.width + 0.5) + this.gridHGap;
                }
                Component comp = this.getColumnCompoundHeader(l, i);
                comp.setBounds(x, this.trellisInsets.top + this.titleHeight + topShift, cw -= this.gridHGap, maxHeight);
                x += cw + this.gridHGap;
            }
            if (this.columnCompoundHeader.getHeader(l).getLabel() != null && this.colHeaderLabelPosition == 4) {
                Component comp = this.columnCompoundHeader.getHeader(l).getLabel();
                comp.setBounds(x - this.gridHGap, this.trellisInsets.top + this.titleHeight + topShift, comp.getPreferredSize().width, maxHeight);
            }
            topShift += maxHeight;
            x = xo;
            l = k;
            int maxHeight2 = 0;
            if (this.columnCompoundHeader.getHeader(l).getLabel2() != null) {
                Component comp = this.columnCompoundHeader.getHeader(l).getLabel2();
                maxHeight2 = comp.getPreferredSize().height;
            }
            num = this.columnCompoundHeader.getHeader(l).getNumHeaders2();
            for (int i = 0; i < num; ++i) {
                Component comp = this.getColumn2CompoundHeader(l, i);
                maxHeight2 = Math.max(maxHeight2, comp.getPreferredSize().height);
            }
            if (this.columnCompoundHeader.getHeader(l).getLabel2() != null && this.colHeaderLabelPosition == 2) {
                Component comp = this.columnCompoundHeader.getHeader(l).getLabel2();
                comp.setBounds(xo - comp.getPreferredSize().width, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom - bottomShift, comp.getPreferredSize().width, maxHeight2);
            }
            span = this.columnCompoundHeader.getHeader(l).getSpan();
            for (int i = 0; i < num; ++i) {
                int cw = 0;
                for (int j = 0; j < span; ++j) {
                    int c = i * span + j;
                    cw += (int)(this.columnWeight[c] * (double)this.visibleColumns * (double)this.cellSize.width + 0.5) + this.gridHGap;
                }
                Component comp = this.getColumn2CompoundHeader(l, i);
                comp.setBounds(x, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom - bottomShift, cw -= this.gridHGap, maxHeight2);
                x += cw + this.gridHGap;
            }
            if (this.columnCompoundHeader.getHeader(l).getLabel2() != null && this.colHeaderLabelPosition == 4) {
                Component comp = this.columnCompoundHeader.getHeader(l).getLabel2();
                comp.setBounds(x - this.gridHGap, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom - bottomShift, comp.getPreferredSize().width, maxHeight2);
            }
            bottomShift -= maxHeight2;
        }
    }

    public static ArrayList getMatchedLeafs(DataTreeGroupNode root, DefaultMutableTreeNode[] leafs) {
        if (leafs == null) {
            return null;
        }
        ArrayList<DataTreeGroupNode> list = new ArrayList<DataTreeGroupNode>();
        Enumeration eu = root.depthFirstEnumeration();
        while (eu.hasMoreElements()) {
            DataTreeGroupNode n = (DataTreeGroupNode)eu.nextElement();
            if (n.isRoot()) continue;
            for (int i = 0; i < leafs.length; ++i) {
                DataTreeGroupNode leaf = (DataTreeGroupNode)leafs[i];
                if (n.getTupleElementName() != leaf.getTupleElementName() || n.getTupleElementSpan() != leaf.getTupleElementSpan() || n.getTupleElementSpanDepth() != leaf.getTupleElementSpanDepth()) continue;
                list.add(n);
                break;
            }
            if (list.size() != leafs.length) continue;
            break;
        }
        return list;
    }

    protected void layoutRowColOLAPHeader() {
        Component comp;
        int ww;
        int kk;
        int k;
        OLAPHeader.TreeHeader major;
        int[] shifts = this.getShifts();
        int topShift = shifts[0];
        int leftShift = shifts[1];
        int bottomShift = shifts[2];
        int rightShift = shifts[3];
        int xo = this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + this.rcSbarMargin.left + this.axisMargin.left;
        int yo = this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top + this.rcSbarMargin.top + this.axisMargin.top;
        int dh = 0;
        if (this.rowAxisLabel != null) {
            for (int l = 0; l < this.rowAxisLabel.length; ++l) {
                dh += this.rowAxisLabel[l].getHeight();
            }
        }
        int x = xo;
        int y = yo;
        if (this.rowOLAPHeader != null) {
            major = this.rowOLAPHeader.getMajor();
            if (major.titleComponent != null) {
                Component comp2 = major.titleComponent;
                int yc = (this.getGridTop() + this.getGridBottom()) / 2;
                int xc = this.trellisInsets.left;
                comp2.setBounds(xc, yc - comp2.getPreferredSize().height / 2, comp2.getPreferredSize().width, comp2.getPreferredSize().height);
            }
            int levels = major.getLevels();
            for (int k2 = 0; k2 < levels; ++k2) {
                Component comp3 = major.getLabel(k2);
                comp3.setBounds(this.trellisInsets.left + this.rcaMargin.left - (leftShift += major.levelWidths[k2]), yo - dh - (topShift += comp3.getPreferredSize().height), comp3.getPreferredSize().width, comp3.getPreferredSize().height);
            }
            y = yo;
            leftShift = shifts[1];
            DataTreeGroupNode tree = major.getTree();
            if (tree != null) {
                if (major.getHeaderLeafs() != null) {
                    ArrayList leafs = TrellisLayout.getMatchedLeafs(tree, major.getHeaderLeafs());
                    for (int r = 0; r < leafs.size(); ++r) {
                        DataTreeGroupNode leaf = (DataTreeGroupNode)leafs.get(r);
                        DefaultMutableTreeNode[] catLeafs = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)leaf);
                        int ch = (int)(this.rowWeight[r] * (double)this.visibleRows * (double)this.cellSize.height + 0.5);
                        if (catLeafs.length > 0) {
                            int h = ch / catLeafs.length;
                            int yy = y;
                            for (k = 0; k < catLeafs.length; ++k) {
                                DataTreeGroupNode dtn = (DataTreeGroupNode)catLeafs[k];
                                Component comp4 = (Component)dtn.getUserObject();
                                if (k == catLeafs.length - 1) {
                                    h += ch - h * catLeafs.length;
                                }
                                int w = 0;
                                for (kk = 0; kk < dtn.getTupleElementSpan(); ++kk) {
                                    w += major.levelWidths[kk];
                                }
                                comp4.setBounds(this.trellisInsets.left + this.rcaMargin.left - w, yy, w, h);
                                yy += h;
                            }
                        } else {
                            Component comp5 = (Component)leaf.getUserObject();
                            int w = 0;
                            for (k = 0; k < leaf.getTupleElementSpan(); ++k) {
                                w += major.levelWidths[k];
                            }
                            comp5.setBounds(this.trellisInsets.left + this.rcaMargin.left - w, y, w, ch);
                        }
                        y += ch + this.gridVGap;
                    }
                } else {
                    DefaultMutableTreeNode[] catLeafs = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)tree);
                    int ch = this.cellSize.height;
                    int h = ch / catLeafs.length;
                    int yy = y;
                    for (int k3 = 0; k3 < catLeafs.length; ++k3) {
                        DataTreeGroupNode dtn = (DataTreeGroupNode)catLeafs[k3];
                        Component comp6 = (Component)dtn.getUserObject();
                        if (k3 == catLeafs.length - 1) {
                            h += ch - h * catLeafs.length;
                        }
                        int w = 0;
                        for (int kk2 = 0; kk2 < dtn.getTupleElementSpan(); ++kk2) {
                            w += major.levelWidths[kk2];
                        }
                        comp6.setBounds(this.trellisInsets.left + this.rcaMargin.left - w, yy, w, h);
                        yy += h;
                    }
                }
                Enumeration eu = tree.breadthFirstEnumeration();
                while (eu.hasMoreElements()) {
                    DataTreeGroupNode n = (DataTreeGroupNode)eu.nextElement();
                    if (n.isLeaf() || n.isRoot()) continue;
                    int l = n.getDepth();
                    DefaultMutableTreeNode first = n.getFirstLeaf();
                    DefaultMutableTreeNode last = n.getLastLeaf();
                    Component firstComp = (Component)first.getUserObject();
                    Component lastComp = (Component)last.getUserObject();
                    int off = 0;
                    for (int k4 = 0; k4 <= l; ++k4) {
                        off += major.levelWidths[k4];
                    }
                    int xx = this.trellisInsets.left + this.rcaMargin.left - off;
                    int yy = firstComp.getY();
                    int hh = lastComp.getY() + lastComp.getHeight() - yy;
                    ww = 0;
                    for (int k5 = 0; k5 < n.getTupleElementSpan(); ++k5) {
                        ww += major.levelWidths[k5 + l];
                    }
                    comp = (Component)n.getUserObject();
                    comp.setBounds(xx, yy, ww, hh);
                }
            }
        }
        if (this.columnOLAPHeader != null) {
            major = this.columnOLAPHeader.getMajor();
            if (major.titleComponent != null) {
                Component comp7 = major.titleComponent;
                int xc = (this.getGridLeft() + this.getGridRight()) / 2;
                int yc = this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - comp7.getPreferredSize().height;
                comp7.setBounds(xc - comp7.getPreferredSize().width / 2, yc, comp7.getPreferredSize().width, comp7.getPreferredSize().height);
            }
            int levels = major.getLevels();
            for (int k6 = 0; k6 < levels; ++k6) {
                Component comp8 = major.getLabel(k6);
                comp8.setBounds(xo - comp8.getPreferredSize().width, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom + bottomShift, comp8.getPreferredSize().width, major.levelHeights[k6]);
                bottomShift += major.levelHeights[k6];
            }
            bottomShift = shifts[2];
            x = xo;
            DataTreeGroupNode tree = major.getTree();
            if (tree != null) {
                if (major.getHeaderLeafs() != null) {
                    ArrayList leafs = TrellisLayout.getMatchedLeafs(tree, major.getHeaderLeafs());
                    for (int c = 0; c < leafs.size(); ++c) {
                        DataTreeGroupNode leaf = (DataTreeGroupNode)leafs.get(c);
                        DefaultMutableTreeNode[] catLeafs = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)leaf);
                        int cw = (int)(this.columnWeight[c] * (double)this.visibleColumns * (double)this.cellSize.width + 0.5);
                        if (catLeafs.length > 0) {
                            int w = catLeafs.length > 0 ? cw / catLeafs.length : cw;
                            int xx = x;
                            for (k = 0; k < catLeafs.length; ++k) {
                                DataTreeGroupNode dtn = (DataTreeGroupNode)catLeafs[k];
                                Component comp9 = (Component)dtn.getUserObject();
                                if (k == catLeafs.length - 1) {
                                    w += cw - w * catLeafs.length;
                                }
                                int h = 0;
                                for (kk = 0; kk < dtn.getTupleElementSpan(); ++kk) {
                                    h += major.levelHeights[kk];
                                }
                                comp9.setBounds(xx, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom - bottomShift, w, h);
                                xx += w;
                            }
                        } else {
                            Component comp10 = (Component)leaf.getUserObject();
                            int h = 0;
                            for (k = 0; k < leaf.getTupleElementSpan(); ++k) {
                                h += major.levelHeights[k];
                            }
                            comp10.setBounds(x, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom - bottomShift, cw, h);
                        }
                        x += cw + this.gridHGap;
                    }
                } else {
                    DefaultMutableTreeNode[] catLeafs = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)tree);
                    int cw = this.cellSize.width;
                    int w = cw / catLeafs.length;
                    int xx = x;
                    for (int k7 = 0; k7 < catLeafs.length; ++k7) {
                        DataTreeGroupNode leaf = (DataTreeGroupNode)catLeafs[k7];
                        Component comp11 = (Component)leaf.getUserObject();
                        if (k7 == catLeafs.length - 1) {
                            w += cw - w * catLeafs.length;
                        }
                        int h = 0;
                        for (int kk3 = 0; kk3 < leaf.getTupleElementSpan(); ++kk3) {
                            h += major.levelHeights[kk3];
                        }
                        comp11.setBounds(xx, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom - bottomShift, w, h);
                        xx += w;
                    }
                }
                Enumeration eu = tree.breadthFirstEnumeration();
                while (eu.hasMoreElements()) {
                    DataTreeGroupNode n = (DataTreeGroupNode)eu.nextElement();
                    if (n.isLeaf() || n.isRoot()) continue;
                    int l = n.getDepth();
                    DefaultMutableTreeNode first = n.getFirstLeaf();
                    DefaultMutableTreeNode last = n.getLastLeaf();
                    Component firstComp = (Component)first.getUserObject();
                    Component lastComp = (Component)last.getUserObject();
                    int xx = firstComp.getX();
                    int off = 0;
                    for (int k8 = 0; k8 < l; ++k8) {
                        off += major.levelHeights[k8];
                    }
                    int hh = 0;
                    for (int k9 = 0; k9 < n.getTupleElementSpan(); ++k9) {
                        hh += major.levelHeights[k9 + l];
                    }
                    int yy = this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom + off;
                    ww = lastComp.getX() + lastComp.getWidth() - xx;
                    comp = (Component)n.getUserObject();
                    comp.setBounds(xx, yy, ww, hh);
                }
            }
        }
    }

    protected void layoutCellHeader() {
        int yo;
        int xo = this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + this.rcSbarMargin.left + this.axisMargin.left;
        int y = yo = this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top + this.rcSbarMargin.top + this.axisMargin.top;
        for (int i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
            int ch = (int)(this.rowWeight[i - this.startRow] * (double)this.visibleRows * (double)this.cellSize.height + 0.5);
            int x = xo;
            for (int j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
                int cw = (int)(this.columnWeight[j - this.startColumn] * (double)this.visibleColumns * (double)this.cellSize.width + 0.5);
                int chy = y;
                for (int k = 0; k < this.getCell(i, j).getNumHeaders(); ++k) {
                    if (this.getCell(i, j).getHeader(k).isVisible()) {
                        if (this.getCell(i, j).isCellItem()) {
                            CellItemInterface item = (CellItemInterface)((Object)this.getCell(i, j).getItem());
                            Insets om = item.getOuterMargin();
                            this.getCell(i, j).getHeader(k).setBounds(x + om.left, chy, cw - om.left - om.right, this.cellHeaderHeights[k]);
                        } else {
                            this.getCell(i, j).getHeader(k).setBounds(x, chy, cw, this.cellHeaderHeights[k]);
                        }
                    }
                    chy += this.cellHeaderHeights[k];
                }
                x += cw + this.gridHGap;
            }
            y += ch + this.gridVGap;
        }
    }

    protected void layoutGridAxis(TrellisPlot trellis) {
        if (this.gridAxisCount > 0) {
            int j;
            Component GL;
            Rectangle r;
            Insets pam;
            GridAxisInterface axis;
            int i;
            int maxWidthLeft = 0;
            int maxWidthRight = 0;
            for (i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
                axis = (GridAxisInterface)((Object)this.getRowAxis(i, true));
                if (axis != null) {
                    pam = axis.getPreferredOuterMargin();
                    maxWidthLeft = Math.max(maxWidthLeft, pam.left);
                }
                if ((axis = (GridAxisInterface)((Object)this.getRowAxis(i, false))) == null) continue;
                pam = axis.getPreferredOuterMargin();
                maxWidthRight = Math.max(maxWidthRight, pam.right);
            }
            for (i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
                int l;
                int h;
                int xShift;
                int bottom;
                int top;
                if (this.skipEmptyCells) {
                    int firstCol = this.getFirstNonEmptyColumn(this.startColumn, this.visibleColumns, i);
                    r = this.getCell(i, firstCol).getBounds();
                } else {
                    r = this.getCell(i, this.startColumn).getBounds();
                }
                axis = (GridAxisInterface)((Object)this.getRowAxis(i, true));
                GL = this.getRowGridLabel(i, true);
                if (axis != null) {
                    pam = axis.getPreferredOuterMargin();
                    top = Math.max(this.getRowOM((int)i).top, pam.top);
                    bottom = Math.max(this.getRowOM((int)i).bottom, pam.bottom);
                    xShift = 0;
                    if (this.externalAxesAlignment == 0) {
                        xShift = this.getColOM((int)this.startColumn).left;
                    }
                    ((Component)((Object)axis)).setBounds(r.x - maxWidthLeft + xShift, r.y + this.maxCellHeaderHeight + this.getRowOM((int)i).top - top, maxWidthLeft, r.height - this.maxCellHeaderHeight + top + bottom - this.getRowOM((int)i).top - this.getRowOM((int)i).bottom);
                    if (GL != null) {
                        GL.setBounds(r.x - Math.max(maxWidthLeft, this.gridLabelMargin.left) + xShift, r.y + this.maxCellHeaderHeight + this.getRowOM((int)i).top, Math.max(maxWidthLeft, this.gridLabelMargin.left), r.height - this.maxCellHeaderHeight - this.getRowOM((int)i).top - this.getRowOM((int)i).bottom);
                    }
                    axis.setOuterMargin(new Insets(top, 0, bottom, 0));
                    if (axis instanceof GridAxisInterface2) {
                        if (((GridAxisInterface2)axis).isMirror()) {
                            axis.setInnerMargin(new Insets(this.getRowIM2((int)i).top, 0, this.getRowIM2((int)i).bottom, 0));
                        } else {
                            axis.setInnerMargin(new Insets(this.getRowIM((int)i).top, 0, this.getRowIM((int)i).bottom, 0));
                        }
                    } else {
                        axis.setInnerMargin(new Insets(this.getRowIM((int)i).top, 0, this.getRowIM((int)i).bottom, 0));
                    }
                    if (this.rowAxisLabel != null && this.rowAxisLabelPosition == 1 && i == 0) {
                        h = 0;
                        for (l = 0; l < this.rowAxisLabel.length; ++l) {
                            if (this.autoRowAxisLabelAlignment && maxWidthLeft > this.rowAxisLabel[l].getPreferredSize().width) {
                                ((JComponent)this.rowAxisLabel[l]).setAlignmentX(1.0f);
                                this.rowAxisLabel[l].setBounds(r.x - maxWidthLeft + xShift, r.y - Math.max(top - (this.maxCellHeaderHeight + this.getRowOM((int)i).top), 0) - this.rowAxisLabel[l].getPreferredSize().height - h, maxWidthLeft, this.rowAxisLabel[l].getPreferredSize().height);
                            } else {
                                ((JComponent)this.rowAxisLabel[l]).setAlignmentX(0.0f);
                                this.rowAxisLabel[l].setBounds(r.x - maxWidthLeft + xShift, r.y - Math.max(top - (this.maxCellHeaderHeight + this.getRowOM((int)i).top), 0) - this.rowAxisLabel[l].getPreferredSize().height - h, this.rowAxisLabel[l].getPreferredSize().width, this.rowAxisLabel[l].getPreferredSize().height);
                            }
                            h += this.rowAxisLabel[l].getPreferredSize().height;
                        }
                    }
                    if (this.rowAxisLabel != null && this.rowAxisLabelPosition == 3 && i == this.startRow + this.visibleRows - 1) {
                        h = 0;
                        for (l = 0; l < this.rowAxisLabel.length; ++l) {
                            if (this.autoRowAxisLabelAlignment && maxWidthLeft > this.rowAxisLabel[l].getPreferredSize().width) {
                                ((JComponent)this.rowAxisLabel[l]).setAlignmentX(1.0f);
                                this.rowAxisLabel[l].setBounds(r.x - maxWidthLeft + xShift, r.y + r.height + h + Math.max(bottom - this.getRowOM((int)i).bottom, 0), maxWidthLeft, this.rowAxisLabel[l].getPreferredSize().height);
                            } else {
                                ((JComponent)this.rowAxisLabel[l]).setAlignmentX(0.0f);
                                this.rowAxisLabel[l].setBounds(r.x - maxWidthLeft + xShift, r.y + r.height + h + Math.max(bottom - this.getRowOM((int)i).bottom, 0), this.rowAxisLabel[l].getPreferredSize().width, this.rowAxisLabel[l].getPreferredSize().height);
                            }
                            h += this.rowAxisLabel[l].getPreferredSize().height;
                        }
                    }
                }
                if (this.skipEmptyCells) {
                    int lastCol = this.getLastNonEmptyColumn(this.startColumn, this.visibleColumns, i);
                    r = this.getCell(i, lastCol).getBounds();
                } else {
                    r = this.getCell(i, this.startColumn + this.visibleColumns - 1).getBounds();
                }
                axis = (GridAxisInterface)((Object)this.getRowAxis(i, false));
                GL = this.getRowGridLabel(i, false);
                if (axis == null) continue;
                pam = axis.getPreferredOuterMargin();
                top = Math.max(this.getRowOM((int)i).top, pam.top);
                bottom = Math.max(this.getRowOM((int)i).bottom, pam.bottom);
                xShift = 0;
                if (this.externalAxesAlignment == 0) {
                    xShift = this.getColOM((int)(this.startColumn + this.visibleColumns - 1)).right;
                }
                ((Component)((Object)axis)).setBounds(r.x + r.width - xShift, r.y + this.maxCellHeaderHeight + this.getRowOM((int)i).top - top, maxWidthRight, r.height - this.maxCellHeaderHeight + top + bottom - this.getRowOM((int)i).top - this.getRowOM((int)i).bottom);
                if (GL != null) {
                    GL.setBounds(r.x + r.width - xShift, r.y + this.maxCellHeaderHeight + this.getRowOM((int)i).top, Math.max(maxWidthRight, this.gridLabelMargin.right), r.height - this.maxCellHeaderHeight - this.getRowOM((int)i).top - this.getRowOM((int)i).bottom);
                }
                axis.setOuterMargin(new Insets(top, 0, bottom, 0));
                if (axis instanceof GridAxisInterface2) {
                    if (((GridAxisInterface2)axis).isMirror()) {
                        axis.setInnerMargin(new Insets(this.getRowIM((int)i).top, 0, this.getRowIM((int)i).bottom, 0));
                    } else {
                        axis.setInnerMargin(new Insets(this.getRowIM2((int)i).top, 0, this.getRowIM2((int)i).bottom, 0));
                    }
                } else {
                    axis.setInnerMargin(new Insets(this.getRowIM((int)i).top, 0, this.getRowIM((int)i).bottom, 0));
                }
                if (this.row2AxisLabel != null && this.row2AxisLabelPosition == 1 && i == 0) {
                    h = 0;
                    for (l = 0; l < this.row2AxisLabel.length; ++l) {
                        if (this.autoRowAxisLabelAlignment && maxWidthRight > this.row2AxisLabel[l].getPreferredSize().width) {
                            ((JComponent)this.row2AxisLabel[l]).setAlignmentX(0.0f);
                            this.row2AxisLabel[l].setBounds(r.x + r.width - xShift, r.y - Math.max(top - (this.maxCellHeaderHeight + this.getRowOM((int)i).top), 0) - this.row2AxisLabel[l].getPreferredSize().height - h, maxWidthRight, this.row2AxisLabel[l].getPreferredSize().height);
                        } else {
                            ((JComponent)this.row2AxisLabel[l]).setAlignmentX(1.0f);
                            this.row2AxisLabel[l].setBounds(r.x + r.width - xShift + maxWidthRight - this.row2AxisLabel[l].getPreferredSize().width, r.y - Math.max(top - (this.maxCellHeaderHeight + this.getRowOM((int)i).top), 0) - this.row2AxisLabel[l].getPreferredSize().height - h, this.row2AxisLabel[l].getPreferredSize().width, this.row2AxisLabel[l].getPreferredSize().height);
                        }
                        h += this.row2AxisLabel[l].getPreferredSize().height;
                    }
                }
                if (this.row2AxisLabel == null || this.row2AxisLabelPosition != 3 || i != this.startRow + this.visibleRows - 1) continue;
                h = 0;
                for (l = 0; l < this.row2AxisLabel.length; ++l) {
                    if (this.autoRowAxisLabelAlignment && maxWidthRight > this.row2AxisLabel[l].getPreferredSize().width) {
                        ((JComponent)this.row2AxisLabel[l]).setAlignmentX(0.0f);
                        this.row2AxisLabel[l].setBounds(r.x + r.width - xShift, r.y + r.height + h + Math.max(bottom - this.getRowOM((int)i).bottom, 0), maxWidthRight, this.row2AxisLabel[l].getPreferredSize().height);
                    } else {
                        ((JComponent)this.row2AxisLabel[l]).setAlignmentX(1.0f);
                        this.row2AxisLabel[l].setBounds(r.x + r.width - xShift + maxWidthRight - this.row2AxisLabel[l].getPreferredSize().width, r.y + r.height + h + Math.max(bottom - this.getRowOM((int)i).bottom, 0), this.row2AxisLabel[l].getPreferredSize().width, this.row2AxisLabel[l].getPreferredSize().height);
                    }
                    h += this.row2AxisLabel[l].getPreferredSize().height;
                }
            }
            int maxHeightTop = 0;
            int maxHeightBottom = 0;
            for (j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
                axis = (GridAxisInterface)((Object)this.getColumnAxis(j, false));
                if (axis != null) {
                    pam = axis.getPreferredOuterMargin();
                    maxHeightTop = Math.max(maxHeightTop, pam.top);
                }
                if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(j, true))) == null) continue;
                pam = axis.getPreferredOuterMargin();
                maxHeightBottom = Math.max(maxHeightBottom, pam.bottom);
            }
            for (j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
                int yShift;
                int right;
                int left;
                if (this.skipEmptyCells) {
                    int firstRow = this.getFirstNonEmptyRow(this.startRow, this.visibleRows, j);
                    r = this.getCell(firstRow, j).getBounds();
                } else {
                    r = this.getCell(this.startRow, j).getBounds();
                }
                axis = (GridAxisInterface)((Object)this.getColumnAxis(j, false));
                GL = this.getColumnGridLabel(j, false);
                if (axis != null) {
                    pam = axis.getPreferredOuterMargin();
                    left = Math.max(this.getColOM((int)j).left, pam.left);
                    right = Math.max(this.getColOM((int)j).right, pam.right);
                    yShift = 0;
                    if (this.externalAxesAlignment == 0 && this.maxCellHeaderHeight == 0) {
                        yShift = this.getRowOM((int)this.startRow).top;
                    }
                    ((Component)((Object)axis)).setBounds(r.x + this.getColOM((int)j).left - left, r.y - maxHeightTop + yShift, r.width + left + right - this.getColOM((int)j).left - this.getColOM((int)j).right, maxHeightTop);
                    if (GL != null) {
                        GL.setBounds(r.x + this.getColOM((int)j).left, r.y - Math.max(maxHeightTop, this.gridLabelMargin.top) + yShift, r.width - this.getColOM((int)j).left - this.getColOM((int)j).right, Math.max(maxHeightTop, this.gridLabelMargin.top));
                    }
                    axis.setOuterMargin(new Insets(0, left, 0, right));
                    if (axis instanceof GridAxisInterface2) {
                        if (((GridAxisInterface2)axis).isMirror()) {
                            axis.setInnerMargin(new Insets(0, this.getColIM((int)j).left, 0, this.getColIM((int)j).right));
                        } else {
                            axis.setInnerMargin(new Insets(0, this.getColIM2((int)j).left, 0, this.getColIM2((int)j).right));
                        }
                    } else {
                        axis.setInnerMargin(new Insets(0, this.getColIM((int)j).left, 0, this.getColIM((int)j).right));
                    }
                    if (this.column2AxisLabel != null && this.column2AxisLabelPosition == 2 && j == 0) {
                        this.column2AxisLabel.setBounds(r.x + this.getColOM((int)j).left - left - this.column2AxisLabel.getPreferredSize().width, r.y - maxHeightTop + yShift, this.column2AxisLabel.getPreferredSize().width, Math.max(maxHeightTop, this.column2AxisLabel.getPreferredSize().height));
                    }
                    if (this.column2AxisLabel != null && this.column2AxisLabelPosition == 4 && j == this.startColumn + this.visibleColumns - 1) {
                        this.column2AxisLabel.setBounds(r.x + r.width - this.getColOM((int)j).right + right, r.y - maxHeightTop + yShift, this.column2AxisLabel.getPreferredSize().width, Math.max(maxHeightTop, this.column2AxisLabel.getPreferredSize().height));
                    }
                }
                if (this.skipEmptyCells) {
                    int lastRow = this.getLastNonEmptyRow(this.startRow, this.visibleRows, j);
                    r = this.getCell(lastRow, j).getBounds();
                } else {
                    r = this.getCell(this.startRow + this.visibleRows - 1, j).getBounds();
                }
                axis = (GridAxisInterface)((Object)this.getColumnAxis(j, true));
                GL = this.getColumnGridLabel(j, true);
                if (axis == null) continue;
                pam = axis.getPreferredOuterMargin();
                left = Math.max(this.getColOM((int)j).left, pam.left);
                right = Math.max(this.getColOM((int)j).right, pam.right);
                yShift = 0;
                if (this.externalAxesAlignment == 0) {
                    yShift = this.getRowOM((int)(this.startRow + this.visibleRows - 1)).bottom;
                }
                ((Component)((Object)axis)).setBounds(r.x + this.getColOM((int)j).left - left, r.y + r.height - yShift, r.width + left + right - this.getColOM((int)j).left - this.getColOM((int)j).right, maxHeightBottom);
                if (GL != null) {
                    GL.setBounds(r.x + this.getColOM((int)j).left, r.y + r.height - yShift, r.width - this.getColOM((int)j).left - this.getColOM((int)j).right, Math.max(maxHeightBottom, this.gridLabelMargin.bottom));
                }
                axis.setOuterMargin(new Insets(0, left, 0, right));
                if (axis instanceof GridAxisInterface2) {
                    if (((GridAxisInterface2)axis).isMirror()) {
                        axis.setInnerMargin(new Insets(0, this.getColIM2((int)j).left, 0, this.getColIM2((int)j).right));
                    } else {
                        axis.setInnerMargin(new Insets(0, this.getColIM((int)j).left, 0, this.getColIM((int)j).right));
                    }
                } else {
                    axis.setInnerMargin(new Insets(0, this.getColIM((int)j).left, 0, this.getColIM((int)j).right));
                }
                if (this.columnAxisLabel != null && this.columnAxisLabelPosition == 2 && j == 0) {
                    this.columnAxisLabel.setBounds(r.x + this.getColOM((int)j).left - left - this.columnAxisLabel.getPreferredSize().width, r.y + r.height - yShift, this.columnAxisLabel.getPreferredSize().width, Math.max(maxHeightBottom, this.columnAxisLabel.getPreferredSize().height));
                }
                if (this.columnAxisLabel == null || this.columnAxisLabelPosition != 4 || j != this.startColumn + this.visibleColumns - 1) continue;
                this.columnAxisLabel.setBounds(r.x + r.width - this.getColOM((int)j).right + right, r.y + r.height - yShift, this.columnAxisLabel.getPreferredSize().width, Math.max(maxHeightBottom, this.columnAxisLabel.getPreferredSize().height));
            }
        } else {
            for (int i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
                for (int j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
                    int bottom;
                    int top;
                    int right;
                    int left;
                    Insets pam;
                    Rectangle r = this.getCell(i, j).getBounds();
                    GridAxisInterface axis = (GridAxisInterface)((Object)this.getCell(i, j).getAxis(1));
                    if (axis != null) {
                        pam = axis.getPreferredOuterMargin();
                        left = Math.max(this.getColOM((int)j).left, pam.left);
                        right = Math.max(this.getColOM((int)j).right, pam.right);
                        ((Component)((Object)axis)).setBounds(r.x + this.getColOM((int)j).left - left, r.y - pam.top, r.width + left + right - this.getColOM((int)j).left - this.getColOM((int)j).right, pam.top);
                        axis.setOuterMargin(new Insets(0, left, 0, right));
                        axis.setInnerMargin(new Insets(0, this.getColIM((int)j).left, 0, this.getColIM((int)j).right));
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getCell(i, j).getAxis(2))) != null) {
                        pam = axis.getPreferredOuterMargin();
                        top = Math.max(this.getRowOM((int)i).top, pam.top);
                        bottom = Math.max(this.getRowOM((int)i).bottom, pam.bottom);
                        ((Component)((Object)axis)).setBounds(r.x - pam.left, r.y + this.maxCellHeaderHeight + this.getRowOM((int)i).top - top, pam.left, r.height - this.maxCellHeaderHeight + top + bottom - this.getRowOM((int)i).top - this.getRowOM((int)i).bottom);
                        axis.setOuterMargin(new Insets(top, 0, bottom, 0));
                        axis.setInnerMargin(new Insets(this.getRowIM((int)i).top, 0, this.getRowIM((int)i).bottom, 0));
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getCell(i, j).getAxis(3))) != null) {
                        pam = axis.getPreferredOuterMargin();
                        left = Math.max(this.getColOM((int)j).left, pam.left);
                        right = Math.max(this.getColOM((int)j).right, pam.right);
                        ((Component)((Object)axis)).setBounds(r.x + this.getColOM((int)j).left - left, r.y + r.height, r.width + left + right - this.getColOM((int)j).left - this.getColOM((int)j).right, pam.bottom);
                        axis.setOuterMargin(new Insets(0, left, 0, right));
                        axis.setInnerMargin(new Insets(0, this.getColIM((int)j).left, 0, this.getColIM((int)j).right));
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getCell(i, j).getAxis(4))) == null) continue;
                    pam = axis.getPreferredOuterMargin();
                    top = Math.max(this.getRowOM((int)i).top, pam.top);
                    bottom = Math.max(this.getRowOM((int)i).bottom, pam.bottom);
                    ((Component)((Object)axis)).setBounds(r.x + r.width, r.y + this.maxCellHeaderHeight + this.getRowOM((int)i).top - top, pam.right, r.height - this.maxCellHeaderHeight + top + bottom - this.getRowOM((int)i).top - this.getRowOM((int)i).bottom);
                    axis.setOuterMargin(new Insets(top, 0, bottom, 0));
                    axis.setInnerMargin(new Insets(this.getRowIM((int)i).top, 0, this.getRowIM((int)i).bottom, 0));
                }
            }
        }
    }

    protected void layoutTitle() {
        int yo = this.initialTrellisInsets.top;
        for (int i = 0; i < this.titles.size(); ++i) {
            JComponent center;
            Component c = (Component)this.titles.get(i);
            if (!c.isVisible()) continue;
            Dimension d = c.getPreferredSize();
            if (this.visibleColumns == 1 && c instanceof ComplexEntryInterface && (center = ((ComplexEntryInterface)((Object)c)).getCenterComponent()) != null && !((ComplexEntryInterface)((Object)c)).isCenterOnGraph()) {
                boolean align = true;
                if (this.visibleRows > 1) {
                    for (int j = this.startRow; j < this.startRow + this.visibleRows; ++j) {
                        if (!this.getCell(j, 0).isCellItem() || ((CellItemInterface)((Object)this.getCell(j, 0).getItem())).getMarginsAligned()) continue;
                        align = false;
                        break;
                    }
                }
                if (align) {
                    Dimension ps = center.getPreferredSize();
                    Rectangle r = this.getCell(0, 0).getBounds();
                    int dw = r.width - this.getColOM((int)0).left - this.getColOM((int)0).right;
                    float cx = (float)(r.x + this.getColOM((int)0).left + dw / 2 - ps.width / 2) / (float)(this.trellisSize.width - ps.width);
                    if (cx < 0.0f || cx > 1.0f) {
                        cx = 0.5f;
                    }
                    center.setAlignmentX(cx);
                }
            }
            if (this.globalLegendPosition.equals("left") || this.globalLegendPosition.equals("right")) {
                c.setBounds(this.initialTrellisInsets.left, yo, this.trellisSize.width - this.initialTrellisInsets.left - this.initialTrellisInsets.right, d.height);
            } else {
                c.setBounds(this.trellisInsets.left, yo, this.trellisSize.width - this.trellisInsets.left - this.trellisInsets.right, d.height);
            }
            yo += c.getHeight() + interTitleFootnoteGap;
        }
    }

    protected void layoutFootnote() {
        int yo = this.trellisSize.height - this.initialTrellisInsets.bottom;
        for (int i = this.footnotes.size() - 1; i >= 0; --i) {
            JComponent center;
            Component c = (Component)this.footnotes.get(i);
            if (!c.isVisible()) continue;
            Dimension d = c.getPreferredSize();
            yo -= d.height;
            if (this.visibleColumns == 1 && c instanceof ComplexEntryInterface && (center = ((ComplexEntryInterface)((Object)c)).getCenterComponent()) != null && !((ComplexEntryInterface)((Object)c)).isCenterOnGraph()) {
                boolean align = true;
                if (this.visibleRows > 1) {
                    for (int j = this.startRow; j < this.startRow + this.visibleRows; ++j) {
                        if (!this.getCell(j, 0).isCellItem() || ((CellItemInterface)((Object)this.getCell(j, 0).getItem())).getMarginsAligned()) continue;
                        align = false;
                        break;
                    }
                }
                if (align) {
                    Dimension ps = center.getPreferredSize();
                    Rectangle r = this.getCell(0, 0).getBounds();
                    int dw = r.width - this.getColOM((int)0).left - this.getColOM((int)0).right;
                    float cx = (float)(r.x + this.getColOM((int)0).left + dw / 2 - ps.width / 2) / (float)(this.trellisSize.width - ps.width);
                    if (cx < 0.0f || cx > 1.0f) {
                        cx = 0.5f;
                    }
                    center.setAlignmentX(cx);
                }
            }
            if (this.globalLegendPosition.equals("left") || this.globalLegendPosition.equals("right")) {
                c.setBounds(this.initialTrellisInsets.left, yo, this.trellisSize.width - this.initialTrellisInsets.left - this.initialTrellisInsets.right, d.height);
            } else {
                c.setBounds(this.trellisInsets.left, yo, this.trellisSize.width - this.trellisInsets.left - this.trellisInsets.right, d.height);
            }
            yo -= interTitleFootnoteGap;
        }
    }

    protected void layoutGlobalLegend() {
        if (this.globalLegend == null || !this.globalLegend.isVisible()) {
            return;
        }
        if (this.globalLegendPosition.equals("bottom")) {
            int yo = this.trellisSize.height - this.initialTrellisInsets.bottom - this.footnoteHeight + this.globalLegendSpacing;
            int maxWidth = this.trellisSize.width - this.trellisInsets.left - this.trellisInsets.right;
            Dimension ps = this.globalLegend.getPreferredSize();
            int width = Math.min(maxWidth, ps.width);
            if (this.globalLegend.getAlignmentX() == 0.0f) {
                this.globalLegend.setBounds(this.trellisInsets.left, yo, width, ps.height);
            } else if (this.globalLegend.getAlignmentX() == 1.0f) {
                this.globalLegend.setBounds(this.trellisSize.width - this.trellisInsets.right - width, yo, width, ps.height);
            } else if (this.visibleColumns == 1) {
                Rectangle r = this.getCell(0, 0).getBounds();
                int dw = r.width - this.getColOM((int)0).left - this.getColOM((int)0).right;
                int x = r.x + this.getColOM((int)0).left + dw / 2 - width / 2;
                if (x + width > this.trellisSize.width - this.trellisInsets.right) {
                    x = this.trellisInsets.left + maxWidth / 2 - width / 2;
                }
                this.globalLegend.setBounds(x, yo, width, ps.height);
            } else {
                int[] shifts = this.getShifts();
                int topShift = shifts[0];
                int leftShift = shifts[1];
                int bottomShift = shifts[2];
                int rightShift = shifts[3];
                int sideBarMaxWidth = this.cellSize.width * this.visibleColumns + this.gridHGap * (this.visibleColumns - 1) - leftShift - rightShift;
                int x = this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + this.rcSbarMargin.left + this.axisMargin.left + leftShift;
                if ((x = x + sideBarMaxWidth / 2 - width / 2) + width > this.trellisSize.width - this.trellisInsets.right) {
                    x = this.trellisInsets.left + maxWidth / 2 - width / 2;
                }
                this.globalLegend.setBounds(x, yo, width, ps.height);
            }
        } else if (this.globalLegendPosition.equals("top")) {
            Dimension ps = this.globalLegend.getPreferredSize();
            int yo = this.initialTrellisInsets.top + this.titleHeight - ps.height - this.globalLegendSpacing;
            int maxWidth = this.trellisSize.width - this.trellisInsets.left - this.trellisInsets.right;
            int width = Math.min(maxWidth, ps.width);
            if (this.globalLegend.getAlignmentX() == 0.0f) {
                this.globalLegend.setBounds(this.trellisInsets.left, yo, width, ps.height);
            } else if (this.globalLegend.getAlignmentX() == 1.0f) {
                this.globalLegend.setBounds(this.trellisSize.width - this.trellisInsets.right - width, yo, width, ps.height);
            } else if (this.visibleColumns == 1) {
                Rectangle r = this.getCell(0, 0).getBounds();
                int dw = r.width - this.getColOM((int)0).left - this.getColOM((int)0).right;
                int x = r.x + this.getColOM((int)0).left + dw / 2 - width / 2;
                if (x + width > this.trellisSize.width - this.trellisInsets.right) {
                    x = this.trellisInsets.left + maxWidth / 2 - width / 2;
                }
                this.globalLegend.setBounds(x, yo, width, ps.height);
            } else {
                int[] shifts = this.getShifts();
                int topShift = shifts[0];
                int leftShift = shifts[1];
                int bottomShift = shifts[2];
                int rightShift = shifts[3];
                int sideBarMaxWidth = this.cellSize.width * this.visibleColumns + this.gridHGap * (this.visibleColumns - 1) - leftShift - rightShift;
                int x = this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + this.rcSbarMargin.left + this.axisMargin.left + leftShift;
                if ((x = x + sideBarMaxWidth / 2 - width / 2) + width > this.trellisSize.width - this.trellisInsets.right) {
                    x = this.trellisInsets.left + maxWidth / 2 - width / 2;
                }
                this.globalLegend.setBounds(x, yo, width, ps.height);
            }
        } else if (this.globalLegendPosition.equals("left")) {
            Dimension ps = this.globalLegend.getPreferredSize();
            int xo = this.initialTrellisInsets.left;
            int maxHeight = this.trellisSize.height - this.trellisInsets.top - this.trellisInsets.bottom;
            int height = Math.min(maxHeight, ps.height);
            if (this.globalLegend.getAlignmentY() == 0.0f) {
                this.globalLegend.setBounds(xo, this.trellisInsets.top + this.titleHeight, ps.width, height);
            } else if (this.globalLegend.getAlignmentY() == 1.0f) {
                this.globalLegend.setBounds(xo, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - height, ps.width, height);
            } else if (this.visibleRows == 1) {
                Rectangle r = this.getCell(0, 0).getBounds();
                int dh = r.height - this.getRowOM((int)0).top - this.getRowOM((int)0).bottom;
                int y = r.y + this.getRowOM((int)0).top + dh / 2 - height / 2;
                if (y + height > this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight) {
                    y = this.trellisInsets.top + maxHeight / 2 - height / 2;
                }
                this.globalLegend.setBounds(xo, y, ps.width, height);
            } else {
                int[] shifts = this.getShifts();
                int topShift = shifts[0];
                int leftShift = shifts[1];
                int bottomShift = shifts[2];
                int rightShift = shifts[3];
                int sideBarMaxHeight = this.cellSize.height * this.visibleRows + this.gridVGap * (this.visibleRows - 1) - topShift - bottomShift;
                int y = this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top + this.rcSbarMargin.top + this.axisMargin.top + topShift;
                if ((y = y + sideBarMaxHeight / 2 - height / 2) + height > this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight) {
                    y = this.trellisInsets.top + maxHeight / 2 - height / 2;
                }
                this.globalLegend.setBounds(xo, y, ps.width, height);
            }
        } else {
            Dimension ps = this.globalLegend.getPreferredSize();
            int xo = this.trellisSize.width - this.initialTrellisInsets.right - ps.width;
            int maxHeight = this.trellisSize.height - this.trellisInsets.top - this.trellisInsets.bottom;
            int height = Math.min(maxHeight, ps.height);
            if (this.globalLegend.getAlignmentY() == 0.0f) {
                this.globalLegend.setBounds(xo, this.trellisInsets.top + this.titleHeight, ps.width, height);
            } else if (this.globalLegend.getAlignmentY() == 1.0f) {
                this.globalLegend.setBounds(xo, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - height, ps.width, height);
            } else if (this.visibleRows == 1) {
                Rectangle r = this.getCell(0, 0).getBounds();
                int dh = r.height - this.getRowOM((int)0).top - this.getRowOM((int)0).bottom;
                int y = r.y + this.getRowOM((int)0).top + dh / 2 - height / 2;
                if (y + height > this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight) {
                    y = this.trellisInsets.top + maxHeight / 2 - height / 2;
                }
                this.globalLegend.setBounds(xo, y, ps.width, height);
            } else {
                int[] shifts = this.getShifts();
                int topShift = shifts[0];
                int leftShift = shifts[1];
                int bottomShift = shifts[2];
                int rightShift = shifts[3];
                int sideBarMaxHeight = this.cellSize.height * this.visibleRows + this.gridVGap * (this.visibleRows - 1) - topShift - bottomShift;
                int y = this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top + this.rcSbarMargin.top + this.axisMargin.top + topShift;
                if ((y = y + sideBarMaxHeight / 2 - height / 2) + height > this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight) {
                    y = this.trellisInsets.top + maxHeight / 2 - height / 2;
                }
                this.globalLegend.setBounds(xo, y, ps.width, height);
            }
        }
    }

    protected int getFirstNonEmptyRow(int startRow, int visibleRows, int col) {
        int row = startRow;
        for (int i = startRow; i < startRow + visibleRows; ++i) {
            if (this.getCell(i, col).getItem() == null) continue;
            row = i;
            break;
        }
        return row;
    }

    protected int getFirstNonEmptyRow() {
        for (int i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
            for (int j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
                if (this.getCell(i, j).getItem() == null) continue;
                return i;
            }
        }
        return this.startRow;
    }

    protected int getLastNonEmptyRow(int startRow, int visibleRows, int col) {
        int row = startRow + visibleRows - 1;
        for (int i = startRow + visibleRows - 1; i >= 0; --i) {
            if (this.getCell(i, col).getItem() == null) continue;
            row = i;
            break;
        }
        return row;
    }

    protected int getLastNonEmptyRow() {
        for (int i = this.startRow + this.visibleRows - 1; i >= this.startRow; --i) {
            for (int j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
                if (this.getCell(i, j).getItem() == null) continue;
                return i;
            }
        }
        return this.startRow + this.visibleRows - 1;
    }

    protected int getFirstNonEmptyColumn(int startCol, int visibleCols, int row) {
        int col = startCol;
        for (int j = startCol; j < startCol + visibleCols; ++j) {
            if (this.getCell(row, j).getItem() == null) continue;
            col = j;
            break;
        }
        return col;
    }

    protected int getFirstNonEmptyColumn() {
        for (int j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
            for (int i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
                if (this.getCell(i, j).getItem() == null) continue;
                return j;
            }
        }
        return this.startColumn;
    }

    protected int getLastNonEmptyColumn(int startCol, int visibleCols, int row) {
        int col = startCol + visibleCols - 1;
        for (int j = startCol + visibleCols - 1; j >= 0; --j) {
            if (this.getCell(row, j).getItem() == null) continue;
            col = j;
            break;
        }
        return col;
    }

    protected int getLastNonEmptyColumn() {
        for (int j = this.startColumn + this.visibleColumns - 1; j >= this.startColumn; --j) {
            for (int i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
                if (this.getCell(i, j).getItem() == null) continue;
                return j;
            }
        }
        return this.startColumn + this.visibleColumns - 1;
    }

    protected void calcVisibleGrid(TrellisPlot trellis) {
        Dimension d;
        if (!this.uniformGrid) {
            return;
        }
        if (trellis.getRowScrollBarPolicy() == 1 && trellis.getColumnScrollBarPolicy() == 1) {
            this.visibleRows = this.getGridRows();
            this.visibleColumns = this.getGridColumns();
            return;
        }
        int w = 0;
        int h = 0;
        for (int i = 0; i < this.getGridRows(); ++i) {
            for (int j = 0; j < this.getGridColumns(); ++j) {
                Component comp = this.getCell(i, j).getItem();
                if (comp == null) continue;
                d = comp.getMinimumSize();
                if (w < d.width) {
                    w = d.width;
                }
                if (h >= d.height) continue;
                h = d.height;
            }
        }
        d = new Dimension();
        d.width = this.trellisSize.width - this.trellisInsets.left - this.trellisInsets.right - this.rcaMargin.left - this.rcaMargin.right - this.oaMargin.left - this.oaMargin.right - this.rcSbarMargin.left - this.rcSbarMargin.right - this.axisMargin.left - this.axisMargin.right;
        d.height = this.trellisSize.height - this.trellisInsets.top - this.trellisInsets.bottom - this.titleHeight - this.footnoteHeight - this.rcaMargin.top - this.rcaMargin.bottom - this.oaMargin.top - this.oaMargin.bottom - this.rcSbarMargin.top - this.rcSbarMargin.bottom - this.axisMargin.top - this.axisMargin.bottom;
        if (trellis.getRowScrollBarPolicy() == 0) {
            this.visibleRows = d.height / (h + this.maxCellHeaderHeight);
            if (this.visibleRows < 1) {
                this.visibleRows = 1;
            }
            if (this.visibleRows > this.getGridRows()) {
                this.visibleRows = this.getGridRows();
            }
        } else {
            this.visibleRows = this.getGridRows();
        }
        if (trellis.getColumnScrollBarPolicy() == 0) {
            this.visibleColumns = d.width / w;
            if (this.visibleColumns < 1) {
                this.visibleColumns = 1;
            }
            if (this.visibleColumns > this.getGridColumns()) {
                this.visibleColumns = this.getGridColumns();
            }
        } else {
            this.visibleColumns = this.getGridColumns();
        }
        if (this.visibleRows == this.getGridRows()) {
            this.startRow = 0;
        }
        if (this.startRow + this.visibleRows >= this.getGridRows()) {
            this.startRow = this.getGridRows() - this.visibleRows;
        }
        if (this.visibleColumns == this.getGridColumns()) {
            this.startColumn = 0;
        }
        if (this.startColumn + this.visibleColumns >= this.getGridColumns()) {
            this.startColumn = this.getGridColumns() - this.visibleColumns;
        }
        this.resetWeights();
    }

    protected void initScrollBars(TrellisPlot trellis) {
        if (!this.uniformGrid) {
            return;
        }
        if (this.vsbar != null) {
            if (this.visibleRows < this.getGridRows()) {
                this.vsbar.setVisible(true);
                this.vsbar.setMinimum(0);
                this.vsbar.setMaximum(this.getGridRows());
                this.vsbar.setValue(this.startRow);
                this.vsbar.setVisibleAmount(this.visibleRows);
            } else {
                this.vsbar.setVisible(false);
            }
        }
        if (this.hsbar != null) {
            if (this.visibleColumns < this.getGridColumns()) {
                this.hsbar.setVisible(true);
                this.hsbar.setMinimum(0);
                this.hsbar.setMaximum(this.getGridColumns());
                this.hsbar.setValue(this.startColumn);
                this.hsbar.setVisibleAmount(this.visibleColumns);
            } else {
                this.hsbar.setVisible(false);
            }
        }
    }

    protected void hideInvisibleComponents(TrellisPlot trellis) {
        int i;
        if (!this.uniformGrid) {
            return;
        }
        if (trellis.getRowScrollBarPolicy() == 1 && trellis.getColumnScrollBarPolicy() == 1) {
            return;
        }
        for (i = 0; i < this.getGridRows(); ++i) {
            if (i < this.startRow || i >= this.startRow + this.visibleRows) {
                if (this.getRowAxis(i, true) != null) {
                    this.getRowAxis(i, true).setVisible(false);
                }
                if (this.getRowAxis(i, false) == null) continue;
                this.getRowAxis(i, false).setVisible(false);
                continue;
            }
            if (this.getRowAxis(i, true) != null) {
                this.getRowAxis(i, true).setVisible(true);
            }
            if (this.getRowAxis(i, false) == null) continue;
            this.getRowAxis(i, false).setVisible(true);
        }
        for (int j = 0; j < this.getGridColumns(); ++j) {
            if (j < this.startColumn || j >= this.startColumn + this.visibleColumns) {
                if (this.getColumnAxis(j, true) != null) {
                    this.getColumnAxis(j, true).setVisible(false);
                }
                if (this.getColumnAxis(j, false) == null) continue;
                this.getColumnAxis(j, false).setVisible(false);
                continue;
            }
            if (this.getColumnAxis(j, true) != null) {
                this.getColumnAxis(j, true).setVisible(true);
            }
            if (this.getColumnAxis(j, false) == null) continue;
            this.getColumnAxis(j, false).setVisible(true);
        }
        for (i = 0; i < this.getGridRows(); ++i) {
            if (this.getRowHeader(i) != null) {
                if (i < this.startRow || i >= this.startRow + this.visibleRows) {
                    this.getRowHeader(i).setVisible(false);
                } else {
                    this.getRowHeader(i).setVisible(true);
                }
            }
            for (int j = 0; j < this.getGridColumns(); ++j) {
                if (i == 0 && this.getColumnHeader(j) != null) {
                    if (j < this.startColumn || j >= this.startColumn + this.visibleColumns) {
                        this.getColumnHeader(j).setVisible(false);
                    } else {
                        this.getColumnHeader(j).setVisible(true);
                    }
                }
                if (i < this.startRow || i >= this.startRow + this.visibleRows || j < this.startColumn || j >= this.startColumn + this.visibleColumns) {
                    this.getCell(i, j).setVisible(false);
                    continue;
                }
                this.getCell(i, j).setVisible(true);
            }
        }
    }

    protected void synchronizeCellItems(TrellisPlot trellis) {
        block11: {
            int j;
            int i;
            CellItemSynchronizationInterface item;
            int numRotate;
            block10: {
                int j2;
                int i2;
                numRotate = 0;
                int numDrop = 0;
                for (i2 = this.startRow; i2 < this.startRow + this.visibleRows; ++i2) {
                    for (j2 = this.startColumn; j2 < this.startColumn + this.visibleColumns; ++j2) {
                        if (!this.getCell(i2, j2).isCellItem() || !(this.getCell(i2, j2).getItem() instanceof CellItemSynchronizationInterface) || !(item = (CellItemSynchronizationInterface)((Object)this.getCell(i2, j2).getItem())).isSynchronizationRequired()) continue;
                        if (item.hasRotatedLabel()) {
                            ++numRotate;
                        }
                        if (!item.hasDroppedLabel()) continue;
                        ++numDrop;
                    }
                }
                if (numDrop <= 0) break block10;
                for (i2 = this.startRow; i2 < this.startRow + this.visibleRows; ++i2) {
                    for (j2 = this.startColumn; j2 < this.startColumn + this.visibleColumns; ++j2) {
                        if (!this.getCell(i2, j2).isCellItem() || !(this.getCell(i2, j2).getItem() instanceof CellItemSynchronizationInterface)) continue;
                        item = (CellItemSynchronizationInterface)((Object)this.getCell(i2, j2).getItem());
                        item.dropAllLabels();
                    }
                }
                break block11;
            }
            if (numRotate <= 0) break block11;
            boolean drop = false;
            block4: for (i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
                for (j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
                    if (!this.getCell(i, j).isCellItem() || !(this.getCell(i, j).getItem() instanceof CellItemSynchronizationInterface) || !(item = (CellItemSynchronizationInterface)((Object)this.getCell(i, j).getItem())).isSynchronizationRequired()) continue;
                    item.rotateAllLabels();
                    if (!item.hasDroppedLabel()) continue;
                    drop = true;
                    continue block4;
                }
            }
            if (drop) {
                for (i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
                    for (j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
                        if (!this.getCell(i, j).isCellItem() || !(this.getCell(i, j).getItem() instanceof CellItemSynchronizationInterface)) continue;
                        item = (CellItemSynchronizationInterface)((Object)this.getCell(i, j).getItem());
                        item.dropAllLabels();
                    }
                }
            }
        }
    }

    protected void adjustCellLayout() {
        int endRow = this.startRow + this.visibleRows;
        int endColumn = this.startColumn + this.visibleColumns;
        for (int i = this.startRow; i < endRow; ++i) {
            for (int j = this.startColumn; j < endColumn; ++j) {
                CellItemInterface item;
                if (!(this.getCell(i, j).getItem() instanceof GridLabelInterface) || !((GridLabelInterface)((Object)(item = (CellItemInterface)((Object)this.getCell(i, j).getItem())))).hasGridLabel()) continue;
                if (this.getColumnGridLabel(j, true) != null) {
                    ((GridLabelInterface)((Object)item)).addGridLabelEntry(this.getColumnGridLabel(j, true));
                }
                if (this.getColumnGridLabel(j, false) != null) {
                    ((GridLabelInterface)((Object)item)).addGridLabelEntry(this.getColumnGridLabel(j, false));
                }
                if (this.getRowGridLabel(i, true) != null) {
                    ((GridLabelInterface)((Object)item)).addGridLabelEntry(this.getRowGridLabel(i, true));
                }
                if (this.getRowGridLabel(i, false) == null) continue;
                ((GridLabelInterface)((Object)item)).addGridLabelEntry(this.getRowGridLabel(i, false));
            }
        }
    }

    protected void adjustItemIOMargin() {
    }

    private void verifyWeights() {
        int i;
        double totalWeight;
        if (this.userRowWeight != null) {
            this.rowWeight = this.userRowWeight;
            totalWeight = 0.0;
            for (i = 0; i < this.getGridRows(); ++i) {
                if (this.rowWeight[i] != 1.0 / (double)this.getGridRows()) {
                    this.uniformGrid = false;
                }
                totalWeight += this.rowWeight[i];
            }
            if (Math.abs(totalWeight - 1.0) > 1.0E-6) {
                throw new IllegalArgumentException("invalid total row weights " + totalWeight);
            }
        } else {
            this.rowWeight = new double[this.getGridRows()];
            for (int i2 = 0; i2 < this.getGridRows(); ++i2) {
                this.rowWeight[i2] = 1.0 / (double)this.getGridRows();
            }
            if (this.rowWeights != null) {
                this.uniformGrid = false;
            }
        }
        if (this.userColumnWeight != null) {
            this.columnWeight = this.userColumnWeight;
            totalWeight = 0.0;
            for (i = 0; i < this.getGridColumns(); ++i) {
                if (this.columnWeight[i] != 1.0 / (double)this.getGridColumns()) {
                    this.uniformGrid = false;
                }
                totalWeight += this.columnWeight[i];
            }
            if (Math.abs(totalWeight - 1.0) > 1.0E-6) {
                throw new IllegalArgumentException("invalid total column weights " + totalWeight);
            }
        } else {
            this.columnWeight = new double[this.getGridColumns()];
            for (int i3 = 0; i3 < this.getGridColumns(); ++i3) {
                this.columnWeight[i3] = 1.0 / (double)this.getGridColumns();
            }
            if (this.columnWeights != null) {
                this.uniformGrid = false;
            }
        }
    }

    private void resetWeights() {
        int i;
        if (this.rowWeight.length > this.visibleRows) {
            this.rowWeight = new double[this.visibleRows];
            for (i = 0; i < this.visibleRows; ++i) {
                this.rowWeight[i] = 1.0 / (double)this.visibleRows;
            }
        }
        if (this.columnWeight.length > this.visibleColumns) {
            this.columnWeight = new double[this.visibleColumns];
            for (i = 0; i < this.visibleColumns; ++i) {
                this.columnWeight[i] = 1.0 / (double)this.visibleColumns;
            }
        }
    }

    protected void addColumnScrollBar(int col, Component comp, int position, boolean ignoreCellMargin) {
        this.getColumnMeta(col).addScrollBar(position, comp, ignoreCellMargin);
    }

    protected void addRowScrollBar(int row, Component comp, int position, boolean ignoreCellMargin) {
        this.getRowMeta(row).addScrollBar(position, comp, ignoreCellMargin);
    }

    protected Component getColumnScrollBar(int col) {
        return this.getColumnMeta(col).getScrollBar();
    }

    protected Component getRowScrollBar(int row) {
        return this.getRowMeta(row).getScrollBar();
    }

    protected void removeColumnScrollBar(int col) {
        this.getColumnMeta(col).removeScrollBar();
    }

    protected void removeRowScrollBar(int row) {
        this.getRowMeta(row).removeScrollBar();
    }

    protected void addCornerButton(Component button, int position) {
        switch (position) {
            default: {
                return;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
        }
        this.buttonPosition = position;
        this.cornerButton = button;
    }

    protected Component getCornerButton() {
        return this.cornerButton;
    }

    protected void removeCornerButton() {
        this.cornerButton = null;
    }

    protected Insets calcRowColScrollBarMargin(boolean isMinSize) {
        Insets i = new Insets(0, 0, 0, 0);
        int wt = 0;
        for (int r = 0; r < this.getGridRows(); ++r) {
            if (this.getRowScrollBar(r) == null || !this.getRowScrollBar(r).isVisible()) continue;
            wt = isMinSize ? this.getRowScrollBar((int)r).getMinimumSize().width : this.getRowScrollBar((int)r).getPreferredSize().width;
            if (this.getRowMeta(r).getScrollBarPosition() == 2 && wt > i.left) {
                i.left = wt;
                continue;
            }
            if (this.getRowMeta(r).getScrollBarPosition() != 4 || wt <= i.right) continue;
            i.right = wt;
        }
        int ht = 0;
        for (int c = 0; c < this.getGridColumns(); ++c) {
            if (this.getColumnScrollBar(c) == null || !this.getColumnScrollBar(c).isVisible()) continue;
            ht = isMinSize ? this.getColumnScrollBar((int)c).getMinimumSize().height : this.getColumnScrollBar((int)c).getPreferredSize().height;
            if (this.getColumnMeta(c).getScrollBarPosition() == 1 && ht > i.top) {
                i.top = ht;
                continue;
            }
            if (this.getColumnMeta(c).getScrollBarPosition() != 3 || ht <= i.bottom) continue;
            i.bottom = ht;
        }
        if (this.cornerButton != null && this.cornerButton.isVisible()) {
            int w = Math.max(i.left, i.right);
            int h = Math.max(i.top, i.bottom);
            int size = Math.max(w, h);
            switch (this.buttonPosition) {
                case 0: {
                    i.top = Math.max(i.top, size);
                    i.left = Math.max(i.left, size);
                    break;
                }
                case 1: {
                    i.top = Math.max(i.top, size);
                    i.right = Math.max(i.right, size);
                    break;
                }
                case 3: {
                    i.bottom = Math.max(i.bottom, size);
                    i.left = Math.max(i.left, size);
                    break;
                }
                case 4: {
                    i.bottom = Math.max(i.bottom, size);
                    i.right = Math.max(i.right, size);
                    break;
                }
            }
        }
        return i;
    }

    protected void layoutRowColScrollBar() {
        Rectangle bounds;
        int xo = this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + this.rcSbarMargin.left + this.axisMargin.left;
        int yo = this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top + this.rcSbarMargin.top + this.axisMargin.top;
        int buttonX1 = -1;
        int buttonY1 = -1;
        int buttonX2 = -1;
        int buttonY2 = -1;
        boolean vbarL = false;
        boolean vbarR = false;
        int x = xo;
        int y = yo;
        for (int i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
            int ch = (int)(this.rowWeight[i - this.startRow] * (double)this.visibleRows * (double)this.cellSize.height + 0.5);
            if (this.getRowScrollBar(i) != null && this.getRowScrollBar(i).isVisible()) {
                if (this.getRowMeta(i).getScrollBarPosition() == 2) {
                    vbarL = true;
                    if (this.getRowMeta(i).isCellMarginIgnored() && this.axisMargin.left == 0) {
                        bounds = this.getCell(i, this.startColumn).getBounds();
                        int left = bounds.x + this.getColOM((int)this.startColumn).left - this.getRowScrollBar((int)i).getPreferredSize().width;
                        this.getRowScrollBar(i).setBounds(left, y + this.getRowOM((int)i).top, this.getRowScrollBar((int)i).getPreferredSize().width, this.cellSize.height - this.getRowOM((int)i).top - this.getRowOM((int)i).bottom);
                        buttonX1 = Math.max(buttonX1, left);
                    } else {
                        this.getRowScrollBar(i).setBounds(this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left, y + this.getRowOM((int)i).top, this.getRowScrollBar((int)i).getPreferredSize().width, this.cellSize.height - this.getRowOM((int)i).top - this.getRowOM((int)i).bottom);
                    }
                } else {
                    vbarR = true;
                    if (this.getRowMeta(i).isCellMarginIgnored() && this.axisMargin.right == 0) {
                        bounds = this.getCell(i, this.startColumn + this.visibleColumns - 1).getBounds();
                        int right = bounds.x + bounds.width - this.getColOM((int)(this.startColumn + this.visibleColumns - 1)).right;
                        this.getRowScrollBar(i).setBounds(right, y + this.getRowOM((int)i).top, this.getRowScrollBar((int)i).getPreferredSize().width, this.cellSize.height - this.getRowOM((int)i).top - this.getRowOM((int)i).bottom);
                        buttonX2 = Math.max(buttonX2, right);
                    } else {
                        this.getRowScrollBar(i).setBounds(this.trellisSize.width - this.trellisInsets.right - this.sbMargin.right - this.rcaMargin.right - this.oaMargin.right - this.rcSbarMargin.right, y + this.getRowOM((int)i).top, this.getRowScrollBar((int)i).getPreferredSize().width, this.cellSize.height - this.getRowOM((int)i).top - this.getRowOM((int)i).bottom);
                    }
                }
            }
            y += ch + this.gridVGap;
        }
        for (int j = this.startColumn; j < this.startColumn + this.visibleColumns; ++j) {
            int cw = (int)(this.columnWeight[j - this.startColumn] * (double)this.visibleColumns * (double)this.cellSize.width + 0.5);
            if (this.getColumnScrollBar(j) != null && this.getColumnScrollBar(j).isVisible()) {
                if (this.getColumnMeta(j).getScrollBarPosition() == 1) {
                    if (this.getColumnMeta(j).isCellMarginIgnored() && this.axisMargin.top == 0) {
                        bounds = this.getCell(this.startRow, j).getBounds();
                        int top = bounds.y + this.getRowOM((int)this.startRow).top - this.getColumnScrollBar((int)j).getPreferredSize().height;
                        this.getColumnScrollBar(j).setBounds(x + this.getColOM((int)j).left, top, cw - this.getColOM((int)j).left - this.getColOM((int)j).right, this.getColumnScrollBar((int)j).getPreferredSize().height);
                        buttonY1 = Math.max(buttonY1, top);
                    } else {
                        this.getColumnScrollBar(j).setBounds(x + this.getColOM((int)j).left, this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top, cw - this.getColOM((int)j).left - this.getColOM((int)j).right, this.getColumnScrollBar((int)j).getPreferredSize().height);
                    }
                } else if (this.getColumnMeta(j).isCellMarginIgnored() && this.axisMargin.bottom == 0) {
                    bounds = this.getCell(this.startRow + this.visibleRows - 1, j).getBounds();
                    int bottom = bounds.y + bounds.height - this.getRowOM((int)this.startRow).bottom;
                    this.getColumnScrollBar(j).setBounds(x + this.getColOM((int)j).left, bottom, cw - this.getColOM((int)j).left - this.getColOM((int)j).right, this.getColumnScrollBar((int)j).getPreferredSize().height);
                    buttonY2 = Math.max(buttonY2, bottom);
                } else {
                    this.getColumnScrollBar(j).setBounds(x + this.getColOM((int)j).left, this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom - this.oaMargin.bottom - this.rcSbarMargin.bottom, cw - this.getColOM((int)j).left - this.getColOM((int)j).right, this.getColumnScrollBar((int)j).getPreferredSize().height);
                }
            }
            x += cw + this.gridHGap;
        }
        if (this.cornerButton != null && this.cornerButton.isVisible()) {
            switch (this.buttonPosition) {
                case 0: {
                    x = vbarL ? (buttonX1 == -1 ? this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left : buttonX1) : this.getColumnScrollBar((int)this.startColumn).getBounds().x - this.rcSbarMargin.left;
                    y = buttonY1 == -1 ? this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top : buttonY1;
                    this.cornerButton.setBounds(x, y, this.rcSbarMargin.left, this.rcSbarMargin.top);
                    break;
                }
                case 1: {
                    x = vbarR ? (buttonX2 == -1 ? this.trellisSize.width - this.trellisInsets.right - this.sbMargin.right - this.rcaMargin.right - this.oaMargin.right - this.rcSbarMargin.right : buttonX2) : this.getColumnScrollBar((int)(this.startColumn + this.visibleColumns - 1)).getBounds().x + this.getColumnScrollBar((int)(this.startColumn + this.visibleColumns - 1)).getBounds().width;
                    y = buttonY1 == -1 ? this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top : buttonY1;
                    this.cornerButton.setBounds(x, y, this.rcSbarMargin.right, this.rcSbarMargin.top);
                    break;
                }
                case 3: {
                    x = vbarL ? (buttonX1 == -1 ? this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left : buttonX1) : this.getColumnScrollBar((int)this.startColumn).getBounds().x - this.rcSbarMargin.left;
                    y = buttonY2 == -1 ? this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom - this.oaMargin.bottom - this.rcSbarMargin.bottom : buttonY2;
                    this.cornerButton.setBounds(x, y, this.rcSbarMargin.left, this.rcSbarMargin.bottom);
                    break;
                }
                case 4: {
                    x = vbarR ? (buttonX2 == -1 ? this.trellisSize.width - this.trellisInsets.right - this.sbMargin.right - this.rcaMargin.right - this.oaMargin.right - this.rcSbarMargin.right : buttonX2) : this.getColumnScrollBar((int)(this.startColumn + this.visibleColumns - 1)).getBounds().x + this.getColumnScrollBar((int)(this.startColumn + this.visibleColumns - 1)).getBounds().width;
                    y = buttonY2 == -1 ? this.trellisSize.height - this.trellisInsets.bottom - this.footnoteHeight - this.sbMargin.bottom - this.rcaMargin.bottom - this.oaMargin.bottom - this.rcSbarMargin.bottom : buttonY2;
                    this.cornerButton.setBounds(x, y, this.rcSbarMargin.right, this.rcSbarMargin.bottom);
                    break;
                }
            }
        }
    }

    public Dimension getMinCellSize() {
        return this.minCellSize;
    }

    public void setMinCellSize(Dimension minCellSize) {
        this.minCellSize = minCellSize;
    }

    private int[] getShifts() {
        int cw;
        int ch;
        int i;
        int[] shifts = new int[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            shifts[i2] = 0;
        }
        if (!this.skipEmptyCells) {
            return shifts;
        }
        int firstRow = this.getFirstNonEmptyRow();
        int firstCol = this.getFirstNonEmptyColumn();
        int lastRow = this.getLastNonEmptyRow();
        int lastCol = this.getLastNonEmptyColumn();
        for (i = this.startRow; i < firstRow; ++i) {
            ch = (int)(this.rowWeight[i - this.startRow] * (double)this.visibleRows * (double)this.cellSize.height + 0.5);
            shifts[0] = shifts[0] + ch;
        }
        for (i = this.startColumn; i < firstCol; ++i) {
            cw = (int)(this.columnWeight[i - this.startColumn] * (double)this.visibleColumns * (double)this.cellSize.width + 0.5);
            shifts[1] = shifts[1] + cw;
        }
        for (i = lastRow + 1; i < this.startRow + this.visibleRows; ++i) {
            ch = (int)(this.rowWeight[i - this.startRow] * (double)this.visibleRows * (double)this.cellSize.height + 0.5) + this.gridVGap;
            shifts[2] = shifts[2] + ch;
        }
        for (i = lastCol + 1; i < this.startColumn + this.visibleColumns; ++i) {
            cw = (int)(this.columnWeight[i - this.startColumn] * (double)this.visibleColumns * (double)this.cellSize.width + 0.5) + this.gridHGap;
            shifts[3] = shifts[3] + cw;
        }
        return shifts;
    }

    private void hideComponents(Container parent) {
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component comp = parent.getComponent(i);
            if (!comp.isVisible()) continue;
            this.hiddenComponents.add(comp);
            comp.setVisible(false);
        }
    }

    private void allocateGridAxisSize(Container parent) {
        Dimension maxsize;
        int r;
        TrellisPlot trellis = (TrellisPlot)parent;
        int width = trellis.getBounds().width;
        int height = trellis.getBounds().height;
        int nRows = this.getGridRows();
        int nCols = this.getGridColumns();
        int nRowAxes = 0;
        if (this.getRowAxis(0, true) != null) {
            ++nRowAxes;
        }
        if (this.getRowAxis(0, false) != null) {
            ++nRowAxes;
        }
        int nColAxes = 0;
        if (this.getColumnAxis(0, true) != null) {
            ++nColAxes;
        }
        if (this.getColumnAxis(0, false) != null) {
            ++nColAxes;
        }
        double defaultPercent = 0.5 / (double)(this.visibleColumns + 1);
        double percent1 = 0.0;
        double percent2 = 0.0;
        percent1 = !Double.isNaN(this.rowAxisWidthPercentage) ? this.rowAxisWidthPercentage : defaultPercent;
        if (percent1 + (percent2 = !Double.isNaN(this.row2AxisWidthPercentage) ? this.row2AxisWidthPercentage : defaultPercent) > 1.0) {
            percent1 = defaultPercent;
            percent2 = defaultPercent;
        }
        double row1AxisWidth = (double)width * percent1;
        double row2AxisWidth = (double)width * percent2;
        int endRow = this.startRow + this.visibleRows;
        int endColumn = this.startColumn + this.visibleColumns;
        for (r = this.startRow; r < endRow; ++r) {
            Component axis = this.getRowAxis(r, true);
            if (axis != null) {
                maxsize = new Dimension((int)row1AxisWidth, height);
                axis.setMaximumSize(maxsize);
            }
            if ((axis = this.getRowAxis(r, false)) == null) continue;
            maxsize = new Dimension((int)row2AxisWidth, height);
            axis.setMaximumSize(maxsize);
        }
        for (r = this.startRow; r < endRow; ++r) {
            for (int c = this.startColumn; c < endColumn; ++c) {
                CellItemInterface item;
                if (!this.getCell(r, c).isCellItem() || !((item = (CellItemInterface)((Object)this.getCell(r, c).getItem())) instanceof GridLabelInterface)) continue;
                ((GridLabelInterface)((Object)item)).setLeftGridLabelMaxWidth(row1AxisWidth);
                ((GridLabelInterface)((Object)item)).setRightGridLabelMaxWidth(row2AxisWidth);
            }
        }
        if (!Double.isNaN(this.columnAxisHeightPercentage) && nColAxes > 0) {
            double columnAxisHeight = (double)height / (double)(nRows + 1);
            columnAxisHeight = Math.max(columnAxisHeight, (double)height * this.columnAxisHeightPercentage);
            maxsize = new Dimension(width, (int)(columnAxisHeight /= (double)nColAxes));
            for (int c = 0; c < nCols; ++c) {
                Component axis = this.getColumnAxis(c, true);
                if (axis != null) {
                    axis.setMaximumSize(maxsize);
                }
                if ((axis = this.getColumnAxis(c, false)) == null) continue;
                axis.setMaximumSize(maxsize);
            }
        }
    }

    private void showHiddenComponents() {
        int n = this.hiddenComponents.size();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Component comp = (Component)this.hiddenComponents.get(i);
            comp.setVisible(true);
        }
        this.hiddenComponents.clear();
    }

    public boolean hasHiddenComponents() {
        return this.hiddenComponents.size() > 0;
    }

    protected void createRowCompoundHeader() {
        this.rowCompoundHeader = new CompoundHeader();
    }

    protected void createColumnCompoundHeader() {
        this.columnCompoundHeader = new CompoundHeader();
    }

    protected boolean isCompoundHeaders() {
        return this.columnCompoundHeader != null || this.rowCompoundHeader != null;
    }

    protected void createRowOLAPHeader() {
        this.rowOLAPHeader = new OLAPHeader();
    }

    protected void createColumnOLAPHeader() {
        this.columnOLAPHeader = new OLAPHeader();
    }

    protected boolean isOLAPHeaders() {
        return this.columnOLAPHeader != null || this.rowOLAPHeader != null;
    }

    protected int getRowHeaderLabelPosition() {
        return this.rowHeaderLabelPosition;
    }

    protected void setRowHeaderLabelPosition(int position) {
        this.rowHeaderLabelPosition = position;
    }

    protected int getColumnHeaderLabelPosition() {
        return this.colHeaderLabelPosition;
    }

    protected void setColumnHeaderLabelPosition(int position) {
        this.colHeaderLabelPosition = position;
    }

    private Component getColumnCompoundHeader(int level, int i) {
        return this.columnCompoundHeader.getHeader(level).getHeader(i);
    }

    private Component getColumn2CompoundHeader(int level, int i) {
        return this.columnCompoundHeader.getHeader(level).getHeader2(i);
    }

    private Component getRowCompoundHeader(int level, int i) {
        return this.rowCompoundHeader.getHeader(level).getHeader(i);
    }

    private Component getRow2CompoundHeader(int level, int i) {
        return this.rowCompoundHeader.getHeader(level).getHeader2(i);
    }

    protected void setRowAxisLabelPosition(int position) {
        this.rowAxisLabelPosition = position;
    }

    protected int getRowAxisLabelPosition() {
        return this.rowAxisLabelPosition;
    }

    protected void setRow2AxisLabelPosition(int position) {
        this.row2AxisLabelPosition = position;
    }

    protected int getRow2AxisLabelPosition() {
        return this.row2AxisLabelPosition;
    }

    protected void setColumnAxisLabelPosition(int position) {
        this.columnAxisLabelPosition = position;
    }

    protected int getColumnAxisLabelPosition() {
        return this.columnAxisLabelPosition;
    }

    protected void setColumn2AxisLabelPosition(int position) {
        this.column2AxisLabelPosition = position;
    }

    protected int getColumn2AxisLabelPosition() {
        return this.column2AxisLabelPosition;
    }

    public void setGridAttrs(LineAttrs la) {
        this.gridAttrs = la;
    }

    protected void preDraw(Graphics g) {
        int i;
        int levels;
        int h;
        Component comp;
        int start;
        int i2;
        int levels2;
        int h2;
        int w;
        int y;
        int x;
        if (this.rowOLAPHeader != null) {
            x = this.trellisInsets.left;
            y = this.getGridTop();
            OLAPHeader.TreeHeader major = this.rowOLAPHeader.getMajor();
            if (major.titleComponent != null) {
                x += major.titleComponent.getPreferredSize().width;
            }
            x += this.axisLabelPadding.left;
            w = 0;
            h2 = 0;
            levels2 = major.getLevels();
            for (i2 = start = levels2 - this.rowOLAPHeader.getMajor().headerLevels; i2 < levels2; ++i2) {
                comp = major.getLabel(i2);
                w = Math.max(w, comp.getX() + comp.getWidth() - x);
                h2 += comp.getHeight();
                y -= comp.getHeight();
            }
            for (i2 = 0; i2 < start; ++i2) {
                comp = major.getLabel(i2);
                w = Math.max(w, comp.getX() + comp.getWidth() - x);
                y -= comp.getHeight();
            }
            if (this.rowAxisLabel != null) {
                for (int l = 0; l < this.rowAxisLabel.length; ++l) {
                    if (this.rowAxisLabel[l].getX() + this.rowAxisLabel[l].getWidth() > x + w) {
                        w = this.rowAxisLabel[l].getX() + this.rowAxisLabel[l].getWidth() - x;
                    }
                    y -= this.rowAxisLabel[l].getHeight();
                }
            }
            g.setColor(this.rowOLAPHeader.getBackground());
            g.fillRect(x, y, w, h2);
            if (start < levels2) {
                y = major.getLabel(start).getY();
            }
            h2 = this.getGridTop() - y;
            w = 0;
            for (i2 = start; i2 < levels2; ++i2) {
                w += major.levelWidths[i2];
            }
            g.fillRect(x, y, w, h2);
        } else if (this.rowCompoundHeader != null) {
            x = this.trellisInsets.left + this.axisLabelPadding.left;
            y = this.getGridTop();
            int w2 = 0;
            h = 0;
            levels = this.rowCompoundHeader.getLevels();
            for (i = 0; i < levels; ++i) {
                Component comp2 = this.rowCompoundHeader.getHeader(i).getLabel();
                if (comp2 == null) continue;
                w2 = Math.max(w2, comp2.getWidth());
                h += comp2.getHeight();
            }
            if (this.rowAxisLabel != null) {
                int dh = 0;
                for (int l = 0; l < this.rowAxisLabel.length; ++l) {
                    if (this.rowAxisLabel[l].getX() + this.rowAxisLabel[l].getWidth() > x + w2) {
                        w2 = this.rowAxisLabel[l].getX() + this.rowAxisLabel[l].getWidth() - x;
                    }
                    dh += this.rowAxisLabel[l].getHeight();
                }
                y -= dh;
            }
            g.setColor(this.rowCompoundHeader.getBackground());
            g.fillRect(x, y - h, w2, h);
            h = this.getGridTop() - y;
            w2 = 0;
            for (i = 0; i < levels; ++i) {
                w2 += this.rowCompoundHeader.getHeader(i).getHeader(0).getWidth();
            }
            g.fillRect(x, y, w2, h);
        }
        if (this.columnOLAPHeader != null) {
            OLAPHeader.TreeHeader major = this.columnOLAPHeader.getMajor();
            int x2 = Integer.MAX_VALUE;
            int y2 = 0;
            w = 0;
            h2 = 0;
            levels2 = major.getLevels();
            for (i2 = start = levels2 - this.columnOLAPHeader.getMajor().headerLevels; i2 < levels2; ++i2) {
                comp = major.getLabel(i2);
                x2 = Math.min(x2, comp.getX());
                if (i2 == start) {
                    y2 = comp.getY();
                }
                h2 += comp.getHeight();
                w = Math.max(w, comp.getWidth());
            }
            for (i2 = 0; i2 < start; ++i2) {
                comp = major.getLabel(i2);
                x2 = Math.min(x2, comp.getX());
                w = Math.max(w, comp.getWidth());
            }
            if (this.columnAxisLabel != null && this.columnAxisLabel.getX() < x2) {
                w += x2 - this.columnAxisLabel.getX();
                x2 = this.columnAxisLabel.getX();
            }
            g.setColor(this.columnOLAPHeader.getBackground());
            g.fillRect(x2, y2, w, h2);
        } else if (this.columnCompoundHeader != null) {
            x = Integer.MAX_VALUE;
            y = 0;
            int w3 = 0;
            h = 0;
            levels = this.columnCompoundHeader.getLevels();
            for (i = 0; i < levels; ++i) {
                Component comp3 = this.columnCompoundHeader.getHeader(i).getLabel2();
                if (comp3 == null) continue;
                x = Math.min(x, comp3.getX());
                if (i == 0) {
                    y = comp3.getY();
                }
                h += comp3.getHeight();
                w3 = Math.max(w3, comp3.getWidth());
            }
            if (this.columnAxisLabel != null && this.columnAxisLabel.getX() < x) {
                w3 += x - this.columnAxisLabel.getX();
                x = this.columnAxisLabel.getX();
            }
            g.setColor(this.columnCompoundHeader.getBackground());
            g.fillRect(x, y, w3, h);
        }
    }

    protected void postDraw(Graphics g) {
        int h;
        Component comp;
        Component comp2;
        DataTreeGroupNode n;
        Enumeration eu;
        int w;
        int y;
        int x;
        if (this.rowOLAPHeader != null) {
            x = this.getGridLeft();
            y = this.getGridTop();
            w = this.visibleColumns * this.cellSize.width;
            g.setColor(this.gridAttrs.getColor());
            g.drawLine(x, y - 1, x + w, y - 1);
            for (int r = this.startRow + 1; r < this.startRow + this.visibleRows; ++r) {
                int h2 = (int)(this.rowWeight[r - this.startRow - 1] * (double)this.visibleRows * (double)this.cellSize.height + 0.5);
                g.drawLine(x, (y += h2) - 1, x + w, y - 1);
            }
            y = this.getGridBottom();
            g.drawLine(x, y, x + w, y);
            OLAPHeader.TreeHeader major = this.rowOLAPHeader.getMajor();
            if (major.getTree() != null) {
                x = this.getGridLeft();
                y = this.getGridTop();
                w = this.rcaMargin.left + this.axisMargin.left;
                if (this.rowOLAPHeader.getMajor().titleComponent != null) {
                    w -= this.rowOLAPHeader.getMajor().titleComponent.getPreferredSize().width;
                }
                g.drawLine(x - w, y - 1, x, y - 1);
                y = this.getGridBottom();
                g.drawLine(x - w, y, x, y);
                x = this.getGridRight();
                y = this.getGridTop();
                w = this.rcaMargin.right + this.axisMargin.right;
                g.drawLine(x, y - 1, x + w, y - 1);
                y = this.getGridBottom();
                g.drawLine(x, y, x + w, y);
                DataTreeGroupNode tree = major.getTree();
                eu = tree.breadthFirstEnumeration();
                while (eu.hasMoreElements()) {
                    n = (DataTreeGroupNode)eu.nextElement();
                    if (n.isRoot()) continue;
                    comp2 = (Component)n.getUserObject();
                    g.drawLine(comp2.getX(), comp2.getY() - 1, x, comp2.getY() - 1);
                    g.drawLine(this.getGridRight(), comp2.getY() - 1, this.getGridRight() + w, comp2.getY() - 1);
                }
            }
        } else if (this.rowCompoundHeader != null) {
            x = this.getGridLeft();
            y = this.getGridTop();
            w = this.visibleColumns * this.cellSize.width;
            g.setColor(this.gridAttrs.getColor());
            g.drawLine(x, y - 1, x + w, y - 1);
            for (int r = this.startRow + 1; r < this.startRow + this.visibleRows; ++r) {
                int h3 = (int)(this.rowWeight[r - this.startRow - 1] * (double)this.visibleRows * (double)this.cellSize.height + 0.5);
                g.drawLine(x, (y += h3) - 1, x + w, y - 1);
            }
            y = this.getGridBottom();
            g.drawLine(x, y, x + w, y);
            x = this.getGridLeft();
            y = this.getGridTop();
            w = this.rcaMargin.left + this.axisMargin.left - this.axisLabelPadding.left;
            g.drawLine(x - w, y - 1, x, y - 1);
            y = this.getGridBottom();
            g.drawLine(x - w, y, x, y);
            x = this.getGridRight();
            y = this.getGridTop();
            w = this.rcaMargin.right + this.axisMargin.right;
            g.drawLine(x, y - 1, x + w, y - 1);
            y = this.getGridBottom();
            g.drawLine(x, y, x + w, y);
            for (int i = 0; i < this.rowCompoundHeader.getLevels(); ++i) {
                for (int j = 0; j < this.rowCompoundHeader.getHeader(i).getNumHeaders(); ++j) {
                    comp = this.rowCompoundHeader.getHeader(i).getHeader(j);
                    g.drawLine(comp.getX(), comp.getY() - 1, x, comp.getY() - 1);
                    g.drawLine(this.getGridRight(), comp.getY() - 1, this.getGridRight() + w, comp.getY() - 1);
                }
            }
        } else if (this.columnOLAPHeader != null || this.columnCompoundHeader != null) {
            x = this.getGridLeft();
            y = this.getGridTop();
            w = this.visibleColumns * this.cellSize.width;
            g.setColor(this.gridAttrs.getColor());
            g.drawLine(x, y, x + w, y);
            y = this.getGridBottom();
            g.drawLine(x, y, x + w, y);
        }
        if (this.columnOLAPHeader != null) {
            x = this.getGridLeft();
            y = this.getGridTop();
            h = this.visibleRows * this.cellSize.height;
            g.setColor(this.gridAttrs.getColor());
            g.drawLine(x, y, x, y + h);
            for (int c = this.startColumn + 1; c < this.startColumn + this.visibleColumns; ++c) {
                int w2 = (int)(this.columnWeight[c - this.startColumn - 1] * (double)this.visibleColumns * (double)this.cellSize.width + 0.5);
                g.drawLine(x += w2, y, x, y + h);
            }
            x = this.getGridRight();
            g.drawLine(x, y, x, y + h);
            OLAPHeader.TreeHeader major = this.columnOLAPHeader.getMajor();
            if (major.getTree() != null) {
                x = this.getGridLeft();
                y = this.getGridBottom();
                h = this.rcaMargin.bottom + this.axisMargin.bottom;
                if (this.columnOLAPHeader.getMajor().titleComponent != null) {
                    h -= this.columnOLAPHeader.getMajor().titleComponent.getPreferredSize().height;
                }
                g.drawLine(x, y, x, y + h);
                x = this.getGridRight();
                g.drawLine(x, y, x, y + h);
                DataTreeGroupNode tree = major.getTree();
                eu = tree.breadthFirstEnumeration();
                while (eu.hasMoreElements()) {
                    n = (DataTreeGroupNode)eu.nextElement();
                    if (n.isRoot()) continue;
                    comp2 = (Component)n.getUserObject();
                    int y2 = comp2.getY() + comp2.getHeight();
                    g.drawLine(comp2.getX(), y, comp2.getX(), y2);
                }
            }
        } else if (this.columnCompoundHeader != null) {
            x = this.getGridLeft();
            y = this.getGridTop();
            h = this.visibleRows * this.cellSize.height;
            g.setColor(this.gridAttrs.getColor());
            g.drawLine(x, y, x, y + h);
            for (int c = this.startColumn + 1; c < this.startColumn + this.visibleColumns; ++c) {
                int w3 = (int)(this.columnWeight[c - this.startColumn - 1] * (double)this.visibleColumns * (double)this.cellSize.width + 0.5);
                g.drawLine(x += w3, y, x, y + h);
            }
            x = this.getGridRight();
            g.drawLine(x, y, x, y + h);
            x = this.getGridLeft();
            y = this.getGridBottom();
            h = this.rcaMargin.bottom + this.axisMargin.bottom;
            g.drawLine(x, y, x, y + h);
            x = this.getGridRight();
            g.drawLine(x, y, x, y + h);
            for (int i = 0; i < this.columnCompoundHeader.getLevels(); ++i) {
                for (int j = 0; j < this.columnCompoundHeader.getHeader(i).getNumHeaders2(); ++j) {
                    comp = this.columnCompoundHeader.getHeader(i).getHeader2(j);
                    g.drawLine(comp.getX(), y, comp.getX(), comp.getY() + comp.getHeight());
                }
            }
        } else if (this.rowOLAPHeader != null || this.rowCompoundHeader != null) {
            x = this.getGridLeft();
            y = this.getGridTop();
            h = this.visibleRows * this.cellSize.height;
            g.setColor(this.gridAttrs.getColor());
            g.drawLine(x, y, x, y + h);
            x = this.getGridRight();
            g.drawLine(x, y, x, y + h);
        }
    }

    private int getGridLeft() {
        return this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + this.rcSbarMargin.left + this.axisMargin.left;
    }

    private int getGridTop() {
        return this.trellisInsets.top + this.titleHeight + this.rcaMargin.top + this.oaMargin.top + this.rcSbarMargin.top + this.axisMargin.top;
    }

    private int getGridRight() {
        return this.getGridLeft() + this.visibleColumns * this.cellSize.width - 1;
    }

    private int getGridBottom() {
        return this.getGridTop() + this.visibleRows * this.cellSize.height - 1;
    }

    public int getGlobalLegendSpacing() {
        return this.globalLegendSpacing;
    }

    public void setGlobalLegendSpacing(int globalLegendSpacing) {
        this.globalLegendSpacing = globalLegendSpacing;
    }

    protected void setColumnAxisHeightPercentage(double percentage) {
        this.columnAxisHeightPercentage = percentage;
    }

    protected double getColumnAxisHeightPercentage() {
        return this.columnAxisHeightPercentage;
    }

    protected void setRowAxisWidthPercentage(double percentage) {
        this.rowAxisWidthPercentage = percentage;
    }

    protected double getRowAxisWidthPercentage() {
        return this.rowAxisWidthPercentage;
    }

    protected void setRow2AxisWidthPercentage(double percentage) {
        this.row2AxisWidthPercentage = percentage;
    }

    protected double getRow2AxisWidthPercentage() {
        return this.row2AxisWidthPercentage;
    }

    public String[] getRowWeights2() {
        return this.rowWeights;
    }

    public void setRowWeights2(String[] rowWeights) {
        this.rowWeights = rowWeights;
    }

    public String[] getCOlumnWeights2() {
        return this.columnWeights;
    }

    public void setColumnWeights2(String[] columnWeights) {
        this.columnWeights = columnWeights;
    }

    private int getRowPreferredHeight(int row) {
        int h = 0;
        for (int col = 0; col < this.getGridColumns(); ++col) {
            OneDPlotInterface odpi;
            Component c = this.getCell(row, col).getItem();
            if (c == null || !(c instanceof OneDPlotInterface) || !(odpi = (OneDPlotInterface)((Object)c)).isOneDimensional() || !odpi.isDataOnHorizontalSide()) continue;
            h = Math.max(h, odpi.getPreferredSizeOnDataLessSide());
        }
        return h;
    }

    private int getColumnPreferredWidth(int col) {
        int w = 0;
        for (int row = 0; row < this.getGridRows(); ++row) {
            OneDPlotInterface odpi;
            Component c = this.getCell(row, col).getItem();
            if (c == null || !(c instanceof OneDPlotInterface) || !(odpi = (OneDPlotInterface)((Object)c)).isOneDimensional() || odpi.isDataOnHorizontalSide()) continue;
            w = Math.max(w, odpi.getPreferredSizeOnDataLessSide());
        }
        return w;
    }

    private void computeRowWeights() {
        int i;
        if (this.rowWeights == null) {
            return;
        }
        int totalPreferredHeight = 0;
        double totalNumericWeights = 0.0;
        int cntNumeric = 0;
        for (int i2 = 0; i2 < this.rowWeights.length; ++i2) {
            if (this.rowWeights[i2].equalsIgnoreCase("PREFERRED")) continue;
            totalNumericWeights += Double.parseDouble(this.rowWeights[i2]);
            ++cntNumeric;
        }
        double avgWeight = cntNumeric == 0 ? 1.0 : totalNumericWeights / (double)cntNumeric;
        int cntPreferred = 0;
        for (i = 0; i < this.rowWeights.length; ++i) {
            if (!this.rowWeights[i].equalsIgnoreCase("PREFERRED")) continue;
            int h = this.getRowPreferredHeight(i);
            totalPreferredHeight += h;
            if (h == 0) {
                totalNumericWeights += avgWeight;
                continue;
            }
            ++cntPreferred;
            totalPreferredHeight += this.maxCellHeaderHeight;
        }
        if (cntNumeric == 0 && cntPreferred == this.rowWeights.length) {
            for (i = 0; i < this.getGridRows(); ++i) {
                this.rowWeight[i] = 1.0 / (double)this.getGridRows();
            }
            return;
        }
        int gridHeight = this.cellSize.height * this.getGridRows();
        if (totalPreferredHeight < gridHeight) {
            int i3;
            int remainingHeight = gridHeight - totalPreferredHeight;
            int[] rowHeights = new int[this.getGridRows()];
            for (i3 = 0; i3 < this.getGridRows(); ++i3) {
                double wt;
                if (this.rowWeights[i3].equalsIgnoreCase("PREFERRED")) {
                    rowHeights[i3] = this.getRowPreferredHeight(i3);
                    if (rowHeights[i3] == 0) {
                        wt = avgWeight / totalNumericWeights;
                        rowHeights[i3] = (int)(wt * (double)remainingHeight);
                        continue;
                    }
                    int n = i3;
                    rowHeights[n] = rowHeights[n] + this.maxCellHeaderHeight;
                    continue;
                }
                wt = Double.parseDouble(this.rowWeights[i3]) / totalNumericWeights;
                rowHeights[i3] = (int)(wt * (double)remainingHeight);
            }
            for (i3 = 0; i3 < this.getGridRows(); ++i3) {
                this.rowWeight[i3] = (double)rowHeights[i3] / (double)gridHeight;
            }
        }
    }

    private void computeColumnWeights() {
        int i;
        if (this.columnWeights == null) {
            return;
        }
        int totalPreferredWidth = 0;
        double totalNumericWeights = 0.0;
        int cntNumeric = 0;
        for (int i2 = 0; i2 < this.columnWeights.length; ++i2) {
            if (this.columnWeights[i2].equalsIgnoreCase("PREFERRED")) continue;
            totalNumericWeights += Double.parseDouble(this.columnWeights[i2]);
            ++cntNumeric;
        }
        double avgWeight = cntNumeric == 0 ? 1.0 : totalNumericWeights / (double)cntNumeric;
        int cntPreferred = 0;
        for (i = 0; i < this.columnWeights.length; ++i) {
            if (!this.columnWeights[i].equalsIgnoreCase("PREFERRED")) continue;
            int w = this.getColumnPreferredWidth(i);
            totalPreferredWidth += w;
            if (w == 0) {
                totalNumericWeights += avgWeight;
                continue;
            }
            ++cntPreferred;
        }
        if (cntNumeric == 0 && cntPreferred == this.columnWeights.length) {
            for (i = 0; i < this.getGridColumns(); ++i) {
                this.columnWeight[i] = 1.0 / (double)this.getGridColumns();
            }
            return;
        }
        int gridWidth = this.cellSize.width * this.getGridColumns();
        if (totalPreferredWidth < gridWidth) {
            int i3;
            int remainingWidth = gridWidth - totalPreferredWidth;
            int[] columnWidths = new int[this.getGridColumns()];
            for (i3 = 0; i3 < this.getGridColumns(); ++i3) {
                double wt;
                if (this.columnWeights[i3].equalsIgnoreCase("PREFERRED")) {
                    columnWidths[i3] = this.getColumnPreferredWidth(i3);
                    if (columnWidths[i3] != 0) continue;
                    wt = avgWeight / totalNumericWeights;
                    columnWidths[i3] = (int)(wt * (double)remainingWidth);
                    continue;
                }
                wt = Double.parseDouble(this.columnWeights[i3]) / totalNumericWeights;
                columnWidths[i3] = (int)(wt * (double)remainingWidth);
            }
            for (i3 = 0; i3 < this.getGridColumns(); ++i3) {
                this.columnWeight[i3] = (double)columnWidths[i3] / (double)gridWidth;
            }
        }
    }

    protected void addColumnGridLabel(int col, Component comp, boolean primary) {
        if (primary) {
            this.getColumnMeta(col).addGridLabel(3, comp);
        } else {
            this.getColumnMeta(col).addGridLabel(1, comp);
        }
    }

    protected Component getColumnGridLabel(int col, boolean primary) {
        if (primary) {
            return this.getColumnMeta(col).getGridLabel(3);
        }
        return this.getColumnMeta(col).getGridLabel(1);
    }

    protected void addRowGridLabel(int row, Component comp, boolean primary) {
        if (primary) {
            this.getRowMeta(row).addGridLabel(2, comp);
        } else {
            this.getRowMeta(row).addGridLabel(4, comp);
        }
    }

    protected Component getRowGridLabel(int row, boolean primary) {
        if (primary) {
            return this.getRowMeta(row).getGridLabel(2);
        }
        return this.getRowMeta(row).getGridLabel(4);
    }
}

