/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.grid;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisConstants;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;

public class TrellisGridCell
implements TrellisConstants {
    protected ArrayList headers = new ArrayList();
    protected Component item;
    protected Component tAxis;
    protected Component bAxis;
    protected Component lAxis;
    protected Component rAxis;
    protected int x;
    protected int y;
    protected int width;
    protected int height;

    public int getNumHeaders() {
        return this.headers.size();
    }

    public Component getHeader(int index) {
        return (Component)this.headers.get(index);
    }

    public void addHeader(int index, Component comp) {
        this.headers.add(index, comp);
    }

    public void removeHeader(int index) {
        this.headers.remove(index);
    }

    public Component getAxis(int position) {
        switch (position) {
            default: {
                return null;
            }
            case 1: {
                return this.tAxis;
            }
            case 3: {
                return this.bAxis;
            }
            case 2: {
                return this.lAxis;
            }
            case 4: 
        }
        return this.rAxis;
    }

    public void addAxis(int position, Component axis) {
        switch (position) {
            default: {
                break;
            }
            case 1: {
                this.tAxis = axis;
                break;
            }
            case 3: {
                this.bAxis = axis;
                break;
            }
            case 2: {
                this.lAxis = axis;
                break;
            }
            case 4: {
                this.rAxis = axis;
            }
        }
    }

    public void removeAxis(int position) {
        switch (position) {
            default: {
                break;
            }
            case 1: {
                this.tAxis = null;
                break;
            }
            case 3: {
                this.bAxis = null;
                break;
            }
            case 2: {
                this.lAxis = null;
                break;
            }
            case 4: {
                this.rAxis = null;
            }
        }
    }

    public boolean isCellItem() {
        return this.item != null && this.item instanceof CellItemInterface;
    }

    public boolean isMarginsAlignedCellItem() {
        if (!this.isCellItem()) {
            return false;
        }
        return ((CellItemInterface)((Object)this.item)).getMarginsAligned();
    }

    public Component getItem() {
        return this.item;
    }

    public void addItem(Component item) {
        this.item = item;
    }

    public void removeItem() {
        this.item = null;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setVisible(boolean visible) {
        if (this.item != null) {
            this.item.setVisible(visible);
        }
        if (this.tAxis != null) {
            this.tAxis.setVisible(visible);
        }
        if (this.bAxis != null) {
            this.bAxis.setVisible(visible);
        }
        if (this.lAxis != null) {
            this.lAxis.setVisible(visible);
        }
        if (this.rAxis != null) {
            this.rAxis.setVisible(visible);
        }
        for (int i = 0; i < this.headers.size(); ++i) {
            Component comp = (Component)this.headers.get(i);
            if (comp == null) continue;
            comp.setVisible(visible);
        }
    }
}

