/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.grid;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisLayout;
import com.sas.graphics.util.ZoomScrollBar;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class TimeSeriesLayout
extends TrellisLayout {
    private static final int BORDER = 4;
    protected double[] weightY;

    public TimeSeriesLayout() {
        this(1, 0);
    }

    public TimeSeriesLayout(int rows) {
        this(rows, 0);
    }

    public TimeSeriesLayout(int rows, int vgap) {
        super(rows, 1, 0, vgap);
        this.weightY = new double[rows];
        for (int i = 0; i < rows; ++i) {
            this.weightY[i] = 1.0 / (double)rows;
        }
    }

    @Override
    public void setGridRows(int rows) {
        super.setGridRows(rows);
        this.weightY = new double[rows];
        for (int i = 0; i < rows; ++i) {
            this.weightY[i] = 1.0 / (double)rows;
        }
    }

    public double getCellWeightY(int row) {
        return this.weightY[row];
    }

    public void setCellWeightY(int row, double weight) {
        this.weightY[row] = weight;
    }

    @Override
    public void addRow(int row) {
        super.addRow(row);
        this.weightY = new double[this.getGridRows()];
        for (int i = 0; i < this.getGridRows(); ++i) {
            this.weightY[i] = 1.0 / (double)this.getGridRows();
        }
    }

    @Override
    protected void adjustCellLayout() {
        this.verifyWeights();
        int totalGraphAreaHeight = 0;
        for (int i = 0; i < this.getGridRows(); ++i) {
            Rectangle r = this.getCell(i, 0).getBounds();
            totalGraphAreaHeight += r.height - this.maxCellHeaderHeight - (this.getRowOM((int)i).top + this.getRowOM((int)i).bottom + this.getRowIM((int)i).top + this.getRowIM((int)i).bottom);
        }
        int x = this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + this.axisMargin.left;
        int y = this.trellisInsets.top + this.rcaMargin.top + this.oaMargin.top + this.axisMargin.top;
        for (int i = 0; i < this.getGridRows(); ++i) {
            int itemHeight = (int)((double)totalGraphAreaHeight * this.weightY[i]) + this.getRowOM((int)i).top + this.getRowOM((int)i).bottom + this.getRowIM((int)i).top + this.getRowIM((int)i).bottom;
            this.getCell(i, 0).setBounds(x, y, this.cellSize.width, itemHeight + this.maxCellHeaderHeight);
            for (int k = 0; k < this.getCell(i, 0).getNumHeaders(); ++k) {
                if (!this.getCell(i, 0).getHeader(k).isVisible()) continue;
                this.getCell(i, 0).getHeader(k).setBounds(x, y + k * (this.maxCellHeaderHeight / this.getCell(i, 0).getNumHeaders()), this.cellSize.width, this.maxCellHeaderHeight / this.getCell(i, 0).getNumHeaders());
            }
            if (this.getCell(i, 0).getItem() != null) {
                this.getCell(i, 0).getItem().setBounds(x, y + this.maxCellHeaderHeight, this.cellSize.width, itemHeight);
            }
            y += this.maxCellHeaderHeight + itemHeight + this.gridVGap;
        }
    }

    @Override
    protected void adjustItemIOMargin() {
        if (this.bAnnotation == null || !((Component)this.bAnnotation.get(0)).isVisible()) {
            return;
        }
        Component bAnnotation0 = (Component)this.bAnnotation.get(0);
        int lw = 0;
        int rw = 0;
        if (bAnnotation0 instanceof JPanel) {
            Component[] comp = ((JPanel)bAnnotation0).getComponents();
            if (comp[0] instanceof JScrollBar) {
                ZoomScrollBar sb = (ZoomScrollBar)comp[0];
                lw = sb.getArrowButtonWidth();
            }
            if (comp.length >= 2 && comp[1] != null) {
                rw = lw + 4 + comp[1].getBounds().width;
            }
        } else if (bAnnotation0 instanceof JScrollBar) {
            ZoomScrollBar sb = (ZoomScrollBar)bAnnotation0;
            lw = sb.getArrowButtonWidth();
        }
        if (lw > this.getColOM((int)0).left || rw > this.getColOM((int)0).right) {
            for (int i = this.startRow; i < this.startRow + this.visibleRows; ++i) {
                if (!this.getCell(i, 0).isCellItem()) continue;
                CellItemInterface item = (CellItemInterface)((Object)this.getCell(i, 0).getItem());
                Insets om = new Insets(this.getRowOM((int)i).top, Math.max(this.getColOM((int)0).left, lw), this.getRowOM((int)i).bottom, Math.max(this.getColOM((int)0).right, rw));
                item.setOuterMargin(om);
            }
        }
    }

    @Override
    protected Insets calcGridBorderAnnotationMargin(boolean isMinSize) {
        Insets i = new Insets(0, 0, 0, 0);
        if (this.tAnnotation != null && ((Component)this.tAnnotation.get(0)).isVisible()) {
            Component tAnnotation0 = (Component)this.tAnnotation.get(0);
            i.top = isMinSize ? tAnnotation0.getMinimumSize().height : tAnnotation0.getPreferredSize().height;
        }
        if (this.bAnnotation != null && ((Component)this.bAnnotation.get(0)).isVisible()) {
            Component bAnnotation0 = (Component)this.bAnnotation.get(0);
            if (bAnnotation0 instanceof JPanel) {
                Component[] comp = ((JPanel)bAnnotation0).getComponents();
                if (comp[0] != null && comp[0] instanceof JScrollBar) {
                    i.bottom = isMinSize ? comp[0].getMinimumSize().height : comp[0].getPreferredSize().height;
                }
            } else {
                i.bottom = isMinSize ? bAnnotation0.getMinimumSize().height : bAnnotation0.getPreferredSize().height;
            }
        }
        if (this.lAnnotation != null && ((Component)this.lAnnotation.get(0)).isVisible()) {
            Component lAnnotation0 = (Component)this.lAnnotation.get(0);
            i.left = isMinSize ? lAnnotation0.getMinimumSize().width : lAnnotation0.getPreferredSize().width;
        }
        if (this.rAnnotation != null && ((Component)this.rAnnotation.get(0)).isVisible()) {
            Component rAnnotation0 = (Component)this.rAnnotation.get(0);
            i.right = isMinSize ? rAnnotation0.getMinimumSize().width : rAnnotation0.getPreferredSize().width;
        }
        return i;
    }

    @Override
    protected void layoutGridBorderAnnotation() {
        if (this.bAnnotation != null && ((Component)this.bAnnotation.get(0)).isVisible()) {
            this.layoutGridBorderAnnotation_bottom();
        }
        if (this.tAnnotation != null && ((Component)this.tAnnotation.get(0)).isVisible()) {
            this.layoutGridBorderAnnotation_top();
        }
    }

    private void layoutGridBorderAnnotation_bottom() {
        if (this.bAnnotation == null || !((Component)this.bAnnotation.get(0)).isVisible()) {
            return;
        }
        Component bAnnotation0 = (Component)this.bAnnotation.get(0);
        if (bAnnotation0 instanceof JPanel) {
            bAnnotation0.setBounds(this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left, this.trellisSize.height - this.trellisInsets.bottom - this.oaMargin.bottom, this.trellisSize.width - this.trellisInsets.left - this.trellisInsets.right - this.rcaMargin.left - this.oaMargin.left - this.oaMargin.right, this.oaMargin.bottom);
            Component[] comp = ((JPanel)bAnnotation0).getComponents();
            int iconWidth = 0;
            if (comp.length >= 2 && comp[1] != null) {
                iconWidth = comp[1].getPreferredSize().width;
            }
            if (comp[0] != null && comp[0] instanceof JScrollBar) {
                JScrollBar sb = (JScrollBar)comp[0];
                int h = sb.getPreferredSize().height;
                sb.setBounds(Math.max(this.getColOM((int)0).left, h) - h, 0, bAnnotation0.getBounds().width - Math.max(this.getColOM((int)0).left, h) - Math.max(this.getColOM((int)0).right, h + 4 + iconWidth) + 2 * h, bAnnotation0.getBounds().height);
                h = ((ZoomScrollBar)sb).getArrowButtonWidth();
                sb.setBounds(Math.max(this.getColOM((int)0).left, h) - h, 0, bAnnotation0.getBounds().width - Math.max(this.getColOM((int)0).left, h) - Math.max(this.getColOM((int)0).right, h + 4 + iconWidth) + 2 * h, bAnnotation0.getBounds().height);
            }
            if (comp.length >= 2 && comp[1] != null) {
                comp[1].setBounds(comp[0].getBounds().x + comp[0].getBounds().width + 4, 0, iconWidth, bAnnotation0.getBounds().height);
            }
        } else if (bAnnotation0 instanceof JScrollBar) {
            JScrollBar sb = (JScrollBar)bAnnotation0;
            int h = sb.getPreferredSize().height;
            sb.setBounds(this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + this.getColOM((int)0).left - h, this.trellisSize.height - this.trellisInsets.bottom - this.oaMargin.bottom, this.trellisSize.width - this.trellisInsets.left - this.trellisInsets.right - this.rcaMargin.left - this.oaMargin.left - this.oaMargin.right - this.getColOM((int)0).left - this.getColOM((int)0).right + 2 * h, this.oaMargin.bottom);
            System.out.println("layoutGridBorderAnnotation oaMargin.left = " + this.oaMargin.left);
            h = ((ZoomScrollBar)sb).getArrowButtonWidth();
            sb.setBounds(this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + Math.max(this.getColOM((int)0).left, h) - h, this.trellisSize.height - this.trellisInsets.bottom - this.oaMargin.bottom, this.trellisSize.width - this.trellisInsets.left - this.trellisInsets.right - this.rcaMargin.left - this.oaMargin.left - this.oaMargin.right - Math.max(this.getColOM((int)0).left, h) - Math.max(this.getColOM((int)0).right, h) + 2 * h, this.oaMargin.bottom);
        }
    }

    private void layoutGridBorderAnnotation_top() {
        if (this.tAnnotation == null || !((Component)this.tAnnotation.get(0)).isVisible()) {
            return;
        }
        Component tAnnotation0 = (Component)this.tAnnotation.get(0);
        if (tAnnotation0 instanceof JScrollBar) {
            JScrollBar sb = (JScrollBar)tAnnotation0;
            int h = sb.getPreferredSize().height;
            sb.setBounds(this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + this.getColOM((int)0).left - h, this.trellisInsets.top + this.rcaMargin.top, this.trellisSize.width - this.trellisInsets.left - this.trellisInsets.right - this.rcaMargin.left - this.oaMargin.left - this.oaMargin.right - this.getColOM((int)0).left - this.getColOM((int)0).right + 2 * h, this.oaMargin.top);
            h = ((ZoomScrollBar)sb).getArrowButtonWidth();
            sb.setBounds(this.trellisInsets.left + this.rcaMargin.left + this.oaMargin.left + Math.max(this.getColOM((int)0).left, h) - h, this.trellisInsets.top + this.rcaMargin.top, this.trellisSize.width - this.trellisInsets.left - this.trellisInsets.right - this.rcaMargin.left - this.oaMargin.left - this.oaMargin.right - Math.max(this.getColOM((int)0).left, h) - Math.max(this.getColOM((int)0).right, h) + 2 * h, this.oaMargin.top);
        }
    }

    private void verifyWeights() {
        double totalWeight = 0.0;
        for (int i = 0; i < this.getGridRows(); ++i) {
            totalWeight += this.weightY[i];
        }
    }
}

