/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.grid;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;

public class JVerticalLabel
extends JLabel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1933965278452581464L;
    String text;
    boolean topDown;

    public JVerticalLabel(String text, boolean topDown) {
        this.text = text;
        this.topDown = topDown;
        this.addPropertyChangeListener("font", this);
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return new Dimension(fm.getHeight(), fm.stringWidth(this.text + " "));
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        Font oldFont = (Font)pce.getOldValue();
        Font newFont = (Font)pce.getNewValue();
        if (oldFont != null && newFont != null && oldFont.getSize() != newFont.getSize() && this.getParent() != null) {
            this.getParent().validate();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        FontMetrics fm = g.getFontMetrics(this.getFont());
        int textLength = fm.stringWidth(this.text);
        if (this.topDown) {
            g2d.rotate(1.5707963267948966, this.getSize().width / 2, this.getSize().height / 2);
        } else {
            g2d.rotate(-1.5707963267948966, this.getSize().width / 2, this.getSize().height / 2);
        }
        g2d.drawString(this.text, this.getSize().width / 2 - textLength / 2, this.getSize().height / 2 + 5);
    }
}

