/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.anno;

import com.sas.graphics.anno.Constants;
import com.sas.graphics.anno.DisplayAnno;
import com.sas.graphics.anno.PointAndSpace;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class PolygonAnno
extends DisplayAnno {
    protected ArrayList<PointAndSpace> points;
    protected ArrayList<Point2D.Double> screenD = new ArrayList();
    ArrayList<Point2D.Double> savedPoints = null;

    public void setPointSet(ArrayList<PointAndSpace> list) {
        this.points = list;
    }

    @Override
    public int getHandleDirection(int handleID) {
        return 9;
    }

    public ArrayList<PointAndSpace> getAllPoints() {
        return this.points;
    }

    @Override
    public ArrayList<PointAndSpace> getAllPointAndSpacePoints() {
        return this.points;
    }

    @Override
    public void setAllPointAndSpacePoints(ArrayList<PointAndSpace> points) {
        this.points = points;
    }

    @Override
    public void setDiscreteOffset(double offset) {
        if (this.points == null) {
            return;
        }
        for (int i = 0; i < this.points.size(); ++i) {
            PointAndSpace pas = this.points.get(i);
            pas.xOffset = offset;
            pas.yOffset = offset;
        }
    }

    @Override
    public void move(int handle, int x, int y, boolean snapToGrid) {
        if (this.savedPoints == null) {
            this.savedPoints = new ArrayList();
        } else {
            this.savedPoints.clear();
        }
        for (int i = 0; i < this.screenD.size(); ++i) {
            Point2D.Double s = this.screenD.get(i);
            this.savedPoints.add(new Point2D.Double(s.x, s.y));
            s.x += (double)x;
            s.y += (double)y;
            this.container.update(this.points.get(i), this.dataDPIScaleFactor, s);
        }
    }

    @Override
    public void undoMove() {
        if (this.savedPoints == null || this.savedPoints.size() != this.points.size()) {
            return;
        }
        this.screenD.clear();
        for (int i = 0; i < this.savedPoints.size(); ++i) {
            Point2D.Double s = this.savedPoints.get(i);
            this.screenD.add(s);
            this.container.update(this.points.get(i), this.dataDPIScaleFactor, s);
        }
        this.savedPoints.clear();
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.subpixelRendering) {
            this.subpixelPaint(g);
            return;
        }
        if (this.points == null || this.points.size() < 3 || !this.container.isValidContainer()) {
            return;
        }
        Graphics2D gc = (Graphics2D)g.create();
        if (this.antialias) {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.antialiasText) {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (this.clip && this.isInDataSpace()) {
            Rectangle c = this.container.getDataBoundingBox();
            gc.clip(c);
        }
        if (this.transparency != 0.0) {
            gc.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - this.transparency)));
        }
        int size = this.points.size();
        int[] xPoints = new int[size];
        int[] yPoints = new int[size];
        this.screenD.clear();
        for (int i = 0; i < size; ++i) {
            PointAndSpace ps = this.points.get(i);
            Point2D.Double p2 = this.container.getScreenPoint(ps, this.dataDPIScaleFactor);
            if (p2 == null) {
                return;
            }
            Point pt = PolygonAnno.getPoint(p2);
            boolean bl = this.badData = pt.x == Integer.MIN_VALUE || pt.y == Integer.MIN_VALUE;
            if (this.badData) {
                return;
            }
            this.screenD.add(p2);
            xPoints[i] = (int)Math.round(p2.x);
            yPoints[i] = (int)Math.round(p2.y);
        }
        if (this.background) {
            gc.setColor(this.backgroundColor);
            gc.fillPolygon(xPoints, yPoints, size);
        }
        if (this.border) {
            gc.setColor(this.borderColor);
            gc.setStroke(this.borderStroke);
            gc.drawPolygon(xPoints, yPoints, size);
        }
        this.region.reset();
        Polygon polygon = new Polygon(xPoints, yPoints, size);
        Rectangle bounds = polygon.getBounds();
        this.boundsD = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        if (bounds.width == 0 || bounds.height == 0) {
            Rectangle r;
            if (bounds.width == 0) {
                this.region.reset();
                r = new Rectangle(bounds.x - 1, bounds.y, 2, bounds.height);
                this.region.append(r, false);
                bounds = r;
            }
            if (bounds.height == 0) {
                this.region.reset();
                r = new Rectangle(bounds.x, bounds.y - 1, bounds.width, 2);
                this.region.append(r, false);
                bounds = r;
            }
            this.region.append(bounds, false);
        } else {
            this.region.append(polygon, false);
        }
        this.drawText(gc, bounds);
        if (this.textBounds != null && this.textAnchor != 0) {
            this.region.append(this.textBounds, false);
        }
        gc.dispose();
    }

    public void subpixelPaint(Graphics2D g) {
        if (this.points == null || this.points.size() < 3 || !this.container.isValidContainer()) {
            return;
        }
        Graphics2D gc = (Graphics2D)g.create();
        if (this.antialias) {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.antialiasText) {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        gc.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.clip && this.isInDataSpace()) {
            Rectangle c = this.container.getDataBoundingBox();
            gc.clip(c);
        }
        if (this.transparency != 0.0) {
            gc.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - this.transparency)));
        }
        int size = this.points.size();
        this.screenD.clear();
        GeneralPath polygon = new GeneralPath();
        for (int i = 0; i < size; ++i) {
            PointAndSpace ps = this.points.get(i);
            Point2D.Double p2 = this.container.getScreenPoint(ps, this.dataDPIScaleFactor);
            if (p2 == null) {
                return;
            }
            Point pt = PolygonAnno.getPoint(p2);
            boolean bl = this.badData = pt.x == Integer.MIN_VALUE || pt.y == Integer.MIN_VALUE;
            if (this.badData) {
                return;
            }
            this.screenD.add(p2);
            if (i == 0) {
                polygon.moveTo(p2.getX(), p2.getY());
                continue;
            }
            polygon.lineTo(p2.getX(), p2.getY());
        }
        polygon.closePath();
        if (this.background) {
            gc.setColor(this.backgroundColor);
            gc.fill(polygon);
        }
        if (this.border) {
            gc.setColor(this.borderColor);
            gc.setStroke(this.borderStroke);
            gc.draw(polygon);
        }
        this.region.reset();
        this.boundsD = new Rectangle2D.Double(polygon.getBounds2D().getX(), polygon.getBounds2D().getY(), polygon.getBounds2D().getWidth(), polygon.getBounds2D().getHeight());
        if (this.boundsD.getWidth() == 0.0 || this.boundsD.getHeight() == 0.0) {
            if (this.boundsD.getWidth() == 0.0) {
                this.region.reset();
                Rectangle2D.Double r = new Rectangle2D.Double(this.boundsD.getX() - 1.0, this.boundsD.getY(), 2.0, this.boundsD.getHeight());
                this.region.append(r, false);
                this.boundsD = r;
            }
            if (this.boundsD.getHeight() == 0.0) {
                this.region.reset();
                Rectangle2D.Double r = new Rectangle2D.Double(this.boundsD.getX(), this.boundsD.getY() - 1.0, this.boundsD.getWidth(), 2.0);
                this.region.append(r, false);
                this.boundsD = r;
            }
            this.region.append(this.boundsD, false);
        } else {
            this.region.append(polygon, false);
        }
        this.drawText(gc, this.boundsD);
        if (this.textBounds != null && this.textAnchor != 0) {
            this.region.append(this.textBounds, false);
        }
        gc.dispose();
    }

    @Override
    public boolean isInDataSpace() {
        for (PointAndSpace p : this.points) {
            if (Constants.getSpace(p.xSpace) == 2 && Constants.getSpace(p.ySpace) == 2) continue;
            return false;
        }
        return true;
    }

    @Override
    public Shape[] getHandles() {
        if (this.screenD == null || this.screenD.size() < 2) {
            return new GeneralPath[0];
        }
        int size = this.points.size();
        Shape[] handles = new Shape[size];
        int index = 0;
        for (Point2D.Double p : this.screenD) {
            handles[index] = new Ellipse2D.Double(p.x - 4.0, p.y - 4.0, 8.0, 8.0);
            ++index;
        }
        return handles;
    }

    @Override
    public ArrayList<Point2D.Double> getAllScreenPoint2Ds() {
        return this.screenD;
    }

    @Override
    public void setAllScreenPoint2Ds(ArrayList<Point2D.Double> sp) {
        if (this.points.size() != sp.size()) {
            return;
        }
        this.screenD.clear();
        int len = this.points.size();
        for (int i = 0; i < len; ++i) {
            PointAndSpace pp = this.points.get(i);
            Point2D.Double p = sp.get(i);
            this.container.update(pp, this.dataDPIScaleFactor, p);
            this.screenD.add(p);
        }
    }

    @Override
    public ArrayList<Point> getAllScreenPoints() {
        if (this.screenD == null) {
            return null;
        }
        ArrayList<Point> pts = new ArrayList<Point>();
        for (Point2D.Double p : this.screenD) {
            pts.add(PolygonAnno.getPoint(p));
        }
        return pts;
    }

    @Override
    public void setAllScreenPoints(ArrayList<Point> sp) {
        if (this.points.size() != this.screenD.size()) {
            return;
        }
        this.screenD.clear();
        int len = this.points.size();
        for (int i = 0; i < len; ++i) {
            PointAndSpace pp = this.points.get(i);
            Point2D.Double p = PolygonAnno.getPoint(sp.get(i));
            this.container.update(pp, this.dataDPIScaleFactor, p);
            this.screenD.add(p);
        }
    }

    @Override
    public void drawText(Graphics2D gc, int caret, boolean highlight, Color hc) {
        if (this.lbm == null) {
            return;
        }
        Color c = this.getTextColor();
        if (highlight) {
            gc.setColor(hc);
            gc.fill(this.textBounds);
            c = new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue());
        }
        super.drawText(gc, highlight, c, caret);
        Stroke save = gc.getStroke();
        gc.setColor(Color.LIGHT_GRAY);
        gc.setStroke(textBorder);
        gc.draw(this.textBounds);
        gc.setStroke(save);
    }

    @Override
    public int getCaretPosition(int x, int y) {
        if (!this.textBounds.contains(x, y)) {
            return -1;
        }
        return this.getCaret(new Point(x, y));
    }

    @Override
    public void paint(Graphics2D g2d, Color color, Color edgeColor, int x, int y, int w, int h) {
        double sy;
        int xmin = Integer.MAX_VALUE;
        int ymin = Integer.MAX_VALUE;
        int xmax = -2147483647;
        int ymax = -2147483647;
        int size = this.points.size();
        int[] xPoints = new int[size];
        int[] yPoints = new int[size];
        for (int i = 0; i < size; ++i) {
            PointAndSpace ps = this.points.get(i);
            Point2D.Double p = this.container.getScreenPoint(ps, this.dataDPIScaleFactor);
            if (p == null) {
                return;
            }
            Point p2 = PolygonAnno.getPoint(p);
            boolean bl = this.badData = p2.x == Integer.MIN_VALUE || p2.y == Integer.MIN_VALUE;
            if (this.badData) {
                return;
            }
            xPoints[i] = p2.x;
            yPoints[i] = p2.y;
            xmin = Math.min(p2.x, xmin);
            ymin = Math.min(p2.y, ymin);
            xmax = Math.max(p2.x, xmax);
            ymax = Math.max(p2.y, ymax);
        }
        int xc = (xmin + xmax) / 2;
        int yc = (ymin + ymax) / 2;
        double sx = xmax > xmin ? (double)w / (double)(xmax - xmin) : 1.0;
        double d = sy = ymax > ymin ? (double)h / (double)(ymax - ymin) : 1.0;
        if (this.rotation == 0.0) {
            for (int i = 0; i < size; ++i) {
                xPoints[i] = (int)((double)(xPoints[i] - xc) * sx) + x;
                yPoints[i] = (int)((double)(yPoints[i] - yc) * sy) + y;
            }
        } else {
            AffineTransform at = AffineTransform.getRotateInstance(-this.rotation);
            Point2D.Double pt = new Point2D.Double();
            Point2D.Double rotated = new Point2D.Double();
            for (int i = 0; i < size; ++i) {
                pt.x = (double)(xPoints[i] - xc) * sx;
                pt.y = (double)(yPoints[i] - yc) * sy;
                at.transform(pt, rotated);
                xPoints[i] = (int)rotated.getX() + x;
                yPoints[i] = (int)rotated.getY() + y;
            }
        }
        Graphics2D gc = (Graphics2D)g2d.create();
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setClip(x - w / 2, y - h / 2, w, h);
        if (this.background) {
            gc.setColor(color);
            gc.fillPolygon(xPoints, yPoints, size);
        }
        if (this.border) {
            gc.setColor(edgeColor);
            gc.setStroke(this.borderStroke);
            gc.drawPolygon(xPoints, yPoints, size);
        }
        gc.dispose();
    }

    @Override
    public void paint(Graphics2D g2d, Color color, Color edgeColor, double x, double y, int w, int h) {
        double sy;
        double xmin = 2.147483647E9;
        double ymin = 2.147483647E9;
        double xmax = -2.147483647E9;
        double ymax = -2.147483647E9;
        int size = this.points.size();
        double[] xPoints = new double[size];
        double[] yPoints = new double[size];
        for (int i = 0; i < size; ++i) {
            PointAndSpace ps = this.points.get(i);
            Point2D.Double p2 = this.container.getScreenPoint(ps, this.dataDPIScaleFactor);
            if (p2 == null) {
                return;
            }
            Point pt = PolygonAnno.getPoint(p2);
            boolean bl = this.badData = pt.x == Integer.MIN_VALUE || pt.y == Integer.MIN_VALUE;
            if (this.badData) {
                return;
            }
            xPoints[i] = p2.getX();
            yPoints[i] = p2.getY();
            xmin = Math.min(p2.getX(), xmin);
            ymin = Math.min(p2.getY(), ymin);
            xmax = Math.max(p2.getX(), xmax);
            ymax = Math.max(p2.getY(), ymax);
        }
        double xc = (xmin + xmax) / 2.0;
        double yc = (ymin + ymax) / 2.0;
        double sx = xmax > xmin ? (double)w / (xmax - xmin) : 1.0;
        double d = sy = ymax > ymin ? (double)h / (ymax - ymin) : 1.0;
        if (this.rotation == 0.0) {
            for (int i = 0; i < size; ++i) {
                xPoints[i] = (xPoints[i] - xc) * sx + x;
                yPoints[i] = (yPoints[i] - yc) * sy + y;
            }
        } else {
            AffineTransform at = AffineTransform.getRotateInstance(-this.rotation);
            Point2D.Double pt = new Point2D.Double();
            Point2D.Double rotated = new Point2D.Double();
            for (int i = 0; i < size; ++i) {
                pt.x = (xPoints[i] - xc) * sx;
                pt.y = (yPoints[i] - yc) * sy;
                at.transform(pt, rotated);
                xPoints[i] = rotated.getX() + x;
                yPoints[i] = rotated.getY() + y;
            }
        }
        Graphics2D gc = (Graphics2D)g2d.create();
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        gc.setClip(new Rectangle2D.Double(x - (double)w / 2.0, y - (double)h / 2.0, w, h));
        GeneralPath poly = new GeneralPath();
        poly.moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < size; ++i) {
            poly.lineTo(xPoints[i], yPoints[i]);
        }
        poly.closePath();
        if (this.background) {
            gc.setColor(color);
            gc.fill(poly);
        }
        if (this.border) {
            gc.setColor(edgeColor);
            gc.setStroke(this.borderStroke);
            gc.draw(poly);
        }
        gc.dispose();
    }
}

