/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.anno;

import com.sas.graphics.anno.AreaAnno;
import com.sas.graphics.anno.Constants;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.io.File;

public class ImageAnno
extends AreaAnno
implements ImageObserver {
    String path;
    Image image;
    Image scaledImage;
    int scale;
    boolean loading = false;
    static Color transparentColor = null;

    public ImageAnno() {
        this.textAnchor = 4;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public void paint(Graphics2D g) {
        int y1;
        int x1;
        int yo;
        Rectangle bounds;
        if (this.anchorPoint.x == null || this.anchorPoint.y == null) {
            return;
        }
        if (this.computeBounds() == null) {
            return;
        }
        Graphics2D gc = (Graphics2D)g.create();
        if (this.antialias) {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.antialiasText) {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (this.clip) {
            boolean flag;
            boolean bl = flag = Constants.getSpace(this.anchorPoint.xSpace) == 2 && Constants.getSpace(this.anchorPoint.ySpace) == 2;
            if (flag) {
                Rectangle c = this.container.getDataBoundingBox();
                if (this.rotationAngle != 0.0) {
                    AffineTransform at = AffineTransform.getRotateInstance(this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY());
                    gc.clip(at.createTransformedShape(c));
                } else {
                    gc.clip(c);
                }
            }
        }
        if (this.rotationAngle != 0.0) {
            gc.rotate(-this.rotationAngle, this.anchorScreen.x, this.anchorScreen.y);
        }
        if (this.transparency != 0.0) {
            gc.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - this.transparency)));
        }
        this.region.reset();
        Rectangle r = bounds = this.boundsD.getBounds();
        if (bounds.width < 0 || bounds.height < 0) {
            int x = bounds.x;
            int y = bounds.y;
            int width = bounds.width;
            int height = bounds.height;
            if (width < 0) {
                x += width;
                width *= -1;
            }
            if (height < 0) {
                y += height;
                height *= -1;
            }
            r = new Rectangle(x, y, width, height);
        }
        this.region.append(r, false);
        if (this.background) {
            gc.setColor(this.backgroundColor);
            gc.fill(r);
        }
        if (this.image == null) {
            if (!this.background) {
                gc.setColor(Color.white);
                gc.fill(bounds);
            }
            gc.setColor(Color.red);
            int xo = r.width > 9 ? r.x + 3 : r.x;
            yo = r.height > 9 ? r.y + 3 : r.y;
            x1 = r.width > 9 ? xo + r.width - 6 : xo + r.width;
            y1 = r.height > 9 ? yo + r.height - 6 : yo + r.height;
            gc.drawLine(xo, yo, x1, y1);
            gc.drawLine(x1, yo, xo, y1);
            gc.setColor(Color.black);
            gc.draw(r);
        } else if (this.image.getWidth(null) != -1) {
            if (this.scale != 3) {
                if (this.scaledImage != null && (Toolkit.getDefaultToolkit().checkImage(this.scaledImage, -1, -1, this) & 0x20) != 0) {
                    gc.drawImage(this.scaledImage, bounds.x, bounds.y, transparentColor, null);
                } else {
                    gc.drawImage(this.image, bounds.x, bounds.y, bounds.width, bounds.height, transparentColor, null);
                }
            } else {
                Rectangle clip;
                int xo = bounds.x;
                yo = bounds.y;
                x1 = xo + bounds.width;
                y1 = yo + bounds.height;
                int iw = this.image.getWidth(null);
                int ih = this.image.getHeight(null);
                Rectangle rectangle = clip = gc.getClip() == null ? null : gc.getClip().getBounds();
                if (clip != null) {
                    gc.setClip(bounds.createIntersection(clip));
                } else {
                    gc.setClip(bounds);
                }
                for (int i = xo; i < x1; i += iw) {
                    for (int j = yo; j < y1; j += ih) {
                        if (this.background) {
                            gc.drawImage(this.image, i, j, iw, ih, this.backgroundColor, null);
                            continue;
                        }
                        gc.drawImage(this.image, i, j, iw, ih, transparentColor, null);
                    }
                }
                gc.setClip(clip);
            }
        }
        if (this.border) {
            gc.setColor(this.borderColor);
            gc.setStroke(this.borderStroke);
            gc.drawRect(r.x, r.y, r.width, r.height);
        }
        Rectangle temp = this.region.getBounds();
        if (temp.width < 0 || temp.height < 0) {
            System.out.println("Negative values");
        }
        this.drawText(gc, r);
        if (this.textBounds != null && this.textAnchor != 0) {
            this.region.append(this.textBounds, false);
        }
        if (this.rotationAngle != 0.0) {
            AffineTransform at = AffineTransform.getRotateInstance(-this.rotationAngle, this.anchorScreen.x, this.anchorScreen.y);
            this.region.transform(at);
            this.textBounds = at.createTransformedShape(this.textBounds);
        }
        gc.dispose();
    }

    protected Rectangle2D.Double computeBoundsInDouble() {
        this.computeBounds();
        return this.boundsD;
    }

    public boolean setResource(String url) {
        this.path = url;
        if (!new File(this.path).exists()) {
            return false;
        }
        try {
            this.image = Toolkit.getDefaultToolkit().createImage(url);
        }
        catch (Exception ee) {
            this.image = null;
            return false;
        }
        this.image.getHeight(null);
        this.image.getWidth(null);
        int wait = 0;
        while ((Toolkit.getDefaultToolkit().checkImage(this.image, -1, -1, null) & 0x20) == 0) {
            try {
                Thread.sleep(100L);
                if ((wait += 100) <= 120000) continue;
                this.image = null;
                return false;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return true;
    }

    @Override
    protected Rectangle2D.Double computeBounds() {
        double height;
        double width;
        this.anchorScreen = this.container.getScreenPoint(this.anchorPoint, this.dataDPIScaleFactor);
        if (this.anchorScreen == null) {
            return null;
        }
        Point pt = ImageAnno.getPoint(this.anchorScreen);
        if (pt.x == Integer.MIN_VALUE || pt.y == Integer.MIN_VALUE) {
            return null;
        }
        if (this.scale == 3 || this.image == null) {
            double h;
            double w = this.size.width;
            if (Double.isNaN(w)) {
                this.size.width = 10.0;
                this.size.widthSpace = 1;
            }
            if (Double.isNaN(h = this.size.height)) {
                this.size.height = 10.0;
                this.size.heightSpace = 1;
            }
            Point2D.Double ssize = this.container.getScreenSize(this.size, this.linearScaleFactor);
            width = ((Point2D)ssize).getX();
            height = ((Point2D)ssize).getY();
            this.size.width = w;
            this.size.height = h;
        } else {
            Point2D.Double ssize = this.container.getScreenSize(this.size, this.linearScaleFactor);
            if (((Point2D)ssize).getX() >= 2.147483647E9 && ((Point2D)ssize).getY() >= 2.147483647E9) {
                width = (double)this.image.getWidth(null) * this.linearScaleFactor;
                height = (double)this.image.getHeight(null) * this.linearScaleFactor;
            } else if (((Point2D)ssize).getX() >= 2.147483647E9) {
                height = ((Point2D)ssize).getY();
                width = (double)this.image.getWidth(null) * height / (double)this.image.getHeight(null);
            } else if (((Point2D)ssize).getY() >= 2.147483647E9) {
                width = ((Point2D)ssize).getX();
                height = (double)this.image.getHeight(null) * width / (double)this.image.getWidth(null);
            } else {
                width = ((Point2D)ssize).getX();
                height = ((Point2D)ssize).getY();
            }
        }
        double xo = 0.0;
        double yo = 0.0;
        switch (this.anchor) {
            case 3: {
                xo += this.anchorScreen.x - width / 2.0;
                yo += this.anchorScreen.y;
                break;
            }
            case 4: {
                xo += this.anchorScreen.x - width / 2.0;
                yo += this.anchorScreen.y - height;
                break;
            }
            case 1: {
                xo += this.anchorScreen.x;
                yo += this.anchorScreen.y - height / 2.0;
                break;
            }
            case 2: {
                xo += this.anchorScreen.x - width;
                yo += this.anchorScreen.y - height / 2.0;
                break;
            }
            default: {
                xo = this.anchorScreen.x - width / 2.0;
                yo += this.anchorScreen.y - height / 2.0;
                break;
            }
            case 5: {
                xo += this.anchorScreen.x;
                yo += this.anchorScreen.y;
                break;
            }
            case 8: {
                xo += this.anchorScreen.x - width;
                yo += this.anchorScreen.y;
                break;
            }
            case 6: {
                xo += this.anchorScreen.x;
                yo += this.anchorScreen.y - height;
                break;
            }
            case 7: {
                xo += this.anchorScreen.x - width;
                yo += this.anchorScreen.y - height;
            }
        }
        this.boundsD = new Rectangle2D.Double(xo, yo, width, height);
        Rectangle bounds = this.boundsD.getBounds();
        if (width == 0.0 || height == 0.0 || this.image == null) {
            return this.boundsD;
        }
        if (this.scale != 3) {
            int w = -1;
            int h = -1;
            if (this.scaledImage != null) {
                w = this.scaledImage.getWidth(null);
                h = this.scaledImage.getHeight(null);
            }
            if (w != bounds.width || h != bounds.height) {
                if (this.scaledImage != null) {
                    this.scaledImage.flush();
                }
                this.scaledImage = this.image.getWidth(null) == bounds.width && this.image.getHeight(null) == bounds.height ? null : this.image.getScaledInstance(bounds.width, bounds.height, 4);
            }
        } else {
            this.scaledImage = null;
        }
        return this.boundsD;
    }

    @Override
    public boolean imageUpdate(Image arg0, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x20) != 0) {
            if (arg0 != this.scaledImage) {
                this.computeBounds();
            }
            this.container.repaint();
            return false;
        }
        return true;
    }
}

