/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.anno;

import com.sas.graphics.anno.Constants;
import com.sas.graphics.anno.DisplayAnno;
import com.sas.graphics.anno.PointAndSpace;
import com.sas.graphics.anno.SizeAndSpace;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public abstract class AreaAnno
extends DisplayAnno {
    protected int anchor = 0;
    protected SizeAndSpace size = new SizeAndSpace(10.0, 10.0, 1, 1, true, true);
    protected PointAndSpace anchorPoint = new PointAndSpace(50.0, 50.0, 1, 1, true, true);
    protected double rotationAngle = 0.0;
    protected Point2D.Double anchorScreen;
    double adjustRot = 0.0;
    double adjustX = 0.0;
    double adjustY = 0.0;
    double saveAdjustRot = 0.0;
    double saveAdjustX = 0.0;
    double saveAdjustY = 0.0;
    Point2D.Double saveSize = null;
    Point2D.Double saveAnchor = null;
    Point2D.Double tempSize = null;
    double aspectRatio;

    public Point2D.Double getAnchorScreen2D() {
        return this.anchorScreen;
    }

    public Point getAnchorScreen() {
        return AreaAnno.getPoint(this.anchorScreen);
    }

    public PointAndSpace getAnchorPoint() {
        return this.anchorPoint;
    }

    public SizeAndSpace getSize() {
        return this.size;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int anchor) {
        this.anchor = anchor;
    }

    public double getWidth() {
        return this.size.width;
    }

    public int getScreenWidth() {
        return (int)Math.round(this.boundsD.width);
    }

    public void setWidth(double width) {
        this.size.width = width;
    }

    public int getWidthSpace() {
        return this.size.widthSpace;
    }

    public void setWidthSpace(int widthSpace) {
        this.size.widthSpace = widthSpace;
    }

    public int getScreenHeight() {
        return (int)Math.round(this.boundsD.height);
    }

    public double getHeight() {
        return this.size.height;
    }

    public void setHeight(double height) {
        this.size.height = height;
    }

    public int getHeightSpace() {
        return this.size.heightSpace;
    }

    public void setHeightSpace(int heightSpace) {
        this.size.heightSpace = heightSpace;
    }

    public Object getX() {
        return this.anchorPoint.x;
    }

    public void setX(Object x) {
        this.anchorPoint.x = x;
    }

    public Object getY() {
        return this.anchorPoint.y;
    }

    public void setY(Object y) {
        this.anchorPoint.y = y;
    }

    @Override
    public void setDiscreteOffset(double discreteOffset) {
        this.anchorPoint.xOffset = discreteOffset;
        this.anchorPoint.yOffset = discreteOffset;
    }

    public void setXDiscreteOffset(double discreteOffset) {
        this.anchorPoint.xOffset = discreteOffset;
    }

    public void setYDiscreteOffset(double discreteOffset) {
        this.anchorPoint.yOffset = discreteOffset;
    }

    public double getXDiscreteOffset() {
        return this.anchorPoint.xOffset;
    }

    public double getYDiscreteOffset() {
        return this.anchorPoint.yOffset;
    }

    public int getXSpace() {
        return this.anchorPoint.xSpace;
    }

    public void setXSpace(int space) {
        this.anchorPoint.xSpace = space;
    }

    public int getYSpace() {
        return this.anchorPoint.ySpace;
    }

    public void setYSpace(int space) {
        this.anchorPoint.ySpace = space;
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(double rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    protected Rectangle2D.Double computeBounds() {
        Point2D.Double sz = this.container.getScreenSize(this.size, this.linearScaleFactor);
        if (sz == null) {
            return null;
        }
        this.anchorScreen = this.container.getScreenPoint(this.anchorPoint, this.dataDPIScaleFactor);
        Point pt = AreaAnno.getPoint(this.anchorScreen);
        boolean bl = this.badData = pt.x == Integer.MIN_VALUE || pt.y == Integer.MIN_VALUE;
        if (this.badData) {
            return null;
        }
        double xo = 0.0;
        double yo = 0.0;
        double width = Math.abs(sz.getX());
        double height = Math.abs(sz.getY());
        switch (this.anchor) {
            case 3: {
                xo = this.anchorScreen.getX() - width / 2.0;
                yo = this.anchorScreen.getY();
                break;
            }
            case 4: {
                xo = this.anchorScreen.getX() - width / 2.0;
                yo = this.anchorScreen.getY() - height;
                break;
            }
            case 1: {
                xo = this.anchorScreen.getX();
                yo = this.anchorScreen.getY() - height / 2.0;
                break;
            }
            case 2: {
                xo = this.anchorScreen.getX() - width;
                yo = this.anchorScreen.getY() - height / 2.0;
                break;
            }
            default: {
                xo = this.anchorScreen.getX() - width / 2.0;
                yo = this.anchorScreen.getY() - height / 2.0;
                break;
            }
            case 5: {
                xo = this.anchorScreen.getX();
                yo = this.anchorScreen.getY();
                break;
            }
            case 8: {
                xo = this.anchorScreen.getX() - width;
                yo = this.anchorScreen.getY();
                break;
            }
            case 6: {
                xo = this.anchorScreen.getX();
                yo = this.anchorScreen.getY() - height;
                break;
            }
            case 7: {
                xo = this.anchorScreen.getX() - width;
                yo = this.anchorScreen.getY() - height;
            }
        }
        this.boundsD = new Rectangle2D.Double(xo, yo, width, height);
        return this.boundsD;
    }

    public boolean isXPrimary() {
        return this.anchorPoint.xPrimary;
    }

    public void setXPrimary(boolean primary) {
        this.anchorPoint.xPrimary = primary;
        this.size.widthPrimary = primary;
    }

    public boolean isYPrimary() {
        return this.anchorPoint.yPrimary;
    }

    public void setYPrimary(boolean primary) {
        this.anchorPoint.yPrimary = primary;
        this.size.heightPrimary = primary;
    }

    @Override
    public boolean isInDataSpace() {
        return Constants.getSpace(this.anchorPoint.xSpace) == 2 && Constants.getSpace(this.anchorPoint.ySpace) == 2;
    }

    @Override
    public void move(int handle, int x, int y, boolean snapToGrid) {
        this.saveAdjustRot = this.adjustRot;
        if (this.tempSize == null || this.anchorScreen == null) {
            this.computeBounds();
            if (this.boundsD.getWidth() == 0.0 || this.boundsD.getHeight() == 0.0) {
                this.boundsD.setFrame(this.anchorScreen.getX(), this.anchorScreen.getY(), 3.0, 3.0);
            }
            this.tempSize = new Point2D.Double(this.boundsD.getWidth(), this.boundsD.getHeight());
        }
        AffineTransform at = AffineTransform.getRotateInstance(this.rotationAngle, 0.0, 0.0);
        Point2D pi = at.transform(new Point2D.Double(x, y), null);
        if (snapToGrid) {
            switch (handle) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: {
                    double nw = this.tempSize.getX() + pi.getX() + this.adjustX;
                    double nh = this.tempSize.getY() + pi.getY() + this.adjustY;
                    if (Math.abs(nw) < 3.0 || Math.abs(nh) < 3.0) {
                        this.adjustX += (double)x;
                        this.adjustY += (double)y;
                        return;
                    }
                    this.saveAdjustX = this.adjustX;
                    this.saveAdjustY = this.adjustY;
                    double na = nw / nh;
                    if (na > this.aspectRatio) {
                        this.adjustX = nw - nh * this.aspectRatio;
                        nw = nh * this.aspectRatio;
                        this.adjustY = 0.0;
                    } else {
                        this.adjustY = nh - nw / this.aspectRatio;
                        nh = nw / this.aspectRatio;
                        this.adjustX = 0.0;
                    }
                    pi.setLocation(nw - this.tempSize.getX(), nh - this.tempSize.getY());
                    break;
                }
            }
        } else {
            double xx = pi.getX() + this.adjustX;
            double yy = pi.getY() + this.adjustY;
            int halfx = (int)Math.round(xx / 2.0);
            int halfy = (int)Math.round(yy / 2.0);
            pi.setLocation(2 * halfx, 2 * halfy);
            this.saveAdjustX = this.adjustX;
            this.saveAdjustY = this.adjustY;
            this.adjustX = xx - (double)(2 * halfx);
            this.adjustY = yy - (double)(2 * halfy);
        }
        Point2D.Double p1 = null;
        Point2D.Double p2 = null;
        switch (handle) {
            case 1: {
                p1 = new Point2D.Double(pi.getX(), 0.0);
                break;
            }
            case 2: {
                p2 = new Point2D.Double(pi.getX(), 0.0);
                break;
            }
            case 3: {
                p1 = new Point2D.Double(0.0, pi.getY());
                break;
            }
            case 4: {
                p2 = new Point2D.Double(0.0, pi.getY());
                break;
            }
            case 5: {
                p1 = new Point2D.Double(pi.getX(), pi.getY());
                break;
            }
            case 8: {
                p1 = new Point2D.Double(0.0, pi.getY());
                p2 = new Point2D.Double(pi.getX(), 0.0);
                break;
            }
            case 6: {
                p1 = new Point2D.Double(pi.getX(), 0.0);
                p2 = new Point2D.Double(0.0, pi.getY());
                break;
            }
            case 7: {
                p2 = new Point2D.Double(pi.getX(), pi.getY());
                break;
            }
            case 11: {
                p2 = new Point2D.Double(pi.getX(), pi.getY());
                p1 = new Point2D.Double(-pi.getX(), -pi.getY());
                break;
            }
            default: {
                p1 = p2 = new Point2D.Double(pi.getX(), pi.getY());
                break;
            }
            case 0: {
                double theta = (double)(Math.abs(x) + Math.abs(y)) * Math.PI / this.boundsD.getWidth();
                this.rotationAngle = x > 0 ? (this.rotationAngle -= theta) : (this.rotationAngle += theta);
                if (snapToGrid) {
                    this.rotationAngle += this.adjustRot;
                    double rot = (int)Math.toDegrees(this.rotationAngle) % 15;
                    if (rot > 8.0) {
                        rot -= 15.0;
                    }
                    this.adjustRot = Math.toRadians(rot);
                    this.rotationAngle -= this.adjustRot;
                }
                while (this.rotationAngle < 0.0) {
                    this.rotationAngle += Math.PI * 2;
                }
                while (this.rotationAngle > Math.PI * 2) {
                    this.rotationAngle -= Math.PI * 2;
                }
                return;
            }
        }
        this.move(p1, p2);
    }

    private void move(Point2D p1, Point2D p2) {
        if (this.boundsD == null) {
            this.computeBounds();
            this.region.reset();
            this.region.append(this.boundsD, false);
            if (this.rotationAngle != 0.0) {
                this.region.transform(AffineTransform.getRotateInstance(-this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY()));
            }
        }
        this.saveSize = new Point2D.Double(this.tempSize.getX(), this.tempSize.getY());
        this.saveAnchor = new Point2D.Double(this.anchorScreen.getX(), this.anchorScreen.getY());
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        if (p1 != null) {
            x1 = (int)Math.round(p1.getX() / 2.0) * 2;
            y1 = (int)Math.round(p1.getY() / 2.0) * 2;
        }
        if (p2 != null) {
            x2 = (int)Math.round(p2.getX() / 2.0) * 2;
            y2 = (int)Math.round(p2.getY() / 2.0) * 2;
        }
        if (this.tempSize == null) {
            this.tempSize = new Point2D.Double(this.boundsD.getWidth(), this.boundsD.getHeight());
        }
        double xo = this.anchorScreen.getX();
        double yo = this.anchorScreen.getY();
        switch (this.anchor) {
            case 5: {
                this.anchorScreen = new Point2D.Double(xo + (double)x1, yo + (double)y1);
                break;
            }
            case 3: {
                this.anchorScreen = new Point2D.Double(xo + (double)((x1 + x2) / 2), yo + (double)y1);
                break;
            }
            case 8: {
                this.anchorScreen = new Point2D.Double(xo + (double)x2, yo + (double)y1);
                break;
            }
            case 1: {
                this.anchorScreen = new Point2D.Double(xo + (double)x1, yo + (double)((y1 + y2) / 2));
                break;
            }
            default: {
                this.anchorScreen = new Point2D.Double(xo + (double)((x1 + x2) / 2), yo + (double)((y1 + y2) / 2));
                break;
            }
            case 2: {
                this.anchorScreen = new Point2D.Double(xo + (double)x2, yo + (double)((y1 + y2) / 2));
                break;
            }
            case 6: {
                this.anchorScreen = new Point2D.Double(xo + (double)x1, yo + (double)y2);
                break;
            }
            case 4: {
                this.anchorScreen = new Point2D.Double(xo + (double)((x1 + x2) / 2), yo + (double)y2);
                break;
            }
            case 7: {
                this.anchorScreen = new Point2D.Double(xo + (double)x2, yo + (double)y2);
            }
        }
        this.container.update(this.anchorPoint, this.dataDPIScaleFactor, this.anchorScreen);
        double w = this.tempSize.getX();
        double h = this.tempSize.getY();
        this.tempSize = new Point2D.Double(w + (double)x2 - (double)x1, h + (double)y2 - (double)y1);
        this.container.update(this.size, this.linearScaleFactor, this.tempSize);
        this.computeBounds();
    }

    @Override
    public void undoMove() {
        this.adjustRot = this.saveAdjustRot;
        this.adjustX = this.saveAdjustX;
        this.adjustY = this.saveAdjustY;
        if (this.saveAnchor != null) {
            this.anchorScreen = this.saveAnchor;
            this.container.update(this.anchorPoint, this.dataDPIScaleFactor, this.anchorScreen);
        }
        if (this.saveSize != null) {
            this.tempSize = this.saveSize;
            this.container.update(this.size, this.linearScaleFactor, this.tempSize);
        }
        this.computeBounds();
        this.saveSize = null;
        this.saveAnchor = null;
    }

    @Override
    public void resetAdjusters() {
        this.adjustX = 0.0;
        this.adjustY = 0.0;
        this.adjustRot = 0.0;
        if (this.boundsD == null) {
            this.computeBounds();
        }
        this.tempSize = new Point2D.Double(this.boundsD.getWidth(), this.boundsD.getHeight());
        this.aspectRatio = this.tempSize.x > 2.0 && this.tempSize.y > 2.0 ? this.tempSize.x / this.tempSize.y : 1.0;
    }

    @Override
    public Shape[] getHandles() {
        if (this.anchorScreen == null) {
            return new GeneralPath[0];
        }
        if (this.boundsD == null) {
            this.computeBounds();
        }
        Rectangle2D.Double r = this.flipIfNeeded(this.boundsD);
        AffineTransform at = AffineTransform.getRotateInstance(-this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY());
        Shape[] handles = new GeneralPath[9];
        for (int i = 0; i < 9; ++i) {
            handles[i] = new GeneralPath();
        }
        Ellipse2D.Double ee = new Ellipse2D.Double(r.x + r.width / 2.0 - 4.0, r.y - 24.0, 8.0, 8.0);
        Line2D.Double ll1 = new Line2D.Double(r.x + r.width / 2.0, r.y - 16.0, r.x + r.width / 2.0, r.y);
        Line2D.Double ll2 = new Line2D.Double(r.x + r.width / 2.0, r.y, this.anchorScreen.getX(), this.anchorScreen.getY());
        handles[0].append(ee.getPathIterator(at), false);
        handles[0].append(ll1.getPathIterator(at), false);
        handles[0].append(ll2.getPathIterator(at), false);
        ee = new Ellipse2D.Double(this.boundsD.x - 4.0, this.boundsD.y - 4.0, 8.0, 8.0);
        handles[5].append(ee.getPathIterator(at), false);
        ee = new Ellipse2D.Double(this.boundsD.x + this.boundsD.width / 2.0 - 4.0, this.boundsD.y - 4.0, 8.0, 8.0);
        handles[3].append(ee.getPathIterator(at), false);
        ee = new Ellipse2D.Double(this.boundsD.x + this.boundsD.width - 4.0, this.boundsD.y - 4.0, 8.0, 8.0);
        handles[8].append(ee.getPathIterator(at), false);
        ee = new Ellipse2D.Double(this.boundsD.x + this.boundsD.width - 4.0, this.boundsD.y + this.boundsD.height / 2.0 - 4.0, 8.0, 8.0);
        handles[2].append(ee.getPathIterator(at), false);
        ee = new Ellipse2D.Double(this.boundsD.x - 4.0, this.boundsD.y + this.boundsD.height / 2.0 - 4.0, 8.0, 8.0);
        handles[1].append(ee.getPathIterator(at), false);
        ee = new Ellipse2D.Double(this.boundsD.x - 4.0, this.boundsD.y + this.boundsD.height - 4.0, 8.0, 8.0);
        handles[6].append(ee.getPathIterator(at), false);
        ee = new Ellipse2D.Double(this.boundsD.x + this.boundsD.width / 2.0 - 4.0, this.boundsD.y + this.boundsD.height - 4.0, 8.0, 8.0);
        handles[4].append(ee.getPathIterator(at), false);
        ee = new Ellipse2D.Double(this.boundsD.x + this.boundsD.width - 4.0, this.boundsD.y + this.boundsD.height - 4.0, 8.0, 8.0);
        handles[7].append(ee.getPathIterator(at), false);
        return handles;
    }

    @Override
    public Point2D getCenter() {
        Point2D.Double p = new Point2D.Double(this.boundsD.getCenterX(), this.boundsD.getCenterY());
        if (this.rotationAngle == 0.0) {
            return p;
        }
        return AffineTransform.getRotateInstance(this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY()).transform(p, null);
    }

    @Override
    public void scaleFromCenter(int x, int y, boolean snapToGrid) {
        AffineTransform at = AffineTransform.getRotateInstance(-this.rotationAngle, 0.0, 0.0);
        Point2D p2 = at.transform(new Point2D.Double(x, y), null);
        Point2D p1 = at.transform(new Point2D.Double(-x, -y), null);
        this.move(p1, p2);
    }

    @Override
    public ArrayList<Point2D.Double> getAllScreenPoint2Ds() {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        points.add(new Point2D.Double(this.boundsD.x, this.boundsD.y));
        points.add(new Point2D.Double(this.boundsD.x + this.boundsD.width, this.boundsD.y + this.boundsD.height));
        return points;
    }

    @Override
    public ArrayList<PointAndSpace> getAllPointAndSpacePoints() {
        return null;
    }

    @Override
    public void setAllPointAndSpacePoints(ArrayList<PointAndSpace> points) {
    }

    @Override
    public void setAllScreenPoint2Ds(ArrayList<Point2D.Double> points) {
        if (points.size() != 2) {
            return;
        }
        Point2D.Double s1 = points.get(0);
        Point2D.Double s2 = points.get(1);
        switch (this.anchor) {
            case 5: {
                this.anchorScreen = new Point2D.Double(s1.x, s1.y);
                break;
            }
            case 3: {
                this.anchorScreen = new Point2D.Double((s1.x + s2.x) / 2.0, s1.y);
                break;
            }
            case 8: {
                this.anchorScreen = new Point2D.Double(s2.x, s1.y);
                break;
            }
            case 1: {
                this.anchorScreen = new Point2D.Double(s1.x, (s1.y + s2.y) / 2.0);
                break;
            }
            default: {
                this.anchorScreen = new Point2D.Double((s1.x + s2.x) / 2.0, (s1.y + s2.y) / 2.0);
                break;
            }
            case 2: {
                this.anchorScreen = new Point2D.Double(s1.x, (s1.y + s2.y) / 2.0);
                break;
            }
            case 6: {
                this.anchorScreen = new Point2D.Double(s1.x, s2.y);
                break;
            }
            case 4: {
                this.anchorScreen = new Point2D.Double((s2.x + s1.x) / 2.0, s1.y);
                break;
            }
            case 7: {
                this.anchorScreen = new Point2D.Double(s2.x, s2.y);
            }
        }
        this.container.update(this.anchorPoint, this.dataDPIScaleFactor, this.anchorScreen);
        Point2D.Double sz = new Point2D.Double(s2.x - s1.x, s2.y - s1.y);
        this.container.update(this.size, this.linearScaleFactor, sz);
    }

    @Override
    public int getHandleDirection(int handleID) {
        double normalizedRot;
        if (handleID == 0) {
            return 0;
        }
        if (handleID == 9) {
            return 9;
        }
        for (normalizedRot = this.rotationAngle; normalizedRot < 0.0; normalizedRot += Math.PI * 2) {
        }
        while (normalizedRot > Math.PI * 2) {
            normalizedRot -= Math.PI * 2;
        }
        int angle = (int)Math.round(normalizedRot * 4.0 / Math.PI);
        switch (handleID) {
            default: {
                break;
            }
            case 8: {
                ++angle;
                break;
            }
            case 3: {
                angle += 2;
                break;
            }
            case 5: {
                angle += 3;
                break;
            }
            case 1: {
                angle += 4;
                break;
            }
            case 6: {
                angle += 5;
                break;
            }
            case 4: {
                angle += 6;
                break;
            }
            case 7: {
                angle += 7;
            }
        }
        if ((angle %= 8) == 0) {
            return 2;
        }
        if (angle == 1) {
            return 8;
        }
        if (angle == 2) {
            return 3;
        }
        if (angle == 3) {
            return 5;
        }
        if (angle == 4) {
            return 1;
        }
        if (angle == 5) {
            return 6;
        }
        if (angle == 6) {
            return 4;
        }
        if (angle == 7) {
            return 7;
        }
        return 0;
    }

    @Override
    public void drawText(Graphics2D gc, int caret, boolean highlight, Color hc) {
        if (this.lbm == null) {
            return;
        }
        Color c = this.getTextColor();
        if (highlight) {
            gc.setColor(hc);
            gc.fill(this.textBounds);
            c = new Color(255 - hc.getRed(), 255 - hc.getGreen(), 255 - hc.getBlue());
        }
        AffineTransform saveAT = gc.getTransform();
        if (this.rotationAngle != 0.0) {
            gc.rotate(-this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY());
        }
        this.drawText(gc, highlight, c, caret);
        gc.setTransform(saveAT);
        Stroke save = gc.getStroke();
        gc.setColor(Color.LIGHT_GRAY);
        gc.setStroke(textBorder);
        gc.draw(this.textBounds);
        gc.setStroke(save);
    }

    @Override
    public int getCaretPosition(int x, int y) {
        if (!this.textBounds.contains(x, y)) {
            return -1;
        }
        Point2D p = new Point2D.Double(x, y);
        if (this.rotationAngle != 0.0) {
            AffineTransform at = AffineTransform.getRotateInstance(this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY());
            p = at.transform(p, p);
        }
        return this.getCaret(p);
    }

    @Override
    protected int getPad() {
        int pad = this.border ? (int)this.borderStroke.getLineWidth() : 0;
        return pad;
    }

    @Override
    public ArrayList<Point> getAllScreenPoints() {
        ArrayList<Point> points = new ArrayList<Point>();
        Rectangle bounds = this.boundsD.getBounds();
        points.add(new Point(bounds.x, bounds.y));
        points.add(new Point(bounds.x + bounds.width, bounds.y + bounds.height));
        return points;
    }

    @Override
    public void setAllScreenPoints(ArrayList<Point> points) {
        if (points == null) {
            this.setAllScreenPoints(null);
        }
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        for (Point p : points) {
            pts.add(AreaAnno.getPoint(p));
        }
        this.setAllScreenPoint2Ds(pts);
    }
}

