/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.anno;

import com.sas.graphics.anno.AnnotationContainer;
import com.sas.graphics.anno.PointAndSpace;
import com.sas.graphics.util.UserDefinedMarkerInterface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;

public abstract class AbstractAnno
implements UserDefinedMarkerInterface {
    static final Stroke textBorder = new BasicStroke(2.0f, 2, 2, 1.0f, new float[]{8.0f, 4.0f}, 0.0f);
    public static AttributedCharacterIterator.Attribute[] attributes = new AttributedCharacterIterator.Attribute[]{TextAttribute.FOREGROUND, TextAttribute.FONT, TextAttribute.FAMILY, TextAttribute.SIZE, TextAttribute.WEIGHT, TextAttribute.POSTURE, TextAttribute.SUPERSCRIPT};
    protected String name;
    protected String url;
    protected int justify = 0;
    protected LineBreakMeasurer lbm;
    protected AttributedString as;
    protected String tooltip;
    protected String group;
    protected boolean clip = false;
    protected int index = -1;
    protected AnnotationContainer container;
    protected boolean antialias = true;
    protected boolean antialiasText = true;
    protected double transparency = 0.0;
    protected double dataDPIScaleFactor = 1.0;
    protected double linearScaleFactor = 1.0;
    protected GeneralPath region = new GeneralPath();
    protected boolean subpixelRendering = false;
    protected int textAnchor = 0;
    protected String label = null;
    protected Font font = null;
    protected Color textColor = null;
    protected Rectangle2D.Double boundsD;
    protected Shape textBounds;
    protected double textAngle = 0.0;
    protected boolean badData = false;
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;
    protected double xScale = 1.0;
    protected double yScale = 1.0;
    protected double rotation = 0.0;

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public abstract void move(int var1, int var2, int var3, boolean var4);

    public abstract Shape[] getHandles();

    public abstract void setDiscreteOffset(double var1);

    public abstract int getHandleDirection(int var1);

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isClip() {
        return this.clip;
    }

    public void setClip(boolean clip) {
        this.clip = clip;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getTextAnchor() {
        return this.textAnchor;
    }

    public void setTextAnchor(int textAnchor) {
        this.textAnchor = textAnchor;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Shape getRegion() {
        return this.region;
    }

    public Rectangle getObjectBounds() {
        return this.boundsD.getBounds();
    }

    public double getDataDPIScaleFactor() {
        return this.dataDPIScaleFactor;
    }

    public void setDataDPIScaleFactor(double dataDPIScaleFactor) {
        this.dataDPIScaleFactor = dataDPIScaleFactor;
    }

    public double getLinearSizeScaleFactor() {
        return this.linearScaleFactor;
    }

    public void setLinearScaleFactor(double dataDPIScaleFactor) {
        this.linearScaleFactor = dataDPIScaleFactor;
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    public boolean isDataAntialias() {
        return this.antialias;
    }

    public boolean isTextAntialias() {
        return this.antialiasText;
    }

    public void setAntialias(boolean antialias) {
        this.antialias = antialias;
    }

    public void setDataAntialias(boolean antialias) {
        this.antialias = antialias;
    }

    public void setTextAntialias(boolean antialias) {
        this.antialiasText = antialias;
    }

    public void setSubpixelRendering(boolean subpixel) {
        this.subpixelRendering = subpixel;
    }

    public boolean isSubpixelRendering() {
        return this.subpixelRendering;
    }

    public AnnotationContainer getContainer() {
        return this.container;
    }

    public void setContainer(AnnotationContainer container) {
        this.container = container;
    }

    public abstract void paint(Graphics2D var1);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(double transparency) {
        this.transparency = transparency;
    }

    protected Shape drawText(Graphics2D gc, Rectangle bounds) {
        this.textBounds = null;
        this.lbm = null;
        if (this.label != null && this.label.length() > 0) {
            this.as = new AttributedString(this.label);
            if (this.font != null) {
                this.as.addAttribute(TextAttribute.FONT, this.font);
            }
            if (this.textColor != null) {
                this.as.addAttribute(TextAttribute.FOREGROUND, this.textColor);
            }
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), gc.getFontRenderContext());
            this.lbm.setPosition(0);
            float width = bounds.width;
            float height = bounds.height;
            int wrappingWidth = Math.max(10, bounds.width - 2 * this.getPad());
            switch (this.textAnchor) {
                default: {
                    float yo;
                    TextLayout tl = this.lbm.nextLayout(wrappingWidth);
                    height = tl.getAscent() + tl.getDescent();
                    width = tl.getVisibleAdvance();
                    float vspace = 0.2f * height;
                    while ((tl = this.lbm.nextLayout(wrappingWidth)) != null) {
                        width = Math.max(width, tl.getVisibleAdvance());
                        height += tl.getAscent() + tl.getDescent() + tl.getLeading();
                    }
                    int twidth = Math.round(width);
                    float xo = (float)(bounds.x + bounds.width / 2) - width / 2.0f;
                    if (this.textAnchor == 0) {
                        yo = (float)(bounds.y + bounds.height / 2) - height / 2.0f;
                        this.textBounds = new Rectangle((int)Math.max(xo - vspace, (float)bounds.x), (int)Math.max(yo - vspace, (float)bounds.y), (int)Math.min((float)bounds.width, width + 2.0f * vspace), (int)Math.min((float)bounds.height, height + 2.0f * vspace));
                    } else if (this.textAnchor == 3) {
                        yo = (float)bounds.y - height - vspace;
                        this.textBounds = new Rectangle((int)Math.max(xo - vspace, (float)bounds.x), (int)(yo - vspace), (int)Math.min((float)bounds.width, width + 2.0f * vspace), (int)(height + 2.0f * vspace));
                    } else {
                        yo = (float)(bounds.y + bounds.height) + vspace;
                        this.textBounds = new Rectangle((int)Math.max(xo - vspace, (float)bounds.x), (int)(yo - vspace), (int)Math.min((float)bounds.width, width + 2.0f * vspace), (int)(height + 2.0f * vspace));
                    }
                    this.lbm.setPosition(0);
                    int start = Math.round(xo);
                    tl = this.lbm.nextLayout(wrappingWidth);
                    xo = this.getTextAnchor(tl, start, twidth);
                    yo += tl.getAscent();
                    int curPos = 0;
                    int nextPos = this.lbm.getPosition();
                    while (true) {
                        AttributedCharacterIterator iter = this.as.getIterator(attributes, curPos, nextPos);
                        gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                        gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                        gc.drawString(iter, xo, yo);
                        yo += tl.getDescent();
                        tl = this.lbm.nextLayout(wrappingWidth);
                        if (tl == null) break;
                        xo = this.getTextAnchor(tl, start, twidth);
                        yo += tl.getLeading() + tl.getAscent();
                        curPos = nextPos;
                        nextPos = this.lbm.getPosition();
                    }
                    this.textAngle = 0.0;
                    break;
                }
                case 1: {
                    TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
                    height = tl.getAscent() + tl.getDescent();
                    float vspace = 0.2f * height;
                    width = tl.getVisibleAdvance();
                    float xo = (float)bounds.x - tl.getDescent() - vspace;
                    float yo = (float)(bounds.y + bounds.height / 2) + width / 2.0f;
                    this.textBounds = new Rectangle((int)((float)bounds.x - height), (int)(yo - width - vspace), (int)(height + 2.0f * vspace), (int)(width + 2.0f * vspace));
                    gc.rotate(-1.5707963267948966, xo, yo);
                    AttributedCharacterIterator iter = this.as.getIterator(attributes);
                    gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                    gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                    gc.drawString(iter, xo, yo);
                    gc.rotate(1.5707963267948966, xo, yo);
                    this.textAngle = -1.5707963267948966;
                    break;
                }
                case 2: {
                    TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
                    height = tl.getAscent() + tl.getDescent();
                    float vspace = 0.2f * height;
                    width = tl.getVisibleAdvance();
                    float xo = (float)(bounds.x + bounds.width) + tl.getAscent() + vspace;
                    float yo = (float)(bounds.y + bounds.height / 2) + width / 2.0f;
                    this.textBounds = new Rectangle(bounds.x + bounds.width, (int)(yo - width - vspace), (int)(height + 2.0f * vspace), (int)(width + 2.0f * vspace));
                    gc.rotate(-1.5707963267948966, xo, yo);
                    AttributedCharacterIterator iter = this.as.getIterator(attributes);
                    gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                    gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                    gc.drawString(iter, xo, yo);
                    gc.rotate(1.5707963267948966, xo, yo);
                    this.textAngle = -1.5707963267948966;
                    break;
                }
            }
        } else {
            this.textBounds = null;
            this.textAngle = 0.0;
        }
        return this.textBounds;
    }

    protected Shape drawText(Graphics2D gc, Rectangle2D bounds) {
        this.textBounds = null;
        this.lbm = null;
        if (this.label != null && this.label.length() > 0) {
            this.as = new AttributedString(this.label);
            if (this.font != null) {
                this.as.addAttribute(TextAttribute.FONT, this.font);
            }
            if (this.textColor != null) {
                this.as.addAttribute(TextAttribute.FOREGROUND, this.textColor);
            }
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), gc.getFontRenderContext());
            this.lbm.setPosition(0);
            float width = (float)bounds.getWidth();
            float height = (float)bounds.getHeight();
            float wrappingWidth = (float)Math.max(10.0, bounds.getWidth() - (double)(2 * this.getPad()));
            switch (this.textAnchor) {
                default: {
                    float yo;
                    TextLayout tl = this.lbm.nextLayout(wrappingWidth);
                    height = tl.getAscent() + tl.getDescent();
                    width = tl.getVisibleAdvance();
                    float vspace = 0.2f * height;
                    while ((tl = this.lbm.nextLayout(wrappingWidth)) != null) {
                        width = Math.max(width, tl.getVisibleAdvance());
                        height += tl.getAscent() + tl.getDescent() + tl.getLeading();
                    }
                    float twidth = width;
                    float xo = (float)(bounds.getX() + bounds.getWidth() / 2.0 - (double)(width / 2.0f));
                    if (this.textAnchor == 0) {
                        yo = (float)(bounds.getY() + bounds.getHeight() / 2.0 - (double)(height / 2.0f));
                        this.textBounds = new Rectangle2D.Double(Math.max((double)(xo - vspace), bounds.getX()), Math.max((double)(yo - vspace), bounds.getY()), Math.min(bounds.getWidth(), (double)(width + 2.0f * vspace)), Math.min(bounds.getHeight(), (double)(height + 2.0f * vspace)));
                    } else if (this.textAnchor == 3) {
                        yo = (float)(bounds.getY() - (double)height - (double)vspace);
                        this.textBounds = new Rectangle2D.Double(Math.max((double)(xo - vspace), bounds.getX()), yo - vspace, Math.min(bounds.getWidth(), (double)(width + 2.0f * vspace)), height + 2.0f * vspace);
                    } else {
                        yo = (float)(bounds.getY() + bounds.getHeight() + (double)vspace);
                        this.textBounds = new Rectangle2D.Double(Math.max((double)(xo - vspace), bounds.getX()), yo - vspace, Math.min(bounds.getWidth(), (double)(width + 2.0f * vspace)), height + 2.0f * vspace);
                    }
                    this.lbm.setPosition(0);
                    float start = xo;
                    tl = this.lbm.nextLayout(wrappingWidth);
                    xo = this.getTextAnchor(tl, start, twidth);
                    yo += tl.getAscent();
                    int curPos = 0;
                    int nextPos = this.lbm.getPosition();
                    while (true) {
                        AttributedCharacterIterator iter = this.as.getIterator(attributes, curPos, nextPos);
                        gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                        gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                        gc.drawString(iter, xo, yo);
                        yo += tl.getDescent();
                        tl = this.lbm.nextLayout(wrappingWidth);
                        if (tl == null) break;
                        xo = this.getTextAnchor(tl, start, twidth);
                        yo += tl.getLeading() + tl.getAscent();
                        curPos = nextPos;
                        nextPos = this.lbm.getPosition();
                    }
                    this.textAngle = 0.0;
                    break;
                }
                case 1: {
                    TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
                    height = tl.getAscent() + tl.getDescent();
                    float vspace = 0.2f * height;
                    width = tl.getVisibleAdvance();
                    float xo = (float)(bounds.getX() - (double)tl.getDescent() - (double)vspace);
                    float yo = (float)(bounds.getY() + bounds.getHeight() / 2.0 + (double)(width / 2.0f));
                    this.textBounds = new Rectangle2D.Double(bounds.getX() - (double)height, yo - width - vspace, height + 2.0f * vspace, width + 2.0f * vspace);
                    gc.rotate(-1.5707963267948966, xo, yo);
                    AttributedCharacterIterator iter = this.as.getIterator(attributes);
                    gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                    gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                    gc.drawString(iter, xo, yo);
                    gc.rotate(1.5707963267948966, xo, yo);
                    this.textAngle = -1.5707963267948966;
                    break;
                }
                case 2: {
                    TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
                    height = tl.getAscent() + tl.getDescent();
                    float vspace = 0.2f * height;
                    width = tl.getVisibleAdvance();
                    float xo = (float)(bounds.getX() + bounds.getWidth() + (double)tl.getAscent() + (double)vspace);
                    float yo = (float)(bounds.getY() + bounds.getHeight() / 2.0 + (double)(width / 2.0f));
                    this.textBounds = new Rectangle2D.Double(bounds.getX() + bounds.getWidth(), yo - width - vspace, height + 2.0f * vspace, width + 2.0f * vspace);
                    gc.rotate(-1.5707963267948966, xo, yo);
                    AttributedCharacterIterator iter = this.as.getIterator(attributes);
                    gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                    gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                    gc.drawString(iter, xo, yo);
                    gc.rotate(1.5707963267948966, xo, yo);
                    this.textAngle = -1.5707963267948966;
                    break;
                }
            }
        } else {
            this.textBounds = null;
            this.textAngle = 0.0;
        }
        return this.textBounds;
    }

    public void drawText(Graphics2D gc, boolean redraw, Color c, int caret) {
        if (this.lbm == null) {
            return;
        }
        Rectangle2D.Double bounds = this.flipIfNeeded(this.boundsD);
        if (redraw && c != null) {
            this.as.addAttribute(TextAttribute.FOREGROUND, c);
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), gc.getFontRenderContext());
        }
        this.lbm.setPosition(0);
        float width = (float)bounds.width;
        float height = (float)bounds.height;
        int wrappingWidth = (int)Math.ceil(Math.max(10.0, bounds.width - (double)(2 * this.getPad())));
        block0 : switch (this.textAnchor) {
            default: {
                TextLayout tl = this.lbm.nextLayout(wrappingWidth);
                height = tl.getAscent() + tl.getDescent();
                width = tl.getVisibleAdvance();
                float vspace = 0.2f * height;
                while ((tl = this.lbm.nextLayout(wrappingWidth)) != null) {
                    width = Math.max(width, tl.getVisibleAdvance());
                    height += tl.getAscent() + tl.getDescent() + tl.getLeading();
                }
                int twidth = Math.round(width);
                int start = (int)Math.round(bounds.x + (bounds.width - (double)width) / 2.0);
                float yo = this.textAnchor == 0 ? (float)(bounds.y + bounds.height / 2.0 - (double)(height / 2.0f)) : (this.textAnchor == 3 ? (float)(bounds.y - (double)height - (double)vspace) : (float)(bounds.y + bounds.height + (double)vspace));
                this.lbm.setPosition(0);
                tl = this.lbm.nextLayout(wrappingWidth);
                float xo = this.getTextAnchor(tl, start, twidth);
                yo += tl.getAscent();
                int prev = 0;
                int next = this.lbm.getPosition();
                while (true) {
                    if (redraw) {
                        AttributedCharacterIterator iter = this.as.getIterator(attributes, prev, next);
                        gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                        gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                        gc.drawString(iter, xo, yo);
                    }
                    if (caret != -1 && caret >= prev && caret < next) {
                        this.drawCaret(gc, caret - prev, xo, yo, tl);
                    }
                    yo += tl.getDescent();
                    tl = this.lbm.nextLayout(wrappingWidth);
                    if (tl == null) break block0;
                    xo = this.getTextAnchor(tl, start, twidth);
                    prev = next;
                    next = this.lbm.getPosition();
                    yo += tl.getLeading() + tl.getAscent();
                }
            }
            case 1: {
                TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
                height = tl.getAscent() + tl.getDescent();
                float vspace = 0.2f * height;
                width = tl.getVisibleAdvance();
                float xo = (float)(bounds.x - (double)tl.getDescent() - (double)vspace);
                float yo = (float)(bounds.y + bounds.height / 2.0 + (double)(width / 2.0f));
                gc.rotate(-1.5707963267948966, xo, yo);
                if (redraw) {
                    AttributedCharacterIterator iter = this.as.getIterator(attributes);
                    gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                    gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                    gc.drawString(iter, xo, yo);
                }
                if (caret != -1) {
                    this.drawCaret(gc, caret, xo, yo, tl);
                }
                gc.rotate(1.5707963267948966, xo, yo);
                break;
            }
            case 2: {
                TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
                height = tl.getAscent() + tl.getDescent();
                float vspace = 0.2f * height;
                width = tl.getVisibleAdvance();
                float xo = (float)(bounds.x + bounds.width + (double)tl.getAscent() + (double)vspace);
                float yo = (float)(bounds.y + bounds.height / 2.0 + (double)(width / 2.0f));
                gc.rotate(-1.5707963267948966, xo, yo);
                if (redraw) {
                    AttributedCharacterIterator iter = this.as.getIterator(attributes);
                    gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                    gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                    gc.drawString(iter, xo, yo);
                }
                if (caret != -1) {
                    this.drawCaret(gc, caret, xo, yo, tl);
                }
                gc.rotate(1.5707963267948966, xo, yo);
            }
        }
        if (c != null) {
            this.as.addAttribute(TextAttribute.FOREGROUND, this.textColor);
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), gc.getFontRenderContext());
        }
    }

    protected void drawCaret(Graphics2D gc, int caret, float xo, float yo, TextLayout tl) {
        Shape[] carets = tl.getCaretShapes(caret);
        gc.setColor(Color.white);
        gc.translate(xo, yo);
        gc.draw(carets[0]);
        gc.translate(1, 0);
        gc.setColor(Color.black);
        gc.draw(carets[0]);
        gc.translate(-xo - 1.0f, -yo);
    }

    public double getTextAngle() {
        return this.textAngle;
    }

    public abstract boolean isInDataSpace();

    public Rectangle getDataBoundingBox() {
        if (this.container == null) {
            return null;
        }
        return this.container.getDataBoundingBox();
    }

    public Shape getTextBoundingBox() {
        if (this.textBounds != null) {
            return this.textBounds;
        }
        return new Rectangle();
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.boundsD.getCenterX(), this.boundsD.getCenterY());
    }

    protected int getCaret(Point2D p) {
        float xo;
        float yo;
        TextLayout tl;
        if (this.lbm == null || this.label == null) {
            return -1;
        }
        int size = this.label.length();
        this.lbm.setPosition(0);
        float width = (float)this.boundsD.getWidth();
        float height = (float)this.boundsD.getHeight();
        int wrappingWidth = Math.max(10, (int)Math.floor(width) - 2 * this.getPad());
        Rectangle bounds = this.boundsD.getBounds();
        int offset = 0;
        block0 : switch (this.textAnchor) {
            default: {
                tl = this.lbm.nextLayout(wrappingWidth);
                height = tl.getAscent() + tl.getDescent();
                width = tl.getVisibleAdvance();
                float vspace = 0.2f * height;
                while ((tl = this.lbm.nextLayout(wrappingWidth)) != null) {
                    width = Math.max(width, tl.getVisibleAdvance());
                    height += tl.getAscent() + tl.getDescent() + tl.getLeading();
                }
                int twidth = Math.round(width);
                int start = Math.round((float)(bounds.x + bounds.width / 2) - width / 2.0f);
                yo = this.textAnchor == 0 ? (float)(bounds.y + bounds.height / 2) - height / 2.0f : (this.textAnchor == 3 ? (float)bounds.y - height - vspace : (float)(bounds.y + bounds.height) + vspace);
                this.lbm.setPosition(0);
                tl = this.lbm.nextLayout(wrappingWidth);
                xo = this.getTextAnchor(tl, start, twidth);
                double dy = tl.getAscent() + tl.getDescent() + tl.getLeading();
                double py = p.getY();
                while ((double)yo + dy <= py) {
                    offset = this.lbm.getPosition();
                    tl = this.lbm.nextLayout(wrappingWidth);
                    if (tl == null) break block0;
                    xo = this.getTextAnchor(tl, start, twidth);
                    yo = (float)((double)yo + dy);
                }
                break;
            }
            case 1: {
                tl = this.lbm.nextLayout(2.1474836E9f);
                height = tl.getAscent() + tl.getDescent();
                float vspace = 0.2f * height;
                width = tl.getVisibleAdvance();
                xo = (float)bounds.x - tl.getDescent() - vspace;
                yo = (float)(bounds.y + bounds.height / 2) + width / 2.0f;
                p = AffineTransform.getRotateInstance(1.5707963267948966, xo, yo).transform(p, p);
                break;
            }
            case 2: {
                tl = this.lbm.nextLayout(2.1474836E9f);
                height = tl.getAscent() + tl.getDescent();
                float vspace = 0.2f * height;
                width = tl.getVisibleAdvance();
                xo = (float)(bounds.x + bounds.width) + tl.getAscent() + vspace;
                yo = (float)(bounds.y + bounds.height / 2) + width / 2.0f;
                p = AffineTransform.getRotateInstance(1.5707963267948966, xo, yo).transform(p, p);
            }
        }
        if (tl == null) {
            return size;
        }
        TextHitInfo thi = tl.hitTestChar((float)p.getX() - xo, (float)p.getY() - yo);
        int caret = 0;
        if (thi != null) {
            caret = offset + thi.getInsertionIndex();
        }
        if (caret > size) {
            caret = size;
        }
        return caret;
    }

    public int getJustify() {
        return this.justify;
    }

    public void setJustify(int justify) {
        this.justify = justify;
    }

    protected float getTextAnchor(TextLayout tl, int xo, int totalWidth) {
        int width = (int)tl.getVisibleAdvance();
        float start = this.justify == 2 ? (float)(xo + totalWidth - width) : (this.justify == 1 ? (float)xo : (float)xo + (float)(totalWidth - width) / 2.0f);
        return start;
    }

    protected float getTextAnchor(TextLayout tl, float xo, float totalWidth) {
        float width = tl.getVisibleAdvance();
        float start = this.justify == 2 ? xo + totalWidth - width : (this.justify == 1 ? xo : xo + (totalWidth - width) / 2.0f);
        return start;
    }

    protected int getPad() {
        return 0;
    }

    protected Rectangle2D.Double flipIfNeeded(Rectangle2D.Double bounds) {
        Rectangle2D.Double r = bounds;
        if (bounds.width < 0.0 || bounds.height < 0.0) {
            double x = bounds.x;
            double y = bounds.y;
            double width = bounds.width;
            double height = bounds.height;
            if (width < 0.0) {
                x += width;
                width *= -1.0;
            }
            if (height < 0.0) {
                y += height;
                height *= -1.0;
            }
            r = new Rectangle2D.Double(x, y, width, height);
        }
        return r;
    }

    public void scaleFromCenter(int x, int y, boolean snapToGrid) {
    }

    public void resetAdjusters() {
    }

    public boolean isBadData() {
        return this.badData;
    }

    public abstract void undoMove();

    public abstract ArrayList<Point> getAllScreenPoints();

    public abstract void setAllScreenPoints(ArrayList<Point> var1);

    public abstract ArrayList<PointAndSpace> getAllPointAndSpacePoints();

    public abstract void setAllPointAndSpacePoints(ArrayList<PointAndSpace> var1);

    public abstract void drawText(Graphics2D var1, int var2, boolean var3, Color var4);

    public abstract int getCaretPosition(int var1, int var2);

    public double getMarkerOffsetX() {
        return this.xOffset;
    }

    public void setMarkerOffsetX(double offset) {
        this.xOffset = offset;
    }

    public double getMarkerOffsetY() {
        return this.yOffset;
    }

    public void setMarkerOffsetY(double offset) {
        this.yOffset = offset;
    }

    public double getMarkerScaleX() {
        return this.xScale;
    }

    public void setMarkerScaleX(double scale) {
        this.xScale = scale;
    }

    public double getMarkerScaleY() {
        return this.yScale;
    }

    public void setMarkerScaleY(double scale) {
        this.yScale = scale;
    }

    public double getMarkerRotation() {
        return this.rotation;
    }

    public void setMarkerRotation(double angle) {
        this.rotation = angle;
    }

    public void paint(Graphics2D g2d, Color color, Color edgeColor, int x, int y, int w, int h) {
    }

    public void paint(Graphics2D g2d, Color color, Color edgeColor, double x, double y, int w, int h) {
    }

    public Shape[] getImageMapRegions() {
        return new Shape[]{this.getRegion()};
    }

    public ArrayList<Point2D.Double> getAllScreenPoint2Ds() {
        ArrayList<Point> pts = this.getAllScreenPoints();
        if (pts == null) {
            return null;
        }
        ArrayList<Point2D.Double> dpts = new ArrayList<Point2D.Double>();
        for (Point p : pts) {
            dpts.add(AbstractAnno.getPoint(p));
        }
        return dpts;
    }

    public void setAllScreenPoint2Ds(ArrayList<Point2D.Double> points) {
        if (points == null) {
            this.setAllScreenPoints(null);
        }
        ArrayList<Point> pts = new ArrayList<Point>();
        for (Point2D.Double p : points) {
            pts.add(AbstractAnno.getPoint(p));
        }
        this.setAllScreenPoints(pts);
    }

    public static Point getPoint(Point2D.Double pt) {
        return new Point((int)Math.round(pt.getX()), (int)Math.round(pt.getY()));
    }

    static Point2D.Double getPoint(Point pt) {
        return new Point2D.Double(pt.getX(), pt.getY());
    }
}

