/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.batchsec.model;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SASLibrary;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GenerateCode {
    private static final WAdminResource bundle = new WAdminResource(GenerateCode.class);
    public static final String newline = System.getProperty("line.separator");
    private static final int LINE_LENGTH = 70;
    private static final String START = "/* ";
    private static final String END = " */";

    public static StringBuffer getExportCode(SASLibrary lib, String tableName, String cubeName, String schemaName, Class thisClass, boolean submitcode) {
        StringBuffer code = new StringBuffer();
        GenerateCode.addExportCommentBlock(code);
        code.append(newline);
        String msg = bundle.getString("GenerateCode.Export.NoConnection.txt");
        code.append("%let noConnectMsg=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Export.AttributeNotFound.txt");
        code.append("%let noAttrMsg=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Export.NoObjectMatch.txt");
        code.append("%let noMatch=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Export.NoObjectFound.txt");
        code.append("%let notFound=").append(msg).append(";").append(newline);
        try {
            String line;
            if (!submitcode) {
                GenerateCode.addMetaPortServer(code);
            }
            code.append(LibraryUtil.getAccessPath((SASLibrary)lib));
            code.append(newline);
            code.append("%let aciOlapTable=");
            code.append(lib.getLibref());
            code.append(".");
            code.append(tableName);
            code.append(";").append(newline);
            code.append("%let cubename=");
            if (!Utilities.isBlank((String)cubeName)) {
                code.append(cubeName);
            }
            code.append(";").append(newline);
            code.append("%let olapschema=");
            if (!Utilities.isBlank((String)schemaName)) {
                code.append(schemaName);
            }
            code.append(";").append(newline);
            InputStream is = thisClass.getResourceAsStream("export_aci.sas");
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                code.append(line);
                code.append(newline);
            }
            br.close();
            isr.close();
            is.close();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (IOException e1) {
            ExceptionHandler.handleException((Exception)e1);
        }
        return code;
    }

    public static StringBuffer getImportCode(SASLibrary lib, String tableName, Class thisClass, boolean submitCode) {
        StringBuffer code = new StringBuffer();
        GenerateCode.addImportCommentBlock(code);
        code.append(newline);
        String msg = bundle.getString("GenerateCode.Import.NoPersonFOund.txt");
        code.append("%let noPerson=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.problemRecordNumber.txt");
        code.append("%let recordNo=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.invalidPERMTYpe.txt");
        code.append("%let invalidPerm=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.invalidRemoveACE.txt");
        code.append("%let invalidRemoveACE=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.NoConnection.txt");
        code.append("%let noConnect=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.DimensionNotFound.txt");
        code.append("%let dimNotFound=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.HierarchyNotFound.txt");
        code.append("%let hierNotFound=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.MeasureNotFound.txt");
        code.append("%let measureNotFound=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.LevelNotFound.txt");
        code.append("%let levelNotFound=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.ErrorSettingPermCond.txt");
        code.append("%let errorSettingPermCond=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.SuccessSettingPermCond.txt");
        code.append("%let successSettingPermCond=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.ErrorSettingRead.txt");
        code.append("%let errorSettingRead=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.SuccessSettingRead.txt");
        code.append("%let successSettingRead=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.ErrorSettingReadMetadata.txt");
        code.append("%let errorSettingReadMetadata=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.SuccessSettingReadMetadata.txt");
        code.append("%let successSettingReadMetadata=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.ErrorOnRecordNumber.txt");
        code.append("%let errorRecordNumber=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.ErrorSettingPerm.txt");
        code.append("%let errorSettingPerm=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.PermissionSet.txt");
        code.append("%let permissionSet=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.NoConnection.txt");
        code.append("%let noConnectMsg=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.AttributeNotFound.txt");
        code.append("%let noAttrMsg=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.NoObjectMatch.txt");
        code.append("%let noMatch=").append(msg).append(";").append(newline);
        msg = bundle.getString("GenerateCode.Import.NoObjectFound.txt");
        code.append("%let notFound=").append(msg).append(";").append(newline);
        try {
            String line;
            if (!submitCode) {
                GenerateCode.addMetaPortServer(code);
            }
            code.append(LibraryUtil.getAccessPath((SASLibrary)lib));
            code.append(newline);
            code.append("%let aciOlapTable=");
            code.append(lib.getLibref());
            code.append(".");
            code.append(tableName);
            code.append(";").append(newline);
            InputStream is = thisClass.getResourceAsStream("import_aci.sas");
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                code.append(line);
                code.append(newline);
            }
            br.close();
            isr.close();
            is.close();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (IOException e1) {
            ExceptionHandler.handleException((Exception)e1);
        }
        return code;
    }

    public static StringBuffer getDeleteTableCode(HashMap mapOfLibraries) {
        StringBuffer code = new StringBuffer();
        try {
            for (SASLibrary lib : mapOfLibraries.keySet()) {
                code.append(LibraryUtil.getAccessPath((SASLibrary)lib)).append(newline);
            }
            code.append(newline);
            for (SASLibrary lib : mapOfLibraries.keySet()) {
                ArrayList listOfTables = (ArrayList)mapOfLibraries.get(lib);
                code.append("PROC DATASETS LIBRARY = ").append(lib.getLibref()).append(";");
                code.append(newline);
                code.append("     DELETE ");
                int size = listOfTables.size();
                for (int a = 0; a < size; ++a) {
                    String tableName = (String)listOfTables.get(a);
                    code.append(newline);
                    code.append("            ").append(tableName).append(newline);
                }
                code.append(";").append(newline).append(newline).append("run;");
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return code;
    }

    private static void addMetaPortServer(StringBuffer code) {
        try {
            UserContextInterface userContext = Workspace.getWorkspace().getUserContext();
            ServerInterface serverInterface = userContext.getAuthServer();
            code.append("%let metaPort       = %nrquote(").append(serverInterface.getPort()).append(");").append(newline);
            code.append("%let metaServer     = %nrquote(").append(serverInterface.getHost()).append(");").append(newline);
            code.append(newline);
            code.append("options metaport    = &metaPort ").append(newline);
            code.append("        metaserver  = \"&metaServer\";").append(newline).append(newline);
        }
        catch (ServiceException e) {
            Workspace.handleServiceException((ServiceException)e);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    private static void addExportCommentBlock(StringBuffer code) {
        String nextLine;
        int i;
        code.append("/").append(GenerateCode.repeat("*", 68)).append("/");
        String line = bundle.getString("GenerateCode.Export.NameComment.txt");
        List lines = GenerateCode.splitString(line, 64);
        for (i = 0; i < lines.size(); ++i) {
            nextLine = (String)lines.get(i);
            code.append(newline);
            code.append(START).append(nextLine.trim()).append(GenerateCode.repeat(" ", 64 - nextLine.length())).append(END);
        }
        line = bundle.getString("GenerateCode.Export.TitleComment.txt");
        lines = GenerateCode.splitString(line, 64);
        for (i = 0; i < lines.size(); ++i) {
            nextLine = (String)lines.get(i);
            code.append(newline);
            code.append(START).append(nextLine.trim()).append(GenerateCode.repeat(" ", 64 - nextLine.length())).append(END);
        }
        line = bundle.getString("GenerateCode.Export.NoteComment.txt");
        lines = GenerateCode.splitString(line, 64);
        for (i = 0; i < lines.size(); ++i) {
            nextLine = (String)lines.get(i);
            code.append(newline);
            code.append(START).append(nextLine.trim()).append(GenerateCode.repeat(" ", 64 - nextLine.length())).append(END);
        }
        code.append(newline);
        code.append("/").append(GenerateCode.repeat("*", 68)).append("/");
        code.append(newline);
    }

    private static void addImportCommentBlock(StringBuffer code) {
        String nextLine;
        int i;
        code.append("/").append(GenerateCode.repeat("*", 68)).append("/");
        String line = bundle.getString("GenerateCode.Import.NameComment.txt");
        List lines = GenerateCode.splitString(line, 64);
        for (i = 0; i < lines.size(); ++i) {
            nextLine = (String)lines.get(i);
            code.append(newline);
            code.append(START).append(nextLine.trim()).append(GenerateCode.repeat(" ", 64 - nextLine.length())).append(END);
        }
        line = bundle.getString("GenerateCode.Import.TitleComment.txt");
        lines = GenerateCode.splitString(line, 64);
        for (i = 0; i < lines.size(); ++i) {
            nextLine = (String)lines.get(i);
            code.append(newline);
            code.append(START).append(nextLine.trim()).append(GenerateCode.repeat(" ", 64 - nextLine.length())).append(END);
        }
        code.append(newline);
        code.append("/").append(GenerateCode.repeat("*", 68)).append("/");
        code.append(newline);
    }

    private static String repeat(String repeatString, int numRepeats) {
        StringBuffer newString = new StringBuffer();
        for (int i = 0; i < numRepeats; ++i) {
            newString.append(repeatString);
        }
        return newString.toString();
    }

    private static List splitString(String string, int lineLength) {
        ArrayList<String> lineList = new ArrayList<String>();
        string = string.replaceAll("\n", "").replaceAll("\r", "");
        while (string.length() > 0) {
            if (string.length() <= lineLength) {
                lineList.add(string);
                break;
            }
            String blank = "X";
            int index = lineLength + 1;
            while (!blank.equals(" ") && index > 0) {
                blank = string.substring(--index, index + 1);
            }
            if (index <= 0) {
                index = lineLength - 1;
            }
            String line = string.substring(0, index).trim();
            lineList.add(line);
            string = string.substring(index);
        }
        return lineList;
    }
}

