/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.image;

import com.objectplanet.image.Encoder;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class IndexedEncoder
extends Encoder {
    private FastHashtable paletteMap = new FastHashtable();
    protected ByteArrayOutputStream paletteChunk = new ByteArrayOutputStream();
    protected boolean palette_set;

    IndexedEncoder(int n) {
        super(n);
        this.colorType = 3;
    }

    synchronized void encode(Image image, DataOutputStream dataOutputStream) throws IOException {
        this.paletteChunk.reset();
        this.paletteChunk.write("PLTE".getBytes());
        this.palette_set = false;
        super.encode(image, dataOutputStream);
    }

    protected void writeChunks(DataOutputStream dataOutputStream) throws IOException {
        this.writeChunk(this.headerChunk, dataOutputStream);
        this.writeChunk(this.paletteChunk, dataOutputStream);
        this.writeChunk(this.idatChunk, dataOutputStream);
    }

    protected void initPalette() {
        int n = 0;
        int n2 = 0xFFFFFF;
        while (n < 3) {
            this.paletteChunk.write(-1);
            this.paletteChunk.write(-1);
            this.paletteChunk.write(-1);
            this.paletteMap.put(n2, n);
            ++n;
        }
        int n3 = 50;
        while (n3 <= 255) {
            int n4 = 50;
            while (n4 <= 255) {
                int n5 = 50;
                while (n5 <= 255) {
                    if (n3 != n4 || n3 != n5) {
                        n2 = n3 << 16 | n4 << 8 | n5;
                        this.paletteChunk.write((byte)n3);
                        this.paletteChunk.write((byte)n4);
                        this.paletteChunk.write((byte)n5);
                        this.paletteMap.put(n2, n);
                        ++n;
                    }
                    n5 += 41;
                }
                n4 += 41;
            }
            n3 += 41;
        }
        n3 = 0;
        while (n3 <= 252) {
            n2 = n3 << 16 | n3 << 8 | n3;
            this.paletteChunk.write(n3);
            this.paletteChunk.write(n3);
            this.paletteChunk.write(n3);
            this.paletteMap.put(n2, n);
            ++n;
            n3 += 6;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (colorModel == null || nArray == null) {
            return;
        }
        if (!this.palette_set) {
            this.initPalette();
            this.palette_set = true;
        }
        if (this.pngPixels == null || this.pngPixels.length < n6 + 1) {
            this.pngPixels = new byte[n6 + 1];
        }
        int n7 = nArray.length / n6;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n7) {
            this.pngPixels[0] = 0;
            int n10 = 0;
            while (n10 < n6) {
                this.setPixel(colorModel, nArray[n8], n10);
                ++n8;
                ++n10;
            }
            try {
                this.deflaterOut.write(this.pngPixels, 0, n6 + 1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n9;
        }
    }

    protected void setPixel(ColorModel colorModel, int n, int n2) {
        int n3;
        int n4;
        int n5 = n >> 16 & 0xFF;
        int n6 = n >> 8 & 0xFF;
        int n7 = n & 0xFF;
        float f = Math.abs(n5 - n6);
        f = Math.max(f, (float)Math.abs(n5 - n7));
        if ((f = Math.max(f, (float)Math.abs(n7 - n6))) < 24.0f || n5 < 50 && n6 < 50 && n7 < 50) {
            n4 = (int)((double)n5 * 0.3 + (double)n6 * 0.59 + (double)n7 * 0.11);
            n4 = (int)Math.round((double)n4 / 6.0) * 6;
            n4 = Math.max(n4, 6);
            n4 = Math.min(n4, 252);
            n3 = n4 << 16 | n4 << 8 | n4;
        } else {
            n4 = (int)Math.round((double)(n5 - 50) / 41.0) * 41 + 50;
            int n8 = (int)Math.round((double)(n6 - 50) / 41.0) * 41 + 50;
            int n9 = (int)Math.round((double)(n7 - 50) / 41.0) * 41 + 50;
            n4 = Math.max(n4, 50);
            n8 = Math.max(n8, 50);
            n9 = Math.max(n9, 50);
            if (n4 == n8 && n8 == n9) {
                n8 = n9 = (n4 = (int)Math.round((double)n4 / 6.0) * 6);
            }
            n3 = n4 << 16 | n8 << 8 | n9;
        }
        n4 = this.paletteMap.get(n3);
        this.pngPixels[n2 + 1] = n4 >= 0 ? (byte)n4 : (byte)0;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (colorModel == null || byArray == null) {
            return;
        }
        if (!this.palette_set) {
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[256];
            byte[] byArray4 = new byte[256];
            ((IndexColorModel)colorModel).getReds(byArray2);
            ((IndexColorModel)colorModel).getGreens(byArray3);
            ((IndexColorModel)colorModel).getBlues(byArray4);
            int n7 = 0;
            while (n7 < 256) {
                this.paletteChunk.write(byArray2[n7]);
                this.paletteChunk.write(byArray3[n7]);
                this.paletteChunk.write(byArray4[n7]);
                ++n7;
            }
            this.palette_set = true;
        }
        try {
            this.deflaterOut.write(0);
            this.deflaterOut.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class FastHashtable {
        HashEntry[] table = new HashEntry[101];

        FastHashtable() {
        }

        void put(int n, int n2) {
            int n3 = (n & Integer.MAX_VALUE) % this.table.length;
            HashEntry hashEntry = this.table[n3];
            while (hashEntry != null) {
                if (hashEntry.key == n) {
                    hashEntry.value = n2;
                    return;
                }
                hashEntry = hashEntry.next;
            }
            hashEntry = new HashEntry();
            hashEntry.key = n;
            hashEntry.value = n2;
            hashEntry.next = this.table[n3];
            this.table[n3] = hashEntry;
        }

        int get(int n) {
            int n2 = (n & Integer.MAX_VALUE) % this.table.length;
            HashEntry hashEntry = this.table[n2];
            while (hashEntry != null) {
                if (hashEntry.key == n) {
                    return hashEntry.value;
                }
                hashEntry = hashEntry.next;
            }
            return -1;
        }

        void clear() {
            int n = 0;
            while (n < this.table.length) {
                this.table[n] = null;
                ++n;
            }
        }

        class HashEntry {
            int key;
            int value;
            HashEntry next;

            HashEntry() {
            }
        }
    }
}

