/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.image;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

abstract class Encoder
implements ImageConsumer {
    private ImageProducer producer;
    protected ByteArrayOutputStream headerChunk;
    protected ByteArrayOutputStream idatChunk;
    protected DeflaterOutputStream deflaterOut;
    protected Deflater deflater;
    private CRC32 crc;
    protected int colorType;
    protected byte[] pngPixels;
    private boolean encoding;
    private int compressionLevel = -1;

    Encoder(int n) {
        this.setCompression(n);
        this.headerChunk = new ByteArrayOutputStream();
        this.idatChunk = new ByteArrayOutputStream();
        this.crc = new CRC32();
    }

    void setCompression(int n) {
        if (n < -1 || n > 9) {
            throw new IllegalArgumentException("Invalid compression: " + n);
        }
        this.compressionLevel = n;
    }

    synchronized void encode(Image image, DataOutputStream dataOutputStream) throws IOException {
        if (image == null || dataOutputStream == null) {
            return;
        }
        this.headerChunk.reset();
        this.crc.reset();
        this.idatChunk.reset();
        this.idatChunk.write("IDAT".getBytes("US-ASCII"));
        this.deflater = new Deflater(this.compressionLevel);
        this.deflaterOut = new DeflaterOutputStream((OutputStream)this.idatChunk, this.deflater);
        this.encoding = true;
        this.producer = image.getSource();
        this.producer.startProduction(this);
        while (this.encoding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.deflaterOut.finish();
        this.deflater.end();
        this.writeChunks(dataOutputStream);
    }

    public void setDimensions(int n, int n2) {
        this.headerChunk.reset();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(this.headerChunk);
            dataOutputStream.write("IHDR".getBytes("US-ASCII"));
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n2);
            dataOutputStream.write(8);
            dataOutputStream.write(this.colorType);
            dataOutputStream.write(0);
            dataOutputStream.write(0);
            dataOutputStream.write(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public abstract void setPixels(int var1, int var2, int var3, int var4, ColorModel var5, int[] var6, int var7, int var8);

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (colorModel == null || byArray == null) {
            return;
        }
        int[] nArray = new int[byArray.length];
        int n7 = 0;
        while (n7 < byArray.length) {
            nArray[n7] = byArray[n7] & 0xFF;
            ++n7;
        }
        this.setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
    }

    public synchronized void imageComplete(int n) {
        this.producer.removeConsumer(this);
        this.encoding = false;
        this.notifyAll();
    }

    protected void writeChunks(DataOutputStream dataOutputStream) throws IOException {
        this.writeChunk(this.headerChunk, dataOutputStream);
        this.writeChunk(this.idatChunk, dataOutputStream);
    }

    protected void writeChunk(ByteArrayOutputStream byteArrayOutputStream, DataOutputStream dataOutputStream) throws IOException {
        if (byteArrayOutputStream != null && dataOutputStream != null) {
            dataOutputStream.writeInt(byteArrayOutputStream.size() - 4);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.write(byArray);
            this.crc.reset();
            this.crc.update(byArray);
            dataOutputStream.writeInt((int)this.crc.getValue());
        }
    }

    public void setProperties(Hashtable hashtable) {
    }

    public void setHints(int n) {
    }
}

