/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.client;

import com.sas.svcs.commons.webservice.client.SecurityToken;
import com.sas.svcs.commons.webservice.client.ServiceRegistryClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.soap.security.wss4j2.Wss4jSecurityInterceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
public class SecurityTokenServiceClient
implements Serializable {
    private static final Logger logger = LogManager.getLogger(SecurityTokenServiceClient.class);
    private static final long serialVersionUID = 1L;
    private static final String WS_SC_NS = "http://schemas.xmlsoap.org/ws/2005/02/sc";
    private static final String WS_SC_IDENTIFIER = "Identifier";
    private static final String WS_TRUST_NS = "http://schemas.xmlsoap.org/ws/2005/02/trust";
    private static final String WS_TRUST_BINARY_SECRET = "BinarySecret";
    private static final String WSS_SEC_UTIL_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private static final String WSS_SEC_EXT_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String WSS_SEC_UTIL_CREATED = "Created";
    private static final String WSS_SEC_UTIL_EXPIRES = "Expires";
    private static final String WSS_SEC_EXT_REFERENCE = "Reference";
    private static final String WSS_SEC_EXT_REFERENCE_URI = "URI";
    private static final String SECURITY_TOKEN_SERVICE_NAME = "SecurityTokenService";
    private static final String REQUEST_FILE = "SecurityTokenServiceRequest.xml";
    private static final String CANCEL_REQUEST_FILE = "SecurityTokenServiceCancelRequest.xml";
    protected String userid;
    protected String password;
    protected String serviceRegistryURL;
    protected String securityTokenServiceURL;
    protected SecurityToken token;

    public SecurityTokenServiceClient(String serviceRegistryURL, String userid, String password) {
        this.serviceRegistryURL = serviceRegistryURL;
        ServiceRegistryClient srClient = new ServiceRegistryClient(serviceRegistryURL);
        srClient.obtainServices();
        this.securityTokenServiceURL = srClient.getServiceURL(SECURITY_TOKEN_SERVICE_NAME);
        this.userid = userid;
        this.password = password;
    }

    public void obtainToken() {
        logger.info("Obtaining Token");
        StreamSource request = new StreamSource(SecurityTokenServiceClient.class.getResourceAsStream(REQUEST_FILE));
        Document responseDoc = this.call(request);
        Element responseElem = responseDoc.getDocumentElement();
        Element idNode = SecurityTokenServiceClient.getOnlyIfOneElement(responseElem, WS_SC_NS, WS_SC_IDENTIFIER);
        String securityContextKey = idNode.getTextContent();
        Element secretNode = SecurityTokenServiceClient.getOnlyIfOneElement(responseElem, WS_TRUST_NS, WS_TRUST_BINARY_SECRET);
        String binarySecret = secretNode.getTextContent();
        Element createdNode = SecurityTokenServiceClient.getOnlyIfOneElement(responseElem, WSS_SEC_UTIL_NS, WSS_SEC_UTIL_CREATED);
        Date created = this.parseXmlDateTime(createdNode.getTextContent());
        Element expiresNode = SecurityTokenServiceClient.getOnlyIfOneElement(responseElem, WSS_SEC_UTIL_NS, WSS_SEC_UTIL_EXPIRES);
        Date expires = this.parseXmlDateTime(expiresNode.getTextContent());
        if (logger.isInfoEnabled()) {
            logger.info("SecurityContextKey: " + securityContextKey);
            logger.info("BinarySecret: " + binarySecret);
            logger.info("Created: " + created);
            logger.info("Expires: " + expires);
        }
        this.token = new SecurityToken(securityContextKey, binarySecret, created, expires);
    }

    public void cancelToken() {
        if (this.token != null) {
            logger.info("Cancelling Token");
            try {
                DOMSource request = new DOMSource(this.getCancelRequest());
                this.call(request);
            }
            catch (Exception e) {
                logger.warn("Failure when cancelling token. It is very likely that this is because the token has already expired", (Throwable)e);
            }
            finally {
                this.token = null;
            }
        }
    }

    public String getServiceRegistryURL() {
        return this.serviceRegistryURL;
    }

    private Document getCancelRequest() {
        try {
            StreamSource requestTemplate = new StreamSource(SecurityTokenServiceClient.class.getResourceAsStream(CANCEL_REQUEST_FILE));
            DOMResult request = new DOMResult();
            TransformerFactory.newInstance().newTransformer().transform(requestTemplate, request);
            Document requestDoc = (Document)request.getNode();
            Element requestElem = requestDoc.getDocumentElement();
            Element refElem = SecurityTokenServiceClient.getOnlyIfOneElement(requestElem, WSS_SEC_EXT_NS, WSS_SEC_EXT_REFERENCE);
            refElem.setAttribute(WSS_SEC_EXT_REFERENCE_URI, this.token.getSecurityContextKey());
            if (logger.isDebugEnabled()) {
                this.printXML(requestDoc, "Cancel Request");
            }
            return requestDoc;
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    private Document call(Source request) {
        DOMResult response = new DOMResult();
        WebServiceTemplate wsTemplate = new WebServiceTemplate();
        this.addSecurityInterceptor(wsTemplate);
        wsTemplate.sendSourceAndReceiveToResult(this.securityTokenServiceURL, request, new WebServiceMessageCallback(){

            public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
                if (logger.isDebugEnabled()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    message.writeTo((OutputStream)baos);
                    logger.debug("WS Request:\n" + baos.toString());
                }
            }
        }, (Result)response);
        Document responseDoc = (Document)response.getNode();
        if (logger.isDebugEnabled()) {
            this.printXML(responseDoc, "XML response");
        }
        return responseDoc;
    }

    private void addSecurityInterceptor(WebServiceTemplate wsTemplate) {
        try {
            Wss4jSecurityInterceptor securityInterceptor = new Wss4jSecurityInterceptor();
            securityInterceptor.setSecurementUsername(this.userid);
            if (this.password != null) {
                securityInterceptor.setSecurementPassword(this.password);
            } else {
                securityInterceptor.setSecurementPassword(this.userid);
            }
            String actions = "UsernameToken Timestamp";
            String passwordType = "PasswordText";
            securityInterceptor.setSecurementActions(actions);
            securityInterceptor.setSecurementPasswordType(passwordType);
            securityInterceptor.setValidateResponse(false);
            securityInterceptor.afterPropertiesSet();
            wsTemplate.setInterceptors(new ClientInterceptor[]{securityInterceptor});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized SecurityToken getSecurityToken() {
        if (this.token == null) {
            this.obtainToken();
        } else if (this.token.isExpired()) {
            logger.info("Token Expired Or about to expire");
            this.token = null;
            this.obtainToken();
        }
        return this.token;
    }

    public String getSecurityContextKey() {
        return this.token.getSecurityContextKey();
    }

    public String getBinarySecret() {
        return this.token.getBinarySecret();
    }

    private static Element getOnlyIfOneElement(Element elem, String namespaceURI, String localName) {
        NodeList childElems = elem.getElementsByTagNameNS(namespaceURI, localName);
        if (childElems != null && childElems.getLength() == 1) {
            return (Element)childElems.item(0);
        }
        String errorStr = "Error: None or More than one element found for: " + namespaceURI + ":" + localName;
        logger.error(errorStr);
        throw new RuntimeException(errorStr);
    }

    private Date parseXmlDateTime(String str) {
        try {
            XMLGregorianCalendar cal = DatatypeFactory.newInstance().newXMLGregorianCalendar(str);
            return cal.toGregorianCalendar().getTime();
        }
        catch (DatatypeConfigurationException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private void printXML(Node node, String message) {
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(node), new StreamResult(sw));
            logger.debug(message + ":\n" + sw.toString());
        }
        catch (Exception e) {
            logger.debug("IGNORING - Error while printing " + message, (Throwable)e);
        }
    }
}

