/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.client;

import com.sas.svcs.commons.webservice.client.MarshallingCallback;
import com.sas.svcs.commons.webservice.client.ProxyHelperException;
import com.sas.svcs.commons.webservice.client.SecurityContext;
import com.sas.svcs.commons.webservice.client.SecurityToken;
import com.sas.svcs.commons.webservice.client.SecurityTokenServiceClient;
import com.sas.svcs.commons.webservice.client.UnmarshallingExtractor;
import com.sas.svcs.commons.webservice.client.UnmarshallingFaultMessageResolver;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.FaultMessageResolver;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceMessageExtractor;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.SaajSoapMessageFactory;
import org.springframework.ws.soap.security.wss4j2.Wss4jSecurityInterceptor;
import org.springframework.ws.transport.WebServiceMessageSender;

public class ProxyHelperNew
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(ProxyHelperNew.class);
    private static final String SECURITY_POLICY_DIGEST = "com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml";
    private static final String TOKEN_EXPIRED_MSG = "com.sun.xml.wss.impl.WssSoapFaultException: Authentication of Username Password Token Failed";
    private static final String TOKEN_EXPIRED_MSG_WSS4J = "The security token could not be authenticated or authorized;";
    private boolean soap12;
    private SecurityContext secContext = new SecurityContext();

    public ProxyHelperNew() {
    }

    public ProxyHelperNew(boolean soap12) {
        this.soap12 = soap12;
    }

    public void setUserid(String userid) {
        this.secContext.setUserid(userid);
    }

    public String getUserid() {
        return this.secContext.getUserid();
    }

    public void setPassword(String password) {
        this.secContext.setPassword(password);
    }

    public String getPassword() {
        return this.secContext.getPassword();
    }

    public void setSecurityTokenServiceClient(SecurityTokenServiceClient stsClient) {
        this.secContext.setStsClient(stsClient);
    }

    public SecurityTokenServiceClient getSecurityTokenServiceClient() {
        return this.secContext.getStsClient();
    }

    public void setSecurityPolicy(String securityPolicy) {
        this.secContext.setSecurityPolicy(securityPolicy);
    }

    public String getSecurityPolicy() {
        return this.secContext.getSecurityPolicy();
    }

    public void setSecurityOptional(boolean securityOptional) {
        this.secContext.setSecurityOptional(securityOptional);
    }

    public boolean isSecurityOptional() {
        return this.secContext.isSecurityOptional();
    }

    public Object call(String uri, String action, Object requestPayload, String binding) {
        return this.call(uri, action, requestPayload, binding, null);
    }

    public Object call(String uri, String action, Object requestPayload, String binding, String contextPath) {
        return this.callWithSender(uri, action, requestPayload, binding, contextPath, null);
    }

    protected Object callWithSender(String uri, String action, Object requestPayload, String binding, String contextPath, WebServiceMessageSender sender) {
        String[] inParamBindings;
        Object[] inParams;
        if (requestPayload != null) {
            inParams = new Object[]{requestPayload};
            inParamBindings = new String[]{binding};
        } else {
            inParams = new Object[]{};
            inParamBindings = new String[]{};
        }
        return this.callWithSender(uri, action, null, inParams, inParamBindings, null, binding, null, binding, contextPath, sender);
    }

    public Object call(String uri, String action, String encInElem, Object[] inParams, String[] inParamBindings, String encOutElem, String outParamBinding, String faultBinding, String contextPath) {
        return this.callWithSender(uri, action, encInElem, inParams, inParamBindings, encOutElem, outParamBinding, null, faultBinding, contextPath, null);
    }

    protected Object callWithSender(String uri, String action, String encInElem, Object[] inParams, String[] inParamBindings, String encOutElem, String outParamBinding, String statefulElem, String faultBinding, String contextPath, WebServiceMessageSender sender) {
        if (inParams == null || inParamBindings == null || inParams.length != inParamBindings.length) {
            logger.error("Error in setup - inParams or inParamBindings are null OR their lengths are different");
            throw new RuntimeException("Error in setup - inParams or inParamBindings are null OR their lengths are different");
        }
        WebServiceTemplate wsTemplate = this.createTemplate(uri, sender, this.secContext);
        MarshallingCallback requestCallback = new MarshallingCallback(action, encInElem, inParams, inParamBindings, contextPath);
        UnmarshallingExtractor responseExtractor = new UnmarshallingExtractor(encOutElem, outParamBinding, contextPath, statefulElem);
        if (faultBinding != null) {
            wsTemplate.setFaultMessageResolver((FaultMessageResolver)new UnmarshallingFaultMessageResolver(faultBinding, contextPath));
        }
        return this.callWithSender(wsTemplate, requestCallback, responseExtractor);
    }

    private Object callWithSender(WebServiceTemplate wsTemplate, WebServiceMessageCallback requestCallback, WebServiceMessageExtractor responseExtractor) {
        try {
            return wsTemplate.sendAndReceive(requestCallback, responseExtractor);
        }
        catch (ProxyHelperException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (RuntimeException e) {
            String exceptionMsg;
            if (this.secContext.getStsClient() != null && (exceptionMsg = e.getMessage()) != null && (exceptionMsg.startsWith(TOKEN_EXPIRED_MSG) || exceptionMsg.startsWith(TOKEN_EXPIRED_MSG_WSS4J))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Retrying Request. Token Expired Fault: " + e.getMessage());
                }
                this.secContext.getStsClient().cancelToken();
                return wsTemplate.sendAndReceive(requestCallback, responseExtractor);
            }
            logger.error((Object)e);
            throw e;
        }
    }

    private WebServiceTemplate createTemplate(String uri, WebServiceMessageSender sender, SecurityContext secContext) {
        WebServiceTemplate wsTemplate = new WebServiceTemplate();
        wsTemplate.setDefaultUri(uri);
        if (this.soap12) {
            try {
                SaajSoapMessageFactory messageFactory = new SaajSoapMessageFactory();
                messageFactory.setSoapVersion(SoapVersion.SOAP_12);
                messageFactory.afterPropertiesSet();
                wsTemplate.setMessageFactory((WebServiceMessageFactory)messageFactory);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
        }
        if (sender != null) {
            wsTemplate.setMessageSender(sender);
        }
        this.addSecurityInterceptor(wsTemplate);
        return wsTemplate;
    }

    private void addSecurityInterceptor(WebServiceTemplate wsTemplate) {
        try {
            String user = null;
            String password = null;
            if (this.secContext.getStsClient() != null) {
                SecurityToken token = this.secContext.getStsClient().getSecurityToken();
                user = token.getSecurityContextKey();
                password = token.getBinarySecret();
            } else if (this.secContext.getUserid() != null) {
                user = this.secContext.getUserid();
                password = this.secContext.getPassword();
            }
            if (user != null) {
                Wss4jSecurityInterceptor securityInterceptor = new Wss4jSecurityInterceptor();
                securityInterceptor.setSecurementUsername(user);
                if (password != null) {
                    securityInterceptor.setSecurementPassword(password);
                } else {
                    securityInterceptor.setSecurementPassword(user);
                }
                String actions = "UsernameToken";
                String passwordType = "PasswordText";
                boolean tokenCreated = false;
                boolean tokenNonce = false;
                if (SECURITY_POLICY_DIGEST.equals(this.secContext.getSecurityPolicy())) {
                    actions = actions + " Timestamp";
                    passwordType = "PasswordDigest";
                    tokenCreated = true;
                    tokenNonce = true;
                }
                securityInterceptor.setSecurementActions(actions);
                securityInterceptor.setSecurementPasswordType(passwordType);
                if (tokenCreated && tokenNonce) {
                    securityInterceptor.setSecurementUsernameTokenNonce(tokenNonce);
                    securityInterceptor.setSecurementUsernameTokenCreated(tokenCreated);
                }
                securityInterceptor.setValidateResponse(false);
                securityInterceptor.afterPropertiesSet();
                wsTemplate.setInterceptors(new ClientInterceptor[]{securityInterceptor});
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }
}

