/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.client;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.ClassPathResource;

public class ProxyHelperHttpInvoker {
    private static final Logger logger = LogManager.getLogger(ProxyHelperHttpInvoker.class);
    private static final String CLASSPATH_PREFIX = "classpath*:";
    private static final String META_INF_DIR = "META-INF/";
    private static final String REGISTRY_CONFIG_FILE = "services-client-registry-config.xml";
    private static final String AOP_CONFIG_FILE = "services-client-registry-aop-config.xml";
    private static final String APP_AOP_CONFIG_FILE = "aop-config.xml";
    private static final String DEFAULT_AOP_CONFIG_FILE = "com/sas/svcs/commons/webservice/client/default-aop-config.xml";
    private static final String SERVICE_REGISTRY_CONFIG_FILE = "com/sas/svcs/commons/webservice/client/ServiceRegistrySpringConfig.xml";
    private ApplicationContext appContext;

    public ProxyHelperHttpInvoker(String key, String serviceRegistryURL, String url) {
        String aopConfigFile;
        String regConfigFile;
        if (key != null && key.length() > 0) {
            regConfigFile = "classpath*:META-INF/" + key + "-" + REGISTRY_CONFIG_FILE;
            aopConfigFile = META_INF_DIR + key + "-" + AOP_CONFIG_FILE;
        } else {
            regConfigFile = "classpath*:META-INF/services-client-registry-config.xml";
            aopConfigFile = "META-INF/services-client-registry-aop-config.xml";
        }
        ArrayList<String> contextFilesColl = new ArrayList<String>();
        contextFilesColl.add(regConfigFile);
        if (this.aopConfigFileExists(APP_AOP_CONFIG_FILE)) {
            contextFilesColl.add(APP_AOP_CONFIG_FILE);
        } else if (this.aopConfigFileExists(aopConfigFile)) {
            contextFilesColl.add(aopConfigFile);
        } else if (this.aopConfigFileExists(DEFAULT_AOP_CONFIG_FILE)) {
            if (logger.isInfoEnabled()) {
                logger.info("Using default AOP Config for application key: " + key);
            }
            contextFilesColl.add(DEFAULT_AOP_CONFIG_FILE);
        }
        if (serviceRegistryURL != null) {
            contextFilesColl.add(SERVICE_REGISTRY_CONFIG_FILE);
        }
        String[] contextFiles = contextFilesColl.toArray(new String[0]);
        ClassPathXmlApplicationContext classpathAppContext = new ClassPathXmlApplicationContext(contextFiles, false);
        Properties props = new Properties();
        if (serviceRegistryURL != null) {
            props.put("cfcompiler.serviceRegistryURL", serviceRegistryURL);
        }
        if (url != null) {
            props.put("cfcompiler.serviceURL", url);
        }
        PropertyPlaceholderConfigurer configurer = new PropertyPlaceholderConfigurer();
        configurer.setProperties(props);
        classpathAppContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configurer);
        classpathAppContext.refresh();
        this.appContext = classpathAppContext;
    }

    public Object getBean(String beanName) {
        return this.appContext.getBean(beanName);
    }

    private boolean aopConfigFileExists(String aopConfigFile) {
        return new ClassPathResource(aopConfigFile).exists();
    }
}

