/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.client;

import com.sas.svcs.registry.client.RegisteredService;
import com.sas.svcs.registry.client.ServiceRegistryInterface;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProxyFactory {
    private static final Logger logger = LogManager.getLogger(ProxyFactory.class);
    private static final String INTERFACE_PROXY_CLASS = "META-INF/interface-to-proxy-class.properties";
    private static final String SERVICE_REGISTRY_SERVICE_NAME = "ServiceRegistry";
    private static Properties interfaceToProxyClassName;

    public static <T> T getProxy(Class<T> interfaceClass, ServiceRegistryInterface serviceRegistry) {
        RegisteredService regService = serviceRegistry.getService(SERVICE_REGISTRY_SERVICE_NAME);
        if (regService == null) {
            String errorMsg = "ServiceRegistry Service not found";
            logger.error("ServiceRegistry Service not found");
            throw new RuntimeException("ServiceRegistry Service not found");
        }
        return ProxyFactory.getProxy(interfaceClass, regService.getUrl());
    }

    public static <T> T getProxy(Class<T> interfaceClass, String serviceRegistryUrl) {
        try {
            String proxyClassName = ProxyFactory.getInterfaceToProxyClassName().getProperty(interfaceClass.getName());
            if (proxyClassName != null) {
                Class<?> proxyClass = Class.forName(proxyClassName);
                Constructor<?> constructor = proxyClass.getConstructor(String.class);
                return interfaceClass.cast(constructor.newInstance(serviceRegistryUrl));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Proxy class name for service interface: " + interfaceClass.getName() + " not found");
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e);
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e);
            }
            return null;
        }
        catch (IllegalAccessException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e);
            }
            return null;
        }
        catch (InstantiationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e);
            }
            return null;
        }
        catch (InvocationTargetException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getTargetException());
            }
            return null;
        }
    }

    private static synchronized Properties getInterfaceToProxyClassName() {
        if (interfaceToProxyClassName == null) {
            try {
                interfaceToProxyClassName = new Properties();
                Enumeration<URL> urls = ProxyFactory.class.getClassLoader().getResources(INTERFACE_PROXY_CLASS);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    interfaceToProxyClassName.load(url.openStream());
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
        }
        return interfaceToProxyClassName;
    }
}

