/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.client;

import com.sas.svcs.commons.webservice.jaxb.Jaxb2DynamicMarshaller;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.oxm.xmlbeans.XmlBeansMarshaller;

public class MarshallingSupport {
    private static final Logger logger = LogManager.getLogger(MarshallingSupport.class);
    private static final String XMLBEANS_MARSHALLER = "xmlbeansMarshaller";
    private static final String JAXB_MARSHALLER = "jaxbMarshaller";
    private static final String JAXB_ATTACHMENT_MARSHALLER = "jaxbAttachmentMarshaller";
    private static final String JAXB_DYNAMIC_MARSHALLER = "jaxbDynamicMarshaller";
    private static final String JAXB_ATTACHMENT_DYNAMIC_MARSHALLER = "jaxbAttachmentDynamicMarshaller";
    private static DocumentBuilderFactory docBuilderFactory;
    private static TransformerFactory transformerFactory;
    private static Map<String, Object> marshallerMap;

    protected static synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        if (docBuilderFactory == null) {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return docBuilderFactory;
    }

    protected static synchronized TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    protected static synchronized Marshaller getMarshaller(String binding, String contextPath) {
        return (Marshaller)MarshallingSupport.getMarshallerUnmarshaller(binding, contextPath);
    }

    protected static synchronized Unmarshaller getUnmarshaller(String binding, String contextPath) {
        return (Unmarshaller)MarshallingSupport.getMarshallerUnmarshaller(binding, contextPath);
    }

    private static Object getMarshallerUnmarshaller(String binding, String contextPath) {
        if (marshallerMap == null) {
            marshallerMap = new HashMap<String, Object>();
        }
        if (XMLBEANS_MARSHALLER.equals(binding)) {
            XmlBeansMarshaller xmlbeansMarshaller = (XmlBeansMarshaller)marshallerMap.get(XMLBEANS_MARSHALLER);
            if (xmlbeansMarshaller == null) {
                xmlbeansMarshaller = new XmlBeansMarshaller();
                xmlbeansMarshaller.setValidating(false);
                marshallerMap.put(XMLBEANS_MARSHALLER, xmlbeansMarshaller);
            }
            return xmlbeansMarshaller;
        }
        if (JAXB_MARSHALLER.equals(binding)) {
            if (contextPath == null) {
                logger.error("NULL context path for binding: " + binding);
                throw new RuntimeException("NULL context path for binding: " + binding);
            }
            String key = JAXB_MARSHALLER + contextPath;
            Jaxb2Marshaller jaxb2Marshaller = (Jaxb2Marshaller)marshallerMap.get(key);
            if (jaxb2Marshaller == null) {
                try {
                    jaxb2Marshaller = new Jaxb2Marshaller();
                    jaxb2Marshaller.setContextPath(contextPath);
                    jaxb2Marshaller.afterPropertiesSet();
                    marshallerMap.put(key, jaxb2Marshaller);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    throw new RuntimeException(e);
                }
            }
            return jaxb2Marshaller;
        }
        if (JAXB_ATTACHMENT_MARSHALLER.equals(binding)) {
            if (contextPath == null) {
                logger.error("NULL context path for binding: " + binding);
                throw new RuntimeException("NULL context path for binding: " + binding);
            }
            String key = JAXB_ATTACHMENT_MARSHALLER + contextPath;
            Jaxb2Marshaller jaxb2AttachmentMarshaller = (Jaxb2Marshaller)marshallerMap.get(key);
            try {
                jaxb2AttachmentMarshaller = new Jaxb2Marshaller();
                jaxb2AttachmentMarshaller.setContextPath(contextPath);
                jaxb2AttachmentMarshaller.setMtomEnabled(true);
                jaxb2AttachmentMarshaller.afterPropertiesSet();
                marshallerMap.put(key, jaxb2AttachmentMarshaller);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
            return jaxb2AttachmentMarshaller;
        }
        if (JAXB_DYNAMIC_MARSHALLER.equals(binding)) {
            Jaxb2DynamicMarshaller jaxb2DynamicMarshaller = (Jaxb2DynamicMarshaller)marshallerMap.get(JAXB_DYNAMIC_MARSHALLER);
            if (jaxb2DynamicMarshaller == null) {
                try {
                    jaxb2DynamicMarshaller = new Jaxb2DynamicMarshaller();
                    jaxb2DynamicMarshaller.afterPropertiesSet();
                    marshallerMap.put(JAXB_DYNAMIC_MARSHALLER, jaxb2DynamicMarshaller);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    throw new RuntimeException(e);
                }
            }
            return jaxb2DynamicMarshaller;
        }
        if (JAXB_ATTACHMENT_DYNAMIC_MARSHALLER.equals(binding)) {
            Jaxb2DynamicMarshaller jaxb2AttachmentDynamicMarshaller = (Jaxb2DynamicMarshaller)marshallerMap.get(JAXB_ATTACHMENT_DYNAMIC_MARSHALLER);
            try {
                jaxb2AttachmentDynamicMarshaller = new Jaxb2DynamicMarshaller();
                jaxb2AttachmentDynamicMarshaller.setMtomEnabled(true);
                jaxb2AttachmentDynamicMarshaller.afterPropertiesSet();
                marshallerMap.put(JAXB_ATTACHMENT_DYNAMIC_MARSHALLER, jaxb2AttachmentDynamicMarshaller);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
            return jaxb2AttachmentDynamicMarshaller;
        }
        logger.error("Unknown XML binding: " + binding);
        throw new RuntimeException("Unknown XML binding: " + binding);
    }
}

