/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.client;

import com.sas.svcs.commons.webservice.client.MarshallingSupport;
import com.sas.svcs.commons.webservice.util.SASMarshallingUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.oxm.Marshaller;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.soap.addressing.client.ActionCallback;
import org.springframework.ws.support.MarshallingUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class MarshallingCallback
implements WebServiceMessageCallback {
    private static final Logger logger = LogManager.getLogger(MarshallingCallback.class);
    private String action;
    private String encInElem;
    private Object[] inParams;
    private String[] inParamBindings;
    private String contextPath;

    public MarshallingCallback(String action, String encInElem, Object[] inParams, String[] inParamBindings, String contextPath) {
        this.action = action;
        this.encInElem = encInElem;
        this.inParams = inParams;
        this.inParamBindings = inParamBindings;
        this.contextPath = contextPath;
    }

    public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
        if (this.action != null) {
            try {
                new ActionCallback(this.action).doWithMessage(message);
            }
            catch (URISyntaxException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
        }
        if (this.encInElem == null) {
            if (this.inParams.length > 1) {
                logger.error("Error in setup - inParams length is more than one when encInElem is null");
                throw new RuntimeException("Error in setup - inParams length is more than one when encInElem is null");
            }
            if (this.inParams.length == 1) {
                Object requestPayload = this.inParams[0];
                String binding = this.inParamBindings[0];
                Marshaller marshaller = MarshallingSupport.getMarshaller(binding, this.contextPath);
                MarshallingUtils.marshal((Marshaller)marshaller, (Object)requestPayload, (WebServiceMessage)message);
            }
        } else {
            try {
                Document doc = MarshallingSupport.getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                QName encElemQName = QName.valueOf(this.encInElem);
                Element elem = doc.createElementNS(encElemQName.getNamespaceURI(), encElemQName.getLocalPart());
                doc.appendChild(elem);
                DocumentFragment docFrag = doc.createDocumentFragment();
                DOMResult result = new DOMResult(docFrag);
                for (int i = 0; i < this.inParams.length; ++i) {
                    Object inParam = this.inParams[i];
                    String binding = this.inParamBindings[i];
                    Marshaller marshaller = MarshallingSupport.getMarshaller(binding, this.contextPath);
                    SASMarshallingUtils.marshal((Marshaller)marshaller, (Object)inParam, (Result)result, (WebServiceMessage)message);
                }
                elem.appendChild(docFrag);
                MarshallingSupport.getTransformerFactory().newTransformer().transform(new DOMSource(doc), message.getPayloadResult());
            }
            catch (ParserConfigurationException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
        }
        if (logger.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            message.writeTo((OutputStream)baos);
            logger.debug("WS Request:\n" + baos.toString());
        }
    }
}

