/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.util.NumberUtil;
import com.sas.util.transforms.TransformInputOutputInterface;
import java.util.Locale;

public class StringToFloatTransform
implements TransformInputOutputInterface {
    static final long serialVersionUID = 4539523488635769533L;
    public static final StringToFloatTransform defaultInstance = new StringToFloatTransform();
    private Locale locale;

    public StringToFloatTransform() {
        this(null);
    }

    public StringToFloatTransform(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Object transform(Object input) {
        if (input == null) {
            return new Float(0.0f);
        }
        String trimmedInput = ((String)input).trim();
        if (trimmedInput.length() == 0) {
            return new Float(0.0f);
        }
        if (this.locale == null) {
            return new Float(NumberUtil.floatValueOf(trimmedInput));
        }
        return new Float(NumberUtil.floatValueOf(trimmedInput, this.locale));
    }

    @Override
    public Class getInputClass() {
        return String.class;
    }

    @Override
    public Class getOutputClass() {
        return Float.class;
    }
}

