/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DateType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.util.GenericComparator;
import com.sas.util.Util;
import com.sas.util.transforms.ObjectToStringTransform;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@SASScope
public class ValueItem
implements Comparable {
    private String label;
    private Object labelObject;
    private Object value;
    private transient Map attributeMap;
    public static String PARENT = "Parent";
    private ObjectToStringTransform defaultTransform;

    public ValueItem() {
        this(null, null);
    }

    public ValueItem(Object labelObject, Object value) {
        if (labelObject instanceof String) {
            this.label = (String)labelObject;
        } else {
            this.setLabelObject(labelObject);
        }
        this.value = value;
        this.defaultTransform = new ObjectToStringTransform(){

            @Override
            public Object transform(Object input) {
                if (input instanceof Date) {
                    if (input instanceof Time) {
                        return TimeType.DEFAULT_INSTANCE.getDisplayString(input, this.locale);
                    }
                    if (input instanceof Timestamp) {
                        return TimeStampType.DEFAULT_INSTANCE.getDisplayString(input, this.locale);
                    }
                    return DateType.DEFAULT_INSTANCE.getDisplayString(input, this.locale);
                }
                return super.transform(input);
            }
        };
        this.defaultTransform.setNullString("");
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.getLabel(null);
    }

    public String getLabel(Locale locale) {
        if (locale != null && this.defaultTransform != null) {
            this.defaultTransform.setLocale(locale);
        }
        if (this.label == null && this.labelObject != null) {
            this.label = (String)this.defaultTransform.transform(this.labelObject);
        } else if (this.label == null && this.value != null) {
            return (String)this.defaultTransform.transform(this.getValue());
        }
        return this.label;
    }

    public String getValueAsString() {
        return this.getValueAsString(null);
    }

    public String getValueAsString(Locale locale) {
        if (locale != null && this.defaultTransform != null) {
            this.defaultTransform.setLocale(locale);
        }
        if (this.getValue() != null) {
            return (String)this.defaultTransform.transform(this.getValue());
        }
        return null;
    }

    public void setLabelObject(Object labelObject) {
        this.labelObject = labelObject;
    }

    public Object getLabelObject() {
        return this.labelObject;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public Collection getAttributesNames() {
        if (this.attributeMap == null) {
            return Collections.EMPTY_LIST;
        }
        return this.attributeMap.keySet();
    }

    public Object getAttribute(String attributeName) {
        if (this.attributeMap == null) {
            return null;
        }
        return this.attributeMap.get(attributeName);
    }

    public void setAttribute(String attributeName, Object value) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Null attribute names are not allowed.");
        }
        if (value instanceof Object[]) {
            throw new IllegalArgumentException("Array attribute values are not allowed.");
        }
        this._getAttributesNonNull().put(attributeName, value);
    }

    private Map _getAttributesNonNull() {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap(2);
        }
        return this.attributeMap;
    }

    public String toString() {
        if (this.getLabel() != null) {
            return this.getLabel();
        }
        if (this.getLabelObject() != null) {
            return this.getLabelObject().toString();
        }
        if (this.getValue() != null) {
            return (String)this.defaultTransform.transform(this.getValue());
        }
        return "";
    }

    public int hashCode() {
        int code = 0;
        if (this.getLabel() != null) {
            code += this.getLabel().hashCode();
        }
        if (this.getValue() != null) {
            code += this.getValue().hashCode();
        }
        if (this.attributeMap != null) {
            code += this.attributeMap.hashCode();
        }
        return code;
    }

    public boolean equals(Object otherValue) {
        if (otherValue instanceof ValueItem) {
            ValueItem otherItem = (ValueItem)otherValue;
            if (!Util.equal(this.getLabel(), otherItem.getLabel())) {
                return false;
            }
            if (!Util.equal(this.getLabelObject(), otherItem.getLabelObject())) {
                return false;
            }
            if (!Util.equal(this.getValue(), otherItem.getValue())) {
                return false;
            }
            if (this.attributeMap != null && otherItem.attributeMap != null) {
                if (otherItem.attributeMap == this.attributeMap) {
                    return true;
                }
                if (otherItem.attributeMap.size() != this.attributeMap.size()) {
                    return false;
                }
                for (Map.Entry e : this.attributeMap.entrySet()) {
                    Object key = e.getKey();
                    Object value = e.getValue();
                    if (!(value == null ? otherItem.attributeMap.get(key) != null || !otherItem.attributeMap.containsKey(key) : !Util.equal(value, otherItem.attributeMap.get(key)))) continue;
                    return false;
                }
            } else if (!Util.equal(this.attributeMap, otherItem.attributeMap)) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(ValueItem vi) {
        Object v2;
        Object v1 = this.getLabel();
        int compare = GenericComparator.defaultInstance.compare(v1, v2 = vi.getLabel());
        if (compare == Integer.MAX_VALUE || compare == 0) {
            v1 = this.getLabelObject();
            v2 = vi.getLabelObject();
            compare = GenericComparator.defaultInstance.compare(v1, v2);
        }
        if (compare == Integer.MAX_VALUE || compare == 0) {
            v1 = this.getValue();
            v2 = vi.getValue();
            compare = GenericComparator.defaultInstance.compare(v1, v2);
        }
        return compare;
    }

    public int compareTo(Object obj) {
        return this.compareTo((ValueItem)obj);
    }
}

