/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.net.crypto.CipherInterface;
import com.sas.net.crypto.Crypto;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.ByteArrayInputStream;
import java.util.Properties;

@SASScope
public class Encryption {
    private static final String cryType = "SASPROPRIETARY";
    private static final String EMPTY_STRING = "";
    private static final String SAS_PASSWORD_PREFIX = "{sas";
    public static final String ENCRYPTION913_ENCODING_PROPERTY = "com.sas.util.encryption913.encoding";

    public static String encrypt(String input) {
        String encrypted = null;
        if (input != null) {
            if (input.indexOf(SAS_PASSWORD_PREFIX) == -1) {
                try {
                    encrypted = SasPasswordString.encode("sas002", input);
                }
                catch (SasPasswordEncodingException e) {
                    e.printStackTrace();
                }
            } else {
                encrypted = input;
            }
        }
        return encrypted;
    }

    public static String decrypt(String input) {
        String decrypted = null;
        if (input != null) {
            if (!input.startsWith(SAS_PASSWORD_PREFIX)) {
                decrypted = Encryption.safeDecrypt(input);
            } else {
                try {
                    decrypted = SasPasswordString.decode(input);
                }
                catch (SasPasswordEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return decrypted;
    }

    private static String safeDecrypt(String input) {
        if (input == null) {
            return null;
        }
        String ret = EMPTY_STRING;
        String charset = System.getProperty(ENCRYPTION913_ENCODING_PROPERTY);
        if (charset == null && System.getProperty("os.arch").contains("390")) {
            charset = "Cp1252";
        }
        if (charset != null) {
            if (charset.equals("default")) {
                charset = System.getProperty("file.encoding");
            }
            byte[] encryptedBytes = Encryption.convertHexStringToByteArray(input);
            try {
                Properties p = new Properties();
                Crypto sssss = Crypto.getCrypto(cryType, p);
                CipherInterface ci = sssss.openCipher();
                ByteArrayInputStream instr = new ByteArrayInputStream(encryptedBytes);
                byte[] result = new byte[ci.getMaxPlainTextLength(encryptedBytes.length)];
                int returnLength = ci.decrypt(instr, encryptedBytes.length, result, 0);
                ret = new String(result, 0, returnLength, charset);
            }
            catch (Exception e) {
                System.err.println("Internal error: com.sas.util.Encryption#safeDecrypt\n" + e);
                ret = null;
            }
            return ret;
        }
        byte[] expandedBinary = Encryption.convertHexStringToByteArray(input);
        for (int i = 0; i < expandedBinary.length; ++i) {
            ret = ret + (char)expandedBinary[i];
        }
        ret = Encryption.decryptString(ret);
        return ret;
    }

    private static String decryptString(String intext) {
        String ret = null;
        try {
            Properties p = new Properties();
            Crypto sssss = Crypto.getCrypto(cryType, p);
            CipherInterface ci = sssss.openCipher();
            byte[] inbytes = new byte[intext.length()];
            for (int i = 0; i < intext.length(); ++i) {
                char c = intext.charAt(i);
                inbytes[i] = (byte)c;
            }
            ByteArrayInputStream instr = new ByteArrayInputStream(inbytes);
            byte[] result = new byte[ci.getMaxPlainTextLength(inbytes.length)];
            int returnLength = ci.decrypt(instr, inbytes.length, result, 0);
            ret = new String(result, 0, returnLength);
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = null;
        }
        return ret;
    }

    private static byte[] convertHexStringToByteArray(String strValue) {
        byte[] byteArray = new byte[strValue.length() / 2];
        int byteIndex = 0;
        int length = strValue.length();
        if (System.getProperty("os.arch").contains("390") || System.getProperty(ENCRYPTION913_ENCODING_PROPERTY) != null) {
            for (int index = 0; index < length - 1; index += 2) {
                byteArray[byteIndex++] = (byte)Integer.parseInt(strValue.substring(index, index + 2), 16);
            }
            return byteArray;
        }
        byte[] charArray = strValue.getBytes();
        for (int index = 0; index < length; index += 2) {
            byteArray[byteIndex++] = Encryption.convertHexCharsToByte(charArray[index], charArray[index + 1]);
        }
        return byteArray;
    }

    private static byte convertHexCharsToByte(byte leftChar, byte rightChar) {
        int result = 0;
        boolean negative = false;
        int digit = leftChar >= 65 ? leftChar - 65 + 10 : leftChar - 48;
        result = -digit;
        digit = rightChar >= 65 ? rightChar - 65 + 10 : rightChar - 48;
        result *= 16;
        result -= digit;
        if (negative) {
            return (byte)result;
        }
        return (byte)(-result);
    }
}

