/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.text.InvalidFormatException;
import com.sas.text.TableEntry;

@SASScope
class Info {
    protected TableEntry te;
    protected String baseFormat;
    protected int width;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Info(TableEntry entry, String baseFormat, int width) throws InvalidFormatException {
        this.te = entry;
        if (width != -1) {
            if (width < entry.getMinWidth() || width > entry.getMaxWidth()) throw new InvalidFormatException("Width specified for format " + baseFormat + " is invalid.");
            this.width = width;
        } else {
            this.width = entry.getDefaultWidth();
        }
        this.baseFormat = baseFormat;
    }

    public String getBaseFormat() {
        return this.baseFormat;
    }

    public int getWidth() {
        return this.width;
    }

    public int getDefaultWidth() {
        return this.te.getDefaultWidth();
    }

    public TableEntry getEntry() {
        return this.te;
    }
}

