/*
 * Decompiled with CFR 0.152.
 */
package com.sas.nls.id;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;

public class IDStringException
extends Exception {
    private static final Map<Locale, ResourceBundle> bundles = Collections.synchronizedMap(new WeakHashMap());
    private static final String BUNDLE_NAME = "com.sas.nls.id.Resource";
    private String code = null;

    public IDStringException(String code) {
        this.code = code;
        ResourceBundle bundle = IDStringException.getResourceBundle(null);
        String message = bundle.getString(code);
        this.initCause(new Throwable(message));
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getLocalizedMessage() {
        ResourceBundle bundle = IDStringException.getResourceBundle(Locale.getDefault());
        return bundle.getString(this.code);
    }

    public String getLocalizedMessage(Locale locale) {
        ResourceBundle bundle = IDStringException.getResourceBundle(locale);
        return bundle.getString(this.code);
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle rb = bundles.get(locale);
        if (rb == null && (rb = locale == null ? ResourceBundle.getBundle(BUNDLE_NAME) : ResourceBundle.getBundle(BUNDLE_NAME, locale)) != null) {
            bundles.put(locale, rb);
        }
        return rb;
    }
}

