/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models.datasources;

import com.sas.models.datasources.DataSourceInterface;
import com.sas.util.Strings;
import java.io.Serializable;

public class BaseDataSource
implements DataSourceInterface,
Serializable {
    private long dataSourceType;
    private String dataSourceLocation;
    private static final long serialVersionUID = 543342012665779663L;

    public BaseDataSource() {
    }

    public BaseDataSource(long dataSourceType, String dataSourceLocation) {
        this.setDataSourceType(dataSourceType);
        this.dataSourceLocation = dataSourceLocation;
    }

    @Override
    public long getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(long dataSourceType) {
        if (dataSourceType != -1L && dataSourceType != 32L && dataSourceType != 16L && dataSourceType != 2L && dataSourceType != 8L && dataSourceType != 4L && dataSourceType != 1L) {
            throw new IllegalArgumentException("Invalid data source type");
        }
        this.dataSourceType = dataSourceType;
    }

    @Override
    public String getDataSourceLocation() {
        return this.dataSourceLocation;
    }

    public void setDataSourceLocation(String dataSourceLocation) {
        this.dataSourceLocation = dataSourceLocation;
    }

    public boolean equals(Object otherItem) {
        if (otherItem instanceof DataSourceInterface) {
            DataSourceInterface other = (DataSourceInterface)otherItem;
            if (this.getDataSourceType() != other.getDataSourceType()) {
                return false;
            }
            return Strings.equal(this.getDataSourceLocation(), other.getDataSourceLocation(), true, false);
        }
        return false;
    }

    public static String getDataSourceTypeName(int dataSourceType) {
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BaseDataSource clone = (BaseDataSource)super.clone();
        clone.setDataSourceLocation(this.getDataSourceLocation());
        clone.setDataSourceType(this.getDataSourceType());
        return clone;
    }

    public String toString() {
        return this.getDataSourceLocation() + " :: " + this.getDataSourceType();
    }
}

