/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.codepolicy.SASScope;
import com.sas.models.EncodingInterface;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.Strings;

@SASScope
public class EncodedString
implements EncodingInterface {
    private String encoding;
    private String value;
    private static final String encodingStringSAS001 = "{sas001}";
    private static final String encodingStringSAS002 = "{sas002}";

    public EncodedString(String encoding, String value) {
        this.setEncoding(encoding);
        if (value != null && (value.startsWith(encodingStringSAS001) || value.startsWith(encodingStringSAS002))) {
            try {
                this.value = SasPasswordString.decode(value);
            }
            catch (SasPasswordEncodingException e) {
                IllegalStateException ex = new IllegalStateException("Error decoding string.");
                ex.initCause(e);
                throw ex;
            }
        } else {
            this.value = value;
        }
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getEncodedValue() {
        try {
            if (this.encoding != null) {
                return SasPasswordString.encode(this.encoding, this.value);
            }
            return this.value;
        }
        catch (SasPasswordEncodingException e) {
            IllegalStateException ex = new IllegalStateException("Error encoding string.");
            ex.initCause(e);
            throw ex;
        }
    }

    public String toString() {
        return this.value;
    }

    public void setEncoding(String encoding) {
        if (encoding != "sas001" && encoding != "base64" && encoding != "sas002" && encoding != null) {
            throw new IllegalArgumentException("Invalid encoding argument, needed to be either SasPasswordString.SAS001_ENCODING, SasPasswordString.SAS002_ENCODING, SasPasswordString.BASE64_ENCODING, or null.");
        }
        this.encoding = encoding;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object otherItem) {
        if (otherItem instanceof EncodingInterface) {
            EncodingInterface other = (EncodingInterface)otherItem;
            return Strings.equal(this.getEncodedValue(), other.getEncodedValue(), true, false);
        }
        return false;
    }
}

