/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.io.RB;
import com.sas.io.ReaderProviderInterface;
import com.sas.io.RemoteReaderInterface;
import com.sas.text.Message;
import com.sas.util.UncheckedException;
import java.io.IOException;
import java.io.Reader;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;

public class RemoteReader
extends UnicastRemoteObject
implements RemoteReaderInterface {
    private Reader is;

    public RemoteReader(Reader is) throws RemoteException {
        this.is = is;
    }

    public RemoteReader(Reader is, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
        this.is = is;
    }

    @Override
    public boolean ready() throws IOException {
        return this.is.ready();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public synchronized void mark(int readlimit) throws IOException {
        this.is.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public char[] read(int maxread) throws IOException {
        if (maxread < 0) {
            String msg = Message.format(RB.getResources(), "RR.negArg.ex.fmt.txt", (Object)Integer.toString(maxread));
            throw new IllegalArgumentException(msg);
        }
        char[] b = new char[maxread];
        int nread = this.is.read(b);
        if (nread < 0) {
            return null;
        }
        if (nread < maxread) {
            char[] newb = new char[nread];
            for (int i = 0; i < nread; ++i) {
                newb[i] = b[i];
            }
            b = newb;
        }
        return b;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    public static Reader getReader(ReaderProviderInterface provider, Object streamID) throws IOException, RemoteException {
        Reader r;
        try {
            r = provider.getReader(streamID);
        }
        catch (UnmarshalException e) {
            RemoteReaderInterface rr = provider.getRemoteReader(streamID);
            r = new Proxy(rr);
        }
        return r;
    }

    private static class Proxy
    extends Reader {
        private RemoteReaderInterface reader;

        public Proxy(RemoteReaderInterface reader) {
            this.reader = reader;
        }

        @Override
        public boolean ready() throws IOException {
            return this.reader.ready();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public synchronized void mark(int readlimit) throws IOException {
            this.reader.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            try {
                return this.reader.markSupported();
            }
            catch (RemoteException e) {
                throw new UncheckedException(e, RB.getStringResource("RCOM.wrapCheck.ex.txt"));
            }
        }

        @Override
        public int read() throws IOException {
            return this.reader.read();
        }

        @Override
        public int read(char[] b) throws IOException {
            char[] tempbuf = this.reader.read(b.length);
            if (tempbuf == null) {
                return -1;
            }
            for (int i = 0; i < tempbuf.length; ++i) {
                b[i] = tempbuf[i];
            }
            return tempbuf.length;
        }

        @Override
        public int read(char[] b, int off, int len) throws IOException {
            char[] tempbuf = this.reader.read(len);
            if (tempbuf == null) {
                return -1;
            }
            for (int i = 0; i < tempbuf.length; ++i) {
                b[off++] = tempbuf[i];
            }
            return tempbuf.length;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.reader.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.reader.skip(n);
        }
    }
}

