/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.DataSourceType;
import com.sas.datatypes.RB;
import com.sas.models.OLAPMemberName;
import com.sas.models.OLAPMemberNameInterface;
import com.sas.models.datasources.BaseDataSource;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.text.Message;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroInfoSourceFacade;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class OLAPMemberNameType
extends BaseDataType {
    public static final String RB_KEY = "OLAPMemberNameType.";
    public static final OLAPMemberNameType DEFAULT_INSTANCE = new OLAPMemberNameType();

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue == null) {
            return inputValue;
        }
        if (inputValue instanceof OLAPMemberNameInterface) {
            return inputValue;
        }
        if (inputValue instanceof ValueItem) {
            Object o = this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
            String label = ((ValueItem)inputValue).getLabel();
            if (o instanceof OLAPMemberName && label != null) {
                ((OLAPMemberName)o).setLabel(label, inputLocale);
            }
            return o;
        }
        if (inputValue instanceof String) {
            return this.createOLAPMemberNameFromString((String)inputValue, inputLocale);
        }
        throw new IllegalArgumentException(Message.format(RB.getStringResource(RB_KEY, "olapMemberNameValueNotValid.ex.txt", inputLocale), inputValue));
    }

    private OLAPMemberNameInterface createOLAPMemberNameFromString(String text, Locale locale) throws IllegalArgumentException {
        String[] splitText = text.split(" :: ");
        BaseDataSource dataSource = null;
        String uniqueName = null;
        String label = null;
        if (splitText.length == 4) {
            String dataSourceLocation = splitText[0];
            String dataSourceType = splitText[1];
            uniqueName = splitText[2];
            label = splitText[3];
            dataSource = new BaseDataSource(Long.parseLong(dataSourceType), dataSourceLocation);
        } else if (splitText.length == 2) {
            uniqueName = splitText[0];
            label = splitText[1];
        } else if (splitText.length == 1) {
            uniqueName = splitText[0];
        } else {
            throw new IllegalArgumentException(Message.format(RB.getStringResource(RB_KEY, "olapMemberNameValueNotValid.ex.txt", locale), (Object)text));
        }
        OLAPMemberName olapMember = new OLAPMemberName(dataSource, uniqueName, label, locale);
        return olapMember;
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        OLAPMemberNameInterface olapMember = (OLAPMemberNameInterface)value;
        return DataSourceType.DEFAULT_INSTANCE.getValueAsString(olapMember.getDataSource(), outputLocale) + " :: " + olapMember.getUniqueName() + " :: " + olapMember.getLabel().getText(outputLocale);
    }

    @Override
    public String getDisplayString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        return ((OLAPMemberNameInterface)value).getLabel(outputLocale);
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        return this.coerceValue(input, Locale.US);
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return this.getValueAsString(value, Locale.US);
    }

    @Override
    public int getSQLType() {
        return 2000;
    }

    @Override
    public int getExpressionUsage() {
        return 12;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (value == null) {
            return this.getMacroVariablesForNull(macroInfoSource);
        }
        OLAPMemberNameInterface member = (OLAPMemberNameInterface)value;
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (member.getLabel(Locale.US) != null) {
            map.put(baseMacroVariableName, member.getLabel(Locale.US));
        }
        if (member.getUniqueName() != null) {
            map.put(baseMacroVariableName + "_name", member.getUniqueName());
        }
        if (member.getDataSource() != null && member.getDataSource().getDataSourceLocation() != null) {
            map.putAll(DataSourceType.DEFAULT_INSTANCE.getMacroVariableValues(new MacroInfoSourceFacade(macroInfoSource, "_source"), (Object)member.getDataSource(), locale));
        }
        return map;
    }

    @Override
    public Collection getPossibleMacroVariableExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(4);
        extensions.add("");
        extensions.add("_name");
        Collection dataSourceExtensions = DataSourceType.DEFAULT_INSTANCE.getPossibleMacroVariableExtensions();
        for (String ext : dataSourceExtensions) {
            extensions.add("_source" + ext);
        }
        return extensions;
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object retVal = this.coerceValue(value, inputLocale);
        if (retVal != null && retVal instanceof OLAPMemberNameInterface && retVal == value) {
            OLAPMemberNameInterface olap = (OLAPMemberNameInterface)retVal;
            OLAPMemberName outPut = new OLAPMemberName();
            outPut.setUniqueName(olap.getUniqueName());
            outPut.setLabel(olap.getLabel());
            if (olap.getDataSource() != null) {
                try {
                    outPut.setDataSource((DataSourceInterface)olap.getDataSource().clone());
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            return outPut;
        }
        return retVal;
    }
}

