/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.DateType;
import com.sas.datatypes.RB;
import com.sas.text.Message;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

@SASScope
public abstract class BaseDateType
extends BaseDataType {
    public static final String RB_KEY = "BaseDateType.";
    protected static TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    protected TimeZone timeZone;

    public BaseDateType() {
        this.timeZone = gmtTimeZone;
    }

    public BaseDateType(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((String)value).trim().length() == 0) {
            return null;
        }
        if (value instanceof MissingValues) {
            return MissingValues.toQueryString((MissingValues)value);
        }
        if (value instanceof SpecialValues) {
            return this.getSpecialValuesAsString((SpecialValues)value, outputLocale);
        }
        DateFormat formatter = null;
        formatter = this.getDateFormatter(value, outputLocale);
        this.setCalendarAndTimeZone(formatter);
        if (value instanceof Calendar) {
            return formatter.format(((Calendar)value).getTime());
        }
        if (value instanceof DatePeriod) {
            return ((DatePeriod)value).toString(formatter, outputLocale);
        }
        if (formatter != null) {
            return formatter.format(value);
        }
        return null;
    }

    @Override
    public String getDisplayString(Object value, Locale outputLocale) {
        if (value instanceof DatePeriod) {
            DateFormat formatter = null;
            formatter = this.getDateFormatter(value, outputLocale);
            this.setCalendarAndTimeZone(formatter);
            return ((DatePeriod)value).toDisplayString(formatter, outputLocale);
        }
        return super.getDisplayString(value, outputLocale);
    }

    protected void setCalendar(DateFormat formatter) {
        if (formatter != null) {
            Calendar cal = formatter.getCalendar();
            cal.setFirstDayOfWeek(2);
            cal.setMinimalDaysInFirstWeek(4);
            formatter.setCalendar(cal);
        }
    }

    protected void setCalendarAndTimeZone(DateFormat formatter) {
        if (formatter != null) {
            formatter.setTimeZone(this.timeZone);
        }
        this.setCalendar(formatter);
    }

    public abstract DateFormat getDateFormatter(Object var1, Locale var2);

    public abstract DateTypes getDateType();

    public abstract String getDefaultFormatName();

    @Override
    public int getSQLType() {
        return 91;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    protected Map getMacroVariableValuesForDatePeriod(DateTypes dateType, MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (this.isSpecialMacroValue(value)) {
            return this.getMacroVariablesForSpecialValues(macroInfoSource, value);
        }
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(baseMacroVariableName, DateType.formatSASDate((Date)value));
        if (value instanceof DatePeriod && ((DatePeriod)value).isRelativeDate()) {
            map.put(baseMacroVariableName + "_rel", value.toString());
        }
        Date endOfPeriod = new DatePeriod((Date)value, dateType, this.getTimeZone(), locale).getEndOfPeriod();
        map.put(baseMacroVariableName + "_end", DateType.formatSASDate(endOfPeriod));
        if (value instanceof Date) {
            map.put(baseMacroVariableName + "_label", this.getLabelForDate((Date)value, locale));
        } else {
            map.put(baseMacroVariableName + "_label", this.getDisplayString(value, locale));
        }
        return map;
    }

    protected String getLabelForDate(Date date, Locale locale) {
        if (date instanceof DatePeriod) {
            Date absDate = ((DatePeriod)date).getStartOfPeriod();
            String label = Message.format(RB.getStringResource(RB_KEY, "relativeDateLabel.txt", locale), (Object)this.getDisplayString(date, locale), (Object)this.getDisplayString(absDate, locale));
            return label;
        }
        return this.getDisplayString(date, locale);
    }

    @Override
    public Collection getPossibleMacroVariableExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(4);
        extensions.add("");
        extensions.add("_end");
        extensions.add("_rel");
        extensions.add("_label");
        return extensions;
    }
}

