/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class IndexedEnumeration
implements Enumeration,
Serializable {
    static final long serialVersionUID = 426674497607469026L;
    private Enumeration e;
    private boolean started;
    private int start;
    private int index;
    private int end;

    public IndexedEnumeration(Enumeration e, int start, int end) {
        this.e = e;
        this.start = start;
        this.end = end;
        this.index = 0;
        this.started = false;
    }

    public int getIndex() {
        if (this.started) {
            return this.index;
        }
        return this.start;
    }

    @Override
    public boolean hasMoreElements() {
        this.skipToStart();
        return this.start <= this.index && this.index < this.end && this.e.hasMoreElements();
    }

    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        ++this.index;
        return this.e.nextElement();
    }

    private void skipToStart() {
        if (this.started) {
            return;
        }
        this.started = true;
        while (this.index < this.start && this.e.hasMoreElements()) {
            ++this.index;
            Object e = this.e.nextElement();
        }
    }

    public Enumeration getEnumeration() {
        return this.e;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }
}

