/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui.model;

import com.platform.LSFJobFlow.api.JFTemplateParameterDef;
import com.platform.LSFJobFlow.ui.model.JFParamLine;
import com.platform.LSFJobFlow.ui.model.JFRepeatElemLine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class JFRepeatParamLine
extends JFParamLine {
    private String m_caption;
    private Vector m_elements;
    private int m_repeatElemsNum = 0;
    private boolean m_showElements = false;

    public JFRepeatParamLine(String paramName, String paramCaption, String[] input) {
        super(paramName, null);
        this.m_caption = paramCaption;
        this.m_elements = new Vector();
        this.m_repeatElemsNum = 0;
        if (input != null) {
            int j = input.length;
            for (int i = 0; i < j; ++i) {
                if (input[i] == null) {
                    return;
                }
                this.m_elements.add(new JFRepeatElemLine(++this.m_repeatElemsNum, paramName, input[i]));
            }
        }
    }

    @Override
    public void setParameterDefinition(JFTemplateParameterDef paramDef) {
        super.setParameterDefinition(paramDef);
        if (this.m_elements == null) {
            return;
        }
        JFRepeatElemLine item = null;
        int len = this.m_elements.size();
        for (int i = 0; i < len; ++i) {
            item = (JFRepeatElemLine)this.m_elements.get(i);
            if (item == null) continue;
            item.setParameterDefinition(paramDef);
        }
    }

    public String getCaption() {
        return this.m_caption;
    }

    public boolean isShowElements() {
        return this.m_showElements;
    }

    public void setShowElements(boolean flag) {
        this.m_showElements = flag;
    }

    public int getElementsNum() {
        if (this.m_elements != null) {
            return this.m_elements.size();
        }
        return 0;
    }

    public JFRepeatElemLine getElementAt(int idx) {
        if (this.m_elements == null || idx < 0) {
            return null;
        }
        Object ret = this.m_elements.elementAt(idx);
        if (ret instanceof JFRepeatElemLine) {
            return (JFRepeatElemLine)ret;
        }
        return null;
    }

    public boolean isLastElement(JFRepeatElemLine element) {
        return this.m_elements != null && this.m_elements.lastElement() == element;
    }

    public JFRepeatElemLine addNewElement() {
        if (this.m_isReadOnly || this.m_paramDef == null) {
            return null;
        }
        JFRepeatElemLine ret = new JFRepeatElemLine(++this.m_repeatElemsNum, this.m_paramName, null);
        if (this.m_paramDef != null) {
            ret.setParameterDefinition(this.m_paramDef);
        }
        this.m_elements.add(ret);
        this.m_isModified = true;
        return ret;
    }

    public boolean removeEmptyElementLines() {
        if (this.m_elements == null || this.m_elements.size() <= 0) {
            return false;
        }
        Iterator it = this.m_elements.iterator();
        JFRepeatElemLine item = null;
        Object lastElem = this.m_elements.lastElement();
        boolean found = false;
        while (it != null && it.hasNext() && (item = (JFRepeatElemLine)it.next()) != lastElem) {
            if (!item.isEmpty()) continue;
            it.remove();
            found = true;
        }
        if (found) {
            it = this.m_elements.iterator();
            this.m_repeatElemsNum = 0;
            while (it != null && it.hasNext()) {
                item = (JFRepeatElemLine)it.next();
                item.setSeqNo(++this.m_repeatElemsNum);
            }
        }
        return found;
    }

    public String[] getInputs() {
        if (this.m_elements == null || this.m_elements.size() <= 0) {
            return null;
        }
        Iterator it = this.m_elements.iterator();
        JFRepeatElemLine item = null;
        ArrayList<String> ret = new ArrayList<String>();
        while (it != null && it.hasNext()) {
            item = (JFRepeatElemLine)it.next();
            if (item.isEmpty()) continue;
            ret.add(item.getUserInput());
        }
        return ret.toArray(new String[0]);
    }

    @Override
    public Object getTabColumnObject(int column) {
        String ret = null;
        switch (column) {
            case 0: {
                if (this.m_showElements) {
                    ret = "[-]";
                    break;
                }
                ret = "[+]";
                break;
            }
            case 1: {
                if (this.m_caption != null) {
                    ret = this.m_caption;
                    break;
                }
                ret = this.m_paramName;
                break;
            }
            case 2: {
                StringBuffer buf = new StringBuffer();
                buf.append("[ ");
                boolean isFirst = true;
                if (this.m_elements != null) {
                    String value = null;
                    int j = this.m_elements.size();
                    for (int i = 0; i < j; ++i) {
                        value = ((JFRepeatElemLine)this.m_elements.elementAt(i)).getUserInput();
                        if (value == null) continue;
                        if (!isFirst) {
                            buf.append(",");
                        } else {
                            isFirst = false;
                        }
                        buf.append(value);
                    }
                }
                buf.append(" ]");
                ret = buf.toString();
                if (!isFirst) {
                    this.m_userInput = ret;
                    break;
                }
                this.m_userInput = null;
                break;
            }
        }
        return ret;
    }

    @Override
    public boolean isRepeatEmpty() {
        return this.m_repeatElemsNum == 0;
    }
}

