/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFEventInstance;
import com.platform.LSFJobFlow.api.JFFilter;
import com.platform.LSFJobFlow.api.JFFlowDefinitionManager;
import com.platform.LSFJobFlow.api.JFPseudoFlow;
import com.platform.LSFJobFlow.ui.Debug;
import com.platform.LSFJobFlow.ui.JFEventBeanINF;
import com.platform.LSFJobFlow.ui.JFFlowEventBean;
import com.platform.LSFJobFlow.ui.JFPluginEventManager;
import com.platform.LSFJobFlow.ui.JFProxyEventBean;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFTimeEventBean;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class PluginEventDialog
extends JDialog {
    JFPluginEventManager m_pluginMgr = null;
    boolean hasPluginEventFlag = false;
    JFEventBeanINF currentBean = null;
    String currentEvent = null;
    JFEvent event = null;
    boolean m_editable;
    boolean m_submission = false;
    private static String[] m_flowList = null;
    private JComboBox eventSelector;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel eventPanel;
    private JPanel contentPanel;
    private JPanel buttonPanel;
    private JLabel jLabel1;

    public PluginEventDialog(Frame frame) {
        super(frame, true);
        this.setTitle(JFResourceBundle.getString("Plugin_Events"));
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.eventSelector.setEditable(false);
        this.jLabel1.setLabelFor(this.eventSelector);
        this.eventSelector.getAccessibleContext().setAccessibleName(this.jLabel1.getText());
        this.setResizable(false);
        this.currentBean = null;
        this.currentEvent = null;
        this.eventPanel.setLayout(new BorderLayout());
        this.m_editable = true;
        this.m_submission = false;
        m_flowList = null;
        this.setPluginEvents();
    }

    public void setSubmission(boolean bl) {
        this.m_submission = bl;
    }

    public JFEvent createNewEvent() {
        this.m_editable = true;
        this.event = null;
        this.eventSelector.setEnabled(true);
        this.eventSelector.setOpaque(true);
        this.eventSelector.setSelectedIndex(0);
        this.cancelButton.setVisible(this.m_editable);
        this.show();
        return this.event;
    }

    public JFEvent openEvent(Object object, boolean bl) {
        if (object instanceof JFEvent) {
            this.event = (JFEvent)object;
        } else if (object instanceof JFEventInstance) {
            this.event = ((JFEventInstance)object).getEventDefinition();
        }
        if (this.event == null) {
            return null;
        }
        this.m_editable = bl;
        String string = null;
        string = this.event.isProxy() ? "Proxy" : this.event.getEventGeneratorType();
        if (string.equals("flow_except")) {
            string = "Proxy";
        }
        this.currentEvent = this.m_pluginMgr.getEventName(string);
        this.eventSelector.setEnabled(true);
        this.eventSelector.setSelectedItem(this.currentEvent);
        if (this.currentBean != null) {
            try {
                this.currentBean.setEvent(this.event);
            }
            catch (Exception exception) {
                JFUtility.showAppException(this, exception);
            }
        }
        this.event = null;
        this.eventSelector.setEnabled(false);
        this.eventSelector.setOpaque(false);
        this.cancelButton.setVisible(this.m_editable);
        this.show();
        if (bl) {
            return this.event;
        }
        return null;
    }

    void setPluginEvents() {
        this.eventPanel.setVisible(false);
        try {
            this.m_pluginMgr = JFPluginEventManager.getInstance();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            return;
        }
        String[] stringArray = this.m_pluginMgr.getEventNames();
        if (stringArray == null || stringArray.length <= 0) {
            return;
        }
        this.hasPluginEventFlag = true;
        for (int i = 0; i < stringArray.length; ++i) {
            this.eventSelector.addItem(stringArray[i]);
        }
    }

    private void selectEventBean(String string) {
        if (string == null) {
            return;
        }
        this.currentEvent = string;
        if (this.currentBean != null) {
            this.eventPanel.remove(this.currentBean.getBeanPanel());
        }
        Object var2_2 = null;
        JFEventBeanINF jFEventBeanINF = this.m_pluginMgr.getEventBeanByName(this.currentEvent);
        if (jFEventBeanINF != null && jFEventBeanINF instanceof JFEventBeanINF) {
            if (jFEventBeanINF instanceof JFFlowEventBean) {
                if (!this.m_editable) {
                    ((JFFlowEventBean)jFEventBeanINF).setFlowSelectionList(null);
                } else {
                    if (m_flowList == null) {
                        this.getAllFlowNames();
                    }
                    ((JFFlowEventBean)jFEventBeanINF).setFlowSelectionList(m_flowList);
                }
            }
            this.currentBean = jFEventBeanINF;
            if (this.currentBean instanceof JFTimeEventBean) {
                ((JFTimeEventBean)this.currentBean).setEnableOccurrence(true);
                ((JFTimeEventBean)this.currentBean).setInitEndAfterCheckBox(false);
            }
            this.currentBean.setEditable(this.m_editable);
            this.currentBean.showAllComponents();
            if (this.currentBean instanceof JFProxyEventBean) {
                ((JFProxyEventBean)this.currentBean).setSubmission(this.m_submission);
            }
            this.eventPanel.setVisible(true);
            this.eventPanel.add((Component)this.currentBean.getBeanPanel(), "Center");
            this.eventPanel.setBorder(new TitledBorder(this.currentEvent));
            this.pack();
            this.currentBean.reset();
        }
    }

    private void getAllFlowNames() {
        try {
            JFFlowDefinitionManager jFFlowDefinitionManager = new JFFlowDefinitionManager();
            JFFilter jFFilter = new JFFilter();
            jFFilter.setUser("all");
            JFPseudoFlow[] jFPseudoFlowArray = jFFlowDefinitionManager.getPseudoFlows(jFFilter);
            m_flowList = new String[jFPseudoFlowArray.length];
            for (int i = 0; i < jFPseudoFlowArray.length; ++i) {
                PluginEventDialog.m_flowList[i] = jFPseudoFlowArray[i].getFlowName();
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
    }

    private void initComponents() {
        this.eventSelector = new JComboBox();
        this.eventPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.contentPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.okButton.setText(JFResourceBundle.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PluginEventDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText(JFResourceBundle.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PluginEventDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.contentPanel.setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PluginEventDialog.this.closeDialog(windowEvent);
            }
        });
        this.eventSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PluginEventDialog.this.eventSelectorActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setText(JFResourceBundle.getString("Select_type_of_event:"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.contentPanel.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.contentPanel.add((Component)this.eventSelector, gridBagConstraints);
        this.eventPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        this.contentPanel.add((Component)this.eventPanel, gridBagConstraints);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        if (this.m_editable && this.currentBean != null) {
            try {
                this.event = this.currentBean.getEvent();
            }
            catch (Exception exception) {
                JFUtility.showAppException(this, exception);
                return;
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    private void eventSelectorActionPerformed(ActionEvent actionEvent) {
        this.selectEventBean((String)this.eventSelector.getSelectedItem());
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new PluginEventDialog(new JFrame()).show();
    }
}

