/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFLinkEvent;
import com.platform.LSFJobFlow.api.JFLinkEventInstance;
import com.platform.LSFJobFlow.ui.AbstractImageShape;
import com.platform.LSFJobFlow.ui.EventShape;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import java.util.ArrayList;
import java.util.Vector;

class LinkedEventShape
extends AbstractImageShape {
    public static final int AND_SHAPE = 0;
    public static final int OR_SHAPE = 1;
    int shapeType = 0;
    Vector eventShapes = null;
    private JFLinkEvent m_linkEvent = null;
    private JFLinkEventInstance m_linkEventInstance = null;
    private boolean m_modified = false;

    public LinkedEventShape(int n, int n2, int n3) {
        super(n2, n3, false);
        this.shapeType = n;
        this.reloadImage();
        this.eventShapes = null;
    }

    public LinkedEventShape(int n, int n2, int n3, JFLinkEventInstance jFLinkEventInstance) {
        super(n2, n3, false);
        this.shapeType = n;
        this.m_linkEventInstance = jFLinkEventInstance;
        if (this.m_linkEventInstance != null) {
            this.m_linkEvent = (JFLinkEvent)this.m_linkEventInstance.getEventDefinition();
        }
        this.reloadImage();
        this.eventShapes = null;
    }

    public LinkedEventShape(int n, int n2, int n3, JFLinkEvent jFLinkEvent) {
        super(n2, n3, false);
        this.shapeType = n;
        this.m_linkEvent = jFLinkEvent;
        this.reloadImage();
        this.eventShapes = null;
    }

    public JFLinkEvent getDefObj() {
        return this.m_linkEvent;
    }

    public JFLinkEventInstance getInstanceObj() {
        return this.m_linkEventInstance;
    }

    public JFLinkEvent getLinkEvent() {
        if (this.m_linkEvent == null || this.isModified()) {
            if (this.eventShapes == null) {
                return null;
            }
            int n = this.eventShapes.size();
            if (n <= 0) {
                return null;
            }
            ArrayList<JFEvent> arrayList = new ArrayList<JFEvent>();
            JFEvent jFEvent = null;
            for (int i = 0; i < n; ++i) {
                jFEvent = ((EventShape)this.eventShapes.get(i)).getEvent();
                if (jFEvent == null) continue;
                arrayList.add(jFEvent);
            }
            if (arrayList.size() == 0) {
                return null;
            }
            JFLinkEvent jFLinkEvent = null;
            JFEvent[] jFEventArray = new JFEvent[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                jFEventArray[i] = (JFEvent)arrayList.get(i);
            }
            jFLinkEvent = this.shapeType == 0 ? new JFLinkEvent(jFEventArray, 0) : new JFLinkEvent(jFEventArray, 1);
            if (this.m_linkEvent != null) {
                jFLinkEvent.setLinkJobName(this.m_linkEvent.getName());
            }
            jFLinkEvent.setAttribute("PositionX", String.valueOf(this.x));
            jFLinkEvent.setAttribute("PositionY", String.valueOf(this.y));
            this.m_modified = false;
            this.m_linkEvent = jFLinkEvent;
        }
        return this.m_linkEvent;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(int n) {
        this.shapeType = n;
        this.reloadImage();
        this.m_modified = true;
    }

    public void shiftShapeType() {
        this.shapeType = this.shapeType == 0 ? 1 : 0;
        this.reloadImage();
        this.m_modified = true;
    }

    public void addEventShape(EventShape eventShape) {
        if (this.eventShapes == null) {
            this.eventShapes = new Vector();
        }
        this.eventShapes.add(eventShape);
        this.m_modified = true;
    }

    public void removeEventShape(EventShape eventShape) {
        if (this.eventShapes == null) {
            return;
        }
        this.eventShapes.remove(eventShape);
        this.m_modified = true;
    }

    public void setModified() {
        this.m_modified = true;
    }

    public boolean isModified() {
        if (this.m_modified) {
            return true;
        }
        int n = this.eventShapes.size();
        if (n <= 0) {
            return this.m_modified;
        }
        AbstractImageShape abstractImageShape = null;
        for (int i = 0; i < n; ++i) {
            abstractImageShape = ((EventShape)this.eventShapes.get(i)).getSourceShape();
            if (abstractImageShape == null || !(abstractImageShape instanceof LinkedEventShape) || !((LinkedEventShape)abstractImageShape).isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        switch (this.shapeType) {
            case 0: {
                return JFResourceBundle.getString("Event_And_");
            }
            case 1: {
                return JFResourceBundle.getString("Event_Or_");
            }
        }
        return "";
    }

    public boolean isUndefinedShape() {
        return this.eventShapes == null || this.eventShapes.size() == 0;
    }

    void reloadImage() {
        switch (this.shapeType) {
            case 0: {
                this.curImage = this.imageLoader.getANDImage();
                break;
            }
            case 1: {
                this.curImage = this.imageLoader.getORImage();
                break;
            }
        }
    }

    @Override
    public void move(int n, int n2) {
        this.m_modified = true;
        super.move(n, n2);
    }

    @Override
    public void moveTo(int n, int n2) {
        this.m_modified = true;
        super.moveTo(n, n2);
    }

    @Override
    void setPosition(int n, int n2) {
        this.m_modified = true;
        super.setPosition(n, n2);
    }
}

