/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.ibm.icu.util.TimeZone;
import com.platform.LSFJobFlow.api.JFAdminManager;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.ui.GMTComparator;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;

public class JFTimeZoneSelectionBean
extends JPanel {
    private static final long serialVersionUID = 1387452727854060250L;
    private static Vector m_timeZones = null;
    private static Hashtable m_timeZoneDisplayNameToIDMap = null;
    private static Hashtable m_timeZoneIDToDisplayNameMap = null;
    private DefaultComboBoxModel m_model;
    private JRadioButton m_UTCRadioButton;
    private JRadioButton m_clientRadioButton;
    private JRadioButton m_customRadioButton;
    private JRadioButton m_serverRadioButton;
    private JLabel m_serverTimeLabel;
    private ButtonGroup m_timeZoneButtonGroup;
    private JComboBox m_timeZoneComboBox;
    private JScrollBar m_timeZoneVerticleScroll;

    public JFTimeZoneSelectionBean() {
        this.initComponents();
        this.initTimeZones();
        this.initData();
    }

    private void initTimeZones() {
        if (m_timeZones == null) {
            Object object;
            m_timeZones = new Vector();
            m_timeZoneDisplayNameToIDMap = new Hashtable();
            m_timeZoneIDToDisplayNameMap = new Hashtable();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("timezones", Locale.getDefault());
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement().trim();
                String string = resourceBundle.getString((String)object).trim();
                m_timeZones.addElement(string);
                m_timeZoneDisplayNameToIDMap.put(string, object);
                m_timeZoneIDToDisplayNameMap.put(object, string);
            }
            object = new GMTComparator();
            Collections.sort(m_timeZones, object);
        }
    }

    private void initData() {
        this.m_model = new DefaultComboBoxModel(m_timeZones);
        this.m_timeZoneComboBox.setModel(this.m_model);
    }

    private void initComponents() {
        this.m_timeZoneButtonGroup = new ButtonGroup();
        this.m_clientRadioButton = new JRadioButton();
        this.m_serverRadioButton = new JRadioButton();
        this.m_customRadioButton = new JRadioButton();
        this.m_UTCRadioButton = new JRadioButton();
        this.m_timeZoneVerticleScroll = new JScrollBar();
        this.m_timeZoneComboBox = new JComboBox();
        this.m_serverTimeLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.m_timeZoneButtonGroup.add(this.m_clientRadioButton);
        this.m_clientRadioButton.setSelected(true);
        this.m_clientRadioButton.setText(JFResourceBundle.getString("JFTimeZoneSelectionBean$Client"));
        this.m_clientRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_clientRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.m_clientRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JFTimeZoneSelectionBean.this.m_clientRadioButtonItemStateChanged(itemEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 0);
        this.add((Component)this.m_clientRadioButton, gridBagConstraints);
        this.m_timeZoneButtonGroup.add(this.m_serverRadioButton);
        this.m_serverRadioButton.setText(JFResourceBundle.getString("JFTimeZoneSelectionBean$Server"));
        this.m_serverRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_serverRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.m_serverRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JFTimeZoneSelectionBean.this.m_serverRadioButtonItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.m_serverRadioButton, gridBagConstraints);
        this.m_timeZoneButtonGroup.add(this.m_customRadioButton);
        this.m_customRadioButton.setText(JFResourceBundle.getString("JFTimeZoneSelectionBean$Custom"));
        this.m_customRadioButton.setActionCommand(JFResourceBundle.getString("JFTimeZoneSelectionBean$Custom"));
        this.m_customRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_customRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.m_customRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JFTimeZoneSelectionBean.this.m_customRadioButtonItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.m_customRadioButton, gridBagConstraints);
        this.m_timeZoneButtonGroup.add(this.m_UTCRadioButton);
        this.m_UTCRadioButton.setText(JFResourceBundle.getString("JFTimeZoneSelectionBean$UTC"));
        this.m_UTCRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_UTCRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.m_UTCRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JFTimeZoneSelectionBean.this.m_UTCRadioButtonItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.m_UTCRadioButton, gridBagConstraints);
        this.m_timeZoneVerticleScroll.setEnabled(false);
        this.m_timeZoneVerticleScroll.setPreferredSize(new Dimension(18, 20));
        this.m_timeZoneVerticleScroll.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                JFTimeZoneSelectionBean.this.m_timeZoneVerticleScrollAdjustmentValueChanged(adjustmentEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.add((Component)this.m_timeZoneVerticleScroll, gridBagConstraints);
        this.m_timeZoneComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.m_timeZoneComboBox.setEnabled(false);
        this.m_timeZoneComboBox.setMinimumSize(new Dimension(200, 21));
        this.m_timeZoneComboBox.setOpaque(false);
        this.m_timeZoneComboBox.setPreferredSize(new Dimension(385, 20));
        this.m_timeZoneComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JFTimeZoneSelectionBean.this.m_timeZoneComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 25, 5, 0);
        this.add((Component)this.m_timeZoneComboBox, gridBagConstraints);
        this.m_timeZoneComboBox.getAccessibleContext().setAccessibleParent(this);
        this.m_serverTimeLabel.setText("TEMP TEXT");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 25, 5, 0);
        this.add((Component)this.m_serverTimeLabel, gridBagConstraints);
    }

    private void m_timeZoneComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.m_timeZoneVerticleScroll.setValue(this.m_timeZoneComboBox.getSelectedIndex());
    }

    private void m_timeZoneVerticleScrollAdjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        if (n >= this.m_model.getSize()) {
            n = this.m_model.getSize() - 1;
            this.m_timeZoneVerticleScroll.setValue(n);
            return;
        }
        this.m_timeZoneComboBox.setSelectedIndex(n);
    }

    @Override
    public void setEnabled(boolean bl) {
    }

    private void m_UTCRadioButtonItemStateChanged(ItemEvent itemEvent) {
        if (this.m_UTCRadioButton.isSelected()) {
            this.m_timeZoneComboBox.setEnabled(false);
            this.m_timeZoneVerticleScroll.setEnabled(false);
        }
    }

    private void m_customRadioButtonItemStateChanged(ItemEvent itemEvent) {
        if (this.m_customRadioButton.isSelected()) {
            this.m_timeZoneComboBox.setEnabled(true);
            this.m_timeZoneVerticleScroll.setEnabled(true);
        }
    }

    private void m_serverRadioButtonItemStateChanged(ItemEvent itemEvent) {
        if (this.m_serverRadioButton.isSelected()) {
            this.m_timeZoneComboBox.setEnabled(false);
            this.m_timeZoneVerticleScroll.setEnabled(false);
        }
    }

    private void m_clientRadioButtonItemStateChanged(ItemEvent itemEvent) {
        if (this.m_clientRadioButton.isSelected()) {
            this.m_timeZoneComboBox.setEnabled(false);
            this.m_timeZoneVerticleScroll.setEnabled(false);
        }
    }

    public int getTimeZoneType() {
        if (this.m_clientRadioButton.isSelected()) {
            return 0;
        }
        if (this.m_serverRadioButton.isSelected()) {
            return 1;
        }
        if (this.m_UTCRadioButton.isSelected()) {
            return 2;
        }
        if (this.m_customRadioButton.isSelected()) {
            return 3;
        }
        return -1;
    }

    public String getTimeZoneID() {
        if (this.m_clientRadioButton.isSelected()) {
            return "Client";
        }
        if (this.m_serverRadioButton.isSelected()) {
            return "Server";
        }
        if (this.m_UTCRadioButton.isSelected()) {
            return "UTC";
        }
        if (this.m_customRadioButton.isSelected()) {
            String string = (String)m_timeZoneDisplayNameToIDMap.get(this.m_timeZoneComboBox.getSelectedItem());
            return string;
        }
        return null;
    }

    public void setTimeZone(String string, String string2) {
        this.reset();
        if (string != null) {
            int n = Integer.parseInt(string);
            if (n == -1 || n == 0) {
                this.m_timeZoneComboBox.setSelectedIndex(0);
                this.m_clientRadioButton.setSelected(true);
                this.m_timeZoneComboBox.setEnabled(false);
                this.m_timeZoneVerticleScroll.setEnabled(false);
            } else if (n == 1) {
                this.m_timeZoneComboBox.setSelectedIndex(0);
                this.m_serverRadioButton.setSelected(true);
                this.m_timeZoneComboBox.setEnabled(false);
                this.m_timeZoneVerticleScroll.setEnabled(false);
            } else if (n == 2) {
                this.m_timeZoneComboBox.setSelectedIndex(0);
                this.m_UTCRadioButton.setSelected(true);
                this.m_timeZoneComboBox.setEnabled(false);
                this.m_timeZoneVerticleScroll.setEnabled(false);
            } else {
                String string3 = (String)m_timeZoneIDToDisplayNameMap.get(string2);
                if (string3 == null) {
                    TimeZone timeZone = TimeZone.getTimeZone((String)string2);
                    string3 = timeZone.getID() + " - " + timeZone.getDisplayName();
                    m_timeZoneDisplayNameToIDMap.put(string3, timeZone.getID());
                    m_timeZoneIDToDisplayNameMap.put(timeZone.getID(), string3);
                    this.m_model.addElement(string3);
                }
                this.m_timeZoneComboBox.setSelectedItem(string3);
                this.m_customRadioButton.setSelected(true);
                if (this.m_customRadioButton.isEnabled()) {
                    this.m_timeZoneComboBox.setEnabled(true);
                    this.m_timeZoneVerticleScroll.setEnabled(true);
                } else {
                    this.m_timeZoneComboBox.setEnabled(false);
                    this.m_timeZoneVerticleScroll.setEnabled(false);
                }
            }
        }
    }

    public void setEditable(boolean bl) {
        this.m_clientRadioButton.setEnabled(bl);
        this.m_serverRadioButton.setEnabled(bl);
        this.m_customRadioButton.setEnabled(bl);
        this.m_UTCRadioButton.setEnabled(bl);
        this.m_serverTimeLabel.setEnabled(bl);
        if (bl && this.m_customRadioButton.isSelected()) {
            this.m_timeZoneComboBox.setEnabled(true);
            this.m_timeZoneVerticleScroll.setEnabled(true);
        } else {
            this.m_timeZoneComboBox.setEnabled(false);
            this.m_timeZoneVerticleScroll.setEnabled(false);
        }
    }

    public void reset() {
        Object[] objectArray;
        int n = JFConfigManager.getTimeZoneFlag();
        if (n == 0) {
            this.m_clientRadioButton.setSelected(true);
        }
        if (n == 1) {
            this.m_serverRadioButton.setSelected(true);
        }
        if (n == 2) {
            this.m_UTCRadioButton.setSelected(true);
        }
        String string = "";
        try {
            objectArray = new JFAdminManager();
            string = objectArray.getServerTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            string = JFResourceBundle.getString("unavailable");
        }
        objectArray = new Object[]{string};
        String string2 = JFResourceBundle.getString("Current_server_time_is_T");
        MessageFormat messageFormat = new MessageFormat(string2);
        string = messageFormat.format(objectArray);
        this.m_serverTimeLabel.setText(string);
        this.m_clientRadioButton.setText(JFResourceBundle.getString("JFTimeZoneSelectionBean$Client") + " (" + TimeZone.getDefault().getDisplayName() + ")");
        this.m_timeZoneComboBox.setEnabled(false);
        this.m_timeZoneComboBox.setSelectedIndex(0);
        this.m_timeZoneVerticleScroll.setEnabled(false);
    }
}

