/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.ui.Debug;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class JFGUIprofile {
    protected Properties m_props = null;
    private File m_file = null;
    private String m_title = null;

    public JFGUIprofile(String string, String string2) throws Exception {
        if (string == null) {
            throw new NullPointerException();
        }
        this.m_title = string2;
        this.m_props = new Properties();
        try {
            this.m_file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + string);
            if (!this.m_file.exists()) {
                this.m_file.createNewFile();
            }
            this.m_props.load(new FileInputStream(this.m_file));
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
    }

    public void store() throws Exception {
        if (!this.m_file.exists()) {
            this.m_file.createNewFile();
        }
        this.m_props.store(new FileOutputStream(this.m_file), this.m_title);
    }

    public Dimension getWindowSize() {
        String string = null;
        int n = 0;
        string = this.m_props.getProperty("WINDOW_SIZE");
        if (string != null) {
            int n2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t");
            try {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                return null;
            }
            return new Dimension(n2, n);
        }
        return null;
    }

    public void setWindowSize(Dimension dimension) {
        if (dimension == null) {
            this.m_props.remove("WINDOWN_SIZE");
        }
        this.m_props.setProperty("WINDOW_SIZE", String.valueOf(dimension.width) + "," + String.valueOf(dimension.height));
    }

    public void setCWD(String string) {
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            return;
        }
        this.m_props.setProperty("CWD", string);
    }

    public String getCWD() {
        String string = System.getProperty("user.home");
        if (this.m_props == null) {
            return string;
        }
        return this.m_props.getProperty("CWD", string);
    }

    public void setMRU(String string) {
        if (string == null) {
            return;
        }
        this.m_props.setProperty("MRU", string);
    }

    public String getMRU() {
        return this.m_props.getProperty("MRU");
    }
}

