/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public final class JFExampleResourceBundle {
    private static final String TITLE = "_Title";
    private static final String DESCIPTION = "_Desc";
    static OrderedResourceBundle resourceBdl = (OrderedResourceBundle)ResourceBundle.getBundle("exampleResource", Locale.getDefault(), new ResourceBundle.Control(){

        @Override
        public List<String> getFormats(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            return Arrays.asList("properties");
        }

        @Override
        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
            if (string == null || locale == null || string2 == null || classLoader == null) {
                throw new NullPointerException();
            }
            OrderedResourceBundle orderedResourceBundle = null;
            if (string2.equals("properties")) {
                String string3 = this.toBundleName(string, locale);
                String string4 = this.toResourceName(string3, string2);
                InputStream inputStream = null;
                try {
                    if (bl) {
                        URLConnection uRLConnection;
                        URL uRL = classLoader.getResource(string4);
                        if (uRL != null && (uRLConnection = uRL.openConnection()) != null) {
                            uRLConnection.setUseCaches(false);
                            inputStream = uRLConnection.getInputStream();
                        }
                    } else {
                        inputStream = classLoader.getResourceAsStream(string4);
                    }
                    if (inputStream != null) {
                        orderedResourceBundle = new OrderedResourceBundle(inputStream);
                    }
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return orderedResourceBundle;
        }
    });

    public static Enumeration<String> getExampleNames() {
        return resourceBdl.getKeys();
    }

    public static String getExampleName(int n) {
        return resourceBdl.getKey(n);
    }

    private static String getString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        try {
            string2 = resourceBdl.getString(string);
        }
        catch (Exception exception) {
            string2 = null;
        }
        return string2;
    }

    public static String getTitleString(int n) {
        String string = JFExampleResourceBundle.getExampleName(n);
        return JFExampleResourceBundle.getTitleString(string);
    }

    public static String getTitleString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = JFExampleResourceBundle.getString(string + TITLE);
        if (string2 == null) {
            return null;
        }
        return string2 + " (" + string + ".xml)";
    }

    public static String getDescriptionString(int n) {
        String string = JFExampleResourceBundle.getExampleName(n);
        return JFExampleResourceBundle.getDescriptionString(string);
    }

    public static String getDescriptionString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = JFExampleResourceBundle.getString(string + DESCIPTION);
        String string3 = JFExampleResourceBundle.getTitleString(string);
        if (string3 == null || string2 == null) {
            return null;
        }
        return string3 + "\n\n" + string2;
    }

    private static class OrderedResourceBundle
    extends ResourceBundle {
        private Properties props = new Properties();
        private ArrayList<String> keys = new ArrayList();
        private ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
        private InputStream propsStream = null;
        private BufferedReader keysBuffer = null;

        OrderedResourceBundle(InputStream inputStream) throws IOException {
            try {
                String string;
                int n;
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) > -1) {
                    this.bufferStream.write(byArray, 0, n);
                }
                this.bufferStream.flush();
                this.propsStream = new ByteArrayInputStream(this.bufferStream.toByteArray());
                this.props.load(this.propsStream);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.bufferStream.toByteArray());
                this.keysBuffer = new BufferedReader(new InputStreamReader(byteArrayInputStream));
                while ((string = this.keysBuffer.readLine()) != null) {
                    int n2;
                    if ((string = string.trim()).startsWith("#") || (n2 = string.indexOf("_Title=")) <= 0) continue;
                    this.keys.add(string.substring(0, n2).trim());
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                try {
                    if (this.propsStream != null) {
                        this.propsStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (this.keysBuffer != null) {
                        this.keysBuffer.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    this.bufferStream.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        protected Object handleGetObject(String string) {
            return this.props.getProperty(string);
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(this.keys);
        }

        public String getKey(int n) {
            if (n < 0 || n >= this.keys.size()) {
                return null;
            }
            return this.keys.get(n);
        }
    }
}

