/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.ui.JFEditEnvVarDialog;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFVarTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JFEnvVarsBean
extends JPanel {
    private static JFEditEnvVarDialog m_editEnvVarDialog = null;
    private boolean m_mustSpecifyValue = false;
    private JButton editButton;
    private JPanel envVarPanel;
    private JPanel jPanel1;
    private JButton newButton;
    private JButton removeButton;
    private JList varList;
    private JScrollPane varListScrollPane;
    private JTable varTable;
    private JFVarTableModel varTableModel;

    public static void main(String[] stringArray) {
        new JFEnvVarsBean().setVisible(true);
    }

    public JFEnvVarsBean() {
        this.initComponents();
        this.initGUI();
    }

    public String getVarList() {
        Vector<Vector> vector = this.varTableModel.getDataVector();
        if (vector == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        String string2 = null;
        Enumeration<Vector> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2 = enumeration.nextElement();
            string = (String)vector2.get(0);
            string2 = (String)vector2.get(1);
            stringBuffer.append(string);
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append("=" + string2);
            }
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }

    public int setVarList(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        String string2 = string;
        String[] stringArray = string2.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = null;
            int n = stringArray[i].indexOf("=");
            if (n < 0) {
                stringArray2 = new String[]{stringArray[i]};
            } else {
                String string3 = null;
                String string4 = null;
                string3 = stringArray[i].substring(0, n);
                if (n < stringArray[i].length() - 1) {
                    string4 = stringArray[i].substring(n + 1);
                }
                stringArray2 = new String[]{string3, string4};
            }
            if (stringArray2[0] == null || stringArray2[0].isEmpty()) continue;
            this.addVarToList(stringArray2);
        }
        this.sortVarTable(0, true);
        return 0;
    }

    public void setEnableDefaultValue(boolean bl) {
        this.m_mustSpecifyValue = bl;
    }

    private void initGUI() {
    }

    private JFrame getMainFrame() {
        JFrame jFrame = null;
        if (jFrame == null) {
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof JFrame)) continue;
                jFrame = (JFrame)container;
                break;
            }
        }
        return jFrame;
    }

    private void initComponents() {
        this.envVarPanel = new JPanel();
        this.varListScrollPane = new JScrollPane();
        this.varList = new JList();
        this.varTableModel = new JFVarTableModel();
        this.varTableModel.addColumn(JFResourceBundle.getString("NAME_LABEL"));
        this.varTableModel.addColumn(JFResourceBundle.getString("VALUE_LABEL"));
        this.varTable = new JTable(this.varTableModel);
        this.varTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JFEnvVarsBean.this.setButtonOnSelection();
            }
        });
        this.jPanel1 = new JPanel();
        this.newButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.envVarPanel.setLayout(new GridBagLayout());
        this.envVarPanel.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("JFEnvVarsBean$TITLE")));
        this.envVarPanel.setMinimumSize(new Dimension(415, 160));
        this.envVarPanel.setOpaque(false);
        this.envVarPanel.setPreferredSize(new Dimension(410, 160));
        this.varListScrollPane.setBackground(new Color(255, 255, 255));
        this.varListScrollPane.setMinimumSize(new Dimension(300, 125));
        this.varListScrollPane.setNextFocusableComponent(this.removeButton);
        this.varListScrollPane.setPreferredSize(new Dimension(300, 125));
        this.varListScrollPane.setViewport(this.varListScrollPane.getViewport());
        this.varList.setToolTipText(JFResourceBundle.getString("JFEnvVarsBean$TIP_varList"));
        this.varList.setMaximumSize(new Dimension(999999999, 999999999));
        this.varList.setMinimumSize(new Dimension(300, 100));
        this.varList.setNextFocusableComponent(this.newButton);
        this.varListScrollPane.setViewportView(this.varTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.envVarPanel.add((Component)this.varListScrollPane, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.newButton.setText(ResourceBundle.getBundle("guiSharedResource").getString("New"));
        this.newButton.setToolTipText(ResourceBundle.getBundle("guiSharedResource").getString("JFEnvVarsBean$TIP_newButton"));
        this.newButton.setNextFocusableComponent(this.editButton);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFEnvVarsBean.this.newButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.newButton, gridBagConstraints);
        this.editButton.setText(ResourceBundle.getBundle("guiSharedResource").getString("Edit"));
        this.editButton.setToolTipText(ResourceBundle.getBundle("guiSharedResource").getString("JFEnvVarsBean$TIP_editButton"));
        this.editButton.setNextFocusableComponent(this.removeButton);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFEnvVarsBean.this.editButtonActionPerformed(actionEvent);
            }
        });
        this.editButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 5, 15, 5);
        this.jPanel1.add((Component)this.editButton, gridBagConstraints);
        this.removeButton.setText(ResourceBundle.getBundle("guiSharedResource").getString("Remove"));
        this.removeButton.setToolTipText(JFResourceBundle.getString("JFEnvVarsBean$TIP_removeButton"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFEnvVarsBean.this.removeButtonActionPerformed(actionEvent);
            }
        });
        this.removeButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.envVarPanel.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.envVarPanel, gridBagConstraints);
        this.envVarPanel.getAccessibleContext().setAccessibleName("Job Environment Variable Editor");
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        m_editEnvVarDialog = new JFEditEnvVarDialog((Frame)this.getMainFrame(), true);
        m_editEnvVarDialog.setLocationRelativeTo(this);
        m_editEnvVarDialog.setEnableDefaultValue(this.m_mustSpecifyValue);
        m_editEnvVarDialog.setTitle(JFResourceBundle.getString("JFEditEnvVarDialog$TITLE_New"));
        m_editEnvVarDialog.setVisible(true);
        Object[] objectArray = m_editEnvVarDialog.getVariableDeclaration();
        if (objectArray == null) {
            return;
        }
        int n = this.getVarDeclarationIndex((String[])objectArray);
        if (n != -1) {
            int n2 = JOptionPane.showConfirmDialog(this, JFResourceBundle.getString("MSG_overwriteVariable"), JFResourceBundle.getString("JFEditEnvVarDialog$TITLE_New"), 0, 2);
            if (n2 == 1) {
                return;
            }
            this.varTableModel.setValueAt(objectArray[1], n, 1);
        } else {
            this.varTableModel.addRow(objectArray);
        }
        this.sortVarTable(0, true);
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.varTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        String string = (String)this.varTableModel.getValueAt(n, 0);
        String string2 = (String)this.varTableModel.getValueAt(n, 1);
        m_editEnvVarDialog = new JFEditEnvVarDialog((Frame)this.getMainFrame(), true);
        m_editEnvVarDialog.setLocationRelativeTo(this);
        m_editEnvVarDialog.setEnableDefaultValue(this.m_mustSpecifyValue);
        m_editEnvVarDialog.init(string, string2);
        m_editEnvVarDialog.setNameFieldEditable(false);
        m_editEnvVarDialog.setTitle(JFResourceBundle.getString("JFEditEnvVarDialog$TITLE_Edit"));
        m_editEnvVarDialog.setVisible(true);
        String[] stringArray = m_editEnvVarDialog.getVariableDeclaration();
        if (stringArray == null) {
            return;
        }
        this.varTableModel.setValueAt(stringArray[1], n, 1);
    }

    private boolean addVarToList(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        int n = this.getVarDeclarationIndex(stringArray);
        String string = stringArray.length < 2 ? null : stringArray[1];
        if (n != -1) {
            this.varTableModel.setValueAt(string, n, 1);
            return false;
        }
        this.varTableModel.addRow(stringArray);
        return true;
    }

    private int getVarDeclarationIndex(String[] stringArray) {
        if (stringArray[0] == null || stringArray[0].length() == 0) {
            return -1;
        }
        int n = this.varTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!stringArray[0].equals(this.varTableModel.getValueAt(i, 0))) continue;
            return i;
        }
        return -1;
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.varTable.getSelectedRow();
        if (n != -1) {
            this.varTableModel.removeRow(n);
        }
    }

    private void setButtonOnSelection() {
        boolean bl = !this.varTable.getSelectionModel().isSelectionEmpty();
        this.removeButton.setEnabled(bl);
        this.editButton.setEnabled(bl);
    }

    private void sortVarTable(int n, boolean bl) {
        Vector<Vector> vector = this.varTableModel.getDataVector();
        Vector<String> vector2 = new Vector<String>();
        vector2.add(JFResourceBundle.getString("NAME_LABEL"));
        vector2.add(JFResourceBundle.getString("VALUE_LABEL"));
        this.varTableModel.setDataVector(vector, vector2);
        this.varTableModel.fireTableStructureChanged();
    }
}

