/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFEventInstance;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowInstance;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import com.platform.LSFJobFlow.ui.PluginEventDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FlowTriggerEventsBean
extends JPanel {
    JList m_eventList = null;
    boolean m_editable = false;
    boolean m_dirty = false;
    int m_combOpOld = 0;
    DefaultListModel m_listModel = new DefaultListModel();
    private String m_popupWinTitle = JFResourceBundle.getString("Trigger_Flow_with_Events");
    JFrame m_parent = null;
    private ButtonGroup buttonGroupAndOr;
    private JPanel eventListPanel;
    private JScrollPane m_eventListScrollPane;
    private JButton m_addButton;
    private JButton m_removeButton;
    private JButton m_openButton;
    private JLabel triggerLabel;
    private JRadioButton m_ANDselector;
    private JRadioButton m_ORselector;

    public FlowTriggerEventsBean() {
        this.m_eventList = new JList(this.m_listModel);
        this.m_eventList.setToolTipText(JFResourceBundle.getString("FlowTriggerEventsBeam$TIP_eventListFLD"));
        this.m_eventList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.setBackground(bl ? Color.blue : Color.white);
                this.setForeground(bl ? Color.white : Color.black);
                this.setText(object.toString());
                return this;
            }
        });
        this.m_eventList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FlowTriggerEventsBean.this.setButtonOnSelection();
            }
        });
        this.initComponents();
    }

    public JPanel getBeanPanel() {
        return this;
    }

    public void viewFlowTriggeringEvents(JFFlow jFFlow) {
        if (jFFlow == null) {
            return;
        }
        this.m_listModel.removeAllElements();
        JFEvent[] jFEventArray = jFFlow.getTriggerEvents();
        JFEventInstance[] jFEventInstanceArray = jFFlow.getTriggeredEvents();
        for (int i = 0; jFEventArray != null && i < jFEventArray.length; ++i) {
            int n = this.matchesEvent(jFEventInstanceArray, jFEventArray[i]);
            if (n == -1) {
                this.m_listModel.addElement(jFEventArray[i]);
                continue;
            }
            this.m_listModel.addElement(jFEventInstanceArray[n]);
        }
        this.m_combOpOld = jFFlow.getTriggerEventsCombinationOp();
        if (this.m_combOpOld == 0) {
            this.m_ANDselector.setSelected(true);
        } else {
            this.m_ORselector.setSelected(true);
        }
    }

    private int matchesEvent(JFEventInstance[] jFEventInstanceArray, JFEvent jFEvent) {
        if (jFEvent == null || jFEventInstanceArray == null) {
            return -1;
        }
        for (int i = 0; i < jFEventInstanceArray.length; ++i) {
            if (!jFEvent.equals((Object)jFEventInstanceArray[i].getEventDefinition())) continue;
            return i;
        }
        return -1;
    }

    public void viewFlowTriggeringEvents(JFFlowInstance jFFlowInstance) {
        if (jFFlowInstance == null) {
            return;
        }
        this.m_listModel.removeAllElements();
        JFEventInstance[] jFEventInstanceArray = jFFlowInstance.getEventInstances();
        for (int i = 0; jFEventInstanceArray != null && i < jFEventInstanceArray.length; ++i) {
            this.m_listModel.addElement(jFEventInstanceArray[i]);
        }
        JFFlow jFFlow = jFFlowInstance.getFlowDefinition();
        if (jFFlow != null) {
            this.m_combOpOld = jFFlow.getTriggerEventsCombinationOp();
        }
        if (this.m_combOpOld == 0) {
            this.m_ANDselector.setSelected(true);
        } else {
            this.m_ORselector.setSelected(true);
        }
    }

    public void setEditable(boolean bl) {
        this.m_editable = bl;
        this.m_addButton.setEnabled(bl);
        this.m_ANDselector.setEnabled(bl);
        this.m_ORselector.setEnabled(bl);
    }

    public void reset() {
        this.m_listModel.removeAllElements();
        this.m_ANDselector.setSelected(true);
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public JFEvent[] getEvents() {
        int n = this.m_listModel.size();
        if (n <= 0) {
            return new JFEvent[0];
        }
        JFEvent[] jFEventArray = new JFEvent[n];
        for (int i = 0; i < n; ++i) {
            if (this.m_listModel.elementAt(i) instanceof JFEvent) {
                jFEventArray[i] = (JFEvent)this.m_listModel.elementAt(i);
                continue;
            }
            if (this.m_listModel.elementAt(i) instanceof JFEventInstance) {
                JFEventInstance jFEventInstance = (JFEventInstance)this.m_listModel.elementAt(i);
                jFEventArray[i] = jFEventInstance.getEventDefinition();
                continue;
            }
            jFEventArray[i] = null;
        }
        return jFEventArray;
    }

    public int getCombinationOp() {
        if (this.m_ANDselector.isSelected()) {
            return 0;
        }
        return 1;
    }

    private void setDirtyBit(boolean bl) {
        this.m_dirty = bl;
    }

    private void setButtonOnSelection() {
        boolean bl = this.m_eventList.getSelectedIndex() != -1;
        this.m_openButton.setEnabled(bl);
        if (this.m_editable) {
            this.m_removeButton.setEnabled(bl);
        }
    }

    private void initComponents() {
        this.buttonGroupAndOr = new ButtonGroup();
        this.eventListPanel = new JPanel();
        this.m_eventListScrollPane = new JScrollPane(this.m_eventList);
        this.m_addButton = new JButton();
        this.m_removeButton = new JButton();
        this.m_openButton = new JButton();
        this.triggerLabel = new JLabel();
        this.m_ANDselector = new JRadioButton();
        this.m_ORselector = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(496, 320));
        this.eventListPanel.setLayout(new GridBagLayout());
        this.eventListPanel.setBorder(new TitledBorder(JFResourceBundle.getString("Event_s_list")));
        this.eventListPanel.setToolTipText("");
        this.m_eventListScrollPane.setToolTipText(JFResourceBundle.getString("FlowTriggerEventsBeam$TIP_eventListFLD"));
        this.m_eventListScrollPane.setMinimumSize(new Dimension(300, 100));
        this.m_eventListScrollPane.setPreferredSize(new Dimension(300, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.eventListPanel.add((Component)this.m_eventListScrollPane, gridBagConstraints);
        this.m_addButton.setText(JFResourceBundle.getString("Add"));
        this.m_addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlowTriggerEventsBean.this.m_addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.eventListPanel.add((Component)this.m_addButton, gridBagConstraints);
        this.m_removeButton.setText(JFResourceBundle.getString("Remove"));
        this.m_removeButton.setEnabled(false);
        this.m_removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlowTriggerEventsBean.this.m_removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.eventListPanel.add((Component)this.m_removeButton, gridBagConstraints);
        this.m_openButton.setText(JFResourceBundle.getString("Open"));
        this.m_openButton.setEnabled(false);
        this.m_openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlowTriggerEventsBean.this.m_openButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.eventListPanel.add((Component)this.m_openButton, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.eventListPanel, gridBagConstraints2);
        this.triggerLabel.setText(JFResourceBundle.getString("Trigger_flow_when..."));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.triggerLabel, gridBagConstraints2);
        this.m_ANDselector.setText(JFResourceBundle.getString("All_events_are_true"));
        this.buttonGroupAndOr.add(this.m_ANDselector);
        this.m_ANDselector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlowTriggerEventsBean.this.m_ANDselectorActionPerformed(actionEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.m_ANDselector, gridBagConstraints2);
        this.m_ORselector.setText(JFResourceBundle.getString("Any_event_is_true"));
        this.buttonGroupAndOr.add(this.m_ORselector);
        this.m_ORselector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlowTriggerEventsBean.this.m_ORselectorActionPerformed(actionEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.m_ORselector, gridBagConstraints2);
    }

    private void m_ORselectorActionPerformed(ActionEvent actionEvent) {
        if (this.m_combOpOld != 1) {
            this.setDirtyBit(true);
        }
    }

    private void m_ANDselectorActionPerformed(ActionEvent actionEvent) {
        if (this.m_combOpOld != 0) {
            this.setDirtyBit(true);
        }
    }

    private void m_openButtonActionPerformed(ActionEvent actionEvent) {
        int n;
        if (this.m_eventList.isSelectionEmpty()) {
            return;
        }
        PluginEventDialog pluginEventDialog = new PluginEventDialog(JFUtility.getMainFrame(this));
        pluginEventDialog.setTitle(this.m_popupWinTitle);
        pluginEventDialog.setLocationRelativeTo(this);
        pluginEventDialog.setSubmission(true);
        JFEvent jFEvent = pluginEventDialog.openEvent(this.m_eventList.getSelectedValue(), this.m_editable);
        if (jFEvent != null && (n = this.m_eventList.getSelectedIndex()) >= 0) {
            this.m_listModel.removeElementAt(n);
            this.m_listModel.insertElementAt(jFEvent, n);
            this.setDirtyBit(true);
        }
    }

    private void m_removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.m_eventList.getSelectedIndex();
        if (n >= 0) {
            this.m_listModel.remove(n);
            this.setDirtyBit(true);
        }
        this.setButtonOnSelection();
    }

    private void m_addButtonActionPerformed(ActionEvent actionEvent) {
        PluginEventDialog pluginEventDialog = new PluginEventDialog(JFUtility.getMainFrame(this));
        pluginEventDialog.setTitle(this.m_popupWinTitle);
        pluginEventDialog.setLocationRelativeTo(this);
        pluginEventDialog.setSubmission(true);
        JFEvent jFEvent = pluginEventDialog.createNewEvent();
        if (jFEvent != null) {
            this.m_listModel.addElement(jFEvent);
            this.setDirtyBit(true);
        }
    }
}

