/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobArray;
import com.platform.LSFJobFlow.api.JFJobArrayInstance;
import com.platform.LSFJobFlow.api.JFJobInstance;
import com.platform.LSFJobFlow.ui.AbstractImageShape;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

abstract class AbstractJobArrayShape
extends AbstractImageShape {
    JFJobArray jobArrayDefObj = null;
    JFJobArrayInstance jobArrayInstObj = null;

    public AbstractJobArrayShape(JFJobArray jFJobArray, int n, int n2) {
        super(n, n2, false);
        this.jobArrayDefObj = jFJobArray;
        if (this.jobArrayDefObj != null) {
            this.name = this.jobArrayDefObj.getName();
        }
        this.curImage = this.imageLoader.getJobArrayScriptDefImage(this.jobArrayDefObj);
        if (jFJobArray == null) {
            this.isDummyShape = true;
        } else {
            JFJob jFJob = jFJobArray.getJobDefinition();
            if (jFJob == null) {
                this.isDummyShape = true;
            } else {
                String string = jFJob.getAttribute("JobCmdLine");
                if (string == null || string.length() <= 0) {
                    this.isDummyShape = true;
                }
            }
        }
    }

    public AbstractJobArrayShape(String string, int n, int n2) {
        super(string, n, n2);
    }

    public AbstractJobArrayShape(JFJobArrayInstance jFJobArrayInstance, int n, int n2) {
        super(n, n2, true);
        this.jobArrayInstObj = jFJobArrayInstance;
        if (this.jobArrayInstObj != null) {
            this.jobArrayDefObj = jFJobArrayInstance.getJobArrayDefinition();
            JFJobInstance jFJobInstance = jFJobArrayInstance.getJobInstance();
            if (jFJobInstance != null) {
                this.name = JFUtility.getShortInstanceName(jFJobInstance.getName());
                this.owner = jFJobInstance.getOwner();
            }
            int n3 = this.jobArrayInstObj.getState();
            switch (n3) {
                case 1: {
                    this.state = 0;
                    break;
                }
                case 2: {
                    this.state = 1;
                    break;
                }
                case 3: {
                    this.state = 2;
                    break;
                }
                case 4: {
                    this.state = 3;
                    break;
                }
                case 5: {
                    if (jFJobInstance.isPending()) {
                        this.state = 10;
                        break;
                    }
                    this.state = 4;
                    break;
                }
                case 6: {
                    this.state = 5;
                    break;
                }
                case 7: {
                    this.state = 6;
                    break;
                }
                case 8: {
                    this.state = 7;
                    break;
                }
                case 9: {
                    this.state = 9;
                    break;
                }
                default: {
                    this.state = -1;
                }
            }
        }
        this.curImage = this.imageLoader.getJobArrayScriptInstanceImage(jFJobArrayInstance);
    }

    public JFJobArray getDefObj() {
        JFJob jFJob = null;
        if (this.jobArrayDefObj != null && (jFJob = this.jobArrayDefObj.getJobDefinition()) != null) {
            jFJob.setAttribute("PositionX", String.valueOf(this.x));
            jFJob.setAttribute("PositionY", String.valueOf(this.y));
        }
        return this.jobArrayDefObj;
    }

    public void setDefObj(JFJobArray jFJobArray) {
        if (jFJobArray != null) {
            this.jobArrayDefObj = jFJobArray;
            this.isDummyShape = false;
        }
    }

    public JFJobArrayInstance getInstanceObj() {
        return this.jobArrayInstObj;
    }

    public abstract boolean updateImage();

    @Override
    public String toString() {
        return JFResourceBundle.getString("Job_Array") + "[" + this.name + "]";
    }

    @Override
    public String getTipString() {
        if (this.isInstance) {
            Object[] objectArray = new Object[]{this.toString(), this.getCurStateString()};
            String string = JFResourceBundle.getString("A_is_B");
            MessageFormat messageFormat = new MessageFormat(string);
            return messageFormat.format(objectArray);
        }
        return this.toString();
    }

    @Override
    public String getRuntimeAttributesStr() {
        if (this.jobArrayInstObj != null) {
            return this.convertJobArrayInstance(this.jobArrayInstObj);
        }
        return null;
    }

    String convertJobArrayInstance(JFJobArrayInstance jFJobArrayInstance) {
        StringBuffer stringBuffer = new StringBuffer();
        HashMap hashMap = jFJobArrayInstance.getStates();
        if (this.owner != null) {
            stringBuffer.append(JFUtility.alignString(JFResourceBundle.getString("Submitter"), 20) + ": " + this.owner + "\n\n");
        }
        stringBuffer.append(JFUtility.alignString(JFResourceBundle.getString("Index"), 23) + JFResourceBundle.getString("State"));
        stringBuffer.append("\n---------------------------------");
        String string = "";
        string = this.state == 9 || this.state == 7 ? JFResourceBundle.getString("The_job_array_was_not_submitted") : JFResourceBundle.getString("The_job_array_has_not_been_submitted_yet");
        if (hashMap == null || hashMap.size() == 0) {
            if (this.owner != null) {
                string = string + "\n" + JFUtility.alignString(JFResourceBundle.getString("Submitter"), 21) + ": " + this.owner;
            }
            return string + "\n" + JFUtility.alignString(JFResourceBundle.getString("State"), 20) + " : " + this.getCurStateString();
        }
        Set set = hashMap.keySet();
        if (set == null) {
            return string + "\n" + JFUtility.alignString(JFResourceBundle.getString("State"), 20) + " : " + this.getCurStateString();
        }
        Iterator iterator = new TreeSet(set).iterator();
        int n = 0;
        String string2 = null;
        while (iterator.hasNext()) {
            StringBuffer stringBuffer2;
            Object object = iterator.next();
            try {
                n = (Integer)hashMap.get(object);
            }
            catch (Exception exception) {
                n = 0;
            }
            switch (n) {
                case 7: {
                    string2 = JFResourceBundle.getString("Done");
                    break;
                }
                case 9: {
                    string2 = JFResourceBundle.getString("Exit");
                    break;
                }
                case 8: {
                    string2 = JFResourceBundle.getString("Killed");
                    break;
                }
                case 5: {
                    string2 = JFResourceBundle.getString("Running");
                    break;
                }
                case 3: {
                    string2 = JFResourceBundle.getString("Waiting");
                    break;
                }
                case 1: {
                    string2 = JFResourceBundle.getString("Initializing");
                    break;
                }
                case 2: {
                    string2 = JFResourceBundle.getString("Suspend_Intializing");
                    break;
                }
                case 4: {
                    string2 = JFResourceBundle.getString("Suspend_Waiting");
                    break;
                }
                case 6: {
                    string2 = JFResourceBundle.getString("Suspend_Running");
                    break;
                }
                default: {
                    string2 = this.jobArrayInstObj.getState() == 3 ? JFResourceBundle.getString("Waiting") : JFResourceBundle.getString("In_Progress");
                }
            }
            if (object instanceof Integer) {
                stringBuffer2 = new StringBuffer(20);
                stringBuffer2.append(((Integer)object).toString().trim());
                stringBuffer2.append("       ");
                object = stringBuffer2.substring(0, 6);
            }
            stringBuffer2 = new StringBuffer();
            stringBuffer2.append(object);
            stringBuffer.append("\n" + JFUtility.alignString(stringBuffer2.toString(), 20) + string2);
        }
        return stringBuffer.toString();
    }

    @Override
    public void update() {
        this.updateState();
    }

    private void updateState() {
        int n = this.jobArrayInstObj.getState();
        switch (n) {
            case 1: {
                this.state = 0;
                break;
            }
            case 2: {
                this.state = 1;
                break;
            }
            case 3: {
                this.state = 2;
                break;
            }
            case 4: {
                this.state = 3;
                break;
            }
            case 5: {
                this.state = 4;
                break;
            }
            case 6: {
                this.state = 5;
                break;
            }
            case 7: {
                this.state = 6;
                break;
            }
            case 8: {
                this.state = 7;
                break;
            }
            case 9: {
                this.state = 9;
                break;
            }
            default: {
                this.state = -1;
            }
        }
    }
}

