/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.ui.ImageLoader;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JobFlowShapeINF;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Properties;

abstract class AbstractImageShape
implements JobFlowShapeINF {
    static final int MINI_RECT_WIDTH = 4;
    static final int MINI_RECT_HEIGHT = 4;
    static final int LABLE_SPACE = 5;
    static final int UNKNOW_STATE = -1;
    static final int INITIALIZING_STATE = 0;
    static final int INITIALIZING_SUSP_STATE = 1;
    static final int WAITING_STATE = 2;
    static final int WAITING_SUSP_STATE = 3;
    static final int RUNNING_STATE = 4;
    static final int RUNNING_SUSP_STATE = 5;
    static final int DONE_STATE = 6;
    static final int KILLED_STATE = 7;
    static final int SUSPENDED_STATE = 8;
    static final int EXIT_STATE = 9;
    static final int RUNNING_PENDING_STATE = 10;
    boolean isInstance = false;
    int state = -1;
    boolean m_onHold = false;
    Image curImage = null;
    protected ImageLoader imageLoader = null;
    int x;
    int y;
    int width;
    int height;
    protected String name = null;
    protected String owner = null;
    protected JFUser triggerUser = null;
    FontMetrics fontMetrics = null;
    boolean selectedFlag = true;
    boolean isErasingFlag = false;
    boolean isDummyShape = false;
    boolean isTerminationShape = false;
    Properties m_displayAttrs = null;
    private int m_inConnNum = 0;
    private int m_outConnNum = 0;
    private int m_maxLabelLen = -1;
    private int m_originalX = -1;
    private int m_originalY = -1;

    public String getOwner() {
        return this.owner;
    }

    protected AbstractImageShape(int n, int n2, boolean bl) {
        this.x = n;
        this.y = n2;
        this.selectedFlag = false;
        this.isInstance = bl;
        this.imageLoader = ImageLoader.getInstance();
        this.isDummyShape = false;
        this.m_displayAttrs = null;
    }

    protected AbstractImageShape(String string, int n, int n2) {
        this.name = string;
        this.isDummyShape = true;
        this.x = n;
        this.y = n2;
        this.selectedFlag = false;
        this.isInstance = false;
        this.imageLoader = ImageLoader.getInstance();
        this.m_displayAttrs = null;
    }

    public void setDummyShapeFlag(boolean bl) {
        this.isDummyShape = bl;
    }

    public String getCurStateString() {
        String string = null;
        if (this.m_onHold) {
            return JFResourceBundle.getString("On_Hold");
        }
        switch (this.state) {
            case 0: {
                string = JFResourceBundle.getString("Initializing");
                break;
            }
            case 1: {
                string = JFResourceBundle.getString("Initializing_suspended");
                break;
            }
            case 2: {
                string = JFResourceBundle.getString("Waiting");
                break;
            }
            case 3: {
                string = JFResourceBundle.getString("Waiting_suspended");
                break;
            }
            case 4: {
                string = JFResourceBundle.getString("Running");
                break;
            }
            case 10: {
                string = JFResourceBundle.getString("Pending");
                break;
            }
            case 5: {
                string = JFResourceBundle.getString("Running_suspended");
                break;
            }
            case 6: {
                string = JFResourceBundle.getString("Done");
                break;
            }
            case 7: {
                string = JFResourceBundle.getString("Killed");
                break;
            }
            case 8: {
                string = JFResourceBundle.getString("Suspended");
                break;
            }
            case 9: {
                string = JFResourceBundle.getString("Exit");
                break;
            }
            default: {
                string = JFResourceBundle.getString("Unknown");
            }
        }
        return string;
    }

    public boolean isDummyShape() {
        return this.isDummyShape;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void moveTo(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void move(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    @Override
    public boolean contains(int n, int n2, Graphics2D graphics2D) {
        Rectangle rectangle = this.getImageOutline();
        if (rectangle == null) {
            return false;
        }
        return rectangle.contains(n, n2);
    }

    @Override
    public int distanceSq(int n, int n2) {
        int n3 = n - this.x;
        int n4 = n2 - this.y;
        return n3 * n3 + n4 * n4;
    }

    @Override
    public boolean intersects(JobFlowShapeINF jobFlowShapeINF, Graphics2D graphics2D) {
        if (jobFlowShapeINF == null) {
            return false;
        }
        Rectangle rectangle = jobFlowShapeINF.getOutline(graphics2D);
        if (rectangle == null) {
            return false;
        }
        return this.getOutline(graphics2D).intersects(rectangle);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Serializable serializable;
        Object object;
        this.checkAndCorrectPosition();
        Color color = graphics2D.getColor();
        if (this.isErasingFlag) {
            graphics2D.setColor(Color.white);
        } else if (this.isDummyShape) {
            graphics2D.setColor(Color.red);
        } else {
            graphics2D.setColor(Color.black);
        }
        if (!this.isErasingFlag && this.m_onHold) {
            this.erase(graphics2D);
        }
        if (this.name != null) {
            int n;
            object = this.name;
            if (this.m_maxLabelLen > 0 && (n = (serializable = graphics2D.getFontMetrics()).stringWidth((String)object)) > this.m_maxLabelLen) {
                object = this.getTruncatedString((String)object, this.m_maxLabelLen, (FontMetrics)serializable);
            }
            graphics2D.drawString((String)object, this.x, this.y - 5);
        }
        if (this.isErasingFlag) {
            object = graphics2D.getBackground();
            graphics2D.setBackground(Color.white);
            serializable = this.getImageOutline();
            graphics2D.clearRect(((Rectangle)serializable).x - 1, ((Rectangle)serializable).y - 1, ((Rectangle)serializable).width + 2, ((Rectangle)serializable).height + 2);
            graphics2D.setBackground((Color)object);
        } else {
            object = graphics2D.getComposite();
            if (!this.m_onHold) {
                graphics2D.drawImage(this.curImage, this.x, this.y, null);
            } else {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.33f));
                graphics2D.drawImage(this.curImage, this.x, this.y, null);
            }
            graphics2D.setComposite((Composite)object);
        }
        this.width = this.curImage.getWidth(null);
        this.height = this.curImage.getHeight(null);
        if (this.isInstance && !this.m_onHold) {
            if (this.isErasingFlag) {
                graphics2D.setColor(Color.white);
            } else {
                switch (this.state) {
                    case 0: 
                    case 2: {
                        graphics2D.setColor(Color.orange);
                        break;
                    }
                    case 4: {
                        graphics2D.setColor(Color.green);
                        break;
                    }
                    case 10: {
                        graphics2D.setColor(new Color(128, 64, 0));
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 8: {
                        graphics2D.setColor(Color.black);
                        break;
                    }
                    case 6: {
                        graphics2D.setColor(Color.blue);
                        break;
                    }
                    case 7: 
                    case 9: {
                        graphics2D.setColor(Color.red);
                        break;
                    }
                    default: {
                        graphics2D.setColor(Color.gray);
                    }
                }
            }
            graphics2D.drawRect(this.x - 2, this.y - 2, this.width + 4, this.height + 4);
            graphics2D.drawRect(this.x - 3, this.y - 3, this.width + 6, this.height + 6);
            graphics2D.drawRect(this.x - 4, this.y - 4, this.width + 8, this.height + 8);
        }
        if (this.selectedFlag) {
            if (this.isErasingFlag) {
                graphics2D.setColor(Color.white);
            } else {
                graphics2D.setColor(Color.black);
            }
            graphics2D.drawRect(this.x, this.y, 4, 4);
            graphics2D.drawRect(this.x + this.width - 4, this.y, 4, 4);
            graphics2D.drawRect(this.x, this.y + this.height - 4, 4, 4);
            graphics2D.drawRect(this.x + this.width - 4, this.y + this.height - 4, 4, 4);
        }
        graphics2D.setColor(color);
    }

    @Override
    public void erase(Graphics2D graphics2D) {
        this.isErasingFlag = true;
        this.draw(graphics2D);
        this.isErasingFlag = false;
    }

    @Override
    public void drawOutline(Graphics2D graphics2D) {
        this.checkAndCorrectPosition();
        graphics2D.drawRect(this.x, this.y, this.width, this.height);
    }

    public Rectangle getImageOutline() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    public Rectangle getOutline(Graphics2D graphics2D) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.fontMetrics = graphics2D.getFontMetrics();
        if (this.name == null || this.name.length() <= 0) {
            n = this.x - 4;
            n2 = this.y - 4;
            n3 = this.width + 4 * 2;
            n4 = this.height + 4 * 2;
        } else {
            n = this.x - 4;
            int n5 = this.fontMetrics.getHeight();
            if (n5 + 5 > 4) {
                n2 = this.y - (n5 + 5);
                n4 = this.height + n5 + 5 + 4;
            } else {
                n2 = this.y - 4;
                n4 = this.height + 4 * 2;
            }
            String string = this.name;
            string = string.replace(':', 'a');
            int n6 = this.fontMetrics.stringWidth(string);
            if (n6 > this.m_maxLabelLen) {
                string = this.getTruncatedString(string, this.m_maxLabelLen, this.fontMetrics);
                n6 = this.fontMetrics.stringWidth(string);
            }
            n3 = this.width + 4 * 2;
            if (n3 < n6 + 4) {
                n3 = n6 + 4;
            }
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    @Override
    public void setSelected(boolean bl) {
        this.selectedFlag = bl;
    }

    @Override
    public boolean isSelected() {
        return this.selectedFlag;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getTipString() {
        return this.toString();
    }

    @Override
    public String getRuntimeAttributesStr() {
        return "No runtime attributes";
    }

    public Properties getDisplayAttributes() {
        return this.m_displayAttrs;
    }

    public void setDisplayAttributes(Properties properties) {
        this.m_displayAttrs = properties;
    }

    public void setMaximumLabelLen(int n) {
        this.m_maxLabelLen = n;
    }

    void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    void incInConnection() {
        ++this.m_inConnNum;
    }

    int getInConnections() {
        return this.m_inConnNum;
    }

    void incOutConnection() {
        ++this.m_outConnNum;
    }

    int getOutConnections() {
        return this.m_outConnNum;
    }

    boolean isOnHold() {
        return this.m_onHold;
    }

    void setOnHold(boolean bl) {
        this.m_onHold = bl;
    }

    void storePositionInf() {
        this.m_originalX = this.x;
        this.m_originalY = this.y;
    }

    void restorePositionInf() {
        this.x = this.m_originalX;
        this.y = this.m_originalY;
    }

    public void update() {
    }

    private String getTruncatedString(String string, int n, FontMetrics fontMetrics) {
        if (string == null) {
            return null;
        }
        if (fontMetrics == null) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        while (fontMetrics.charsWidth(cArray, 0, n2) > n && --n2 > 0) {
        }
        if (n2 > 3) {
            cArray[n2 - 1] = 46;
            cArray[n2 - 2] = 46;
            cArray[n2 - 3] = 46;
        } else if (n2 > 1) {
            cArray[n2 - 1] = 42;
        }
        return new String(cArray, 0, n2);
    }

    private void checkAndCorrectPosition() {
        if (this.x < 1) {
            this.x = 1;
        }
        if (this.y < 1) {
            this.y = 1;
        }
    }
}

