/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.client.loading;

import com.sas.svcs.commons.ObjectIdentity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Date submittedDate;
    private Date completedDate;
    private Map<ObjectIdentity, Integer> subjects = new HashMap<ObjectIdentity, Integer>();

    public void addSubject(ObjectIdentity identity, int relationshipCount) {
        this.subjects.put(identity, relationshipCount);
    }

    public List<ObjectIdentity> getSubjects() {
        return new ArrayList<ObjectIdentity>(this.subjects.keySet());
    }

    public int getRelationshipCountForSubject(ObjectIdentity identity) {
        Integer count = this.subjects.get(identity);
        return count == null ? 0 : count;
    }

    public int getTotalRelationshipCount() {
        int count = 0;
        for (Map.Entry<ObjectIdentity, Integer> entry : this.subjects.entrySet()) {
            count += entry.getValue().intValue();
        }
        return count;
    }

    public int getSubjectCount() {
        return this.subjects.size();
    }

    public Date getSubmittedDate() {
        return this.submittedDate;
    }

    public void setSubmittedDate(Date submittedDate) {
        this.submittedDate = submittedDate;
    }

    public Date getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
    }
}

