/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.client;

import com.sas.codepolicy.SASScope;
import com.sas.svcs.content.relationship.client.RelationshipAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SASScope
public class RelationshipT
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int relationshipId;
    private int resourceId;
    private String relType;
    private int dependentResourceId;
    @SASScope
    private ArrayList<RelationshipAttribute> attributeMap = new ArrayList();
    private Map<String, String> attributes = new HashMap<String, String>();
    @SASScope
    private List<String> dependencyTypes;

    public int getRelationshipId() {
        return this.relationshipId;
    }

    @SASScope
    public void setRelationshipId(int relelationshipId) {
        this.relationshipId = relelationshipId;
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(int resourceId) {
        this.resourceId = resourceId;
    }

    public String getRelationshipType() {
        return this.relType;
    }

    public void setRelationshipType(String relType) {
        this.relType = relType;
    }

    public int getDependentResourceId() {
        return this.dependentResourceId;
    }

    public void setDependentResourceId(int dependentResourceId) {
        this.dependentResourceId = dependentResourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        if (null == name) {
            return;
        }
        RelationshipT relationshipT = this;
        synchronized (relationshipT) {
            String a = this.attributes.remove(name);
            if (a != null) {
                int deleteIndex = -1;
                for (int i = 0; i < this.attributeMap.size(); ++i) {
                    RelationshipAttribute ra = this.attributeMap.get(i);
                    if (!ra.getName().equals(name)) continue;
                    deleteIndex = i;
                }
                if (deleteIndex > -1) {
                    this.attributeMap.remove(deleteIndex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, String value) {
        boolean updated = false;
        RelationshipT relationshipT = this;
        synchronized (relationshipT) {
            for (RelationshipAttribute a : this.attributeMap) {
                if (!name.equals(a.getName())) continue;
                a.setValue(value);
                updated = true;
            }
            this.attributes.put(name, value);
        }
        if (!updated) {
            RelationshipAttribute a = new RelationshipAttribute(name, value);
            a.setRelationshipId(this.relationshipId);
            RelationshipT relationshipT2 = this;
            synchronized (relationshipT2) {
                this.attributeMap.add(a);
                this.attributes.put(name, value);
            }
        }
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Map<String, String> attributes) {
        if (null == attributes) {
            return;
        }
        RelationshipT relationshipT = this;
        synchronized (relationshipT) {
            this.attributeMap.clear();
            this.attributes.clear();
            for (String key : attributes.keySet()) {
                RelationshipAttribute attr = new RelationshipAttribute(key, attributes.get(key));
                attr.setRelationshipId(this.relationshipId);
                this.attributeMap.add(attr);
                this.attributes.put(key, attributes.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public void setAttributeMap(List<RelationshipAttribute> attributes) {
        if (null == attributes) {
            return;
        }
        RelationshipT relationshipT = this;
        synchronized (relationshipT) {
            this.attributeMap.clear();
            this.attributeMap.addAll(attributes);
            this.attributes.clear();
            for (RelationshipAttribute ra : attributes) {
                this.attributes.put(ra.getName(), ra.getValue());
            }
        }
    }

    @SASScope
    public List<RelationshipAttribute> getAttributeMap() {
        return this.attributeMap;
    }

    @SASScope
    public List<String> getDependencyTypes() {
        return this.dependencyTypes;
    }

    @SASScope
    public void setDependencyTypes(List<String> dependencyTypes) {
        this.dependencyTypes = dependencyTypes;
    }
}

