/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.client;

import com.sas.codepolicy.SASScope;
import com.sas.svcs.content.relationship.client.RelationshipAttribute;
import com.sas.svcs.content.relationship.client.RelationshipDirection;
import com.sas.svcs.content.relationship.client.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public final class Relationship
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Resource resource;
    private String relationshipType;
    private RelationshipDirection direction = RelationshipDirection.TO;
    private List<RelationshipAttribute> relAttributes;
    private Map<String, String> attributes = new HashMap<String, String>();
    private int relationshipId;

    @SASScope
    public int getRelationshipId() {
        return this.relationshipId;
    }

    @SASScope
    public void setRelationshipId(int relelationshipId) {
        this.relationshipId = relelationshipId;
    }

    public Relationship(Resource resource, String relationshipType) {
        Assert.notNull((Object)resource);
        Assert.notNull((Object)relationshipType);
        this.resource = resource;
        this.relationshipType = relationshipType;
    }

    @SASScope
    public Relationship(Resource resource, String relationshipType, List<RelationshipAttribute> attributes) {
        Assert.notNull((Object)resource);
        Assert.notNull((Object)relationshipType);
        this.resource = resource;
        this.relationshipType = relationshipType;
        this.setAttributeMap(attributes);
    }

    public Relationship() {
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public RelationshipDirection getDirection() {
        return this.direction;
    }

    @SASScope
    public void setDirection(RelationshipDirection direction) {
        this.direction = direction;
    }

    public void setResource(Resource resource) {
        Assert.notNull((Object)resource);
        this.resource = resource;
    }

    public void setRelationshipType(String relationshipType) {
        Assert.notNull((Object)relationshipType);
        this.relationshipType = relationshipType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        if (null == name) {
            return;
        }
        if (this.relAttributes == null) {
            this.relAttributes = new ArrayList<RelationshipAttribute>();
        }
        Relationship relationship = this;
        synchronized (relationship) {
            String a = this.attributes.remove(name);
            if (a != null) {
                int deleteIndex = -1;
                for (int i = 0; i < this.relAttributes.size(); ++i) {
                    RelationshipAttribute ra = this.relAttributes.get(i);
                    if (!ra.getName().equals(name)) continue;
                    deleteIndex = i;
                }
                if (deleteIndex > -1) {
                    this.relAttributes.remove(deleteIndex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, String value) {
        if (this.relAttributes == null) {
            this.relAttributes = new ArrayList<RelationshipAttribute>();
        }
        boolean updated = false;
        Relationship relationship = this;
        synchronized (relationship) {
            for (RelationshipAttribute a : this.relAttributes) {
                if (!name.equals(a.getName())) continue;
                a.setValue(value);
                updated = true;
            }
            this.attributes.put(name, value);
        }
        if (!updated) {
            RelationshipAttribute a = new RelationshipAttribute(name, value);
            Relationship relationship2 = this;
            synchronized (relationship2) {
                this.relAttributes.add(a);
                this.attributes.put(name, value);
            }
        }
    }

    public Map<String, String> getAttributes() {
        if (null != this.relAttributes && this.attributes.size() == 0 && !this.relAttributes.isEmpty()) {
            for (RelationshipAttribute type : this.relAttributes) {
                this.attributes.put(type.getName(), type.getValue());
            }
        }
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Map<String, String> attributes) {
        if (null == attributes) {
            return;
        }
        if (this.relAttributes == null) {
            this.relAttributes = new ArrayList<RelationshipAttribute>();
        }
        Relationship relationship = this;
        synchronized (relationship) {
            this.relAttributes.clear();
            this.attributes.clear();
            for (String key : attributes.keySet()) {
                RelationshipAttribute attr = new RelationshipAttribute(key, attributes.get(key));
                this.relAttributes.add(attr);
                this.attributes.put(key, attributes.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public void setAttributeMap(List<RelationshipAttribute> attributes) {
        if (null == attributes) {
            return;
        }
        if (this.relAttributes == null) {
            this.relAttributes = new ArrayList<RelationshipAttribute>();
        }
        Relationship relationship = this;
        synchronized (relationship) {
            this.relAttributes.clear();
            this.relAttributes.addAll(attributes);
            this.attributes.clear();
            for (RelationshipAttribute ra : attributes) {
                this.attributes.put(ra.getName(), ra.getValue());
            }
        }
    }

    @SASScope
    public List<RelationshipAttribute> getAttributeMap() {
        if (this.relAttributes == null) {
            this.relAttributes = new ArrayList<RelationshipAttribute>();
        }
        return this.relAttributes;
    }

    public String toString() {
        String label;
        String string = label = this.resource == null ? null : this.resource.getLabel();
        return label == null ? super.toString() : label + "(" + (this.relationshipType == null ? "unknown" : this.relationshipType) + ")";
    }
}

