/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.actions;

import com.sas.framework.commons.actions.DefaultAction;
import com.sas.swing.util.Action;

public class ToggleStateAction
extends DefaultAction {
    private static final long serialVersionUID = 1L;
    private static final boolean DEFAULT_STATE = true;
    public static final String STATE_PROPERTY = "state";

    public ToggleStateAction() {
        this(true);
    }

    public ToggleStateAction(boolean initialState) {
        this.putValue("Type", "boolean");
        this.setState(initialState);
    }

    @Override
    public void performAction() {
        this.setState(!this.getState());
    }

    public boolean getState() {
        Object state = this.getValue(STATE_PROPERTY);
        if (null == state) {
            return true;
        }
        return (Boolean)state;
    }

    public void setState(boolean newState) {
        ToggleStateAction.setState(this, newState);
    }

    @Override
    public void putValue(String name, Object value) {
        if (STATE_PROPERTY.equals(name) && !(value instanceof Boolean)) {
            throw new IllegalArgumentException("State value must be of type boolean.");
        }
        super.putValue(name, value);
    }

    public static final boolean getState(Action action) {
        if (action instanceof ToggleStateAction) {
            return ((ToggleStateAction)action).getState();
        }
        Object obj = action.getValue(STATE_PROPERTY);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public static final void setState(Action action, boolean newValue) {
        action.putValue(STATE_PROPERTY, (Object)(newValue ? Boolean.TRUE : Boolean.FALSE));
    }
}

