/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.actions;

import com.sas.framework.commons.actions.ActionImpl;
import com.sas.framework.commons.actions.ActionListImpl;
import com.sas.framework.commons.actions.ActionMap;
import com.sas.swing.util.Action;
import com.sas.swing.util.ActionList;
import com.sas.swing.util.ActionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActionResourceLoader
implements ActionMap {
    static final Logger LOG = LogManager.getLogger(ActionResourceLoader.class);
    static final String KEY_SEPARATOR = ".";
    static final String ACTION_KEY = "Action.";
    static final String ACTIONLIST_KEY = "ActionList.";
    static final String ACTION_SEPARATOR = "-";
    static final String ACTIONBASE_KEY = "ActionBase.classname";
    static final String ACTIONS_KEY = "actions.notrans";
    static final String PARENT_KEY = "parent.notrans";
    static final String LABEL_KEY = "label.txt";
    private static final Map<String, String> KEY_MAP = new HashMap<String, String>(14);
    private final List<ResourceBundle> _rbList = new ArrayList<ResourceBundle>(2);
    Map _actionGroups;
    private final Map _actions;
    private final Map _actionLists;
    ClassLoader _callerClassLoader;

    static String getResourceKey(String actionKey) {
        String rc = KEY_MAP.get(actionKey);
        if (null != rc) {
            return rc;
        }
        return actionKey;
    }

    public ActionResourceLoader(ResourceBundle rb) {
        this(rb, null);
    }

    public ActionResourceLoader(ResourceBundle rb, Object caller) {
        if (null == rb) {
            throw new NullPointerException("ResourceBundle cannot be null.");
        }
        while (true) {
            this._rbList.add(rb);
            try {
                if (null == caller) {
                    caller = this;
                }
                this._callerClassLoader = caller.getClass().getClassLoader();
                String base = rb.getString(ACTIONBASE_KEY);
                rb = ResourceBundle.getBundle(base, rb.getLocale(), this._callerClassLoader);
            }
            catch (MissingResourceException mre) {
                this._actions = new HashMap();
                this._actionLists = new HashMap();
                return;
            }
        }
    }

    @Override
    public Action getAction(String key) {
        Action action = (Action)this._actions.get(key);
        if (null != action) {
            return action;
        }
        action = this.newAction(ACTION_KEY + key + KEY_SEPARATOR);
        if (null == action.getValue("Name")) {
            throw new MissingResourceException(ACTION_KEY + key + KEY_SEPARATOR + LABEL_KEY, null, null);
        }
        action.putValue("ActionCommandKey", (Object)key);
        this._actions.put(key, action);
        return action;
    }

    @Override
    public ActionList getActionList(String key) {
        ActionList actionList = (ActionList)this._actionLists.get(key);
        if (null != actionList) {
            return actionList;
        }
        actionList = this.newActionList(ACTIONLIST_KEY + key + KEY_SEPARATOR);
        actionList.putValue("ActionCommandKey", (Object)key);
        this._actionLists.put(key, actionList);
        return actionList;
    }

    @Override
    public void add(Action action) {
        if (action instanceof ActionList) {
            this.add((ActionList)action);
            return;
        }
        this._actions.put(action.getValue("ActionCommandKey"), action);
    }

    protected void add(ActionList actionList) {
        Iterator it = ActionUtils.iterator((ActionList)actionList);
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof Action)) continue;
            if (next instanceof ActionList) {
                ActionList nextAL = (ActionList)next;
                this._actionLists.put(nextAL.getValue("ActionCommandKey"), nextAL);
                continue;
            }
            this.add((Action)next);
        }
    }

    public void clear() {
        this._actions.clear();
        this._actionLists.clear();
        this._actionGroups.clear();
    }

    protected Action newAction(String key) {
        return new ActionImpl(key, this);
    }

    protected ActionList newActionList(String key) {
        return new ActionListImpl(key, this);
    }

    String getOptionalStringResource(String key) {
        int iCount = this._rbList.size();
        for (int i = 0; i < iCount; ++i) {
            try {
                ResourceBundle rb = this._rbList.get(i);
                return rb.getString(key);
            }
            catch (MissingResourceException mre) {
                continue;
            }
        }
        return null;
    }

    static {
        KEY_MAP.put("Name", LABEL_KEY);
        KEY_MAP.put("LongName", "longLabel.txt");
        KEY_MAP.put("ShortDescription", "spd.txt");
        KEY_MAP.put("LongDescription", "pd.txt");
        KEY_MAP.put("AcceleratorKey", "accelerator.key");
        KEY_MAP.put("SmallIconName", "smallIcon.image");
        KEY_MAP.put("SmallDisabledIconName", "smallDisabledIcon.image");
        KEY_MAP.put("LargeIconName", "largeIcon.image");
        KEY_MAP.put("LargeDisabledIconName", "largeDisabledIcon.image");
        KEY_MAP.put("CommandClass", "command.classname");
        KEY_MAP.put("URL", "command.url");
        KEY_MAP.put("GroupName", "groupName.notrans");
        KEY_MAP.put("Type", "type.notrans");
        KEY_MAP.put("Actions", ACTIONS_KEY);
    }
}

