/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.actions;

import com.sas.framework.commons.actions.ActionImpl;
import com.sas.framework.commons.actions.ActionResourceLoader;
import com.sas.framework.commons.actions.ActionsList;
import com.sas.swing.util.Action;
import com.sas.swing.util.ActionList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

final class ActionListImpl
extends ActionImpl
implements ActionList {
    private static final long serialVersionUID = 1L;

    public ActionListImpl(String key, ActionResourceLoader map) {
        super(key, map);
        ActionsList actionsList = new ActionsList();
        this._putValue("Actions", actionsList);
        this.parseActions(actionsList, key);
    }

    @Override
    protected Action getParentAction(String key) {
        String subString = key.substring("ActionList.".length());
        return this._map.getActionList(subString);
    }

    private void parseActions(List actionsList, String key) {
        String actionsString = this._map.getOptionalStringResource(key + "actions.notrans");
        if (null == actionsString) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(actionsString);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.startsWith("(") && token.endsWith(")")) {
                token = token.substring("ActionList.".length() + 1, token.length() - 1);
                ActionList list = this._map.getActionList(token);
                Iterator iterator = list.getActions().iterator();
                while (iterator.hasNext()) {
                    actionsList.add(iterator.next());
                }
                continue;
            }
            if (token.startsWith("Action.")) {
                actionsList.add(this._map.getAction(token.substring("Action.".length())));
                continue;
            }
            if (token.startsWith("ActionList.")) {
                actionsList.add(this._map.getActionList(token.substring("ActionList.".length())));
                continue;
            }
            if (token.equals("-")) {
                actionsList.add(ActionList.SEPARATOR);
                continue;
            }
            throw new IllegalArgumentException("Unknown item '" + token + "' found in " + key + "Actions");
        }
    }

    public List getActions() {
        return (List)this.getValue("Actions");
    }

    @Override
    public String toString() {
        return "ActionList: " + this.getValue("ActionCommandKey");
    }
}

